//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/resourcemover/armresourcemover"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// MoveResourcesServer is a fake server for instances of the armresourcemover.MoveResourcesClient type.
type MoveResourcesServer struct {
	// BeginCreate is the fake for method MoveResourcesClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreate func(ctx context.Context, resourceGroupName string, moveCollectionName string, moveResourceName string, options *armresourcemover.MoveResourcesClientBeginCreateOptions) (resp azfake.PollerResponder[armresourcemover.MoveResourcesClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method MoveResourcesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, moveCollectionName string, moveResourceName string, options *armresourcemover.MoveResourcesClientBeginDeleteOptions) (resp azfake.PollerResponder[armresourcemover.MoveResourcesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method MoveResourcesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, moveCollectionName string, moveResourceName string, options *armresourcemover.MoveResourcesClientGetOptions) (resp azfake.Responder[armresourcemover.MoveResourcesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method MoveResourcesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, moveCollectionName string, options *armresourcemover.MoveResourcesClientListOptions) (resp azfake.PagerResponder[armresourcemover.MoveResourcesClientListResponse])
}

// NewMoveResourcesServerTransport creates a new instance of MoveResourcesServerTransport with the provided implementation.
// The returned MoveResourcesServerTransport instance is connected to an instance of armresourcemover.MoveResourcesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewMoveResourcesServerTransport(srv *MoveResourcesServer) *MoveResourcesServerTransport {
	return &MoveResourcesServerTransport{
		srv:          srv,
		beginCreate:  newTracker[azfake.PollerResponder[armresourcemover.MoveResourcesClientCreateResponse]](),
		beginDelete:  newTracker[azfake.PollerResponder[armresourcemover.MoveResourcesClientDeleteResponse]](),
		newListPager: newTracker[azfake.PagerResponder[armresourcemover.MoveResourcesClientListResponse]](),
	}
}

// MoveResourcesServerTransport connects instances of armresourcemover.MoveResourcesClient to instances of MoveResourcesServer.
// Don't use this type directly, use NewMoveResourcesServerTransport instead.
type MoveResourcesServerTransport struct {
	srv          *MoveResourcesServer
	beginCreate  *tracker[azfake.PollerResponder[armresourcemover.MoveResourcesClientCreateResponse]]
	beginDelete  *tracker[azfake.PollerResponder[armresourcemover.MoveResourcesClientDeleteResponse]]
	newListPager *tracker[azfake.PagerResponder[armresourcemover.MoveResourcesClientListResponse]]
}

// Do implements the policy.Transporter interface for MoveResourcesServerTransport.
func (m *MoveResourcesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "MoveResourcesClient.BeginCreate":
		resp, err = m.dispatchBeginCreate(req)
	case "MoveResourcesClient.BeginDelete":
		resp, err = m.dispatchBeginDelete(req)
	case "MoveResourcesClient.Get":
		resp, err = m.dispatchGet(req)
	case "MoveResourcesClient.NewListPager":
		resp, err = m.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *MoveResourcesServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if m.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := m.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Migrate/moveCollections/(?P<moveCollectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/moveResources/(?P<moveResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armresourcemover.MoveResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		moveCollectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("moveCollectionName")])
		if err != nil {
			return nil, err
		}
		moveResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("moveResourceName")])
		if err != nil {
			return nil, err
		}
		var options *armresourcemover.MoveResourcesClientBeginCreateOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armresourcemover.MoveResourcesClientBeginCreateOptions{
				Body: &body,
			}
		}
		respr, errRespr := m.srv.BeginCreate(req.Context(), resourceGroupNameParam, moveCollectionNameParam, moveResourceNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		m.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		m.beginCreate.remove(req)
	}

	return resp, nil
}

func (m *MoveResourcesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if m.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := m.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Migrate/moveCollections/(?P<moveCollectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/moveResources/(?P<moveResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		moveCollectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("moveCollectionName")])
		if err != nil {
			return nil, err
		}
		moveResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("moveResourceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginDelete(req.Context(), resourceGroupNameParam, moveCollectionNameParam, moveResourceNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		m.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		m.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		m.beginDelete.remove(req)
	}

	return resp, nil
}

func (m *MoveResourcesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if m.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Migrate/moveCollections/(?P<moveCollectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/moveResources/(?P<moveResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	moveCollectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("moveCollectionName")])
	if err != nil {
		return nil, err
	}
	moveResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("moveResourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Get(req.Context(), resourceGroupNameParam, moveCollectionNameParam, moveResourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MoveResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MoveResourcesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := m.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Migrate/moveCollections/(?P<moveCollectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/moveResources`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		moveCollectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("moveCollectionName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armresourcemover.MoveResourcesClientListOptions
		if filterParam != nil {
			options = &armresourcemover.MoveResourcesClientListOptions{
				Filter: filterParam,
			}
		}
		resp := m.srv.NewListPager(resourceGroupNameParam, moveCollectionNameParam, options)
		newListPager = &resp
		m.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armresourcemover.MoveResourcesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		m.newListPager.remove(req)
	}
	return resp, nil
}
