//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/reservations/armreservations/v3"
	"net/http"
)

// CalculateExchangeServer is a fake server for instances of the armreservations.CalculateExchangeClient type.
type CalculateExchangeServer struct {
	// BeginPost is the fake for method CalculateExchangeClient.BeginPost
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginPost func(ctx context.Context, body armreservations.CalculateExchangeRequest, options *armreservations.CalculateExchangeClientBeginPostOptions) (resp azfake.PollerResponder[armreservations.CalculateExchangeClientPostResponse], errResp azfake.ErrorResponder)
}

// NewCalculateExchangeServerTransport creates a new instance of CalculateExchangeServerTransport with the provided implementation.
// The returned CalculateExchangeServerTransport instance is connected to an instance of armreservations.CalculateExchangeClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewCalculateExchangeServerTransport(srv *CalculateExchangeServer) *CalculateExchangeServerTransport {
	return &CalculateExchangeServerTransport{
		srv:       srv,
		beginPost: newTracker[azfake.PollerResponder[armreservations.CalculateExchangeClientPostResponse]](),
	}
}

// CalculateExchangeServerTransport connects instances of armreservations.CalculateExchangeClient to instances of CalculateExchangeServer.
// Don't use this type directly, use NewCalculateExchangeServerTransport instead.
type CalculateExchangeServerTransport struct {
	srv       *CalculateExchangeServer
	beginPost *tracker[azfake.PollerResponder[armreservations.CalculateExchangeClientPostResponse]]
}

// Do implements the policy.Transporter interface for CalculateExchangeServerTransport.
func (c *CalculateExchangeServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "CalculateExchangeClient.BeginPost":
		resp, err = c.dispatchBeginPost(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *CalculateExchangeServerTransport) dispatchBeginPost(req *http.Request) (*http.Response, error) {
	if c.srv.BeginPost == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginPost not implemented")}
	}
	beginPost := c.beginPost.get(req)
	if beginPost == nil {
		body, err := server.UnmarshalRequestAsJSON[armreservations.CalculateExchangeRequest](req)
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginPost(req.Context(), body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginPost = &respr
		c.beginPost.add(req, beginPost)
	}

	resp, err := server.PollerResponderNext(beginPost, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginPost.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginPost) {
		c.beginPost.remove(req)
	}

	return resp, nil
}
