//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armredis

import "time"

// AccessKeys - Redis cache access keys.
type AccessKeys struct {
	// READ-ONLY; The current primary key that clients can use to authenticate with Redis cache.
	PrimaryKey *string

	// READ-ONLY; The current secondary key that clients can use to authenticate with Redis cache.
	SecondaryKey *string
}

// CacheAccessPolicy - Response to get/put access policy.
type CacheAccessPolicy struct {
	// Properties of an access policy.
	Properties *CacheAccessPolicyProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// CacheAccessPolicyAssignment - Response to an operation on access policy assignment
type CacheAccessPolicyAssignment struct {
	// Properties of an access policy assignment
	Properties *CacheAccessPolicyAssignmentProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// CacheAccessPolicyAssignmentList - List of access policies assignments (with properties) of a Redis cache.
type CacheAccessPolicyAssignmentList struct {
	// List of access policies assignments (with properties) of a Redis cache.
	Value []*CacheAccessPolicyAssignment

	// READ-ONLY; Link for next set.
	NextLink *string
}

// CacheAccessPolicyAssignmentProperties - Properties for an access policy assignment
type CacheAccessPolicyAssignmentProperties struct {
	// REQUIRED; The name of the access policy that is being assigned
	AccessPolicyName *string

	// REQUIRED; Object Id to assign access policy to
	ObjectID *string

	// REQUIRED; User friendly name for object id. Also represents username for token based authentication
	ObjectIDAlias *string

	// READ-ONLY; Provisioning state of an access policy assignment set
	ProvisioningState *AccessPolicyAssignmentProvisioningState
}

// CacheAccessPolicyList - List of access policies (with properties) of a Redis cache.
type CacheAccessPolicyList struct {
	// List of access policies (with properties) of a Redis cache.
	Value []*CacheAccessPolicy

	// READ-ONLY; Link for next set.
	NextLink *string
}

// CacheAccessPolicyProperties - All properties of an access policy.
type CacheAccessPolicyProperties struct {
	// REQUIRED; Permissions for the access policy. Learn how to configure permissions at https://aka.ms/redis/AADPreRequisites
	Permissions *string

	// READ-ONLY; Provisioning state of access policy
	ProvisioningState *AccessPolicyProvisioningState

	// READ-ONLY; Built-In or Custom access policy
	Type *AccessPolicyType
}

// CheckNameAvailabilityParameters - Parameters body to pass for resource name availability check.
type CheckNameAvailabilityParameters struct {
	// REQUIRED; Resource name.
	Name *string

	// REQUIRED; Resource type. The only legal value of this property for checking redis cache name availability is 'Microsoft.Cache/redis'.
	Type *string
}

// CommonPropertiesRedisConfiguration - All Redis Settings. Few possible keys:
// rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value
// etc.
type CommonPropertiesRedisConfiguration struct {
	// Specifies whether AAD based authentication has been enabled or disabled for the cache
	AADEnabled *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Specifies whether the aof backup is enabled
	AofBackupEnabled *string

	// First storage account connection string
	AofStorageConnectionString0 *string

	// Second storage account connection string
	AofStorageConnectionString1 *string

	// Specifies whether the authentication is disabled. Setting this property is highly discouraged from security point of view.
	Authnotrequired *string

	// Value in megabytes reserved for fragmentation per shard
	MaxfragmentationmemoryReserved *string

	// Value in megabytes reserved for non-cache usage per shard e.g. failover.
	MaxmemoryDelta *string

	// The eviction strategy used when your data won't fit within its memory limit.
	MaxmemoryPolicy *string

	// Value in megabytes reserved for non-cache usage per shard e.g. failover.
	MaxmemoryReserved *string

	// Preferred auth method to communicate to storage account used for data persistence, specify SAS or ManagedIdentity, default
	// value is SAS
	PreferredDataPersistenceAuthMethod *string

	// Specifies whether the rdb backup is enabled
	RdbBackupEnabled *string

	// Specifies the frequency for creating rdb backup in minutes. Valid values: (15, 30, 60, 360, 720, 1440)
	RdbBackupFrequency *string

	// Specifies the maximum number of snapshots for rdb backup
	RdbBackupMaxSnapshotCount *string

	// The storage account connection string for storing rdb file
	RdbStorageConnectionString *string

	// SubscriptionId of the storage account for persistence (aof/rdb) using ManagedIdentity.
	StorageSubscriptionID *string

	// READ-ONLY; The max clients config
	Maxclients *string

	// READ-ONLY; Preferred auth method to communicate to storage account used for data archive, specify SAS or ManagedIdentity,
	// default value is SAS
	PreferredDataArchiveAuthMethod *string

	// READ-ONLY; Zonal Configuration
	ZonalConfiguration *string
}

// CreateParameters - Parameters supplied to the Create Redis operation.
type CreateParameters struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; Redis cache properties.
	Properties *CreateProperties

	// The identity of the resource.
	Identity *ManagedServiceIdentity

	// Resource tags.
	Tags map[string]*string

	// A list of availability zones denoting where the resource needs to come from.
	Zones []*string
}

// CreateProperties - Properties supplied to Create Redis operation.
type CreateProperties struct {
	// REQUIRED; The SKU of the Redis cache to deploy.
	SKU *SKU

	// Specifies whether the non-ssl Redis server port (6379) is enabled.
	EnableNonSSLPort *bool

	// Optional: requires clients to use a specified TLS version (or higher) to connect (e,g, '1.0', '1.1', '1.2')
	MinimumTLSVersion *TLSVersion

	// Whether or not public endpoint access is allowed for this cache. Value is optional but if passed in, must be 'Enabled'
	// or 'Disabled'. If 'Disabled', private endpoints are the exclusive access method.
	// Default value is 'Enabled'
	PublicNetworkAccess *PublicNetworkAccess

	// All Redis Settings. Few possible keys:
	// rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value
	// etc.
	RedisConfiguration *CommonPropertiesRedisConfiguration

	// Redis version. This should be in the form 'major[.minor]' (only 'major' is required) or the value 'latest' which refers
	// to the latest stable Redis version that is available. Supported versions: 4.0,
	// 6.0 (latest). Default value is 'latest'.
	RedisVersion *string

	// The number of replicas to be created per primary.
	ReplicasPerMaster *int32

	// The number of replicas to be created per primary.
	ReplicasPerPrimary *int32

	// The number of shards to be created on a Premium Cluster Cache.
	ShardCount *int32

	// Static IP address. Optionally, may be specified when deploying a Redis cache inside an existing Azure Virtual Network;
	// auto assigned by default.
	StaticIP *string

	// The full resource ID of a subnet in a virtual network to deploy the Redis cache in. Example format:
	// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Microsoft.{Network|ClassicNetwork}/VirtualNetworks/vnet1/subnets/subnet1
	SubnetID *string

	// A dictionary of tenant settings
	TenantSettings map[string]*string

	// Optional: Specifies the update channel for the monthly Redis updates your Redis Cache will receive. Caches using 'Preview'
	// update channel get latest Redis updates at least 4 weeks ahead of 'Stable'
	// channel caches. Default value is 'Stable'.
	UpdateChannel *UpdateChannel
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDetail

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// ExportRDBParameters - Parameters for Redis export operation.
type ExportRDBParameters struct {
	// REQUIRED; Container name to export to.
	Container *string

	// REQUIRED; Prefix to use for exported files.
	Prefix *string

	// File format.
	Format *string

	// Preferred auth method to communicate to storage account used for data archive, specify SAS or ManagedIdentity, default
	// value is SAS
	PreferredDataArchiveAuthMethod *string

	// Subscription id of the storage container for data to be exported using ManagedIdentity.
	StorageSubscriptionID *string
}

// FirewallRule - A firewall rule on a redis cache has a name, and describes a contiguous range of IP addresses permitted
// to connect
type FirewallRule struct {
	// REQUIRED; redis cache firewall rule properties
	Properties *FirewallRuleProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// FirewallRuleListResult - The response of list firewall rules Redis operation.
type FirewallRuleListResult struct {
	// Results of the list firewall rules operation.
	Value []*FirewallRule

	// READ-ONLY; Link for next page of results.
	NextLink *string
}

// FirewallRuleProperties - Specifies a range of IP addresses permitted to connect to the cache
type FirewallRuleProperties struct {
	// REQUIRED; highest IP address included in the range
	EndIP *string

	// REQUIRED; lowest IP address included in the range
	StartIP *string
}

// ForceRebootResponse - Response to force reboot for Redis cache.
type ForceRebootResponse struct {
	// READ-ONLY; Status message
	Message *string
}

// ImportRDBParameters - Parameters for Redis import operation.
type ImportRDBParameters struct {
	// REQUIRED; files to import.
	Files []*string

	// File format.
	Format *string

	// Preferred auth method to communicate to storage account used for data archive, specify SAS or ManagedIdentity, default
	// value is SAS
	PreferredDataArchiveAuthMethod *string

	// Subscription id of the storage container containing files to import using Managed Identity.
	StorageSubscriptionID *string
}

// InstanceDetails - Details of single instance of redis.
type InstanceDetails struct {
	// READ-ONLY; Specifies whether the instance is a primary node.
	IsMaster *bool

	// READ-ONLY; Specifies whether the instance is a primary node.
	IsPrimary *bool

	// READ-ONLY; If enableNonSslPort is true, provides Redis instance Non-SSL port.
	NonSSLPort *int32

	// READ-ONLY; Redis instance SSL port.
	SSLPort *int32

	// READ-ONLY; If clustering is enabled, the Shard ID of Redis Instance
	ShardID *int32

	// READ-ONLY; If the Cache uses availability zones, specifies availability zone where this instance is located.
	Zone *string
}

// LinkedServer - Linked server Id
type LinkedServer struct {
	// READ-ONLY; Linked server Id.
	ID *string
}

// LinkedServerCreateParameters - Parameter required for creating a linked server to redis cache.
type LinkedServerCreateParameters struct {
	// REQUIRED; Properties required to create a linked server.
	Properties *LinkedServerCreateProperties
}

// LinkedServerCreateProperties - Create properties for a linked server
type LinkedServerCreateProperties struct {
	// REQUIRED; Fully qualified resourceId of the linked redis cache.
	LinkedRedisCacheID *string

	// REQUIRED; Location of the linked redis cache.
	LinkedRedisCacheLocation *string

	// REQUIRED; Role of the linked server.
	ServerRole *ReplicationRole

	// READ-ONLY; The unchanging DNS name which will always point to current geo-primary cache among the linked redis caches for
	// seamless Geo Failover experience.
	GeoReplicatedPrimaryHostName *string

	// READ-ONLY; The changing DNS name that resolves to the current geo-primary cache among the linked redis caches before or
	// after the Geo Failover.
	PrimaryHostName *string
}

// LinkedServerProperties - Properties of a linked server to be returned in get/put response
type LinkedServerProperties struct {
	// REQUIRED; Fully qualified resourceId of the linked redis cache.
	LinkedRedisCacheID *string

	// REQUIRED; Location of the linked redis cache.
	LinkedRedisCacheLocation *string

	// REQUIRED; Role of the linked server.
	ServerRole *ReplicationRole

	// READ-ONLY; The unchanging DNS name which will always point to current geo-primary cache among the linked redis caches for
	// seamless Geo Failover experience.
	GeoReplicatedPrimaryHostName *string

	// READ-ONLY; The changing DNS name that resolves to the current geo-primary cache among the linked redis caches before or
	// after the Geo Failover.
	PrimaryHostName *string

	// READ-ONLY; Terminal state of the link between primary and secondary redis cache.
	ProvisioningState *string
}

// LinkedServerWithProperties - Response to put/get linked server (with properties) for Redis cache.
type LinkedServerWithProperties struct {
	// Properties of the linked server.
	Properties *LinkedServerProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// LinkedServerWithPropertiesList - List of linked servers (with properties) of a Redis cache.
type LinkedServerWithPropertiesList struct {
	// List of linked servers (with properties) of a Redis cache.
	Value []*LinkedServerWithProperties

	// READ-ONLY; Link for next set.
	NextLink *string
}

// ListResult - The response of list Redis operation.
type ListResult struct {
	// List of Redis cache instances.
	Value []*ResourceInfo

	// READ-ONLY; Link for next page of results.
	NextLink *string
}

// ManagedServiceIdentity - Managed service identity (system assigned and/or user assigned identities)
type ManagedServiceIdentity struct {
	// REQUIRED; Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
	Type *ManagedServiceIdentityType

	// The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM
	// resource ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
	// The dictionary values can be empty objects ({}) in
	// requests.
	UserAssignedIdentities map[string]*UserAssignedIdentity

	// READ-ONLY; The service principal ID of the system assigned identity. This property will only be provided for a system assigned
	// identity.
	PrincipalID *string

	// READ-ONLY; The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
	TenantID *string
}

// NotificationListResponse - The response of listUpgradeNotifications.
type NotificationListResponse struct {
	// List of all notifications.
	Value []*UpgradeNotification

	// READ-ONLY; Link for next set of notifications.
	NextLink *string
}

// Operation - REST API operation
type Operation struct {
	// The object that describes the operation.
	Display *OperationDisplay

	// Operation name: {provider}/{resource}/{operation}
	Name *string
}

// OperationDisplay - The object that describes the operation.
type OperationDisplay struct {
	// Friendly name of the operation
	Description *string

	// Operation type: read, write, delete, listKeys/action, etc.
	Operation *string

	// Friendly name of the resource provider
	Provider *string

	// Resource type on which the operation is performed.
	Resource *string
}

// OperationListResult - Result of the request to list REST API operations. It contains a list of operations and a URL nextLink
// to get the next set of results.
type OperationListResult struct {
	// List of operations supported by the resource provider.
	Value []*Operation

	// READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string
}

// OperationStatus - Asynchronous operation status
type OperationStatus struct {
	// REQUIRED; Operation status.
	Status *string

	// The end time of the operation.
	EndTime *time.Time

	// If present, details of the operation error.
	Error *ErrorDetail

	// Fully qualified ID for the async operation.
	ID *string

	// Name of the async operation.
	Name *string

	// The operations list.
	Operations []*OperationStatusResult

	// Percent of the operation that is complete.
	PercentComplete *float32

	// Additional properties from RP, only when operation is successful
	Properties map[string]any

	// The start time of the operation.
	StartTime *time.Time
}

// OperationStatusResult - The current status of an async operation.
type OperationStatusResult struct {
	// REQUIRED; Operation status.
	Status *string

	// The end time of the operation.
	EndTime *time.Time

	// If present, details of the operation error.
	Error *ErrorDetail

	// Fully qualified ID for the async operation.
	ID *string

	// Name of the async operation.
	Name *string

	// The operations list.
	Operations []*OperationStatusResult

	// Percent of the operation that is complete.
	PercentComplete *float32

	// The start time of the operation.
	StartTime *time.Time
}

// PatchSchedule - Response to put/get patch schedules for Redis cache.
type PatchSchedule struct {
	// REQUIRED; List of patch schedules for a Redis cache.
	Properties *ScheduleEntries

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The geo-location where the resource lives
	Location *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PatchScheduleListResult - The response of list patch schedules Redis operation.
type PatchScheduleListResult struct {
	// Results of the list patch schedules operation.
	Value []*PatchSchedule

	// READ-ONLY; Link for next page of results.
	NextLink *string
}

// PrivateEndpoint - The Private Endpoint resource.
type PrivateEndpoint struct {
	// READ-ONLY; The ARM identifier for Private Endpoint
	ID *string
}

// PrivateEndpointConnection - The Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateEndpointConnectionListResult - List of private endpoint connection associated with the specified storage account
type PrivateEndpointConnectionListResult struct {
	// Array of private endpoint connections
	Value []*PrivateEndpointConnection
}

// PrivateEndpointConnectionProperties - Properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState

	// The resource of private end point.
	PrivateEndpoint *PrivateEndpoint

	// READ-ONLY; The provisioning state of the private endpoint connection resource.
	ProvisioningState *PrivateEndpointConnectionProvisioningState
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*PrivateLinkResource
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// The private link resource Private link DNS zone name.
	RequiredZoneNames []*string

	// READ-ONLY; The private link resource group id.
	GroupID *string

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string
}

// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer
// and provider.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string

	// The reason for approval/rejection of the connection.
	Description *string

	// Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
	Status *PrivateEndpointServiceConnectionStatus
}

// Properties of the redis cache.
type Properties struct {
	// REQUIRED; The SKU of the Redis cache to deploy.
	SKU *SKU

	// Specifies whether the non-ssl Redis server port (6379) is enabled.
	EnableNonSSLPort *bool

	// Optional: requires clients to use a specified TLS version (or higher) to connect (e,g, '1.0', '1.1', '1.2')
	MinimumTLSVersion *TLSVersion

	// Whether or not public endpoint access is allowed for this cache. Value is optional but if passed in, must be 'Enabled'
	// or 'Disabled'. If 'Disabled', private endpoints are the exclusive access method.
	// Default value is 'Enabled'
	PublicNetworkAccess *PublicNetworkAccess

	// All Redis Settings. Few possible keys:
	// rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value
	// etc.
	RedisConfiguration *CommonPropertiesRedisConfiguration

	// Redis version. This should be in the form 'major[.minor]' (only 'major' is required) or the value 'latest' which refers
	// to the latest stable Redis version that is available. Supported versions: 4.0,
	// 6.0 (latest). Default value is 'latest'.
	RedisVersion *string

	// The number of replicas to be created per primary.
	ReplicasPerMaster *int32

	// The number of replicas to be created per primary.
	ReplicasPerPrimary *int32

	// The number of shards to be created on a Premium Cluster Cache.
	ShardCount *int32

	// Static IP address. Optionally, may be specified when deploying a Redis cache inside an existing Azure Virtual Network;
	// auto assigned by default.
	StaticIP *string

	// The full resource ID of a subnet in a virtual network to deploy the Redis cache in. Example format:
	// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Microsoft.{Network|ClassicNetwork}/VirtualNetworks/vnet1/subnets/subnet1
	SubnetID *string

	// A dictionary of tenant settings
	TenantSettings map[string]*string

	// Optional: Specifies the update channel for the monthly Redis updates your Redis Cache will receive. Caches using 'Preview'
	// update channel get latest Redis updates at least 4 weeks ahead of 'Stable'
	// channel caches. Default value is 'Stable'.
	UpdateChannel *UpdateChannel

	// READ-ONLY; The keys of the Redis cache - not set if this object is not the response to Create or Update redis cache
	AccessKeys *AccessKeys

	// READ-ONLY; Redis host name.
	HostName *string

	// READ-ONLY; List of the Redis instances associated with the cache
	Instances []*InstanceDetails

	// READ-ONLY; List of the linked servers associated with the cache
	LinkedServers []*LinkedServer

	// READ-ONLY; Redis non-SSL port.
	Port *int32

	// READ-ONLY; List of private endpoint connection associated with the specified redis cache
	PrivateEndpointConnections []*PrivateEndpointConnection

	// READ-ONLY; Redis instance provisioning status.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Redis SSL port.
	SSLPort *int32
}

// RebootParameters - Specifies which Redis node(s) to reboot.
type RebootParameters struct {
	// A list of redis instances to reboot, specified by per-instance SSL ports or non-SSL ports.
	Ports []*int32

	// Which Redis node(s) to reboot. Depending on this value data loss is possible.
	RebootType *RebootType

	// If clustering is enabled, the ID of the shard to be rebooted.
	ShardID *int32
}

// RegenerateKeyParameters - Specifies which Redis access keys to reset.
type RegenerateKeyParameters struct {
	// REQUIRED; The Redis access key to regenerate.
	KeyType *RedisKeyType
}

// ResourceInfo - A single Redis item in List or Get Operation.
type ResourceInfo struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; Redis cache properties.
	Properties *Properties

	// The identity of the resource.
	Identity *ManagedServiceIdentity

	// Resource tags.
	Tags map[string]*string

	// A list of availability zones denoting where the resource needs to come from.
	Zones []*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SKU parameters supplied to the create Redis operation.
type SKU struct {
	// REQUIRED; The size of the Redis cache to deploy. Valid values: for C (Basic/Standard) family (0, 1, 2, 3, 4, 5, 6), for
	// P (Premium) family (1, 2, 3, 4).
	Capacity *int32

	// REQUIRED; The SKU family to use. Valid values: (C, P). (C = Basic/Standard, P = Premium).
	Family *SKUFamily

	// REQUIRED; The type of Redis cache to deploy. Valid values: (Basic, Standard, Premium)
	Name *SKUName
}

// ScheduleEntries - List of patch schedules for a Redis cache.
type ScheduleEntries struct {
	// REQUIRED; List of patch schedules for a Redis cache.
	ScheduleEntries []*ScheduleEntry
}

// ScheduleEntry - Patch schedule entry for a Premium Redis Cache.
type ScheduleEntry struct {
	// REQUIRED; Day of the week when a cache can be patched.
	DayOfWeek *DayOfWeek

	// REQUIRED; Start hour after which cache patching can start.
	StartHourUTC *int32

	// ISO8601 timespan specifying how much time cache patching can take.
	MaintenanceWindow *string
}

// UpdateParameters - Parameters supplied to the Update Redis operation.
type UpdateParameters struct {
	// The identity of the resource.
	Identity *ManagedServiceIdentity

	// Redis cache properties.
	Properties *UpdateProperties

	// Resource tags.
	Tags map[string]*string
}

// UpdateProperties - Patchable properties of the redis cache.
type UpdateProperties struct {
	// Specifies whether the non-ssl Redis server port (6379) is enabled.
	EnableNonSSLPort *bool

	// Optional: requires clients to use a specified TLS version (or higher) to connect (e,g, '1.0', '1.1', '1.2')
	MinimumTLSVersion *TLSVersion

	// Whether or not public endpoint access is allowed for this cache. Value is optional but if passed in, must be 'Enabled'
	// or 'Disabled'. If 'Disabled', private endpoints are the exclusive access method.
	// Default value is 'Enabled'
	PublicNetworkAccess *PublicNetworkAccess

	// All Redis Settings. Few possible keys:
	// rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value
	// etc.
	RedisConfiguration *CommonPropertiesRedisConfiguration

	// Redis version. This should be in the form 'major[.minor]' (only 'major' is required) or the value 'latest' which refers
	// to the latest stable Redis version that is available. Supported versions: 4.0,
	// 6.0 (latest). Default value is 'latest'.
	RedisVersion *string

	// The number of replicas to be created per primary.
	ReplicasPerMaster *int32

	// The number of replicas to be created per primary.
	ReplicasPerPrimary *int32

	// The SKU of the Redis cache to deploy.
	SKU *SKU

	// The number of shards to be created on a Premium Cluster Cache.
	ShardCount *int32

	// A dictionary of tenant settings
	TenantSettings map[string]*string

	// Optional: Specifies the update channel for the monthly Redis updates your Redis Cache will receive. Caches using 'Preview'
	// update channel get latest Redis updates at least 4 weeks ahead of 'Stable'
	// channel caches. Default value is 'Stable'.
	UpdateChannel *UpdateChannel
}

// UpgradeNotification - Properties of upgrade notification.
type UpgradeNotification struct {
	// READ-ONLY; Name of upgrade notification.
	Name *string

	// READ-ONLY; Timestamp when upgrade notification occurred.
	Timestamp *time.Time

	// READ-ONLY; Details about this upgrade notification
	UpsellNotification map[string]*string
}

// UserAssignedIdentity - User assigned identity properties
type UserAssignedIdentity struct {
	// READ-ONLY; The client ID of the assigned identity.
	ClientID *string

	// READ-ONLY; The principal ID of the assigned identity.
	PrincipalID *string
}
