//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/recoveryservices/armrecoveryservicessiterecovery/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ReplicationJobsServer is a fake server for instances of the armrecoveryservicessiterecovery.ReplicationJobsClient type.
type ReplicationJobsServer struct {
	// BeginCancel is the fake for method ReplicationJobsClient.BeginCancel
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCancel func(ctx context.Context, resourceName string, resourceGroupName string, jobName string, options *armrecoveryservicessiterecovery.ReplicationJobsClientBeginCancelOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationJobsClientCancelResponse], errResp azfake.ErrorResponder)

	// BeginExport is the fake for method ReplicationJobsClient.BeginExport
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginExport func(ctx context.Context, resourceName string, resourceGroupName string, jobQueryParameter armrecoveryservicessiterecovery.JobQueryParameter, options *armrecoveryservicessiterecovery.ReplicationJobsClientBeginExportOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationJobsClientExportResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ReplicationJobsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceName string, resourceGroupName string, jobName string, options *armrecoveryservicessiterecovery.ReplicationJobsClientGetOptions) (resp azfake.Responder[armrecoveryservicessiterecovery.ReplicationJobsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method ReplicationJobsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceName string, resourceGroupName string, options *armrecoveryservicessiterecovery.ReplicationJobsClientListOptions) (resp azfake.PagerResponder[armrecoveryservicessiterecovery.ReplicationJobsClientListResponse])

	// BeginRestart is the fake for method ReplicationJobsClient.BeginRestart
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRestart func(ctx context.Context, resourceName string, resourceGroupName string, jobName string, options *armrecoveryservicessiterecovery.ReplicationJobsClientBeginRestartOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationJobsClientRestartResponse], errResp azfake.ErrorResponder)

	// BeginResume is the fake for method ReplicationJobsClient.BeginResume
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginResume func(ctx context.Context, resourceName string, resourceGroupName string, jobName string, resumeJobParams armrecoveryservicessiterecovery.ResumeJobParams, options *armrecoveryservicessiterecovery.ReplicationJobsClientBeginResumeOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationJobsClientResumeResponse], errResp azfake.ErrorResponder)
}

// NewReplicationJobsServerTransport creates a new instance of ReplicationJobsServerTransport with the provided implementation.
// The returned ReplicationJobsServerTransport instance is connected to an instance of armrecoveryservicessiterecovery.ReplicationJobsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewReplicationJobsServerTransport(srv *ReplicationJobsServer) *ReplicationJobsServerTransport {
	return &ReplicationJobsServerTransport{
		srv:          srv,
		beginCancel:  newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationJobsClientCancelResponse]](),
		beginExport:  newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationJobsClientExportResponse]](),
		newListPager: newTracker[azfake.PagerResponder[armrecoveryservicessiterecovery.ReplicationJobsClientListResponse]](),
		beginRestart: newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationJobsClientRestartResponse]](),
		beginResume:  newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationJobsClientResumeResponse]](),
	}
}

// ReplicationJobsServerTransport connects instances of armrecoveryservicessiterecovery.ReplicationJobsClient to instances of ReplicationJobsServer.
// Don't use this type directly, use NewReplicationJobsServerTransport instead.
type ReplicationJobsServerTransport struct {
	srv          *ReplicationJobsServer
	beginCancel  *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationJobsClientCancelResponse]]
	beginExport  *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationJobsClientExportResponse]]
	newListPager *tracker[azfake.PagerResponder[armrecoveryservicessiterecovery.ReplicationJobsClientListResponse]]
	beginRestart *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationJobsClientRestartResponse]]
	beginResume  *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationJobsClientResumeResponse]]
}

// Do implements the policy.Transporter interface for ReplicationJobsServerTransport.
func (r *ReplicationJobsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ReplicationJobsClient.BeginCancel":
		resp, err = r.dispatchBeginCancel(req)
	case "ReplicationJobsClient.BeginExport":
		resp, err = r.dispatchBeginExport(req)
	case "ReplicationJobsClient.Get":
		resp, err = r.dispatchGet(req)
	case "ReplicationJobsClient.NewListPager":
		resp, err = r.dispatchNewListPager(req)
	case "ReplicationJobsClient.BeginRestart":
		resp, err = r.dispatchBeginRestart(req)
	case "ReplicationJobsClient.BeginResume":
		resp, err = r.dispatchBeginResume(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *ReplicationJobsServerTransport) dispatchBeginCancel(req *http.Request) (*http.Response, error) {
	if r.srv.BeginCancel == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCancel not implemented")}
	}
	beginCancel := r.beginCancel.get(req)
	if beginCancel == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationJobs/(?P<jobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cancel`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		jobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginCancel(req.Context(), resourceNameParam, resourceGroupNameParam, jobNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCancel = &respr
		r.beginCancel.add(req, beginCancel)
	}

	resp, err := server.PollerResponderNext(beginCancel, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginCancel.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCancel) {
		r.beginCancel.remove(req)
	}

	return resp, nil
}

func (r *ReplicationJobsServerTransport) dispatchBeginExport(req *http.Request) (*http.Response, error) {
	if r.srv.BeginExport == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginExport not implemented")}
	}
	beginExport := r.beginExport.get(req)
	if beginExport == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationJobs/export`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armrecoveryservicessiterecovery.JobQueryParameter](req)
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginExport(req.Context(), resourceNameParam, resourceGroupNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginExport = &respr
		r.beginExport.add(req, beginExport)
	}

	resp, err := server.PollerResponderNext(beginExport, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginExport.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginExport) {
		r.beginExport.remove(req)
	}

	return resp, nil
}

func (r *ReplicationJobsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if r.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationJobs/(?P<jobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	jobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Get(req.Context(), resourceNameParam, resourceGroupNameParam, jobNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Job, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ReplicationJobsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := r.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationJobs`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armrecoveryservicessiterecovery.ReplicationJobsClientListOptions
		if filterParam != nil {
			options = &armrecoveryservicessiterecovery.ReplicationJobsClientListOptions{
				Filter: filterParam,
			}
		}
		resp := r.srv.NewListPager(resourceNameParam, resourceGroupNameParam, options)
		newListPager = &resp
		r.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armrecoveryservicessiterecovery.ReplicationJobsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		r.newListPager.remove(req)
	}
	return resp, nil
}

func (r *ReplicationJobsServerTransport) dispatchBeginRestart(req *http.Request) (*http.Response, error) {
	if r.srv.BeginRestart == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRestart not implemented")}
	}
	beginRestart := r.beginRestart.get(req)
	if beginRestart == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationJobs/(?P<jobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/restart`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		jobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginRestart(req.Context(), resourceNameParam, resourceGroupNameParam, jobNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRestart = &respr
		r.beginRestart.add(req, beginRestart)
	}

	resp, err := server.PollerResponderNext(beginRestart, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginRestart.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRestart) {
		r.beginRestart.remove(req)
	}

	return resp, nil
}

func (r *ReplicationJobsServerTransport) dispatchBeginResume(req *http.Request) (*http.Response, error) {
	if r.srv.BeginResume == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginResume not implemented")}
	}
	beginResume := r.beginResume.get(req)
	if beginResume == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationJobs/(?P<jobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resume`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armrecoveryservicessiterecovery.ResumeJobParams](req)
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		jobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginResume(req.Context(), resourceNameParam, resourceGroupNameParam, jobNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginResume = &respr
		r.beginResume.add(req, beginResume)
	}

	resp, err := server.PollerResponderNext(beginResume, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginResume.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginResume) {
		r.beginResume.remove(req)
	}

	return resp, nil
}
