//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/recoveryservices/armrecoveryservicesbackup/v4"
	"net/http"
	"net/url"
	"regexp"
)

// FetchTieringCostServer is a fake server for instances of the armrecoveryservicesbackup.FetchTieringCostClient type.
type FetchTieringCostServer struct {
	// BeginPost is the fake for method FetchTieringCostClient.BeginPost
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginPost func(ctx context.Context, resourceGroupName string, vaultName string, parameters armrecoveryservicesbackup.FetchTieringCostInfoRequestClassification, options *armrecoveryservicesbackup.FetchTieringCostClientBeginPostOptions) (resp azfake.PollerResponder[armrecoveryservicesbackup.FetchTieringCostClientPostResponse], errResp azfake.ErrorResponder)
}

// NewFetchTieringCostServerTransport creates a new instance of FetchTieringCostServerTransport with the provided implementation.
// The returned FetchTieringCostServerTransport instance is connected to an instance of armrecoveryservicesbackup.FetchTieringCostClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewFetchTieringCostServerTransport(srv *FetchTieringCostServer) *FetchTieringCostServerTransport {
	return &FetchTieringCostServerTransport{
		srv:       srv,
		beginPost: newTracker[azfake.PollerResponder[armrecoveryservicesbackup.FetchTieringCostClientPostResponse]](),
	}
}

// FetchTieringCostServerTransport connects instances of armrecoveryservicesbackup.FetchTieringCostClient to instances of FetchTieringCostServer.
// Don't use this type directly, use NewFetchTieringCostServerTransport instead.
type FetchTieringCostServerTransport struct {
	srv       *FetchTieringCostServer
	beginPost *tracker[azfake.PollerResponder[armrecoveryservicesbackup.FetchTieringCostClientPostResponse]]
}

// Do implements the policy.Transporter interface for FetchTieringCostServerTransport.
func (f *FetchTieringCostServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "FetchTieringCostClient.BeginPost":
		resp, err = f.dispatchBeginPost(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (f *FetchTieringCostServerTransport) dispatchBeginPost(req *http.Request) (*http.Response, error) {
	if f.srv.BeginPost == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginPost not implemented")}
	}
	beginPost := f.beginPost.get(req)
	if beginPost == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupTieringCost/default/fetchTieringCost`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		raw, err := readRequestBody(req)
		if err != nil {
			return nil, err
		}
		body, err := unmarshalFetchTieringCostInfoRequestClassification(raw)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := f.srv.BeginPost(req.Context(), resourceGroupNameParam, vaultNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginPost = &respr
		f.beginPost.add(req, beginPost)
	}

	resp, err := server.PollerResponderNext(beginPost, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		f.beginPost.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginPost) {
		f.beginPost.remove(req)
	}

	return resp, nil
}
