//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpostgresql

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewCheckNameAvailabilityClient creates a new instance of CheckNameAvailabilityClient.
func (c *ClientFactory) NewCheckNameAvailabilityClient() *CheckNameAvailabilityClient {
	subClient, _ := NewCheckNameAvailabilityClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewConfigurationsClient creates a new instance of ConfigurationsClient.
func (c *ClientFactory) NewConfigurationsClient() *ConfigurationsClient {
	subClient, _ := NewConfigurationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDatabasesClient creates a new instance of DatabasesClient.
func (c *ClientFactory) NewDatabasesClient() *DatabasesClient {
	subClient, _ := NewDatabasesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewFirewallRulesClient creates a new instance of FirewallRulesClient.
func (c *ClientFactory) NewFirewallRulesClient() *FirewallRulesClient {
	subClient, _ := NewFirewallRulesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewLocationBasedPerformanceTierClient creates a new instance of LocationBasedPerformanceTierClient.
func (c *ClientFactory) NewLocationBasedPerformanceTierClient() *LocationBasedPerformanceTierClient {
	subClient, _ := NewLocationBasedPerformanceTierClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewLogFilesClient creates a new instance of LogFilesClient.
func (c *ClientFactory) NewLogFilesClient() *LogFilesClient {
	subClient, _ := NewLogFilesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewPrivateEndpointConnectionsClient creates a new instance of PrivateEndpointConnectionsClient.
func (c *ClientFactory) NewPrivateEndpointConnectionsClient() *PrivateEndpointConnectionsClient {
	subClient, _ := NewPrivateEndpointConnectionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateLinkResourcesClient creates a new instance of PrivateLinkResourcesClient.
func (c *ClientFactory) NewPrivateLinkResourcesClient() *PrivateLinkResourcesClient {
	subClient, _ := NewPrivateLinkResourcesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewRecoverableServersClient creates a new instance of RecoverableServersClient.
func (c *ClientFactory) NewRecoverableServersClient() *RecoverableServersClient {
	subClient, _ := NewRecoverableServersClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewReplicasClient creates a new instance of ReplicasClient.
func (c *ClientFactory) NewReplicasClient() *ReplicasClient {
	subClient, _ := NewReplicasClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServerAdministratorsClient creates a new instance of ServerAdministratorsClient.
func (c *ClientFactory) NewServerAdministratorsClient() *ServerAdministratorsClient {
	subClient, _ := NewServerAdministratorsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServerBasedPerformanceTierClient creates a new instance of ServerBasedPerformanceTierClient.
func (c *ClientFactory) NewServerBasedPerformanceTierClient() *ServerBasedPerformanceTierClient {
	subClient, _ := NewServerBasedPerformanceTierClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServerKeysClient creates a new instance of ServerKeysClient.
func (c *ClientFactory) NewServerKeysClient() *ServerKeysClient {
	subClient, _ := NewServerKeysClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServerParametersClient creates a new instance of ServerParametersClient.
func (c *ClientFactory) NewServerParametersClient() *ServerParametersClient {
	subClient, _ := NewServerParametersClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServerSecurityAlertPoliciesClient creates a new instance of ServerSecurityAlertPoliciesClient.
func (c *ClientFactory) NewServerSecurityAlertPoliciesClient() *ServerSecurityAlertPoliciesClient {
	subClient, _ := NewServerSecurityAlertPoliciesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServersClient creates a new instance of ServersClient.
func (c *ClientFactory) NewServersClient() *ServersClient {
	subClient, _ := NewServersClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVirtualNetworkRulesClient creates a new instance of VirtualNetworkRulesClient.
func (c *ClientFactory) NewVirtualNetworkRulesClient() *VirtualNetworkRulesClient {
	subClient, _ := NewVirtualNetworkRulesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
