//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpolicyinsights

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
	"time"
)

// PolicyEventsClient contains the methods for the PolicyEvents group.
// Don't use this type directly, use NewPolicyEventsClient() instead.
type PolicyEventsClient struct {
	internal *arm.Client
}

// NewPolicyEventsClient creates a new instance of PolicyEventsClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewPolicyEventsClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*PolicyEventsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &PolicyEventsClient{
		internal: cl,
	}
	return client, nil
}

// NewListQueryResultsForManagementGroupPager - Queries policy events for the resources under the management group.
//
// Generated from API version 2019-10-01
//   - policyEventsResource - The name of the virtual resource under PolicyEvents resource type; only "default" is allowed.
//   - managementGroupName - Management group name.
//   - QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
//     method.
//   - options - PolicyEventsClientListQueryResultsForManagementGroupOptions contains the optional parameters for the PolicyEventsClient.NewListQueryResultsForManagementGroupPager
//     method.
func (client *PolicyEventsClient) NewListQueryResultsForManagementGroupPager(policyEventsResource PolicyEventsResourceType, managementGroupName string, queryOptions *QueryOptions, options *PolicyEventsClientListQueryResultsForManagementGroupOptions) *runtime.Pager[PolicyEventsClientListQueryResultsForManagementGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[PolicyEventsClientListQueryResultsForManagementGroupResponse]{
		More: func(page PolicyEventsClientListQueryResultsForManagementGroupResponse) bool {
			return page.ODataNextLink != nil && len(*page.ODataNextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *PolicyEventsClientListQueryResultsForManagementGroupResponse) (PolicyEventsClientListQueryResultsForManagementGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "PolicyEventsClient.NewListQueryResultsForManagementGroupPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.ODataNextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listQueryResultsForManagementGroupCreateRequest(ctx, policyEventsResource, managementGroupName, queryOptions, options)
			}, nil)
			if err != nil {
				return PolicyEventsClientListQueryResultsForManagementGroupResponse{}, err
			}
			return client.listQueryResultsForManagementGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listQueryResultsForManagementGroupCreateRequest creates the ListQueryResultsForManagementGroup request.
func (client *PolicyEventsClient) listQueryResultsForManagementGroupCreateRequest(ctx context.Context, policyEventsResource PolicyEventsResourceType, managementGroupName string, queryOptions *QueryOptions, options *PolicyEventsClientListQueryResultsForManagementGroupOptions) (*policy.Request, error) {
	urlPath := "/providers/{managementGroupsNamespace}/managementGroups/{managementGroupName}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults"
	if policyEventsResource == "" {
		return nil, errors.New("parameter policyEventsResource cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyEventsResource}", url.PathEscape(string(policyEventsResource)))
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupsNamespace}", url.PathEscape("Microsoft.Management"))
	if managementGroupName == "" {
		return nil, errors.New("parameter managementGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupName}", url.PathEscape(managementGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.OrderBy != nil {
		reqQP.Set("$orderby", *queryOptions.OrderBy)
	}
	if queryOptions != nil && queryOptions.Select != nil {
		reqQP.Set("$select", *queryOptions.Select)
	}
	if queryOptions != nil && queryOptions.From != nil {
		reqQP.Set("$from", queryOptions.From.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.To != nil {
		reqQP.Set("$to", queryOptions.To.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	if queryOptions != nil && queryOptions.Apply != nil {
		reqQP.Set("$apply", *queryOptions.Apply)
	}
	if queryOptions != nil && queryOptions.SkipToken != nil {
		reqQP.Set("$skiptoken", *queryOptions.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listQueryResultsForManagementGroupHandleResponse handles the ListQueryResultsForManagementGroup response.
func (client *PolicyEventsClient) listQueryResultsForManagementGroupHandleResponse(resp *http.Response) (PolicyEventsClientListQueryResultsForManagementGroupResponse, error) {
	result := PolicyEventsClientListQueryResultsForManagementGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PolicyEventsQueryResults); err != nil {
		return PolicyEventsClientListQueryResultsForManagementGroupResponse{}, err
	}
	return result, nil
}

// NewListQueryResultsForPolicyDefinitionPager - Queries policy events for the subscription level policy definition.
//
// Generated from API version 2019-10-01
//   - policyEventsResource - The name of the virtual resource under PolicyEvents resource type; only "default" is allowed.
//   - subscriptionID - Microsoft Azure subscription ID.
//   - policyDefinitionName - Policy definition name.
//   - QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
//     method.
//   - options - PolicyEventsClientListQueryResultsForPolicyDefinitionOptions contains the optional parameters for the PolicyEventsClient.NewListQueryResultsForPolicyDefinitionPager
//     method.
func (client *PolicyEventsClient) NewListQueryResultsForPolicyDefinitionPager(policyEventsResource PolicyEventsResourceType, subscriptionID string, policyDefinitionName string, queryOptions *QueryOptions, options *PolicyEventsClientListQueryResultsForPolicyDefinitionOptions) *runtime.Pager[PolicyEventsClientListQueryResultsForPolicyDefinitionResponse] {
	return runtime.NewPager(runtime.PagingHandler[PolicyEventsClientListQueryResultsForPolicyDefinitionResponse]{
		More: func(page PolicyEventsClientListQueryResultsForPolicyDefinitionResponse) bool {
			return page.ODataNextLink != nil && len(*page.ODataNextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *PolicyEventsClientListQueryResultsForPolicyDefinitionResponse) (PolicyEventsClientListQueryResultsForPolicyDefinitionResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "PolicyEventsClient.NewListQueryResultsForPolicyDefinitionPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.ODataNextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listQueryResultsForPolicyDefinitionCreateRequest(ctx, policyEventsResource, subscriptionID, policyDefinitionName, queryOptions, options)
			}, nil)
			if err != nil {
				return PolicyEventsClientListQueryResultsForPolicyDefinitionResponse{}, err
			}
			return client.listQueryResultsForPolicyDefinitionHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listQueryResultsForPolicyDefinitionCreateRequest creates the ListQueryResultsForPolicyDefinition request.
func (client *PolicyEventsClient) listQueryResultsForPolicyDefinitionCreateRequest(ctx context.Context, policyEventsResource PolicyEventsResourceType, subscriptionID string, policyDefinitionName string, queryOptions *QueryOptions, options *PolicyEventsClientListQueryResultsForPolicyDefinitionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policyDefinitions/{policyDefinitionName}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults"
	if policyEventsResource == "" {
		return nil, errors.New("parameter policyEventsResource cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyEventsResource}", url.PathEscape(string(policyEventsResource)))
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	urlPath = strings.ReplaceAll(urlPath, "{authorizationNamespace}", url.PathEscape("Microsoft.Authorization"))
	if policyDefinitionName == "" {
		return nil, errors.New("parameter policyDefinitionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyDefinitionName}", url.PathEscape(policyDefinitionName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.OrderBy != nil {
		reqQP.Set("$orderby", *queryOptions.OrderBy)
	}
	if queryOptions != nil && queryOptions.Select != nil {
		reqQP.Set("$select", *queryOptions.Select)
	}
	if queryOptions != nil && queryOptions.From != nil {
		reqQP.Set("$from", queryOptions.From.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.To != nil {
		reqQP.Set("$to", queryOptions.To.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	if queryOptions != nil && queryOptions.Apply != nil {
		reqQP.Set("$apply", *queryOptions.Apply)
	}
	if queryOptions != nil && queryOptions.SkipToken != nil {
		reqQP.Set("$skiptoken", *queryOptions.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listQueryResultsForPolicyDefinitionHandleResponse handles the ListQueryResultsForPolicyDefinition response.
func (client *PolicyEventsClient) listQueryResultsForPolicyDefinitionHandleResponse(resp *http.Response) (PolicyEventsClientListQueryResultsForPolicyDefinitionResponse, error) {
	result := PolicyEventsClientListQueryResultsForPolicyDefinitionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PolicyEventsQueryResults); err != nil {
		return PolicyEventsClientListQueryResultsForPolicyDefinitionResponse{}, err
	}
	return result, nil
}

// NewListQueryResultsForPolicySetDefinitionPager - Queries policy events for the subscription level policy set definition.
//
// Generated from API version 2019-10-01
//   - policyEventsResource - The name of the virtual resource under PolicyEvents resource type; only "default" is allowed.
//   - subscriptionID - Microsoft Azure subscription ID.
//   - policySetDefinitionName - Policy set definition name.
//   - QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
//     method.
//   - options - PolicyEventsClientListQueryResultsForPolicySetDefinitionOptions contains the optional parameters for the PolicyEventsClient.NewListQueryResultsForPolicySetDefinitionPager
//     method.
func (client *PolicyEventsClient) NewListQueryResultsForPolicySetDefinitionPager(policyEventsResource PolicyEventsResourceType, subscriptionID string, policySetDefinitionName string, queryOptions *QueryOptions, options *PolicyEventsClientListQueryResultsForPolicySetDefinitionOptions) *runtime.Pager[PolicyEventsClientListQueryResultsForPolicySetDefinitionResponse] {
	return runtime.NewPager(runtime.PagingHandler[PolicyEventsClientListQueryResultsForPolicySetDefinitionResponse]{
		More: func(page PolicyEventsClientListQueryResultsForPolicySetDefinitionResponse) bool {
			return page.ODataNextLink != nil && len(*page.ODataNextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *PolicyEventsClientListQueryResultsForPolicySetDefinitionResponse) (PolicyEventsClientListQueryResultsForPolicySetDefinitionResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "PolicyEventsClient.NewListQueryResultsForPolicySetDefinitionPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.ODataNextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listQueryResultsForPolicySetDefinitionCreateRequest(ctx, policyEventsResource, subscriptionID, policySetDefinitionName, queryOptions, options)
			}, nil)
			if err != nil {
				return PolicyEventsClientListQueryResultsForPolicySetDefinitionResponse{}, err
			}
			return client.listQueryResultsForPolicySetDefinitionHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listQueryResultsForPolicySetDefinitionCreateRequest creates the ListQueryResultsForPolicySetDefinition request.
func (client *PolicyEventsClient) listQueryResultsForPolicySetDefinitionCreateRequest(ctx context.Context, policyEventsResource PolicyEventsResourceType, subscriptionID string, policySetDefinitionName string, queryOptions *QueryOptions, options *PolicyEventsClientListQueryResultsForPolicySetDefinitionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policySetDefinitions/{policySetDefinitionName}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults"
	if policyEventsResource == "" {
		return nil, errors.New("parameter policyEventsResource cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyEventsResource}", url.PathEscape(string(policyEventsResource)))
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	urlPath = strings.ReplaceAll(urlPath, "{authorizationNamespace}", url.PathEscape("Microsoft.Authorization"))
	if policySetDefinitionName == "" {
		return nil, errors.New("parameter policySetDefinitionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policySetDefinitionName}", url.PathEscape(policySetDefinitionName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.OrderBy != nil {
		reqQP.Set("$orderby", *queryOptions.OrderBy)
	}
	if queryOptions != nil && queryOptions.Select != nil {
		reqQP.Set("$select", *queryOptions.Select)
	}
	if queryOptions != nil && queryOptions.From != nil {
		reqQP.Set("$from", queryOptions.From.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.To != nil {
		reqQP.Set("$to", queryOptions.To.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	if queryOptions != nil && queryOptions.Apply != nil {
		reqQP.Set("$apply", *queryOptions.Apply)
	}
	if queryOptions != nil && queryOptions.SkipToken != nil {
		reqQP.Set("$skiptoken", *queryOptions.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listQueryResultsForPolicySetDefinitionHandleResponse handles the ListQueryResultsForPolicySetDefinition response.
func (client *PolicyEventsClient) listQueryResultsForPolicySetDefinitionHandleResponse(resp *http.Response) (PolicyEventsClientListQueryResultsForPolicySetDefinitionResponse, error) {
	result := PolicyEventsClientListQueryResultsForPolicySetDefinitionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PolicyEventsQueryResults); err != nil {
		return PolicyEventsClientListQueryResultsForPolicySetDefinitionResponse{}, err
	}
	return result, nil
}

// NewListQueryResultsForResourcePager - Queries policy events for the resource.
//
// Generated from API version 2019-10-01
//   - policyEventsResource - The name of the virtual resource under PolicyEvents resource type; only "default" is allowed.
//   - resourceID - Resource ID.
//   - QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
//     method.
//   - options - PolicyEventsClientListQueryResultsForResourceOptions contains the optional parameters for the PolicyEventsClient.NewListQueryResultsForResourcePager
//     method.
func (client *PolicyEventsClient) NewListQueryResultsForResourcePager(policyEventsResource PolicyEventsResourceType, resourceID string, queryOptions *QueryOptions, options *PolicyEventsClientListQueryResultsForResourceOptions) *runtime.Pager[PolicyEventsClientListQueryResultsForResourceResponse] {
	return runtime.NewPager(runtime.PagingHandler[PolicyEventsClientListQueryResultsForResourceResponse]{
		More: func(page PolicyEventsClientListQueryResultsForResourceResponse) bool {
			return page.ODataNextLink != nil && len(*page.ODataNextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *PolicyEventsClientListQueryResultsForResourceResponse) (PolicyEventsClientListQueryResultsForResourceResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "PolicyEventsClient.NewListQueryResultsForResourcePager")
			nextLink := ""
			if page != nil {
				nextLink = *page.ODataNextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listQueryResultsForResourceCreateRequest(ctx, policyEventsResource, resourceID, queryOptions, options)
			}, nil)
			if err != nil {
				return PolicyEventsClientListQueryResultsForResourceResponse{}, err
			}
			return client.listQueryResultsForResourceHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listQueryResultsForResourceCreateRequest creates the ListQueryResultsForResource request.
func (client *PolicyEventsClient) listQueryResultsForResourceCreateRequest(ctx context.Context, policyEventsResource PolicyEventsResourceType, resourceID string, queryOptions *QueryOptions, options *PolicyEventsClientListQueryResultsForResourceOptions) (*policy.Request, error) {
	urlPath := "/{resourceId}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults"
	if policyEventsResource == "" {
		return nil, errors.New("parameter policyEventsResource cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyEventsResource}", url.PathEscape(string(policyEventsResource)))
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", resourceID)
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.OrderBy != nil {
		reqQP.Set("$orderby", *queryOptions.OrderBy)
	}
	if queryOptions != nil && queryOptions.Select != nil {
		reqQP.Set("$select", *queryOptions.Select)
	}
	if queryOptions != nil && queryOptions.From != nil {
		reqQP.Set("$from", queryOptions.From.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.To != nil {
		reqQP.Set("$to", queryOptions.To.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	if queryOptions != nil && queryOptions.Apply != nil {
		reqQP.Set("$apply", *queryOptions.Apply)
	}
	if queryOptions != nil && queryOptions.Expand != nil {
		reqQP.Set("$expand", *queryOptions.Expand)
	}
	if queryOptions != nil && queryOptions.SkipToken != nil {
		reqQP.Set("$skiptoken", *queryOptions.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listQueryResultsForResourceHandleResponse handles the ListQueryResultsForResource response.
func (client *PolicyEventsClient) listQueryResultsForResourceHandleResponse(resp *http.Response) (PolicyEventsClientListQueryResultsForResourceResponse, error) {
	result := PolicyEventsClientListQueryResultsForResourceResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PolicyEventsQueryResults); err != nil {
		return PolicyEventsClientListQueryResultsForResourceResponse{}, err
	}
	return result, nil
}

// NewListQueryResultsForResourceGroupPager - Queries policy events for the resources under the resource group.
//
// Generated from API version 2019-10-01
//   - policyEventsResource - The name of the virtual resource under PolicyEvents resource type; only "default" is allowed.
//   - subscriptionID - Microsoft Azure subscription ID.
//   - resourceGroupName - Resource group name.
//   - QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
//     method.
//   - options - PolicyEventsClientListQueryResultsForResourceGroupOptions contains the optional parameters for the PolicyEventsClient.NewListQueryResultsForResourceGroupPager
//     method.
func (client *PolicyEventsClient) NewListQueryResultsForResourceGroupPager(policyEventsResource PolicyEventsResourceType, subscriptionID string, resourceGroupName string, queryOptions *QueryOptions, options *PolicyEventsClientListQueryResultsForResourceGroupOptions) *runtime.Pager[PolicyEventsClientListQueryResultsForResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[PolicyEventsClientListQueryResultsForResourceGroupResponse]{
		More: func(page PolicyEventsClientListQueryResultsForResourceGroupResponse) bool {
			return page.ODataNextLink != nil && len(*page.ODataNextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *PolicyEventsClientListQueryResultsForResourceGroupResponse) (PolicyEventsClientListQueryResultsForResourceGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "PolicyEventsClient.NewListQueryResultsForResourceGroupPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.ODataNextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listQueryResultsForResourceGroupCreateRequest(ctx, policyEventsResource, subscriptionID, resourceGroupName, queryOptions, options)
			}, nil)
			if err != nil {
				return PolicyEventsClientListQueryResultsForResourceGroupResponse{}, err
			}
			return client.listQueryResultsForResourceGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listQueryResultsForResourceGroupCreateRequest creates the ListQueryResultsForResourceGroup request.
func (client *PolicyEventsClient) listQueryResultsForResourceGroupCreateRequest(ctx context.Context, policyEventsResource PolicyEventsResourceType, subscriptionID string, resourceGroupName string, queryOptions *QueryOptions, options *PolicyEventsClientListQueryResultsForResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults"
	if policyEventsResource == "" {
		return nil, errors.New("parameter policyEventsResource cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyEventsResource}", url.PathEscape(string(policyEventsResource)))
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.OrderBy != nil {
		reqQP.Set("$orderby", *queryOptions.OrderBy)
	}
	if queryOptions != nil && queryOptions.Select != nil {
		reqQP.Set("$select", *queryOptions.Select)
	}
	if queryOptions != nil && queryOptions.From != nil {
		reqQP.Set("$from", queryOptions.From.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.To != nil {
		reqQP.Set("$to", queryOptions.To.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	if queryOptions != nil && queryOptions.Apply != nil {
		reqQP.Set("$apply", *queryOptions.Apply)
	}
	if queryOptions != nil && queryOptions.SkipToken != nil {
		reqQP.Set("$skiptoken", *queryOptions.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listQueryResultsForResourceGroupHandleResponse handles the ListQueryResultsForResourceGroup response.
func (client *PolicyEventsClient) listQueryResultsForResourceGroupHandleResponse(resp *http.Response) (PolicyEventsClientListQueryResultsForResourceGroupResponse, error) {
	result := PolicyEventsClientListQueryResultsForResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PolicyEventsQueryResults); err != nil {
		return PolicyEventsClientListQueryResultsForResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListQueryResultsForResourceGroupLevelPolicyAssignmentPager - Queries policy events for the resource group level policy
// assignment.
//
// Generated from API version 2019-10-01
//   - policyEventsResource - The name of the virtual resource under PolicyEvents resource type; only "default" is allowed.
//   - subscriptionID - Microsoft Azure subscription ID.
//   - resourceGroupName - Resource group name.
//   - policyAssignmentName - Policy assignment name.
//   - QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
//     method.
//   - options - PolicyEventsClientListQueryResultsForResourceGroupLevelPolicyAssignmentOptions contains the optional parameters
//     for the PolicyEventsClient.NewListQueryResultsForResourceGroupLevelPolicyAssignmentPager method.
func (client *PolicyEventsClient) NewListQueryResultsForResourceGroupLevelPolicyAssignmentPager(policyEventsResource PolicyEventsResourceType, subscriptionID string, resourceGroupName string, policyAssignmentName string, queryOptions *QueryOptions, options *PolicyEventsClientListQueryResultsForResourceGroupLevelPolicyAssignmentOptions) *runtime.Pager[PolicyEventsClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse] {
	return runtime.NewPager(runtime.PagingHandler[PolicyEventsClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse]{
		More: func(page PolicyEventsClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse) bool {
			return page.ODataNextLink != nil && len(*page.ODataNextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *PolicyEventsClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse) (PolicyEventsClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "PolicyEventsClient.NewListQueryResultsForResourceGroupLevelPolicyAssignmentPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.ODataNextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listQueryResultsForResourceGroupLevelPolicyAssignmentCreateRequest(ctx, policyEventsResource, subscriptionID, resourceGroupName, policyAssignmentName, queryOptions, options)
			}, nil)
			if err != nil {
				return PolicyEventsClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse{}, err
			}
			return client.listQueryResultsForResourceGroupLevelPolicyAssignmentHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listQueryResultsForResourceGroupLevelPolicyAssignmentCreateRequest creates the ListQueryResultsForResourceGroupLevelPolicyAssignment request.
func (client *PolicyEventsClient) listQueryResultsForResourceGroupLevelPolicyAssignmentCreateRequest(ctx context.Context, policyEventsResource PolicyEventsResourceType, subscriptionID string, resourceGroupName string, policyAssignmentName string, queryOptions *QueryOptions, options *PolicyEventsClientListQueryResultsForResourceGroupLevelPolicyAssignmentOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{authorizationNamespace}/policyAssignments/{policyAssignmentName}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults"
	if policyEventsResource == "" {
		return nil, errors.New("parameter policyEventsResource cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyEventsResource}", url.PathEscape(string(policyEventsResource)))
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	urlPath = strings.ReplaceAll(urlPath, "{authorizationNamespace}", url.PathEscape("Microsoft.Authorization"))
	if policyAssignmentName == "" {
		return nil, errors.New("parameter policyAssignmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyAssignmentName}", url.PathEscape(policyAssignmentName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.OrderBy != nil {
		reqQP.Set("$orderby", *queryOptions.OrderBy)
	}
	if queryOptions != nil && queryOptions.Select != nil {
		reqQP.Set("$select", *queryOptions.Select)
	}
	if queryOptions != nil && queryOptions.From != nil {
		reqQP.Set("$from", queryOptions.From.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.To != nil {
		reqQP.Set("$to", queryOptions.To.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	if queryOptions != nil && queryOptions.Apply != nil {
		reqQP.Set("$apply", *queryOptions.Apply)
	}
	if queryOptions != nil && queryOptions.SkipToken != nil {
		reqQP.Set("$skiptoken", *queryOptions.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listQueryResultsForResourceGroupLevelPolicyAssignmentHandleResponse handles the ListQueryResultsForResourceGroupLevelPolicyAssignment response.
func (client *PolicyEventsClient) listQueryResultsForResourceGroupLevelPolicyAssignmentHandleResponse(resp *http.Response) (PolicyEventsClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse, error) {
	result := PolicyEventsClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PolicyEventsQueryResults); err != nil {
		return PolicyEventsClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse{}, err
	}
	return result, nil
}

// NewListQueryResultsForSubscriptionPager - Queries policy events for the resources under the subscription.
//
// Generated from API version 2019-10-01
//   - policyEventsResource - The name of the virtual resource under PolicyEvents resource type; only "default" is allowed.
//   - subscriptionID - Microsoft Azure subscription ID.
//   - QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
//     method.
//   - options - PolicyEventsClientListQueryResultsForSubscriptionOptions contains the optional parameters for the PolicyEventsClient.NewListQueryResultsForSubscriptionPager
//     method.
func (client *PolicyEventsClient) NewListQueryResultsForSubscriptionPager(policyEventsResource PolicyEventsResourceType, subscriptionID string, queryOptions *QueryOptions, options *PolicyEventsClientListQueryResultsForSubscriptionOptions) *runtime.Pager[PolicyEventsClientListQueryResultsForSubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[PolicyEventsClientListQueryResultsForSubscriptionResponse]{
		More: func(page PolicyEventsClientListQueryResultsForSubscriptionResponse) bool {
			return page.ODataNextLink != nil && len(*page.ODataNextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *PolicyEventsClientListQueryResultsForSubscriptionResponse) (PolicyEventsClientListQueryResultsForSubscriptionResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "PolicyEventsClient.NewListQueryResultsForSubscriptionPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.ODataNextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listQueryResultsForSubscriptionCreateRequest(ctx, policyEventsResource, subscriptionID, queryOptions, options)
			}, nil)
			if err != nil {
				return PolicyEventsClientListQueryResultsForSubscriptionResponse{}, err
			}
			return client.listQueryResultsForSubscriptionHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listQueryResultsForSubscriptionCreateRequest creates the ListQueryResultsForSubscription request.
func (client *PolicyEventsClient) listQueryResultsForSubscriptionCreateRequest(ctx context.Context, policyEventsResource PolicyEventsResourceType, subscriptionID string, queryOptions *QueryOptions, options *PolicyEventsClientListQueryResultsForSubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults"
	if policyEventsResource == "" {
		return nil, errors.New("parameter policyEventsResource cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyEventsResource}", url.PathEscape(string(policyEventsResource)))
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.OrderBy != nil {
		reqQP.Set("$orderby", *queryOptions.OrderBy)
	}
	if queryOptions != nil && queryOptions.Select != nil {
		reqQP.Set("$select", *queryOptions.Select)
	}
	if queryOptions != nil && queryOptions.From != nil {
		reqQP.Set("$from", queryOptions.From.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.To != nil {
		reqQP.Set("$to", queryOptions.To.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	if queryOptions != nil && queryOptions.Apply != nil {
		reqQP.Set("$apply", *queryOptions.Apply)
	}
	if queryOptions != nil && queryOptions.SkipToken != nil {
		reqQP.Set("$skiptoken", *queryOptions.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listQueryResultsForSubscriptionHandleResponse handles the ListQueryResultsForSubscription response.
func (client *PolicyEventsClient) listQueryResultsForSubscriptionHandleResponse(resp *http.Response) (PolicyEventsClientListQueryResultsForSubscriptionResponse, error) {
	result := PolicyEventsClientListQueryResultsForSubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PolicyEventsQueryResults); err != nil {
		return PolicyEventsClientListQueryResultsForSubscriptionResponse{}, err
	}
	return result, nil
}

// NewListQueryResultsForSubscriptionLevelPolicyAssignmentPager - Queries policy events for the subscription level policy
// assignment.
//
// Generated from API version 2019-10-01
//   - policyEventsResource - The name of the virtual resource under PolicyEvents resource type; only "default" is allowed.
//   - subscriptionID - Microsoft Azure subscription ID.
//   - policyAssignmentName - Policy assignment name.
//   - QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
//     method.
//   - options - PolicyEventsClientListQueryResultsForSubscriptionLevelPolicyAssignmentOptions contains the optional parameters
//     for the PolicyEventsClient.NewListQueryResultsForSubscriptionLevelPolicyAssignmentPager method.
func (client *PolicyEventsClient) NewListQueryResultsForSubscriptionLevelPolicyAssignmentPager(policyEventsResource PolicyEventsResourceType, subscriptionID string, policyAssignmentName string, queryOptions *QueryOptions, options *PolicyEventsClientListQueryResultsForSubscriptionLevelPolicyAssignmentOptions) *runtime.Pager[PolicyEventsClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse] {
	return runtime.NewPager(runtime.PagingHandler[PolicyEventsClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse]{
		More: func(page PolicyEventsClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse) bool {
			return page.ODataNextLink != nil && len(*page.ODataNextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *PolicyEventsClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse) (PolicyEventsClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "PolicyEventsClient.NewListQueryResultsForSubscriptionLevelPolicyAssignmentPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.ODataNextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listQueryResultsForSubscriptionLevelPolicyAssignmentCreateRequest(ctx, policyEventsResource, subscriptionID, policyAssignmentName, queryOptions, options)
			}, nil)
			if err != nil {
				return PolicyEventsClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse{}, err
			}
			return client.listQueryResultsForSubscriptionLevelPolicyAssignmentHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listQueryResultsForSubscriptionLevelPolicyAssignmentCreateRequest creates the ListQueryResultsForSubscriptionLevelPolicyAssignment request.
func (client *PolicyEventsClient) listQueryResultsForSubscriptionLevelPolicyAssignmentCreateRequest(ctx context.Context, policyEventsResource PolicyEventsResourceType, subscriptionID string, policyAssignmentName string, queryOptions *QueryOptions, options *PolicyEventsClientListQueryResultsForSubscriptionLevelPolicyAssignmentOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policyAssignments/{policyAssignmentName}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults"
	if policyEventsResource == "" {
		return nil, errors.New("parameter policyEventsResource cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyEventsResource}", url.PathEscape(string(policyEventsResource)))
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	urlPath = strings.ReplaceAll(urlPath, "{authorizationNamespace}", url.PathEscape("Microsoft.Authorization"))
	if policyAssignmentName == "" {
		return nil, errors.New("parameter policyAssignmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyAssignmentName}", url.PathEscape(policyAssignmentName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.OrderBy != nil {
		reqQP.Set("$orderby", *queryOptions.OrderBy)
	}
	if queryOptions != nil && queryOptions.Select != nil {
		reqQP.Set("$select", *queryOptions.Select)
	}
	if queryOptions != nil && queryOptions.From != nil {
		reqQP.Set("$from", queryOptions.From.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.To != nil {
		reqQP.Set("$to", queryOptions.To.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	if queryOptions != nil && queryOptions.Apply != nil {
		reqQP.Set("$apply", *queryOptions.Apply)
	}
	if queryOptions != nil && queryOptions.SkipToken != nil {
		reqQP.Set("$skiptoken", *queryOptions.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listQueryResultsForSubscriptionLevelPolicyAssignmentHandleResponse handles the ListQueryResultsForSubscriptionLevelPolicyAssignment response.
func (client *PolicyEventsClient) listQueryResultsForSubscriptionLevelPolicyAssignmentHandleResponse(resp *http.Response) (PolicyEventsClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse, error) {
	result := PolicyEventsClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PolicyEventsQueryResults); err != nil {
		return PolicyEventsClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse{}, err
	}
	return result, nil
}
