//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armoperationalinsights

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewAvailableServiceTiersClient creates a new instance of AvailableServiceTiersClient.
func (c *ClientFactory) NewAvailableServiceTiersClient() *AvailableServiceTiersClient {
	subClient, _ := NewAvailableServiceTiersClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewClustersClient creates a new instance of ClustersClient.
func (c *ClientFactory) NewClustersClient() *ClustersClient {
	subClient, _ := NewClustersClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDataExportsClient creates a new instance of DataExportsClient.
func (c *ClientFactory) NewDataExportsClient() *DataExportsClient {
	subClient, _ := NewDataExportsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDataSourcesClient creates a new instance of DataSourcesClient.
func (c *ClientFactory) NewDataSourcesClient() *DataSourcesClient {
	subClient, _ := NewDataSourcesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDeletedWorkspacesClient creates a new instance of DeletedWorkspacesClient.
func (c *ClientFactory) NewDeletedWorkspacesClient() *DeletedWorkspacesClient {
	subClient, _ := NewDeletedWorkspacesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewGatewaysClient creates a new instance of GatewaysClient.
func (c *ClientFactory) NewGatewaysClient() *GatewaysClient {
	subClient, _ := NewGatewaysClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewIntelligencePacksClient creates a new instance of IntelligencePacksClient.
func (c *ClientFactory) NewIntelligencePacksClient() *IntelligencePacksClient {
	subClient, _ := NewIntelligencePacksClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewLinkedServicesClient creates a new instance of LinkedServicesClient.
func (c *ClientFactory) NewLinkedServicesClient() *LinkedServicesClient {
	subClient, _ := NewLinkedServicesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewLinkedStorageAccountsClient creates a new instance of LinkedStorageAccountsClient.
func (c *ClientFactory) NewLinkedStorageAccountsClient() *LinkedStorageAccountsClient {
	subClient, _ := NewLinkedStorageAccountsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagementGroupsClient creates a new instance of ManagementGroupsClient.
func (c *ClientFactory) NewManagementGroupsClient() *ManagementGroupsClient {
	subClient, _ := NewManagementGroupsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationStatusesClient creates a new instance of OperationStatusesClient.
func (c *ClientFactory) NewOperationStatusesClient() *OperationStatusesClient {
	subClient, _ := NewOperationStatusesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewSavedSearchesClient creates a new instance of SavedSearchesClient.
func (c *ClientFactory) NewSavedSearchesClient() *SavedSearchesClient {
	subClient, _ := NewSavedSearchesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSchemaClient creates a new instance of SchemaClient.
func (c *ClientFactory) NewSchemaClient() *SchemaClient {
	subClient, _ := NewSchemaClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSharedKeysClient creates a new instance of SharedKeysClient.
func (c *ClientFactory) NewSharedKeysClient() *SharedKeysClient {
	subClient, _ := NewSharedKeysClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewStorageInsightConfigsClient creates a new instance of StorageInsightConfigsClient.
func (c *ClientFactory) NewStorageInsightConfigsClient() *StorageInsightConfigsClient {
	subClient, _ := NewStorageInsightConfigsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewTablesClient creates a new instance of TablesClient.
func (c *ClientFactory) NewTablesClient() *TablesClient {
	subClient, _ := NewTablesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewUsagesClient creates a new instance of UsagesClient.
func (c *ClientFactory) NewUsagesClient() *UsagesClient {
	subClient, _ := NewUsagesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewWorkspacePurgeClient creates a new instance of WorkspacePurgeClient.
func (c *ClientFactory) NewWorkspacePurgeClient() *WorkspacePurgeClient {
	subClient, _ := NewWorkspacePurgeClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewWorkspacesClient creates a new instance of WorkspacesClient.
func (c *ClientFactory) NewWorkspacesClient() *WorkspacesClient {
	subClient, _ := NewWorkspacesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
