//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armnetworkcloud_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/networkcloud/armnetworkcloud"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/networkcloud/resource-manager/Microsoft.NetworkCloud/stable/2023-07-01/examples/VirtualMachines_ListBySubscription.json
func ExampleVirtualMachinesClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkcloud.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewVirtualMachinesClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.VirtualMachineList = armnetworkcloud.VirtualMachineList{
		// 	Value: []*armnetworkcloud.VirtualMachine{
		// 		{
		// 			Name: to.Ptr("virtualMachineName"),
		// 			Type: to.Ptr("Microsoft.NetworkCloud/virtualMachines"),
		// 			ID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/virtualMachines/virtualMachineName"),
		// 			SystemData: &armnetworkcloud.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-22T13:27:03.008Z"); return t}()),
		// 				CreatedBy: to.Ptr("identityA"),
		// 				CreatedByType: to.Ptr(armnetworkcloud.CreatedByTypeApplication),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-22T13:29:03.001Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("identityB"),
		// 				LastModifiedByType: to.Ptr(armnetworkcloud.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("location"),
		// 			Tags: map[string]*string{
		// 				"key1": to.Ptr("myvalue1"),
		// 				"key2": to.Ptr("myvalue2"),
		// 			},
		// 			ExtendedLocation: &armnetworkcloud.ExtendedLocation{
		// 				Name: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
		// 				Type: to.Ptr("CustomLocation"),
		// 			},
		// 			Properties: &armnetworkcloud.VirtualMachineProperties{
		// 				AdminUsername: to.Ptr("username"),
		// 				AvailabilityZone: to.Ptr("1"),
		// 				BareMetalMachineID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/bareMetalMachines/bareMetalMachineName"),
		// 				BootMethod: to.Ptr(armnetworkcloud.VirtualMachineBootMethodUEFI),
		// 				CloudServicesNetworkAttachment: &armnetworkcloud.NetworkAttachment{
		// 					AttachedNetworkID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/cloudServicesNetworks/cloudServicesNetworkName"),
		// 					IPAllocationMethod: to.Ptr(armnetworkcloud.VirtualMachineIPAllocationMethodDynamic),
		// 				},
		// 				ClusterID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/clusters/clusterName"),
		// 				CPUCores: to.Ptr[int64](2),
		// 				DetailedStatus: to.Ptr(armnetworkcloud.VirtualMachineDetailedStatusAvailable),
		// 				DetailedStatusMessage: to.Ptr("VM is up and healthy"),
		// 				MemorySizeGB: to.Ptr[int64](8),
		// 				NetworkAttachments: []*armnetworkcloud.NetworkAttachment{
		// 					{
		// 						AttachedNetworkID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName"),
		// 						DefaultGateway: to.Ptr(armnetworkcloud.DefaultGatewayTrue),
		// 						IPAllocationMethod: to.Ptr(armnetworkcloud.VirtualMachineIPAllocationMethodDynamic),
		// 						IPv4Address: to.Ptr("198.51.100.1"),
		// 						IPv6Address: to.Ptr("2001:0db8:0000:0000:0000:0000:0000:0000"),
		// 						MacAddress: to.Ptr("bf:1c:29:31:31:1f"),
		// 						NetworkAttachmentName: to.Ptr("netAttachName01"),
		// 				}},
		// 				NetworkData: to.Ptr("bmV0d29ya0RhdGVTYW1wbGU="),
		// 				PlacementHints: []*armnetworkcloud.VirtualMachinePlacementHint{
		// 					{
		// 						HintType: to.Ptr(armnetworkcloud.VirtualMachinePlacementHintTypeAffinity),
		// 						ResourceID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/racks/rackName"),
		// 						SchedulingExecution: to.Ptr(armnetworkcloud.VirtualMachineSchedulingExecutionHard),
		// 						Scope: to.Ptr(armnetworkcloud.VirtualMachinePlacementHintPodAffinityScope("")),
		// 				}},
		// 				PowerState: to.Ptr(armnetworkcloud.VirtualMachinePowerStateOn),
		// 				ProvisioningState: to.Ptr(armnetworkcloud.VirtualMachineProvisioningStateSucceeded),
		// 				SSHPublicKeys: []*armnetworkcloud.SSHPublicKey{
		// 					{
		// 						KeyData: to.Ptr("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"),
		// 				}},
		// 				StorageProfile: &armnetworkcloud.StorageProfile{
		// 					OSDisk: &armnetworkcloud.OsDisk{
		// 						CreateOption: to.Ptr(armnetworkcloud.OsDiskCreateOptionEphemeral),
		// 						DeleteOption: to.Ptr(armnetworkcloud.OsDiskDeleteOptionDelete),
		// 						DiskSizeGB: to.Ptr[int64](120),
		// 					},
		// 					VolumeAttachments: []*string{
		// 						to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/volumes/volumeName")},
		// 					},
		// 					UserData: to.Ptr("dXNlckRhdGVTYW1wbGU="),
		// 					VMDeviceModel: to.Ptr(armnetworkcloud.VirtualMachineDeviceModelTypeT2),
		// 					VMImage: to.Ptr("myacr.azurecr.io/foobar:latest"),
		// 					VMImageRepositoryCredentials: &armnetworkcloud.ImageRepositoryCredentials{
		// 						RegistryURL: to.Ptr("myacr.azurecr.io"),
		// 						Username: to.Ptr("myuser"),
		// 					},
		// 					Volumes: []*string{
		// 						to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/volumes/volumeName")},
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/networkcloud/resource-manager/Microsoft.NetworkCloud/stable/2023-07-01/examples/VirtualMachines_ListByResourceGroup.json
func ExampleVirtualMachinesClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkcloud.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewVirtualMachinesClient().NewListByResourceGroupPager("resourceGroupName", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.VirtualMachineList = armnetworkcloud.VirtualMachineList{
		// 	Value: []*armnetworkcloud.VirtualMachine{
		// 		{
		// 			Name: to.Ptr("virtualMachineName"),
		// 			Type: to.Ptr("Microsoft.NetworkCloud/virtualMachines"),
		// 			ID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/virtualMachines/virtualMachineName"),
		// 			SystemData: &armnetworkcloud.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-22T13:27:03.008Z"); return t}()),
		// 				CreatedBy: to.Ptr("identityA"),
		// 				CreatedByType: to.Ptr(armnetworkcloud.CreatedByTypeApplication),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-22T13:29:03.001Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("identityB"),
		// 				LastModifiedByType: to.Ptr(armnetworkcloud.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("location"),
		// 			Tags: map[string]*string{
		// 				"key1": to.Ptr("myvalue1"),
		// 				"key2": to.Ptr("myvalue2"),
		// 			},
		// 			ExtendedLocation: &armnetworkcloud.ExtendedLocation{
		// 				Name: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
		// 				Type: to.Ptr("CustomLocation"),
		// 			},
		// 			Properties: &armnetworkcloud.VirtualMachineProperties{
		// 				AdminUsername: to.Ptr("username"),
		// 				AvailabilityZone: to.Ptr("1"),
		// 				BareMetalMachineID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/bareMetalMachines/bareMetalMachineName"),
		// 				BootMethod: to.Ptr(armnetworkcloud.VirtualMachineBootMethodUEFI),
		// 				CloudServicesNetworkAttachment: &armnetworkcloud.NetworkAttachment{
		// 					AttachedNetworkID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/cloudServicesNetworks/cloudServicesNetworkName"),
		// 					IPAllocationMethod: to.Ptr(armnetworkcloud.VirtualMachineIPAllocationMethodDynamic),
		// 				},
		// 				ClusterID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/clusters/clusterName"),
		// 				CPUCores: to.Ptr[int64](2),
		// 				DetailedStatus: to.Ptr(armnetworkcloud.VirtualMachineDetailedStatusAvailable),
		// 				DetailedStatusMessage: to.Ptr("VM is up and healthy"),
		// 				MemorySizeGB: to.Ptr[int64](8),
		// 				NetworkAttachments: []*armnetworkcloud.NetworkAttachment{
		// 					{
		// 						AttachedNetworkID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName"),
		// 						DefaultGateway: to.Ptr(armnetworkcloud.DefaultGatewayTrue),
		// 						IPAllocationMethod: to.Ptr(armnetworkcloud.VirtualMachineIPAllocationMethodDynamic),
		// 						IPv4Address: to.Ptr("198.51.100.1"),
		// 						IPv6Address: to.Ptr("2001:0db8:0000:0000:0000:0000:0000:0000"),
		// 						MacAddress: to.Ptr("bf:1c:29:31:31:1f"),
		// 						NetworkAttachmentName: to.Ptr("netAttachName01"),
		// 				}},
		// 				NetworkData: to.Ptr("bmV0d29ya0RhdGVTYW1wbGU="),
		// 				PlacementHints: []*armnetworkcloud.VirtualMachinePlacementHint{
		// 					{
		// 						HintType: to.Ptr(armnetworkcloud.VirtualMachinePlacementHintTypeAffinity),
		// 						ResourceID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/racks/rackName"),
		// 						SchedulingExecution: to.Ptr(armnetworkcloud.VirtualMachineSchedulingExecutionHard),
		// 						Scope: to.Ptr(armnetworkcloud.VirtualMachinePlacementHintPodAffinityScope("")),
		// 				}},
		// 				PowerState: to.Ptr(armnetworkcloud.VirtualMachinePowerStateOn),
		// 				ProvisioningState: to.Ptr(armnetworkcloud.VirtualMachineProvisioningStateSucceeded),
		// 				SSHPublicKeys: []*armnetworkcloud.SSHPublicKey{
		// 					{
		// 						KeyData: to.Ptr("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"),
		// 				}},
		// 				StorageProfile: &armnetworkcloud.StorageProfile{
		// 					OSDisk: &armnetworkcloud.OsDisk{
		// 						CreateOption: to.Ptr(armnetworkcloud.OsDiskCreateOptionEphemeral),
		// 						DeleteOption: to.Ptr(armnetworkcloud.OsDiskDeleteOptionDelete),
		// 						DiskSizeGB: to.Ptr[int64](120),
		// 					},
		// 					VolumeAttachments: []*string{
		// 						to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/volumes/volumeName")},
		// 					},
		// 					UserData: to.Ptr("dXNlckRhdGVTYW1wbGU="),
		// 					VMDeviceModel: to.Ptr(armnetworkcloud.VirtualMachineDeviceModelTypeT2),
		// 					VMImage: to.Ptr("myacr.azurecr.io/foobar:latest"),
		// 					VMImageRepositoryCredentials: &armnetworkcloud.ImageRepositoryCredentials{
		// 						RegistryURL: to.Ptr("myacr.azurecr.io"),
		// 						Username: to.Ptr("myuser"),
		// 					},
		// 					Volumes: []*string{
		// 						to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/volumes/volumeName")},
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/networkcloud/resource-manager/Microsoft.NetworkCloud/stable/2023-07-01/examples/VirtualMachines_Get.json
func ExampleVirtualMachinesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkcloud.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewVirtualMachinesClient().Get(ctx, "resourceGroupName", "virtualMachineName", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VirtualMachine = armnetworkcloud.VirtualMachine{
	// 	Name: to.Ptr("virtualMachineName"),
	// 	Type: to.Ptr("Microsoft.NetworkCloud/virtualMachines"),
	// 	ID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/virtualMachines/virtualMachineName"),
	// 	SystemData: &armnetworkcloud.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-22T13:27:03.008Z"); return t}()),
	// 		CreatedBy: to.Ptr("identityA"),
	// 		CreatedByType: to.Ptr(armnetworkcloud.CreatedByTypeApplication),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-22T13:29:03.001Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("identityB"),
	// 		LastModifiedByType: to.Ptr(armnetworkcloud.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("location"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("myvalue1"),
	// 		"key2": to.Ptr("myvalue2"),
	// 	},
	// 	ExtendedLocation: &armnetworkcloud.ExtendedLocation{
	// 		Name: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
	// 		Type: to.Ptr("CustomLocation"),
	// 	},
	// 	Properties: &armnetworkcloud.VirtualMachineProperties{
	// 		AdminUsername: to.Ptr("username"),
	// 		AvailabilityZone: to.Ptr("1"),
	// 		BareMetalMachineID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/bareMetalMachines/bareMetalMachineName"),
	// 		BootMethod: to.Ptr(armnetworkcloud.VirtualMachineBootMethodUEFI),
	// 		CloudServicesNetworkAttachment: &armnetworkcloud.NetworkAttachment{
	// 			AttachedNetworkID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/cloudServicesNetworks/cloudServicesNetworkName"),
	// 			IPAllocationMethod: to.Ptr(armnetworkcloud.VirtualMachineIPAllocationMethodDynamic),
	// 		},
	// 		ClusterID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/clusters/clusterName"),
	// 		CPUCores: to.Ptr[int64](2),
	// 		DetailedStatus: to.Ptr(armnetworkcloud.VirtualMachineDetailedStatusAvailable),
	// 		DetailedStatusMessage: to.Ptr("VM is up and healthy"),
	// 		MemorySizeGB: to.Ptr[int64](8),
	// 		NetworkAttachments: []*armnetworkcloud.NetworkAttachment{
	// 			{
	// 				AttachedNetworkID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName"),
	// 				DefaultGateway: to.Ptr(armnetworkcloud.DefaultGatewayTrue),
	// 				IPAllocationMethod: to.Ptr(armnetworkcloud.VirtualMachineIPAllocationMethodDynamic),
	// 				IPv4Address: to.Ptr("198.51.100.1"),
	// 				IPv6Address: to.Ptr("2001:0db8:0000:0000:0000:0000:0000:0000"),
	// 				MacAddress: to.Ptr("bf:1c:29:31:31:1f"),
	// 				NetworkAttachmentName: to.Ptr("netAttachName01"),
	// 		}},
	// 		NetworkData: to.Ptr("bmV0d29ya0RhdGVTYW1wbGU="),
	// 		PlacementHints: []*armnetworkcloud.VirtualMachinePlacementHint{
	// 			{
	// 				HintType: to.Ptr(armnetworkcloud.VirtualMachinePlacementHintTypeAffinity),
	// 				ResourceID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/racks/rackName"),
	// 				SchedulingExecution: to.Ptr(armnetworkcloud.VirtualMachineSchedulingExecutionHard),
	// 				Scope: to.Ptr(armnetworkcloud.VirtualMachinePlacementHintPodAffinityScope("")),
	// 		}},
	// 		PowerState: to.Ptr(armnetworkcloud.VirtualMachinePowerStateOn),
	// 		ProvisioningState: to.Ptr(armnetworkcloud.VirtualMachineProvisioningStateSucceeded),
	// 		SSHPublicKeys: []*armnetworkcloud.SSHPublicKey{
	// 			{
	// 				KeyData: to.Ptr("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"),
	// 		}},
	// 		StorageProfile: &armnetworkcloud.StorageProfile{
	// 			OSDisk: &armnetworkcloud.OsDisk{
	// 				CreateOption: to.Ptr(armnetworkcloud.OsDiskCreateOptionEphemeral),
	// 				DeleteOption: to.Ptr(armnetworkcloud.OsDiskDeleteOptionDelete),
	// 				DiskSizeGB: to.Ptr[int64](120),
	// 			},
	// 			VolumeAttachments: []*string{
	// 				to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/volumes/volumeName")},
	// 			},
	// 			UserData: to.Ptr("dXNlckRhdGVTYW1wbGU="),
	// 			VMDeviceModel: to.Ptr(armnetworkcloud.VirtualMachineDeviceModelTypeT2),
	// 			VMImage: to.Ptr("myacr.azurecr.io/foobar:latest"),
	// 			VMImageRepositoryCredentials: &armnetworkcloud.ImageRepositoryCredentials{
	// 				RegistryURL: to.Ptr("myacr.azurecr.io"),
	// 				Username: to.Ptr("myuser"),
	// 			},
	// 			Volumes: []*string{
	// 				to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/volumes/volumeName")},
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/networkcloud/resource-manager/Microsoft.NetworkCloud/stable/2023-07-01/examples/VirtualMachines_Create.json
func ExampleVirtualMachinesClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkcloud.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualMachinesClient().BeginCreateOrUpdate(ctx, "resourceGroupName", "virtualMachineName", armnetworkcloud.VirtualMachine{
		Location: to.Ptr("location"),
		Tags: map[string]*string{
			"key1": to.Ptr("myvalue1"),
			"key2": to.Ptr("myvalue2"),
		},
		ExtendedLocation: &armnetworkcloud.ExtendedLocation{
			Name: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
			Type: to.Ptr("CustomLocation"),
		},
		Properties: &armnetworkcloud.VirtualMachineProperties{
			AdminUsername: to.Ptr("username"),
			BootMethod:    to.Ptr(armnetworkcloud.VirtualMachineBootMethodUEFI),
			CloudServicesNetworkAttachment: &armnetworkcloud.NetworkAttachment{
				AttachedNetworkID:  to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/cloudServicesNetworks/cloudServicesNetworkName"),
				IPAllocationMethod: to.Ptr(armnetworkcloud.VirtualMachineIPAllocationMethodDynamic),
			},
			CPUCores:     to.Ptr[int64](2),
			MemorySizeGB: to.Ptr[int64](8),
			NetworkAttachments: []*armnetworkcloud.NetworkAttachment{
				{
					AttachedNetworkID:     to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName"),
					DefaultGateway:        to.Ptr(armnetworkcloud.DefaultGatewayTrue),
					IPAllocationMethod:    to.Ptr(armnetworkcloud.VirtualMachineIPAllocationMethodDynamic),
					IPv4Address:           to.Ptr("198.51.100.1"),
					IPv6Address:           to.Ptr("2001:0db8:0000:0000:0000:0000:0000:0000"),
					NetworkAttachmentName: to.Ptr("netAttachName01"),
				}},
			NetworkData: to.Ptr("bmV0d29ya0RhdGVTYW1wbGU="),
			PlacementHints: []*armnetworkcloud.VirtualMachinePlacementHint{
				{
					HintType:            to.Ptr(armnetworkcloud.VirtualMachinePlacementHintTypeAffinity),
					ResourceID:          to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/racks/rackName"),
					SchedulingExecution: to.Ptr(armnetworkcloud.VirtualMachineSchedulingExecutionHard),
					Scope:               to.Ptr(armnetworkcloud.VirtualMachinePlacementHintPodAffinityScope("")),
				}},
			SSHPublicKeys: []*armnetworkcloud.SSHPublicKey{
				{
					KeyData: to.Ptr("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"),
				}},
			StorageProfile: &armnetworkcloud.StorageProfile{
				OSDisk: &armnetworkcloud.OsDisk{
					CreateOption: to.Ptr(armnetworkcloud.OsDiskCreateOptionEphemeral),
					DeleteOption: to.Ptr(armnetworkcloud.OsDiskDeleteOptionDelete),
					DiskSizeGB:   to.Ptr[int64](120),
				},
				VolumeAttachments: []*string{
					to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/volumes/volumeName")},
			},
			UserData:      to.Ptr("dXNlckRhdGVTYW1wbGU="),
			VMDeviceModel: to.Ptr(armnetworkcloud.VirtualMachineDeviceModelTypeT2),
			VMImage:       to.Ptr("myacr.azurecr.io/foobar:latest"),
			VMImageRepositoryCredentials: &armnetworkcloud.ImageRepositoryCredentials{
				Password:    to.Ptr("{password}"),
				RegistryURL: to.Ptr("myacr.azurecr.io"),
				Username:    to.Ptr("myuser"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VirtualMachine = armnetworkcloud.VirtualMachine{
	// 	Name: to.Ptr("virtualMachineName"),
	// 	Type: to.Ptr("Microsoft.NetworkCloud/virtualMachines"),
	// 	ID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/virtualMachines/virtualMachineName"),
	// 	SystemData: &armnetworkcloud.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-22T13:27:03.008Z"); return t}()),
	// 		CreatedBy: to.Ptr("identityA"),
	// 		CreatedByType: to.Ptr(armnetworkcloud.CreatedByTypeApplication),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-22T13:29:03.001Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("identityB"),
	// 		LastModifiedByType: to.Ptr(armnetworkcloud.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("location"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("myvalue1"),
	// 		"key2": to.Ptr("myvalue2"),
	// 	},
	// 	ExtendedLocation: &armnetworkcloud.ExtendedLocation{
	// 		Name: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
	// 		Type: to.Ptr("CustomLocation"),
	// 	},
	// 	Properties: &armnetworkcloud.VirtualMachineProperties{
	// 		AdminUsername: to.Ptr("username"),
	// 		AvailabilityZone: to.Ptr("1"),
	// 		BareMetalMachineID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/bareMetalMachines/bareMetalMachineName"),
	// 		BootMethod: to.Ptr(armnetworkcloud.VirtualMachineBootMethodUEFI),
	// 		CloudServicesNetworkAttachment: &armnetworkcloud.NetworkAttachment{
	// 			AttachedNetworkID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/cloudServicesNetworks/cloudServicesNetworkName"),
	// 			IPAllocationMethod: to.Ptr(armnetworkcloud.VirtualMachineIPAllocationMethodDynamic),
	// 		},
	// 		ClusterID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/clusters/clusterName"),
	// 		CPUCores: to.Ptr[int64](2),
	// 		DetailedStatus: to.Ptr(armnetworkcloud.VirtualMachineDetailedStatusAvailable),
	// 		DetailedStatusMessage: to.Ptr("VM is up and healthy"),
	// 		MemorySizeGB: to.Ptr[int64](8),
	// 		NetworkAttachments: []*armnetworkcloud.NetworkAttachment{
	// 			{
	// 				AttachedNetworkID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName"),
	// 				DefaultGateway: to.Ptr(armnetworkcloud.DefaultGatewayTrue),
	// 				IPAllocationMethod: to.Ptr(armnetworkcloud.VirtualMachineIPAllocationMethodDynamic),
	// 				IPv4Address: to.Ptr("198.51.100.1"),
	// 				IPv6Address: to.Ptr("2001:0db8:0000:0000:0000:0000:0000:0000"),
	// 				MacAddress: to.Ptr("bf:1c:29:31:31:1f"),
	// 				NetworkAttachmentName: to.Ptr("netAttachName01"),
	// 		}},
	// 		NetworkData: to.Ptr("bmV0d29ya0RhdGVTYW1wbGU="),
	// 		PlacementHints: []*armnetworkcloud.VirtualMachinePlacementHint{
	// 			{
	// 				HintType: to.Ptr(armnetworkcloud.VirtualMachinePlacementHintTypeAffinity),
	// 				ResourceID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/racks/rackName"),
	// 				SchedulingExecution: to.Ptr(armnetworkcloud.VirtualMachineSchedulingExecutionHard),
	// 				Scope: to.Ptr(armnetworkcloud.VirtualMachinePlacementHintPodAffinityScope("")),
	// 		}},
	// 		PowerState: to.Ptr(armnetworkcloud.VirtualMachinePowerStateOn),
	// 		ProvisioningState: to.Ptr(armnetworkcloud.VirtualMachineProvisioningStateSucceeded),
	// 		SSHPublicKeys: []*armnetworkcloud.SSHPublicKey{
	// 			{
	// 				KeyData: to.Ptr("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"),
	// 		}},
	// 		StorageProfile: &armnetworkcloud.StorageProfile{
	// 			OSDisk: &armnetworkcloud.OsDisk{
	// 				CreateOption: to.Ptr(armnetworkcloud.OsDiskCreateOptionEphemeral),
	// 				DeleteOption: to.Ptr(armnetworkcloud.OsDiskDeleteOptionDelete),
	// 				DiskSizeGB: to.Ptr[int64](120),
	// 			},
	// 			VolumeAttachments: []*string{
	// 				to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/volumes/volumeName")},
	// 			},
	// 			UserData: to.Ptr("dXNlckRhdGVTYW1wbGU="),
	// 			VMDeviceModel: to.Ptr(armnetworkcloud.VirtualMachineDeviceModelTypeT2),
	// 			VMImage: to.Ptr("myacr.azurecr.io/foobar:latest"),
	// 			VMImageRepositoryCredentials: &armnetworkcloud.ImageRepositoryCredentials{
	// 				RegistryURL: to.Ptr("myacr.azurecr.io"),
	// 				Username: to.Ptr("myuser"),
	// 			},
	// 			Volumes: []*string{
	// 				to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/volumes/volumeName")},
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/networkcloud/resource-manager/Microsoft.NetworkCloud/stable/2023-07-01/examples/VirtualMachines_Delete.json
func ExampleVirtualMachinesClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkcloud.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualMachinesClient().BeginDelete(ctx, "resourceGroupName", "virtualMachineName", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/networkcloud/resource-manager/Microsoft.NetworkCloud/stable/2023-07-01/examples/VirtualMachines_Patch.json
func ExampleVirtualMachinesClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkcloud.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualMachinesClient().BeginUpdate(ctx, "resourceGroupName", "virtualMachineName", armnetworkcloud.VirtualMachinePatchParameters{
		Properties: &armnetworkcloud.VirtualMachinePatchProperties{
			VMImageRepositoryCredentials: &armnetworkcloud.ImageRepositoryCredentials{
				Password:    to.Ptr("{password}"),
				RegistryURL: to.Ptr("myacr.azurecr.io"),
				Username:    to.Ptr("myuser"),
			},
		},
		Tags: map[string]*string{
			"key1": to.Ptr("myvalue1"),
			"key2": to.Ptr("myvalue2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VirtualMachine = armnetworkcloud.VirtualMachine{
	// 	Name: to.Ptr("virtualMachineName"),
	// 	Type: to.Ptr("Microsoft.NetworkCloud/virtualMachines"),
	// 	ID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/virtualMachines/virtualMachineName"),
	// 	SystemData: &armnetworkcloud.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-22T13:27:03.008Z"); return t}()),
	// 		CreatedBy: to.Ptr("identityA"),
	// 		CreatedByType: to.Ptr(armnetworkcloud.CreatedByTypeApplication),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-22T13:29:03.001Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("identityB"),
	// 		LastModifiedByType: to.Ptr(armnetworkcloud.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("location"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("myvalue1"),
	// 		"key2": to.Ptr("myvalue2"),
	// 	},
	// 	ExtendedLocation: &armnetworkcloud.ExtendedLocation{
	// 		Name: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
	// 		Type: to.Ptr("CustomLocation"),
	// 	},
	// 	Properties: &armnetworkcloud.VirtualMachineProperties{
	// 		AdminUsername: to.Ptr("username"),
	// 		AvailabilityZone: to.Ptr("1"),
	// 		BareMetalMachineID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/bareMetalMachines/bareMetalMachineName"),
	// 		BootMethod: to.Ptr(armnetworkcloud.VirtualMachineBootMethodUEFI),
	// 		CloudServicesNetworkAttachment: &armnetworkcloud.NetworkAttachment{
	// 			AttachedNetworkID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/cloudServicesNetworks/cloudServicesNetworkName"),
	// 			IPAllocationMethod: to.Ptr(armnetworkcloud.VirtualMachineIPAllocationMethodDynamic),
	// 		},
	// 		ClusterID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/clusters/clusterName"),
	// 		CPUCores: to.Ptr[int64](2),
	// 		DetailedStatus: to.Ptr(armnetworkcloud.VirtualMachineDetailedStatusAvailable),
	// 		DetailedStatusMessage: to.Ptr("VM is up and healthy"),
	// 		MemorySizeGB: to.Ptr[int64](8),
	// 		NetworkAttachments: []*armnetworkcloud.NetworkAttachment{
	// 			{
	// 				AttachedNetworkID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName"),
	// 				DefaultGateway: to.Ptr(armnetworkcloud.DefaultGatewayTrue),
	// 				IPAllocationMethod: to.Ptr(armnetworkcloud.VirtualMachineIPAllocationMethodDynamic),
	// 				IPv4Address: to.Ptr("198.51.100.1"),
	// 				IPv6Address: to.Ptr("2001:0db8:0000:0000:0000:0000:0000:0000"),
	// 				MacAddress: to.Ptr("bf:1c:29:31:31:1f"),
	// 				NetworkAttachmentName: to.Ptr("netAttachName01"),
	// 		}},
	// 		NetworkData: to.Ptr("bmV0d29ya0RhdGVTYW1wbGU="),
	// 		PlacementHints: []*armnetworkcloud.VirtualMachinePlacementHint{
	// 			{
	// 				HintType: to.Ptr(armnetworkcloud.VirtualMachinePlacementHintTypeAffinity),
	// 				ResourceID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/racks/rackName"),
	// 				SchedulingExecution: to.Ptr(armnetworkcloud.VirtualMachineSchedulingExecutionHard),
	// 				Scope: to.Ptr(armnetworkcloud.VirtualMachinePlacementHintPodAffinityScope("")),
	// 		}},
	// 		PowerState: to.Ptr(armnetworkcloud.VirtualMachinePowerStateOn),
	// 		ProvisioningState: to.Ptr(armnetworkcloud.VirtualMachineProvisioningStateSucceeded),
	// 		SSHPublicKeys: []*armnetworkcloud.SSHPublicKey{
	// 			{
	// 				KeyData: to.Ptr("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"),
	// 		}},
	// 		StorageProfile: &armnetworkcloud.StorageProfile{
	// 			OSDisk: &armnetworkcloud.OsDisk{
	// 				CreateOption: to.Ptr(armnetworkcloud.OsDiskCreateOptionEphemeral),
	// 				DeleteOption: to.Ptr(armnetworkcloud.OsDiskDeleteOptionDelete),
	// 				DiskSizeGB: to.Ptr[int64](120),
	// 			},
	// 			VolumeAttachments: []*string{
	// 				to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/volumes/volumeName")},
	// 			},
	// 			UserData: to.Ptr("dXNlckRhdGVTYW1wbGU="),
	// 			VMDeviceModel: to.Ptr(armnetworkcloud.VirtualMachineDeviceModelTypeT2),
	// 			VMImage: to.Ptr("myacr.azurecr.io/foobar:latest"),
	// 			VMImageRepositoryCredentials: &armnetworkcloud.ImageRepositoryCredentials{
	// 				RegistryURL: to.Ptr("myacr.azurecr.io"),
	// 				Username: to.Ptr("myuser"),
	// 			},
	// 			Volumes: []*string{
	// 				to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/volumes/volumeName")},
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/networkcloud/resource-manager/Microsoft.NetworkCloud/stable/2023-07-01/examples/VirtualMachines_PowerOff.json
func ExampleVirtualMachinesClient_BeginPowerOff() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkcloud.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualMachinesClient().BeginPowerOff(ctx, "resourceGroupName", "virtualMachineName", &armnetworkcloud.VirtualMachinesClientBeginPowerOffOptions{VirtualMachinePowerOffParameters: &armnetworkcloud.VirtualMachinePowerOffParameters{
		SkipShutdown: to.Ptr(armnetworkcloud.SkipShutdownTrue),
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/networkcloud/resource-manager/Microsoft.NetworkCloud/stable/2023-07-01/examples/VirtualMachines_Reimage.json
func ExampleVirtualMachinesClient_BeginReimage() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkcloud.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualMachinesClient().BeginReimage(ctx, "resourceGroupName", "virtualMachineName", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/networkcloud/resource-manager/Microsoft.NetworkCloud/stable/2023-07-01/examples/VirtualMachines_Restart.json
func ExampleVirtualMachinesClient_BeginRestart() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkcloud.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualMachinesClient().BeginRestart(ctx, "resourceGroupName", "virtualMachineName", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/networkcloud/resource-manager/Microsoft.NetworkCloud/stable/2023-07-01/examples/VirtualMachines_Start.json
func ExampleVirtualMachinesClient_BeginStart() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkcloud.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualMachinesClient().BeginStart(ctx, "resourceGroupName", "virtualMachineName", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}
