//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmonitor_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/monitor/armmonitor"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2023-01-01/examples/createOrUpdateActionGroup.json
func ExampleActionGroupsClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewActionGroupsClient().CreateOrUpdate(ctx, "Default-NotificationRules", "SampleActionGroup", armmonitor.ActionGroupResource{
		Location: to.Ptr("Global"),
		Tags:     map[string]*string{},
		Properties: &armmonitor.ActionGroup{
			ArmRoleReceivers: []*armmonitor.ArmRoleReceiver{
				{
					Name:                 to.Ptr("Sample armRole"),
					RoleID:               to.Ptr("8e3af657-a8ff-443c-a75c-2fe8c4bcb635"),
					UseCommonAlertSchema: to.Ptr(true),
				}},
			AutomationRunbookReceivers: []*armmonitor.AutomationRunbookReceiver{
				{
					Name:                 to.Ptr("testRunbook"),
					AutomationAccountID:  to.Ptr("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/runbookTest/providers/Microsoft.Automation/automationAccounts/runbooktest"),
					IsGlobalRunbook:      to.Ptr(false),
					RunbookName:          to.Ptr("Sample runbook"),
					ServiceURI:           to.Ptr("<serviceUri>"),
					UseCommonAlertSchema: to.Ptr(true),
					WebhookResourceID:    to.Ptr("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/runbookTest/providers/Microsoft.Automation/automationAccounts/runbooktest/webhooks/Alert1510184037084"),
				}},
			AzureAppPushReceivers: []*armmonitor.AzureAppPushReceiver{
				{
					Name:         to.Ptr("Sample azureAppPush"),
					EmailAddress: to.Ptr("johndoe@email.com"),
				}},
			AzureFunctionReceivers: []*armmonitor.AzureFunctionReceiver{
				{
					Name:                  to.Ptr("Sample azureFunction"),
					FunctionAppResourceID: to.Ptr("/subscriptions/5def922a-3ed4-49c1-b9fd-05ec533819a3/resourceGroups/aznsTest/providers/Microsoft.Web/sites/testFunctionApp"),
					FunctionName:          to.Ptr("HttpTriggerCSharp1"),
					HTTPTriggerURL:        to.Ptr("http://test.me"),
					UseCommonAlertSchema:  to.Ptr(true),
				}},
			EmailReceivers: []*armmonitor.EmailReceiver{
				{
					Name:                 to.Ptr("John Doe's email"),
					EmailAddress:         to.Ptr("johndoe@email.com"),
					UseCommonAlertSchema: to.Ptr(false),
				},
				{
					Name:                 to.Ptr("Jane Smith's email"),
					EmailAddress:         to.Ptr("janesmith@email.com"),
					UseCommonAlertSchema: to.Ptr(true),
				}},
			Enabled: to.Ptr(true),
			EventHubReceivers: []*armmonitor.EventHubReceiver{
				{
					Name:              to.Ptr("Sample eventHub"),
					EventHubName:      to.Ptr("testEventHub"),
					EventHubNameSpace: to.Ptr("testEventHubNameSpace"),
					SubscriptionID:    to.Ptr("187f412d-1758-44d9-b052-169e2564721d"),
					TenantID:          to.Ptr("68a4459a-ccb8-493c-b9da-dd30457d1b84"),
				}},
			GroupShortName: to.Ptr("sample"),
			ItsmReceivers: []*armmonitor.ItsmReceiver{
				{
					Name:                to.Ptr("Sample itsm"),
					ConnectionID:        to.Ptr("a3b9076c-ce8e-434e-85b4-aff10cb3c8f1"),
					Region:              to.Ptr("westcentralus"),
					TicketConfiguration: to.Ptr("{\"PayloadRevision\":0,\"WorkItemType\":\"Incident\",\"UseTemplate\":false,\"WorkItemData\":\"{}\",\"CreateOneWIPerCI\":false}"),
					WorkspaceID:         to.Ptr("5def922a-3ed4-49c1-b9fd-05ec533819a3|55dfd1f8-7e59-4f89-bf56-4c82f5ace23c"),
				}},
			LogicAppReceivers: []*armmonitor.LogicAppReceiver{
				{
					Name:                 to.Ptr("Sample logicApp"),
					CallbackURL:          to.Ptr("https://prod-27.northcentralus.logic.azure.com/workflows/68e572e818e5457ba898763b7db90877/triggers/manual/paths/invoke/azns/test?api-version=2016-10-01&sp=%2Ftriggers%2Fmanual%2Frun&sv=1.0&sig=Abpsb72UYJxPPvmDo937uzofupO5r_vIeWEx7KVHo7w"),
					ResourceID:           to.Ptr("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/LogicApp/providers/Microsoft.Logic/workflows/testLogicApp"),
					UseCommonAlertSchema: to.Ptr(false),
				}},
			SmsReceivers: []*armmonitor.SmsReceiver{
				{
					Name:        to.Ptr("John Doe's mobile"),
					CountryCode: to.Ptr("1"),
					PhoneNumber: to.Ptr("1234567890"),
				},
				{
					Name:        to.Ptr("Jane Smith's mobile"),
					CountryCode: to.Ptr("1"),
					PhoneNumber: to.Ptr("0987654321"),
				}},
			VoiceReceivers: []*armmonitor.VoiceReceiver{
				{
					Name:        to.Ptr("Sample voice"),
					CountryCode: to.Ptr("1"),
					PhoneNumber: to.Ptr("1234567890"),
				}},
			WebhookReceivers: []*armmonitor.WebhookReceiver{
				{
					Name:                 to.Ptr("Sample webhook 1"),
					ServiceURI:           to.Ptr("http://www.example.com/webhook1"),
					UseCommonAlertSchema: to.Ptr(true),
				},
				{
					Name:                 to.Ptr("Sample webhook 2"),
					IdentifierURI:        to.Ptr("http://someidentifier/d7811ba3-7996-4a93-99b6-6b2f3f355f8a"),
					ObjectID:             to.Ptr("d3bb868c-fe44-452c-aa26-769a6538c808"),
					ServiceURI:           to.Ptr("http://www.example.com/webhook2"),
					TenantID:             to.Ptr("68a4459a-ccb8-493c-b9da-dd30457d1b84"),
					UseAADAuth:           to.Ptr(true),
					UseCommonAlertSchema: to.Ptr(true),
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ActionGroupResource = armmonitor.ActionGroupResource{
	// 	Name: to.Ptr("SampleActionGroup"),
	// 	Type: to.Ptr("Microsoft.Insights/ActionGroups"),
	// 	ID: to.Ptr("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/Default-NotificationRules/providers/microsoft.insights/actionGroups/SampleActionGroup"),
	// 	Location: to.Ptr("Global"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armmonitor.ActionGroup{
	// 		ArmRoleReceivers: []*armmonitor.ArmRoleReceiver{
	// 			{
	// 				Name: to.Ptr("Sample armRole"),
	// 				RoleID: to.Ptr("8e3af657-a8ff-443c-a75c-2fe8c4bcb635"),
	// 				UseCommonAlertSchema: to.Ptr(true),
	// 		}},
	// 		AutomationRunbookReceivers: []*armmonitor.AutomationRunbookReceiver{
	// 			{
	// 				Name: to.Ptr("testRunbook"),
	// 				AutomationAccountID: to.Ptr("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/runbookTest/providers/Microsoft.Automation/automationAccounts/runbooktest"),
	// 				IsGlobalRunbook: to.Ptr(false),
	// 				RunbookName: to.Ptr("Sample runbook"),
	// 				ServiceURI: to.Ptr("<serviceUri>"),
	// 				UseCommonAlertSchema: to.Ptr(true),
	// 				WebhookResourceID: to.Ptr("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/runbookTest/providers/Microsoft.Automation/automationAccounts/runbooktest/webhooks/Alert1510184037084"),
	// 		}},
	// 		AzureAppPushReceivers: []*armmonitor.AzureAppPushReceiver{
	// 			{
	// 				Name: to.Ptr("Sample azureAppPush"),
	// 				EmailAddress: to.Ptr("johndoe@email.com"),
	// 		}},
	// 		AzureFunctionReceivers: []*armmonitor.AzureFunctionReceiver{
	// 			{
	// 				Name: to.Ptr("Sample azureFunction"),
	// 				FunctionAppResourceID: to.Ptr("/subscriptions/5def922a-3ed4-49c1-b9fd-05ec533819a3/resourceGroups/aznsTest/providers/Microsoft.Web/sites/testFunctionApp"),
	// 				FunctionName: to.Ptr("HttpTriggerCSharp1"),
	// 				HTTPTriggerURL: to.Ptr("<httpTriggerUrl>"),
	// 				UseCommonAlertSchema: to.Ptr(true),
	// 		}},
	// 		EmailReceivers: []*armmonitor.EmailReceiver{
	// 			{
	// 				Name: to.Ptr("John Doe's email"),
	// 				EmailAddress: to.Ptr("johndoe@email.com"),
	// 				Status: to.Ptr(armmonitor.ReceiverStatusEnabled),
	// 				UseCommonAlertSchema: to.Ptr(false),
	// 			},
	// 			{
	// 				Name: to.Ptr("Jane Smith's email"),
	// 				EmailAddress: to.Ptr("janesmith@email.com"),
	// 				Status: to.Ptr(armmonitor.ReceiverStatusEnabled),
	// 				UseCommonAlertSchema: to.Ptr(true),
	// 		}},
	// 		Enabled: to.Ptr(true),
	// 		EventHubReceivers: []*armmonitor.EventHubReceiver{
	// 			{
	// 				Name: to.Ptr("Sample eventHub"),
	// 				EventHubName: to.Ptr("testEventHub"),
	// 				EventHubNameSpace: to.Ptr("testEventHubNameSpace"),
	// 				SubscriptionID: to.Ptr("187f412d-1758-44d9-b052-169e2564721d"),
	// 				TenantID: to.Ptr("68a4459a-ccb8-493c-b9da-dd30457d1b84"),
	// 				UseCommonAlertSchema: to.Ptr(false),
	// 		}},
	// 		GroupShortName: to.Ptr("sample"),
	// 		ItsmReceivers: []*armmonitor.ItsmReceiver{
	// 			{
	// 				Name: to.Ptr("Sample itsm"),
	// 				ConnectionID: to.Ptr("a3b9076c-ce8e-434e-85b4-aff10cb3c8f1"),
	// 				Region: to.Ptr("westcentralus"),
	// 				TicketConfiguration: to.Ptr("{\"PayloadRevision\":0,\"WorkItemType\":\"Incident\",\"UseTemplate\":false,\"WorkItemData\":\"{}\",\"CreateOneWIPerCI\":false}"),
	// 				WorkspaceID: to.Ptr("5def922a-3ed4-49c1-b9fd-05ec533819a3|55dfd1f8-7e59-4f89-bf56-4c82f5ace23c"),
	// 		}},
	// 		LogicAppReceivers: []*armmonitor.LogicAppReceiver{
	// 			{
	// 				Name: to.Ptr("Sample logicApp"),
	// 				CallbackURL: to.Ptr("https://prod-27.northcentralus.logic.azure.com/workflows/68e572e818e5457ba898763b7db90877/triggers/manual/paths/invoke/azns/test?api-version=2016-10-01&sp=%2Ftriggers%2Fmanual%2Frun&sv=1.0&sig=Abpsb72UYJxPPvmDo937uzofupO5r_vIeWEx7KVHo7w"),
	// 				ResourceID: to.Ptr("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/LogicApp/providers/Microsoft.Logic/workflows/testLogicApp"),
	// 				UseCommonAlertSchema: to.Ptr(false),
	// 		}},
	// 		SmsReceivers: []*armmonitor.SmsReceiver{
	// 			{
	// 				Name: to.Ptr("John Doe's mobile"),
	// 				CountryCode: to.Ptr("1"),
	// 				PhoneNumber: to.Ptr("1234567890"),
	// 				Status: to.Ptr(armmonitor.ReceiverStatusEnabled),
	// 			},
	// 			{
	// 				Name: to.Ptr("Jane Smith's mobile"),
	// 				CountryCode: to.Ptr("1"),
	// 				PhoneNumber: to.Ptr("0987654321"),
	// 				Status: to.Ptr(armmonitor.ReceiverStatusEnabled),
	// 		}},
	// 		VoiceReceivers: []*armmonitor.VoiceReceiver{
	// 			{
	// 				Name: to.Ptr("Sample voice"),
	// 				CountryCode: to.Ptr("1"),
	// 				PhoneNumber: to.Ptr("1234567890"),
	// 		}},
	// 		WebhookReceivers: []*armmonitor.WebhookReceiver{
	// 			{
	// 				Name: to.Ptr("Sample webhook 1"),
	// 				ServiceURI: to.Ptr("http://www.example.com/webhook1"),
	// 				UseCommonAlertSchema: to.Ptr(true),
	// 			},
	// 			{
	// 				Name: to.Ptr("Sample webhook 2"),
	// 				IdentifierURI: to.Ptr("http://someidentifier/d7811ba3-7996-4a93-99b6-6b2f3f355f8a"),
	// 				ObjectID: to.Ptr("d3bb868c-fe44-452c-aa26-769a6538c808"),
	// 				ServiceURI: to.Ptr("http://www.example.com/webhook2"),
	// 				TenantID: to.Ptr("68a4459a-ccb8-493c-b9da-dd30457d1b84"),
	// 				UseAADAuth: to.Ptr(true),
	// 				UseCommonAlertSchema: to.Ptr(true),
	// 		}},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2023-01-01/examples/getActionGroup.json
func ExampleActionGroupsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewActionGroupsClient().Get(ctx, "Default-NotificationRules", "SampleActionGroup", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ActionGroupResource = armmonitor.ActionGroupResource{
	// 	Name: to.Ptr("SampleActionGroup"),
	// 	Type: to.Ptr("Microsoft.Insights/ActionGroups"),
	// 	ID: to.Ptr("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/Default-NotificationRules/providers/microsoft.insights/actionGroups/SampleActionGroup"),
	// 	Location: to.Ptr("Global"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armmonitor.ActionGroup{
	// 		ArmRoleReceivers: []*armmonitor.ArmRoleReceiver{
	// 		},
	// 		AutomationRunbookReceivers: []*armmonitor.AutomationRunbookReceiver{
	// 		},
	// 		AzureAppPushReceivers: []*armmonitor.AzureAppPushReceiver{
	// 		},
	// 		AzureFunctionReceivers: []*armmonitor.AzureFunctionReceiver{
	// 		},
	// 		EmailReceivers: []*armmonitor.EmailReceiver{
	// 			{
	// 				Name: to.Ptr("John Doe's email"),
	// 				EmailAddress: to.Ptr("johndoe@email.com"),
	// 				Status: to.Ptr(armmonitor.ReceiverStatusEnabled),
	// 				UseCommonAlertSchema: to.Ptr(true),
	// 			},
	// 			{
	// 				Name: to.Ptr("Jane Smith's email"),
	// 				EmailAddress: to.Ptr("janesmith@email.com"),
	// 				Status: to.Ptr(armmonitor.ReceiverStatusDisabled),
	// 				UseCommonAlertSchema: to.Ptr(true),
	// 		}},
	// 		Enabled: to.Ptr(true),
	// 		EventHubReceivers: []*armmonitor.EventHubReceiver{
	// 		},
	// 		GroupShortName: to.Ptr("sample"),
	// 		ItsmReceivers: []*armmonitor.ItsmReceiver{
	// 		},
	// 		LogicAppReceivers: []*armmonitor.LogicAppReceiver{
	// 		},
	// 		SmsReceivers: []*armmonitor.SmsReceiver{
	// 			{
	// 				Name: to.Ptr("John Doe's mobile"),
	// 				CountryCode: to.Ptr("1"),
	// 				PhoneNumber: to.Ptr("1234567890"),
	// 				Status: to.Ptr(armmonitor.ReceiverStatusDisabled),
	// 			},
	// 			{
	// 				Name: to.Ptr("Jane Smith's mobile"),
	// 				CountryCode: to.Ptr("1"),
	// 				PhoneNumber: to.Ptr("0987654321"),
	// 				Status: to.Ptr(armmonitor.ReceiverStatusEnabled),
	// 		}},
	// 		VoiceReceivers: []*armmonitor.VoiceReceiver{
	// 		},
	// 		WebhookReceivers: []*armmonitor.WebhookReceiver{
	// 			{
	// 				Name: to.Ptr("Sample webhook"),
	// 				ServiceURI: to.Ptr("http://www.example.com/webhook"),
	// 				UseCommonAlertSchema: to.Ptr(false),
	// 			},
	// 			{
	// 				Name: to.Ptr("Sample webhook 2"),
	// 				IdentifierURI: to.Ptr("http://someidentifier/d7811ba3-7996-4a93-99b6-6b2f3f355f8a"),
	// 				ObjectID: to.Ptr("d3bb868c-fe44-452c-aa26-769a6538c808"),
	// 				ServiceURI: to.Ptr("http://www.example.com/webhook2"),
	// 				TenantID: to.Ptr("68a4459a-ccb8-493c-b9da-dd30457d1b84"),
	// 				UseAADAuth: to.Ptr(true),
	// 				UseCommonAlertSchema: to.Ptr(true),
	// 		}},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2023-01-01/examples/deleteActionGroup.json
func ExampleActionGroupsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewActionGroupsClient().Delete(ctx, "Default-NotificationRules", "SampleActionGroup", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2023-01-01/examples/patchActionGroup.json
func ExampleActionGroupsClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewActionGroupsClient().Update(ctx, "Default-NotificationRules", "SampleActionGroup", armmonitor.ActionGroupPatchBody{
		Properties: &armmonitor.ActionGroupPatch{
			Enabled: to.Ptr(false),
		},
		Tags: map[string]*string{
			"key1": to.Ptr("value1"),
			"key2": to.Ptr("value2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ActionGroupResource = armmonitor.ActionGroupResource{
	// 	Name: to.Ptr("SampleActionGroup"),
	// 	Type: to.Ptr("Microsoft.Insights/ActionGroups"),
	// 	ID: to.Ptr("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/Default-NotificationRules/providers/microsoft.insights/actionGroups/SampleActionGroup"),
	// 	Location: to.Ptr("Global"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 		"key2": to.Ptr("value2"),
	// 	},
	// 	Properties: &armmonitor.ActionGroup{
	// 		ArmRoleReceivers: []*armmonitor.ArmRoleReceiver{
	// 		},
	// 		AutomationRunbookReceivers: []*armmonitor.AutomationRunbookReceiver{
	// 		},
	// 		AzureAppPushReceivers: []*armmonitor.AzureAppPushReceiver{
	// 		},
	// 		AzureFunctionReceivers: []*armmonitor.AzureFunctionReceiver{
	// 		},
	// 		EmailReceivers: []*armmonitor.EmailReceiver{
	// 			{
	// 				Name: to.Ptr("John Doe's email"),
	// 				EmailAddress: to.Ptr("johndoe@email.com"),
	// 				Status: to.Ptr(armmonitor.ReceiverStatusEnabled),
	// 				UseCommonAlertSchema: to.Ptr(true),
	// 			},
	// 			{
	// 				Name: to.Ptr("Jane Smith's email"),
	// 				EmailAddress: to.Ptr("janesmith@email.com"),
	// 				Status: to.Ptr(armmonitor.ReceiverStatusEnabled),
	// 				UseCommonAlertSchema: to.Ptr(true),
	// 		}},
	// 		Enabled: to.Ptr(true),
	// 		EventHubReceivers: []*armmonitor.EventHubReceiver{
	// 		},
	// 		GroupShortName: to.Ptr("sample"),
	// 		ItsmReceivers: []*armmonitor.ItsmReceiver{
	// 		},
	// 		LogicAppReceivers: []*armmonitor.LogicAppReceiver{
	// 		},
	// 		SmsReceivers: []*armmonitor.SmsReceiver{
	// 			{
	// 				Name: to.Ptr("John Doe's mobile"),
	// 				CountryCode: to.Ptr("1"),
	// 				PhoneNumber: to.Ptr("1234567890"),
	// 				Status: to.Ptr(armmonitor.ReceiverStatusEnabled),
	// 			},
	// 			{
	// 				Name: to.Ptr("Jane Smith's mobile"),
	// 				CountryCode: to.Ptr("1"),
	// 				PhoneNumber: to.Ptr("0987654321"),
	// 				Status: to.Ptr(armmonitor.ReceiverStatusEnabled),
	// 		}},
	// 		VoiceReceivers: []*armmonitor.VoiceReceiver{
	// 		},
	// 		WebhookReceivers: []*armmonitor.WebhookReceiver{
	// 			{
	// 				Name: to.Ptr("Sample webhook"),
	// 				ServiceURI: to.Ptr("http://www.example.com/webhook"),
	// 				UseCommonAlertSchema: to.Ptr(false),
	// 			},
	// 			{
	// 				Name: to.Ptr("Sample webhook 2"),
	// 				IdentifierURI: to.Ptr("http://someidentifier/d7811ba3-7996-4a93-99b6-6b2f3f355f8a"),
	// 				ObjectID: to.Ptr("d3bb868c-fe44-452c-aa26-769a6538c808"),
	// 				ServiceURI: to.Ptr("http://www.example.com/webhook2"),
	// 				TenantID: to.Ptr("68a4459a-ccb8-493c-b9da-dd30457d1b84"),
	// 				UseAADAuth: to.Ptr(true),
	// 				UseCommonAlertSchema: to.Ptr(true),
	// 		}},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2023-01-01/examples/postTestNotificationsAtActionGroupResourceLevel.json
func ExampleActionGroupsClient_BeginCreateNotificationsAtActionGroupResourceLevel() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewActionGroupsClient().BeginCreateNotificationsAtActionGroupResourceLevel(ctx, "TestRgName", "TestAgName", armmonitor.NotificationRequestBody{
		AlertType: to.Ptr("budget"),
		ArmRoleReceivers: []*armmonitor.ArmRoleReceiver{
			{
				Name:                 to.Ptr("ArmRole-Common"),
				RoleID:               to.Ptr("11111111-1111-1111-1111-111111111111"),
				UseCommonAlertSchema: to.Ptr(true),
			},
			{
				Name:                 to.Ptr("ArmRole-nonCommon"),
				RoleID:               to.Ptr("11111111-1111-1111-1111-111111111111"),
				UseCommonAlertSchema: to.Ptr(false),
			}},
		AutomationRunbookReceivers: []*armmonitor.AutomationRunbookReceiver{
			{
				Name:                 to.Ptr("testRunbook"),
				AutomationAccountID:  to.Ptr("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/runbookTest/providers/Microsoft.Automation/automationAccounts/runbooktest"),
				IsGlobalRunbook:      to.Ptr(false),
				RunbookName:          to.Ptr("Sample runbook"),
				ServiceURI:           to.Ptr("http://test.me"),
				UseCommonAlertSchema: to.Ptr(true),
				WebhookResourceID:    to.Ptr("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/runbookTest/providers/Microsoft.Automation/automationAccounts/runbooktest/webhooks/Alert1510184037084"),
			}},
		AzureAppPushReceivers: []*armmonitor.AzureAppPushReceiver{
			{
				Name:         to.Ptr("Sample azureAppPush"),
				EmailAddress: to.Ptr("johndoe@email.com"),
			}},
		AzureFunctionReceivers: []*armmonitor.AzureFunctionReceiver{
			{
				Name:                  to.Ptr("Sample azureFunction"),
				FunctionAppResourceID: to.Ptr("/subscriptions/5def922a-3ed4-49c1-b9fd-05ec533819a3/resourceGroups/aznsTest/providers/Microsoft.Web/sites/testFunctionApp"),
				FunctionName:          to.Ptr("HttpTriggerCSharp1"),
				HTTPTriggerURL:        to.Ptr("http://test.me"),
				UseCommonAlertSchema:  to.Ptr(true),
			}},
		EmailReceivers: []*armmonitor.EmailReceiver{
			{
				Name:                 to.Ptr("John Doe's email"),
				EmailAddress:         to.Ptr("johndoe@email.com"),
				UseCommonAlertSchema: to.Ptr(false),
			},
			{
				Name:                 to.Ptr("Jane Smith's email"),
				EmailAddress:         to.Ptr("janesmith@email.com"),
				UseCommonAlertSchema: to.Ptr(true),
			}},
		EventHubReceivers: []*armmonitor.EventHubReceiver{
			{
				Name:              to.Ptr("Sample eventHub"),
				EventHubName:      to.Ptr("testEventHub"),
				EventHubNameSpace: to.Ptr("testEventHubNameSpace"),
				SubscriptionID:    to.Ptr("187f412d-1758-44d9-b052-169e2564721d"),
				TenantID:          to.Ptr("68a4459a-ccb8-493c-b9da-dd30457d1b84"),
			}},
		ItsmReceivers: []*armmonitor.ItsmReceiver{
			{
				Name:                to.Ptr("Sample itsm"),
				ConnectionID:        to.Ptr("a3b9076c-ce8e-434e-85b4-aff10cb3c8f1"),
				Region:              to.Ptr("westcentralus"),
				TicketConfiguration: to.Ptr("{\"PayloadRevision\":0,\"WorkItemType\":\"Incident\",\"UseTemplate\":false,\"WorkItemData\":\"{}\",\"CreateOneWIPerCI\":false}"),
				WorkspaceID:         to.Ptr("5def922a-3ed4-49c1-b9fd-05ec533819a3|55dfd1f8-7e59-4f89-bf56-4c82f5ace23c"),
			}},
		LogicAppReceivers: []*armmonitor.LogicAppReceiver{
			{
				Name:                 to.Ptr("Sample logicApp"),
				CallbackURL:          to.Ptr("https://prod-27.northcentralus.logic.azure.com/workflows/68e572e818e5457ba898763b7db90877/triggers/manual/paths/invoke/azns/test?api-version=2016-10-01&sp=%2Ftriggers%2Fmanual%2Frun&sv=1.0&sig=Abpsb72UYJxPPvmDo937uzofupO5r_vIeWEx7KVHo7w"),
				ResourceID:           to.Ptr("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/LogicApp/providers/Microsoft.Logic/workflows/testLogicApp"),
				UseCommonAlertSchema: to.Ptr(false),
			}},
		SmsReceivers: []*armmonitor.SmsReceiver{
			{
				Name:        to.Ptr("John Doe's mobile"),
				CountryCode: to.Ptr("1"),
				PhoneNumber: to.Ptr("1234567890"),
			},
			{
				Name:        to.Ptr("Jane Smith's mobile"),
				CountryCode: to.Ptr("1"),
				PhoneNumber: to.Ptr("0987654321"),
			}},
		VoiceReceivers: []*armmonitor.VoiceReceiver{
			{
				Name:        to.Ptr("Sample voice"),
				CountryCode: to.Ptr("1"),
				PhoneNumber: to.Ptr("1234567890"),
			}},
		WebhookReceivers: []*armmonitor.WebhookReceiver{
			{
				Name:                 to.Ptr("Sample webhook 1"),
				ServiceURI:           to.Ptr("http://www.example.com/webhook1"),
				UseCommonAlertSchema: to.Ptr(true),
			},
			{
				Name:                 to.Ptr("Sample webhook 2"),
				IdentifierURI:        to.Ptr("http://someidentifier/d7811ba3-7996-4a93-99b6-6b2f3f355f8a"),
				ObjectID:             to.Ptr("d3bb868c-fe44-452c-aa26-769a6538c808"),
				ServiceURI:           to.Ptr("http://www.example.com/webhook2"),
				TenantID:             to.Ptr("68a4459a-ccb8-493c-b9da-dd30457d1b84"),
				UseAADAuth:           to.Ptr(true),
				UseCommonAlertSchema: to.Ptr(true),
			}},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.TestNotificationDetailsResponse = armmonitor.TestNotificationDetailsResponse{
	// 	ActionDetails: []*armmonitor.ActionDetail{
	// 		{
	// 			MechanismType: to.Ptr("AzureAppPush"),
	// 			Name: to.Ptr("AzureAppPush-name"),
	// 			SendTime: to.Ptr("2021-09-21T04:52:42.8620629+00:00"),
	// 			Status: to.Ptr("Completed"),
	// 			SubState: to.Ptr("Default"),
	// 		},
	// 		{
	// 			MechanismType: to.Ptr("AzureFunction"),
	// 			Name: to.Ptr("AzureFunction-name"),
	// 			SendTime: to.Ptr("2021-09-21T04:52:42.0623319+00:00"),
	// 			Status: to.Ptr("Completed"),
	// 			SubState: to.Ptr("Default"),
	// 		},
	// 		{
	// 			MechanismType: to.Ptr("Email"),
	// 			Name: to.Ptr("Email-name"),
	// 			SendTime: to.Ptr("2021-09-21T04:52:40.7480368+00:00"),
	// 			Status: to.Ptr("Completed"),
	// 			SubState: to.Ptr("Default"),
	// 		},
	// 		{
	// 			MechanismType: to.Ptr("LogicApp"),
	// 			Name: to.Ptr("LogicApp-Name"),
	// 			SendTime: to.Ptr("2021-09-21T04:52:42.2473419+00:00"),
	// 			Status: to.Ptr("Completed"),
	// 			SubState: to.Ptr("Default"),
	// 		},
	// 		{
	// 			MechanismType: to.Ptr("Webhook"),
	// 			Name: to.Ptr("Webhook-name"),
	// 			SendTime: to.Ptr("2021-09-21T04:52:42.0723479+00:00"),
	// 			Status: to.Ptr("Completed"),
	// 			SubState: to.Ptr("Default"),
	// 		},
	// 		{
	// 			MechanismType: to.Ptr("SecureWebhook"),
	// 			Name: to.Ptr("SecureWebhook-name"),
	// 			SendTime: to.Ptr("2021-09-21T04:52:42.0723479+00:00"),
	// 			Status: to.Ptr("Completed"),
	// 			SubState: to.Ptr("Default"),
	// 		},
	// 		{
	// 			MechanismType: to.Ptr("Sms"),
	// 			Name: to.Ptr("Sms-name"),
	// 			SendTime: to.Ptr("2021-09-21T04:52:41.353015+00:00"),
	// 			Status: to.Ptr("Completed"),
	// 			SubState: to.Ptr("Default"),
	// 		},
	// 		{
	// 			MechanismType: to.Ptr("Voice"),
	// 			Name: to.Ptr("Voice-name"),
	// 			SendTime: to.Ptr("2021-09-21T04:52:41.6330734+00:00"),
	// 			Status: to.Ptr("Completed"),
	// 			SubState: to.Ptr("Default"),
	// 		},
	// 		{
	// 			MechanismType: to.Ptr("EventHub"),
	// 			Name: to.Ptr("EventHub-name"),
	// 			SendTime: to.Ptr("2021-09-21T04:52:42.0723479+00:00"),
	// 			Status: to.Ptr("Completed"),
	// 			SubState: to.Ptr("Default"),
	// 		},
	// 		{
	// 			MechanismType: to.Ptr("AutomationRunbook"),
	// 			Name: to.Ptr("AutomationRunbook-name"),
	// 			SendTime: to.Ptr("2021-09-21T04:52:42.0723479+00:00"),
	// 			Status: to.Ptr("Completed"),
	// 			SubState: to.Ptr("Default"),
	// 		},
	// 		{
	// 			MechanismType: to.Ptr("Itsm"),
	// 			Name: to.Ptr("Itsm-name"),
	// 			SendTime: to.Ptr("2021-09-21T04:52:42.0723479+00:00"),
	// 			Status: to.Ptr("Completed"),
	// 			SubState: to.Ptr("Default"),
	// 	}},
	// 	CompletedTime: to.Ptr("0001-01-01T00:00:00+00:00"),
	// 	Context: &armmonitor.Context{
	// 		ContextType: to.Ptr("Microsoft.Insights/Budget"),
	// 		NotificationSource: to.Ptr("Microsoft.Insights/TestNotification"),
	// 	},
	// 	CreatedTime: to.Ptr("2021-09-21T04:52:29.5091168+00:00"),
	// 	State: to.Ptr("Completed"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2023-01-01/examples/getTestNotificationsAtActionGroupResourceLevel.json
func ExampleActionGroupsClient_GetTestNotificationsAtActionGroupResourceLevel() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewActionGroupsClient().GetTestNotificationsAtActionGroupResourceLevel(ctx, "TestRgName", "TestAgName", "11000222191287", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.TestNotificationDetailsResponse = armmonitor.TestNotificationDetailsResponse{
	// 	ActionDetails: []*armmonitor.ActionDetail{
	// 		{
	// 			MechanismType: to.Ptr("AzureAppPush"),
	// 			Name: to.Ptr("AzureAppPush-name"),
	// 			SendTime: to.Ptr("2021-09-21T04:52:42.8620629+00:00"),
	// 			Status: to.Ptr("Completed"),
	// 			SubState: to.Ptr("Default"),
	// 		},
	// 		{
	// 			MechanismType: to.Ptr("AzureFunction"),
	// 			Name: to.Ptr("AzureFunction-name"),
	// 			SendTime: to.Ptr("2021-09-21T04:52:42.0623319+00:00"),
	// 			Status: to.Ptr("Completed"),
	// 			SubState: to.Ptr("Default"),
	// 		},
	// 		{
	// 			MechanismType: to.Ptr("Email"),
	// 			Name: to.Ptr("Email-name"),
	// 			SendTime: to.Ptr("2021-09-21T04:52:40.7480368+00:00"),
	// 			Status: to.Ptr("Completed"),
	// 			SubState: to.Ptr("Default"),
	// 		},
	// 		{
	// 			MechanismType: to.Ptr("LogicApp"),
	// 			Name: to.Ptr("LogicApp-name"),
	// 			SendTime: to.Ptr("2021-09-21T04:52:42.2473419+00:00"),
	// 			Status: to.Ptr("Completed"),
	// 			SubState: to.Ptr("Default"),
	// 		},
	// 		{
	// 			MechanismType: to.Ptr("Webhook"),
	// 			Name: to.Ptr("Webhook-name"),
	// 			SendTime: to.Ptr("2021-09-21T04:52:42.0723479+00:00"),
	// 			Status: to.Ptr("Completed"),
	// 			SubState: to.Ptr("Default"),
	// 		},
	// 		{
	// 			MechanismType: to.Ptr("SecureWebhook"),
	// 			Name: to.Ptr("SecureWebhook-name"),
	// 			SendTime: to.Ptr("2021-09-21T04:52:42.0723479+00:00"),
	// 			Status: to.Ptr("Completed"),
	// 			SubState: to.Ptr("Default"),
	// 		},
	// 		{
	// 			MechanismType: to.Ptr("Sms"),
	// 			Name: to.Ptr("Sms-name"),
	// 			SendTime: to.Ptr("2021-09-21T04:52:41.353015+00:00"),
	// 			Status: to.Ptr("Completed"),
	// 			SubState: to.Ptr("Default"),
	// 		},
	// 		{
	// 			MechanismType: to.Ptr("Voice"),
	// 			Name: to.Ptr("Voice-name"),
	// 			SendTime: to.Ptr("2021-09-21T04:52:41.6330734+00:00"),
	// 			Status: to.Ptr("Completed"),
	// 			SubState: to.Ptr("Default"),
	// 		},
	// 		{
	// 			MechanismType: to.Ptr("EventHub"),
	// 			Name: to.Ptr("EventHub-name"),
	// 			SendTime: to.Ptr("2021-09-21T04:52:42.0723479+00:00"),
	// 			Status: to.Ptr("Completed"),
	// 			SubState: to.Ptr("Default"),
	// 		},
	// 		{
	// 			MechanismType: to.Ptr("AutomationRunbook"),
	// 			Name: to.Ptr("AutomationRunbook-name"),
	// 			SendTime: to.Ptr("2021-09-21T04:52:42.0723479+00:00"),
	// 			Status: to.Ptr("Completed"),
	// 			SubState: to.Ptr("Default"),
	// 		},
	// 		{
	// 			MechanismType: to.Ptr("Itsm"),
	// 			Name: to.Ptr("Itsm-name"),
	// 			SendTime: to.Ptr("2021-09-21T04:52:42.0723479+00:00"),
	// 			Status: to.Ptr("Completed"),
	// 			SubState: to.Ptr("Default"),
	// 	}},
	// 	CompletedTime: to.Ptr("0001-01-01T00:00:00+00:00"),
	// 	Context: &armmonitor.Context{
	// 		ContextType: to.Ptr("Microsoft.Insights/Budget"),
	// 		NotificationSource: to.Ptr("Microsoft.Insights/TestNotification"),
	// 	},
	// 	CreatedTime: to.Ptr("2021-09-21T04:52:29.5091168+00:00"),
	// 	State: to.Ptr("Completed"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2023-01-01/examples/listActionGroups.json
func ExampleActionGroupsClient_NewListBySubscriptionIDPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewActionGroupsClient().NewListBySubscriptionIDPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ActionGroupList = armmonitor.ActionGroupList{
		// 	Value: []*armmonitor.ActionGroupResource{
		// 		{
		// 			Name: to.Ptr("SampleActionGroup"),
		// 			Type: to.Ptr("Microsoft.Insights/ActionGroups"),
		// 			ID: to.Ptr("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/Default-NotificationRules/providers/microsoft.insights/actionGroups/SampleActionGroup"),
		// 			Location: to.Ptr("Global"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armmonitor.ActionGroup{
		// 				ArmRoleReceivers: []*armmonitor.ArmRoleReceiver{
		// 				},
		// 				AutomationRunbookReceivers: []*armmonitor.AutomationRunbookReceiver{
		// 				},
		// 				AzureAppPushReceivers: []*armmonitor.AzureAppPushReceiver{
		// 				},
		// 				AzureFunctionReceivers: []*armmonitor.AzureFunctionReceiver{
		// 				},
		// 				EmailReceivers: []*armmonitor.EmailReceiver{
		// 					{
		// 						Name: to.Ptr("John Doe's email"),
		// 						EmailAddress: to.Ptr("johndoe@email.com"),
		// 						Status: to.Ptr(armmonitor.ReceiverStatusEnabled),
		// 						UseCommonAlertSchema: to.Ptr(true),
		// 					},
		// 					{
		// 						Name: to.Ptr("Jane Smith's email"),
		// 						EmailAddress: to.Ptr("janesmith@email.com"),
		// 						Status: to.Ptr(armmonitor.ReceiverStatusDisabled),
		// 						UseCommonAlertSchema: to.Ptr(true),
		// 				}},
		// 				Enabled: to.Ptr(true),
		// 				EventHubReceivers: []*armmonitor.EventHubReceiver{
		// 				},
		// 				GroupShortName: to.Ptr("sample"),
		// 				ItsmReceivers: []*armmonitor.ItsmReceiver{
		// 				},
		// 				LogicAppReceivers: []*armmonitor.LogicAppReceiver{
		// 				},
		// 				SmsReceivers: []*armmonitor.SmsReceiver{
		// 					{
		// 						Name: to.Ptr("John Doe's mobile"),
		// 						CountryCode: to.Ptr("1"),
		// 						PhoneNumber: to.Ptr("1234567890"),
		// 						Status: to.Ptr(armmonitor.ReceiverStatusDisabled),
		// 					},
		// 					{
		// 						Name: to.Ptr("Jane Smith's mobile"),
		// 						CountryCode: to.Ptr("1"),
		// 						PhoneNumber: to.Ptr("0987654321"),
		// 						Status: to.Ptr(armmonitor.ReceiverStatusEnabled),
		// 				}},
		// 				VoiceReceivers: []*armmonitor.VoiceReceiver{
		// 				},
		// 				WebhookReceivers: []*armmonitor.WebhookReceiver{
		// 					{
		// 						Name: to.Ptr("Sample webhook"),
		// 						ServiceURI: to.Ptr("http://www.example.com/webhook"),
		// 						UseCommonAlertSchema: to.Ptr(false),
		// 					},
		// 					{
		// 						Name: to.Ptr("Sample webhook 2"),
		// 						IdentifierURI: to.Ptr("http://someidentifier/d7811ba3-7996-4a93-99b6-6b2f3f355f8a"),
		// 						ObjectID: to.Ptr("d3bb868c-fe44-452c-aa26-769a6538c808"),
		// 						ServiceURI: to.Ptr("http://www.example.com/webhook2"),
		// 						TenantID: to.Ptr("68a4459a-ccb8-493c-b9da-dd30457d1b84"),
		// 						UseAADAuth: to.Ptr(true),
		// 						UseCommonAlertSchema: to.Ptr(true),
		// 				}},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("SampleActionGroup2"),
		// 			Type: to.Ptr("Microsoft.Insights/ActionGroups"),
		// 			ID: to.Ptr("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/Default-NotificationRules/providers/microsoft.insights/actionGroups/SampleActionGroup2"),
		// 			Location: to.Ptr("Global"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armmonitor.ActionGroup{
		// 				ArmRoleReceivers: []*armmonitor.ArmRoleReceiver{
		// 				},
		// 				AutomationRunbookReceivers: []*armmonitor.AutomationRunbookReceiver{
		// 				},
		// 				AzureAppPushReceivers: []*armmonitor.AzureAppPushReceiver{
		// 				},
		// 				AzureFunctionReceivers: []*armmonitor.AzureFunctionReceiver{
		// 				},
		// 				EmailReceivers: []*armmonitor.EmailReceiver{
		// 					{
		// 						Name: to.Ptr("John Doe's email"),
		// 						EmailAddress: to.Ptr("johndoe@email.com"),
		// 						Status: to.Ptr(armmonitor.ReceiverStatusEnabled),
		// 						UseCommonAlertSchema: to.Ptr(true),
		// 				}},
		// 				Enabled: to.Ptr(false),
		// 				EventHubReceivers: []*armmonitor.EventHubReceiver{
		// 				},
		// 				GroupShortName: to.Ptr("sample2"),
		// 				ItsmReceivers: []*armmonitor.ItsmReceiver{
		// 				},
		// 				LogicAppReceivers: []*armmonitor.LogicAppReceiver{
		// 				},
		// 				SmsReceivers: []*armmonitor.SmsReceiver{
		// 					{
		// 						Name: to.Ptr("Jane Smith's mobile"),
		// 						CountryCode: to.Ptr("1"),
		// 						PhoneNumber: to.Ptr("0987654321"),
		// 						Status: to.Ptr(armmonitor.ReceiverStatusEnabled),
		// 				}},
		// 				VoiceReceivers: []*armmonitor.VoiceReceiver{
		// 				},
		// 				WebhookReceivers: []*armmonitor.WebhookReceiver{
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2023-01-01/examples/enableReceiver.json
func ExampleActionGroupsClient_EnableReceiver() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewActionGroupsClient().EnableReceiver(ctx, "Default-NotificationRules", "SampleActionGroup", armmonitor.EnableRequest{
		ReceiverName: to.Ptr("John Doe's mobile"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}
