//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmobilenetwork

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ExtendedUeInformationClient contains the methods for the ExtendedUeInformation group.
// Don't use this type directly, use NewExtendedUeInformationClient() instead.
type ExtendedUeInformationClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewExtendedUeInformationClient creates a new instance of ExtendedUeInformationClient with the specified values.
//   - subscriptionID - The ID of the target subscription. The value must be an UUID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewExtendedUeInformationClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ExtendedUeInformationClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ExtendedUeInformationClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// Get - Gets extended information about the specified UE from the packet core.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-02-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - packetCoreControlPlaneName - The name of the packet core control plane.
//   - ueID - IMSI of a UE.
//   - options - ExtendedUeInformationClientGetOptions contains the optional parameters for the ExtendedUeInformationClient.Get
//     method.
func (client *ExtendedUeInformationClient) Get(ctx context.Context, resourceGroupName string, packetCoreControlPlaneName string, ueID string, options *ExtendedUeInformationClientGetOptions) (ExtendedUeInformationClientGetResponse, error) {
	var err error
	const operationName = "ExtendedUeInformationClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, packetCoreControlPlaneName, ueID, options)
	if err != nil {
		return ExtendedUeInformationClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ExtendedUeInformationClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ExtendedUeInformationClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *ExtendedUeInformationClient) getCreateRequest(ctx context.Context, resourceGroupName string, packetCoreControlPlaneName string, ueID string, options *ExtendedUeInformationClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/ues/{ueId}/extendedInformation/default"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if packetCoreControlPlaneName == "" {
		return nil, errors.New("parameter packetCoreControlPlaneName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{packetCoreControlPlaneName}", url.PathEscape(packetCoreControlPlaneName))
	if ueID == "" {
		return nil, errors.New("parameter ueID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ueId}", url.PathEscape(ueID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-02-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ExtendedUeInformationClient) getHandleResponse(resp *http.Response) (ExtendedUeInformationClientGetResponse, error) {
	result := ExtendedUeInformationClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ExtendedUeInfo); err != nil {
		return ExtendedUeInformationClientGetResponse{}, err
	}
	return result, nil
}
