//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmediaservices_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/mediaservices/armmediaservices/v3"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Encoding/stable/2022-07-01/examples/transforms-list-all.json
func ExampleTransformsClient_NewListPager_listsTheTransforms() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewTransformsClient().NewListPager("contosoresources", "contosomedia", &armmediaservices.TransformsClientListOptions{Filter: nil,
		Orderby: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.TransformCollection = armmediaservices.TransformCollection{
		// 	Value: []*armmediaservices.Transform{
		// 		{
		// 			Name: to.Ptr("sampleEncode"),
		// 			Type: to.Ptr("Microsoft.Media/mediaservices/transforms"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contosoresources/providers/Microsoft.Media/mediaservices/contosomedia/transforms/sampleEncode"),
		// 			Properties: &armmediaservices.TransformProperties{
		// 				Description: to.Ptr("A sample Transform using the Standard Encoder with a built in preset."),
		// 				Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-10-17T23:14:30.248Z"); return t}()),
		// 				LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-10-17T23:14:30.248Z"); return t}()),
		// 				Outputs: []*armmediaservices.TransformOutput{
		// 					{
		// 						OnError: to.Ptr(armmediaservices.OnErrorTypeStopProcessingJob),
		// 						Preset: &armmediaservices.BuiltInStandardEncoderPreset{
		// 							ODataType: to.Ptr("#Microsoft.Media.BuiltInStandardEncoderPreset"),
		// 							PresetName: to.Ptr(armmediaservices.EncoderNamedPresetAdaptiveStreaming),
		// 						},
		// 						RelativePriority: to.Ptr(armmediaservices.PriorityNormal),
		// 				}},
		// 			},
		// 			SystemData: &armmediaservices.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-10-17T23:14:30.248Z"); return t}()),
		// 				CreatedBy: to.Ptr("contoso@microsoft.com"),
		// 				CreatedByType: to.Ptr(armmediaservices.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-10-17T23:14:30.248Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("contoso@microsoft.com"),
		// 				LastModifiedByType: to.Ptr(armmediaservices.CreatedByTypeUser),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleEncodeAndVideoIndex"),
		// 			Type: to.Ptr("Microsoft.Media/mediaservices/transforms"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contosoresources/providers/Microsoft.Media/mediaservices/contosomedia/transforms/sampleEncodeAndVideoIndex"),
		// 			Properties: &armmediaservices.TransformProperties{
		// 				Description: to.Ptr("A sample Transform using the Standard Encoder with a built-in preset, as well as the Video Analyzer."),
		// 				Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-10-17T23:14:30.477Z"); return t}()),
		// 				LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-10-17T23:14:30.477Z"); return t}()),
		// 				Outputs: []*armmediaservices.TransformOutput{
		// 					{
		// 						OnError: to.Ptr(armmediaservices.OnErrorTypeStopProcessingJob),
		// 						Preset: &armmediaservices.BuiltInStandardEncoderPreset{
		// 							ODataType: to.Ptr("#Microsoft.Media.BuiltInStandardEncoderPreset"),
		// 							PresetName: to.Ptr(armmediaservices.EncoderNamedPresetAdaptiveStreaming),
		// 						},
		// 						RelativePriority: to.Ptr(armmediaservices.PriorityNormal),
		// 					},
		// 					{
		// 						OnError: to.Ptr(armmediaservices.OnErrorTypeStopProcessingJob),
		// 						Preset: &armmediaservices.VideoAnalyzerPreset{
		// 							ODataType: to.Ptr("#Microsoft.Media.VideoAnalyzerPreset"),
		// 							Mode: to.Ptr(armmediaservices.AudioAnalysisModeStandard),
		// 							InsightsToExtract: to.Ptr(armmediaservices.InsightsTypeAllInsights),
		// 						},
		// 						RelativePriority: to.Ptr(armmediaservices.PriorityNormal),
		// 				}},
		// 			},
		// 			SystemData: &armmediaservices.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-10-17T23:14:30.477Z"); return t}()),
		// 				CreatedBy: to.Ptr("contoso@microsoft.com"),
		// 				CreatedByType: to.Ptr(armmediaservices.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-10-17T23:14:30.477Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("contoso@microsoft.com"),
		// 				LastModifiedByType: to.Ptr(armmediaservices.CreatedByTypeUser),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Encoding/stable/2022-07-01/examples/transforms-list-all-filter-by-created.json
func ExampleTransformsClient_NewListPager_listsTheTransformsFilterByCreated() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewTransformsClient().NewListPager("contosoresources", "contosomedia", &armmediaservices.TransformsClientListOptions{Filter: to.Ptr("properties/created gt 2021-06-01T00:00:00.0000000Z and properties/created le 2021-06-01T00:00:10.0000000Z"),
		Orderby: to.Ptr("properties/created"),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.TransformCollection = armmediaservices.TransformCollection{
		// 	Value: []*armmediaservices.Transform{
		// 		{
		// 			Name: to.Ptr("sampleEncodeAndVideoIndex"),
		// 			Type: to.Ptr("Microsoft.Media/mediaservices/transforms"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contosoresources/providers/Microsoft.Media/mediaservices/contosomedia/transforms/sampleEncodeAndVideoIndex"),
		// 			Properties: &armmediaservices.TransformProperties{
		// 				Description: to.Ptr("A sample Transform using the Video Analyzer."),
		// 				Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-01T00:00:10.000Z"); return t}()),
		// 				LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-01T00:00:10.000Z"); return t}()),
		// 				Outputs: []*armmediaservices.TransformOutput{
		// 					{
		// 						OnError: to.Ptr(armmediaservices.OnErrorTypeStopProcessingJob),
		// 						Preset: &armmediaservices.VideoAnalyzerPreset{
		// 							ODataType: to.Ptr("#Microsoft.Media.VideoAnalyzerPreset"),
		// 							Mode: to.Ptr(armmediaservices.AudioAnalysisModeStandard),
		// 							InsightsToExtract: to.Ptr(armmediaservices.InsightsTypeAllInsights),
		// 						},
		// 						RelativePriority: to.Ptr(armmediaservices.PriorityNormal),
		// 				}},
		// 			},
		// 			SystemData: &armmediaservices.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-01T00:00:10.000Z"); return t}()),
		// 				CreatedBy: to.Ptr("contoso@microsoft.com"),
		// 				CreatedByType: to.Ptr(armmediaservices.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-01T00:00:10.000Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("contoso@microsoft.com"),
		// 				LastModifiedByType: to.Ptr(armmediaservices.CreatedByTypeUser),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Encoding/stable/2022-07-01/examples/transforms-list-all-filter-by-lastmodified.json
func ExampleTransformsClient_NewListPager_listsTheTransformsFilterByLastmodified() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewTransformsClient().NewListPager("contosoresources", "contosomedia", &armmediaservices.TransformsClientListOptions{Filter: to.Ptr("properties/lastmodified gt 2021-06-01T00:00:00.0000000Z and properties/lastmodified le 2021-06-01T00:00:10.0000000Z"),
		Orderby: to.Ptr("properties/lastmodified desc"),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.TransformCollection = armmediaservices.TransformCollection{
		// 	Value: []*armmediaservices.Transform{
		// 		{
		// 			Name: to.Ptr("sampleEncodeAndVideoIndex"),
		// 			Type: to.Ptr("Microsoft.Media/mediaservices/transforms"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contosoresources/providers/Microsoft.Media/mediaservices/contosomedia/transforms/sampleEncodeAndVideoIndex"),
		// 			Properties: &armmediaservices.TransformProperties{
		// 				Description: to.Ptr("A sample Transform using the Video Analyzer."),
		// 				Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-01T00:00:10.000Z"); return t}()),
		// 				LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-01T00:00:10.000Z"); return t}()),
		// 				Outputs: []*armmediaservices.TransformOutput{
		// 					{
		// 						OnError: to.Ptr(armmediaservices.OnErrorTypeStopProcessingJob),
		// 						Preset: &armmediaservices.VideoAnalyzerPreset{
		// 							ODataType: to.Ptr("#Microsoft.Media.VideoAnalyzerPreset"),
		// 							Mode: to.Ptr(armmediaservices.AudioAnalysisModeStandard),
		// 							InsightsToExtract: to.Ptr(armmediaservices.InsightsTypeAllInsights),
		// 						},
		// 						RelativePriority: to.Ptr(armmediaservices.PriorityNormal),
		// 				}},
		// 			},
		// 			SystemData: &armmediaservices.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-01T00:00:10.000Z"); return t}()),
		// 				CreatedBy: to.Ptr("contoso@microsoft.com"),
		// 				CreatedByType: to.Ptr(armmediaservices.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-01T00:00:10.000Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("contoso@microsoft.com"),
		// 				LastModifiedByType: to.Ptr(armmediaservices.CreatedByTypeUser),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Encoding/stable/2022-07-01/examples/transforms-list-all-filter-by-name.json
func ExampleTransformsClient_NewListPager_listsTheTransformsFilterByName() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewTransformsClient().NewListPager("contosoresources", "contosomedia", &armmediaservices.TransformsClientListOptions{Filter: to.Ptr("(name eq 'sampleEncode') or (name eq 'sampleEncodeAndVideoIndex')"),
		Orderby: to.Ptr("name desc"),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.TransformCollection = armmediaservices.TransformCollection{
		// 	Value: []*armmediaservices.Transform{
		// 		{
		// 			Name: to.Ptr("sampleEncodeAndVideoIndex"),
		// 			Type: to.Ptr("Microsoft.Media/mediaservices/transforms"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contosoresources/providers/Microsoft.Media/mediaservices/contosomedia/transforms/sampleEncodeAndVideoIndex"),
		// 			Properties: &armmediaservices.TransformProperties{
		// 				Description: to.Ptr("A sample Transform using the Standard Encoder with a built-in preset, as well as the Video Analyzer."),
		// 				Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-10-17T23:14:31.238Z"); return t}()),
		// 				LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-10-17T23:14:31.238Z"); return t}()),
		// 				Outputs: []*armmediaservices.TransformOutput{
		// 					{
		// 						OnError: to.Ptr(armmediaservices.OnErrorTypeStopProcessingJob),
		// 						Preset: &armmediaservices.BuiltInStandardEncoderPreset{
		// 							ODataType: to.Ptr("#Microsoft.Media.BuiltInStandardEncoderPreset"),
		// 							PresetName: to.Ptr(armmediaservices.EncoderNamedPresetAdaptiveStreaming),
		// 						},
		// 						RelativePriority: to.Ptr(armmediaservices.PriorityNormal),
		// 					},
		// 					{
		// 						OnError: to.Ptr(armmediaservices.OnErrorTypeStopProcessingJob),
		// 						Preset: &armmediaservices.VideoAnalyzerPreset{
		// 							ODataType: to.Ptr("#Microsoft.Media.VideoAnalyzerPreset"),
		// 							Mode: to.Ptr(armmediaservices.AudioAnalysisModeStandard),
		// 							InsightsToExtract: to.Ptr(armmediaservices.InsightsTypeAllInsights),
		// 						},
		// 						RelativePriority: to.Ptr(armmediaservices.PriorityNormal),
		// 				}},
		// 			},
		// 			SystemData: &armmediaservices.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-10-17T23:14:31.238Z"); return t}()),
		// 				CreatedBy: to.Ptr("contoso@microsoft.com"),
		// 				CreatedByType: to.Ptr(armmediaservices.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-10-17T23:14:31.238Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("contoso@microsoft.com"),
		// 				LastModifiedByType: to.Ptr(armmediaservices.CreatedByTypeUser),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleEncode"),
		// 			Type: to.Ptr("Microsoft.Media/mediaservices/transforms"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contosoresources/providers/Microsoft.Media/mediaservices/contosomedia/transforms/sampleEncode"),
		// 			Properties: &armmediaservices.TransformProperties{
		// 				Description: to.Ptr("A sample Transform using the Standard Encoder with a built in preset."),
		// 				Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-10-17T23:14:31.238Z"); return t}()),
		// 				LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-10-17T23:14:31.238Z"); return t}()),
		// 				Outputs: []*armmediaservices.TransformOutput{
		// 					{
		// 						OnError: to.Ptr(armmediaservices.OnErrorTypeStopProcessingJob),
		// 						Preset: &armmediaservices.BuiltInStandardEncoderPreset{
		// 							ODataType: to.Ptr("#Microsoft.Media.BuiltInStandardEncoderPreset"),
		// 							PresetName: to.Ptr(armmediaservices.EncoderNamedPresetAdaptiveStreaming),
		// 						},
		// 						RelativePriority: to.Ptr(armmediaservices.PriorityNormal),
		// 				}},
		// 			},
		// 			SystemData: &armmediaservices.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-10-17T23:14:31.238Z"); return t}()),
		// 				CreatedBy: to.Ptr("contoso@microsoft.com"),
		// 				CreatedByType: to.Ptr(armmediaservices.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-10-17T23:14:31.238Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("contoso@microsoft.com"),
		// 				LastModifiedByType: to.Ptr(armmediaservices.CreatedByTypeUser),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Encoding/stable/2022-07-01/examples/transforms-get-by-name.json
func ExampleTransformsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewTransformsClient().Get(ctx, "contosoresources", "contosomedia", "sampleTransform", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Transform = armmediaservices.Transform{
	// 	Name: to.Ptr("sampleTransform"),
	// 	Type: to.Ptr("Microsoft.Media/mediaservices/transforms"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contosoresources/providers/Microsoft.Media/mediaservices/contosomedia/transforms/sampleTransform"),
	// 	Properties: &armmediaservices.TransformProperties{
	// 		Description: to.Ptr("A sample Transform using the Standard Encoder with a built in preset."),
	// 		Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-10-17T23:14:31.628Z"); return t}()),
	// 		LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-10-17T23:14:31.628Z"); return t}()),
	// 		Outputs: []*armmediaservices.TransformOutput{
	// 			{
	// 				OnError: to.Ptr(armmediaservices.OnErrorTypeStopProcessingJob),
	// 				Preset: &armmediaservices.BuiltInStandardEncoderPreset{
	// 					ODataType: to.Ptr("#Microsoft.Media.BuiltInStandardEncoderPreset"),
	// 					PresetName: to.Ptr(armmediaservices.EncoderNamedPresetH264MultipleBitrate1080P),
	// 				},
	// 				RelativePriority: to.Ptr(armmediaservices.PriorityNormal),
	// 		}},
	// 	},
	// 	SystemData: &armmediaservices.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-10-17T23:14:31.628Z"); return t}()),
	// 		CreatedBy: to.Ptr("contoso@microsoft.com"),
	// 		CreatedByType: to.Ptr(armmediaservices.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-10-17T23:14:31.628Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("contoso@microsoft.com"),
	// 		LastModifiedByType: to.Ptr(armmediaservices.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Encoding/stable/2022-07-01/examples/transforms-create.json
func ExampleTransformsClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewTransformsClient().CreateOrUpdate(ctx, "contosoresources", "contosomedia", "createdTransform", armmediaservices.Transform{
		Properties: &armmediaservices.TransformProperties{
			Description: to.Ptr("Example Transform to illustrate create and update."),
			Outputs: []*armmediaservices.TransformOutput{
				{
					Preset: &armmediaservices.BuiltInStandardEncoderPreset{
						ODataType:  to.Ptr("#Microsoft.Media.BuiltInStandardEncoderPreset"),
						PresetName: to.Ptr(armmediaservices.EncoderNamedPresetAdaptiveStreaming),
					},
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Transform = armmediaservices.Transform{
	// 	Name: to.Ptr("createdTransform"),
	// 	Type: to.Ptr("Microsoft.Media/mediaservices/transforms"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contosoresources/providers/Microsoft.Media/mediaservices/contosomedia/transforms/createdTransform"),
	// 	Properties: &armmediaservices.TransformProperties{
	// 		Description: to.Ptr("Example Transform to illustrate create and update."),
	// 		Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-10-17T23:14:31.766Z"); return t}()),
	// 		LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-10-17T23:14:31.766Z"); return t}()),
	// 		Outputs: []*armmediaservices.TransformOutput{
	// 			{
	// 				OnError: to.Ptr(armmediaservices.OnErrorTypeStopProcessingJob),
	// 				Preset: &armmediaservices.BuiltInStandardEncoderPreset{
	// 					ODataType: to.Ptr("#Microsoft.Media.BuiltInStandardEncoderPreset"),
	// 					PresetName: to.Ptr(armmediaservices.EncoderNamedPresetAdaptiveStreaming),
	// 				},
	// 				RelativePriority: to.Ptr(armmediaservices.PriorityNormal),
	// 		}},
	// 	},
	// 	SystemData: &armmediaservices.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-10-17T23:14:31.766Z"); return t}()),
	// 		CreatedBy: to.Ptr("contoso@microsoft.com"),
	// 		CreatedByType: to.Ptr(armmediaservices.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-10-17T23:14:31.766Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("contoso@microsoft.com"),
	// 		LastModifiedByType: to.Ptr(armmediaservices.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Encoding/stable/2022-07-01/examples/transforms-delete.json
func ExampleTransformsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewTransformsClient().Delete(ctx, "contosoresources", "contosomedia", "sampleTransform", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Encoding/stable/2022-07-01/examples/transforms-update.json
func ExampleTransformsClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewTransformsClient().Update(ctx, "contosoresources", "contosomedia", "transformToUpdate", armmediaservices.Transform{
		Properties: &armmediaservices.TransformProperties{
			Description: to.Ptr("Example transform to illustrate update."),
			Outputs: []*armmediaservices.TransformOutput{
				{
					Preset: &armmediaservices.BuiltInStandardEncoderPreset{
						ODataType:  to.Ptr("#Microsoft.Media.BuiltInStandardEncoderPreset"),
						PresetName: to.Ptr(armmediaservices.EncoderNamedPresetH264MultipleBitrate720P),
					},
					RelativePriority: to.Ptr(armmediaservices.PriorityHigh),
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Transform = armmediaservices.Transform{
	// 	Name: to.Ptr("transformToUpdate"),
	// 	Type: to.Ptr("Microsoft.Media/mediaservices/transforms"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contosoresources/providers/Microsoft.Media/mediaservices/contosomedia/transforms/transformToUpdate"),
	// 	Properties: &armmediaservices.TransformProperties{
	// 		Description: to.Ptr("Example transform to illustrate update."),
	// 		Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-10-17T23:14:32.143Z"); return t}()),
	// 		LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-10-17T23:14:32.145Z"); return t}()),
	// 		Outputs: []*armmediaservices.TransformOutput{
	// 			{
	// 				OnError: to.Ptr(armmediaservices.OnErrorTypeStopProcessingJob),
	// 				Preset: &armmediaservices.BuiltInStandardEncoderPreset{
	// 					ODataType: to.Ptr("#Microsoft.Media.BuiltInStandardEncoderPreset"),
	// 					PresetName: to.Ptr(armmediaservices.EncoderNamedPresetH264MultipleBitrate720P),
	// 				},
	// 				RelativePriority: to.Ptr(armmediaservices.PriorityHigh),
	// 		}},
	// 	},
	// 	SystemData: &armmediaservices.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-10-17T23:14:32.143Z"); return t}()),
	// 		CreatedBy: to.Ptr("contoso@microsoft.com"),
	// 		CreatedByType: to.Ptr(armmediaservices.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-10-17T23:14:32.145Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("contoso@microsoft.com"),
	// 		LastModifiedByType: to.Ptr(armmediaservices.CreatedByTypeUser),
	// 	},
	// }
}
