//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/marketplaceordering/armmarketplaceordering"
	"net/http"
	"net/url"
	"regexp"
)

// MarketplaceAgreementsServer is a fake server for instances of the armmarketplaceordering.MarketplaceAgreementsClient type.
type MarketplaceAgreementsServer struct {
	// Cancel is the fake for method MarketplaceAgreementsClient.Cancel
	// HTTP status codes to indicate success: http.StatusOK
	Cancel func(ctx context.Context, publisherID string, offerID string, planID string, options *armmarketplaceordering.MarketplaceAgreementsClientCancelOptions) (resp azfake.Responder[armmarketplaceordering.MarketplaceAgreementsClientCancelResponse], errResp azfake.ErrorResponder)

	// Create is the fake for method MarketplaceAgreementsClient.Create
	// HTTP status codes to indicate success: http.StatusOK
	Create func(ctx context.Context, offerType armmarketplaceordering.OfferType, publisherID string, offerID string, planID string, parameters armmarketplaceordering.AgreementTerms, options *armmarketplaceordering.MarketplaceAgreementsClientCreateOptions) (resp azfake.Responder[armmarketplaceordering.MarketplaceAgreementsClientCreateResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method MarketplaceAgreementsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, offerType armmarketplaceordering.OfferType, publisherID string, offerID string, planID string, options *armmarketplaceordering.MarketplaceAgreementsClientGetOptions) (resp azfake.Responder[armmarketplaceordering.MarketplaceAgreementsClientGetResponse], errResp azfake.ErrorResponder)

	// GetAgreement is the fake for method MarketplaceAgreementsClient.GetAgreement
	// HTTP status codes to indicate success: http.StatusOK
	GetAgreement func(ctx context.Context, publisherID string, offerID string, planID string, options *armmarketplaceordering.MarketplaceAgreementsClientGetAgreementOptions) (resp azfake.Responder[armmarketplaceordering.MarketplaceAgreementsClientGetAgreementResponse], errResp azfake.ErrorResponder)

	// List is the fake for method MarketplaceAgreementsClient.List
	// HTTP status codes to indicate success: http.StatusOK
	List func(ctx context.Context, options *armmarketplaceordering.MarketplaceAgreementsClientListOptions) (resp azfake.Responder[armmarketplaceordering.MarketplaceAgreementsClientListResponse], errResp azfake.ErrorResponder)

	// Sign is the fake for method MarketplaceAgreementsClient.Sign
	// HTTP status codes to indicate success: http.StatusOK
	Sign func(ctx context.Context, publisherID string, offerID string, planID string, options *armmarketplaceordering.MarketplaceAgreementsClientSignOptions) (resp azfake.Responder[armmarketplaceordering.MarketplaceAgreementsClientSignResponse], errResp azfake.ErrorResponder)
}

// NewMarketplaceAgreementsServerTransport creates a new instance of MarketplaceAgreementsServerTransport with the provided implementation.
// The returned MarketplaceAgreementsServerTransport instance is connected to an instance of armmarketplaceordering.MarketplaceAgreementsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewMarketplaceAgreementsServerTransport(srv *MarketplaceAgreementsServer) *MarketplaceAgreementsServerTransport {
	return &MarketplaceAgreementsServerTransport{srv: srv}
}

// MarketplaceAgreementsServerTransport connects instances of armmarketplaceordering.MarketplaceAgreementsClient to instances of MarketplaceAgreementsServer.
// Don't use this type directly, use NewMarketplaceAgreementsServerTransport instead.
type MarketplaceAgreementsServerTransport struct {
	srv *MarketplaceAgreementsServer
}

// Do implements the policy.Transporter interface for MarketplaceAgreementsServerTransport.
func (m *MarketplaceAgreementsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "MarketplaceAgreementsClient.Cancel":
		resp, err = m.dispatchCancel(req)
	case "MarketplaceAgreementsClient.Create":
		resp, err = m.dispatchCreate(req)
	case "MarketplaceAgreementsClient.Get":
		resp, err = m.dispatchGet(req)
	case "MarketplaceAgreementsClient.GetAgreement":
		resp, err = m.dispatchGetAgreement(req)
	case "MarketplaceAgreementsClient.List":
		resp, err = m.dispatchList(req)
	case "MarketplaceAgreementsClient.Sign":
		resp, err = m.dispatchSign(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *MarketplaceAgreementsServerTransport) dispatchCancel(req *http.Request) (*http.Response, error) {
	if m.srv.Cancel == nil {
		return nil, &nonRetriableError{errors.New("fake for method Cancel not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MarketplaceOrdering/agreements/(?P<publisherId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/offers/(?P<offerId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/plans/(?P<planId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cancel`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	publisherIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("publisherId")])
	if err != nil {
		return nil, err
	}
	offerIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("offerId")])
	if err != nil {
		return nil, err
	}
	planIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("planId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Cancel(req.Context(), publisherIDParam, offerIDParam, planIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AgreementTerms, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MarketplaceAgreementsServerTransport) dispatchCreate(req *http.Request) (*http.Response, error) {
	if m.srv.Create == nil {
		return nil, &nonRetriableError{errors.New("fake for method Create not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MarketplaceOrdering/offerTypes/(?P<offerType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/publishers/(?P<publisherId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/offers/(?P<offerId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/plans/(?P<planId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/agreements/current`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armmarketplaceordering.AgreementTerms](req)
	if err != nil {
		return nil, err
	}
	offerTypeParam, err := parseWithCast(matches[regex.SubexpIndex("offerType")], func(v string) (armmarketplaceordering.OfferType, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armmarketplaceordering.OfferType(p), nil
	})
	if err != nil {
		return nil, err
	}
	publisherIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("publisherId")])
	if err != nil {
		return nil, err
	}
	offerIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("offerId")])
	if err != nil {
		return nil, err
	}
	planIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("planId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Create(req.Context(), offerTypeParam, publisherIDParam, offerIDParam, planIDParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AgreementTerms, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MarketplaceAgreementsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if m.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MarketplaceOrdering/offerTypes/(?P<offerType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/publishers/(?P<publisherId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/offers/(?P<offerId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/plans/(?P<planId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/agreements/current`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	offerTypeParam, err := parseWithCast(matches[regex.SubexpIndex("offerType")], func(v string) (armmarketplaceordering.OfferType, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armmarketplaceordering.OfferType(p), nil
	})
	if err != nil {
		return nil, err
	}
	publisherIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("publisherId")])
	if err != nil {
		return nil, err
	}
	offerIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("offerId")])
	if err != nil {
		return nil, err
	}
	planIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("planId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Get(req.Context(), offerTypeParam, publisherIDParam, offerIDParam, planIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AgreementTerms, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MarketplaceAgreementsServerTransport) dispatchGetAgreement(req *http.Request) (*http.Response, error) {
	if m.srv.GetAgreement == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAgreement not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MarketplaceOrdering/agreements/(?P<publisherId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/offers/(?P<offerId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/plans/(?P<planId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	publisherIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("publisherId")])
	if err != nil {
		return nil, err
	}
	offerIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("offerId")])
	if err != nil {
		return nil, err
	}
	planIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("planId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.GetAgreement(req.Context(), publisherIDParam, offerIDParam, planIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AgreementTerms, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MarketplaceAgreementsServerTransport) dispatchList(req *http.Request) (*http.Response, error) {
	if m.srv.List == nil {
		return nil, &nonRetriableError{errors.New("fake for method List not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MarketplaceOrdering/agreements`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	respr, errRespr := m.srv.List(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AgreementTermsArray, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MarketplaceAgreementsServerTransport) dispatchSign(req *http.Request) (*http.Response, error) {
	if m.srv.Sign == nil {
		return nil, &nonRetriableError{errors.New("fake for method Sign not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MarketplaceOrdering/agreements/(?P<publisherId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/offers/(?P<offerId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/plans/(?P<planId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sign`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	publisherIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("publisherId")])
	if err != nil {
		return nil, err
	}
	offerIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("offerId")])
	if err != nil {
		return nil, err
	}
	planIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("planId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Sign(req.Context(), publisherIDParam, offerIDParam, planIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AgreementTerms, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
