//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/managementgroups/armmanagementgroups"
	"net/http"
	"net/url"
	"strconv"
)

// EntitiesServer is a fake server for instances of the armmanagementgroups.EntitiesClient type.
type EntitiesServer struct {
	// NewListPager is the fake for method EntitiesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armmanagementgroups.EntitiesClientListOptions) (resp azfake.PagerResponder[armmanagementgroups.EntitiesClientListResponse])
}

// NewEntitiesServerTransport creates a new instance of EntitiesServerTransport with the provided implementation.
// The returned EntitiesServerTransport instance is connected to an instance of armmanagementgroups.EntitiesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewEntitiesServerTransport(srv *EntitiesServer) *EntitiesServerTransport {
	return &EntitiesServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armmanagementgroups.EntitiesClientListResponse]](),
	}
}

// EntitiesServerTransport connects instances of armmanagementgroups.EntitiesClient to instances of EntitiesServer.
// Don't use this type directly, use NewEntitiesServerTransport instead.
type EntitiesServerTransport struct {
	srv          *EntitiesServer
	newListPager *tracker[azfake.PagerResponder[armmanagementgroups.EntitiesClientListResponse]]
}

// Do implements the policy.Transporter interface for EntitiesServerTransport.
func (e *EntitiesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "EntitiesClient.NewListPager":
		resp, err = e.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (e *EntitiesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := e.newListPager.get(req)
	if newListPager == nil {
		qp := req.URL.Query()
		skiptokenUnescaped, err := url.QueryUnescape(qp.Get("$skiptoken"))
		if err != nil {
			return nil, err
		}
		skiptokenParam := getOptional(skiptokenUnescaped)
		skipUnescaped, err := url.QueryUnescape(qp.Get("$skip"))
		if err != nil {
			return nil, err
		}
		skipParam, err := parseOptional(skipUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		selectUnescaped, err := url.QueryUnescape(qp.Get("$select"))
		if err != nil {
			return nil, err
		}
		selectParam := getOptional(selectUnescaped)
		searchUnescaped, err := url.QueryUnescape(qp.Get("$search"))
		if err != nil {
			return nil, err
		}
		searchParam := getOptional(armmanagementgroups.EntitySearchType(searchUnescaped))
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		viewUnescaped, err := url.QueryUnescape(qp.Get("$view"))
		if err != nil {
			return nil, err
		}
		viewParam := getOptional(armmanagementgroups.EntityViewParameterType(viewUnescaped))
		groupNameUnescaped, err := url.QueryUnescape(qp.Get("groupName"))
		if err != nil {
			return nil, err
		}
		groupNameParam := getOptional(groupNameUnescaped)
		cacheControlParam := getOptional(getHeaderValue(req.Header, "Cache-Control"))
		var options *armmanagementgroups.EntitiesClientListOptions
		if skiptokenParam != nil || skipParam != nil || topParam != nil || selectParam != nil || searchParam != nil || filterParam != nil || viewParam != nil || groupNameParam != nil || cacheControlParam != nil {
			options = &armmanagementgroups.EntitiesClientListOptions{
				Skiptoken:    skiptokenParam,
				Skip:         skipParam,
				Top:          topParam,
				Select:       selectParam,
				Search:       searchParam,
				Filter:       filterParam,
				View:         viewParam,
				GroupName:    groupNameParam,
				CacheControl: cacheControlParam,
			}
		}
		resp := e.srv.NewListPager(options)
		newListPager = &resp
		e.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armmanagementgroups.EntitiesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		e.newListPager.remove(req)
	}
	return resp, nil
}
