//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/logz/armlogz"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// MonitorServer is a fake server for instances of the armlogz.MonitorClient type.
type MonitorServer struct {
	// NewListVMHostUpdatePager is the fake for method MonitorClient.NewListVMHostUpdatePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListVMHostUpdatePager func(resourceGroupName string, monitorName string, options *armlogz.MonitorClientListVMHostUpdateOptions) (resp azfake.PagerResponder[armlogz.MonitorClientListVMHostUpdateResponse])

	// NewListVMHostsPager is the fake for method MonitorClient.NewListVMHostsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListVMHostsPager func(resourceGroupName string, monitorName string, options *armlogz.MonitorClientListVMHostsOptions) (resp azfake.PagerResponder[armlogz.MonitorClientListVMHostsResponse])

	// VMHostPayload is the fake for method MonitorClient.VMHostPayload
	// HTTP status codes to indicate success: http.StatusOK
	VMHostPayload func(ctx context.Context, resourceGroupName string, monitorName string, options *armlogz.MonitorClientVMHostPayloadOptions) (resp azfake.Responder[armlogz.MonitorClientVMHostPayloadResponse], errResp azfake.ErrorResponder)
}

// NewMonitorServerTransport creates a new instance of MonitorServerTransport with the provided implementation.
// The returned MonitorServerTransport instance is connected to an instance of armlogz.MonitorClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewMonitorServerTransport(srv *MonitorServer) *MonitorServerTransport {
	return &MonitorServerTransport{
		srv:                      srv,
		newListVMHostUpdatePager: newTracker[azfake.PagerResponder[armlogz.MonitorClientListVMHostUpdateResponse]](),
		newListVMHostsPager:      newTracker[azfake.PagerResponder[armlogz.MonitorClientListVMHostsResponse]](),
	}
}

// MonitorServerTransport connects instances of armlogz.MonitorClient to instances of MonitorServer.
// Don't use this type directly, use NewMonitorServerTransport instead.
type MonitorServerTransport struct {
	srv                      *MonitorServer
	newListVMHostUpdatePager *tracker[azfake.PagerResponder[armlogz.MonitorClientListVMHostUpdateResponse]]
	newListVMHostsPager      *tracker[azfake.PagerResponder[armlogz.MonitorClientListVMHostsResponse]]
}

// Do implements the policy.Transporter interface for MonitorServerTransport.
func (m *MonitorServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "MonitorClient.NewListVMHostUpdatePager":
		resp, err = m.dispatchNewListVMHostUpdatePager(req)
	case "MonitorClient.NewListVMHostsPager":
		resp, err = m.dispatchNewListVMHostsPager(req)
	case "MonitorClient.VMHostPayload":
		resp, err = m.dispatchVMHostPayload(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *MonitorServerTransport) dispatchNewListVMHostUpdatePager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListVMHostUpdatePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListVMHostUpdatePager not implemented")}
	}
	newListVMHostUpdatePager := m.newListVMHostUpdatePager.get(req)
	if newListVMHostUpdatePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Logz/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/vmHostUpdate`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armlogz.VMHostUpdateRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
		if err != nil {
			return nil, err
		}
		var options *armlogz.MonitorClientListVMHostUpdateOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armlogz.MonitorClientListVMHostUpdateOptions{
				Body: &body,
			}
		}
		resp := m.srv.NewListVMHostUpdatePager(resourceGroupNameParam, monitorNameParam, options)
		newListVMHostUpdatePager = &resp
		m.newListVMHostUpdatePager.add(req, newListVMHostUpdatePager)
		server.PagerResponderInjectNextLinks(newListVMHostUpdatePager, req, func(page *armlogz.MonitorClientListVMHostUpdateResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListVMHostUpdatePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListVMHostUpdatePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListVMHostUpdatePager) {
		m.newListVMHostUpdatePager.remove(req)
	}
	return resp, nil
}

func (m *MonitorServerTransport) dispatchNewListVMHostsPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListVMHostsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListVMHostsPager not implemented")}
	}
	newListVMHostsPager := m.newListVMHostsPager.get(req)
	if newListVMHostsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Logz/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listVMHosts`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListVMHostsPager(resourceGroupNameParam, monitorNameParam, nil)
		newListVMHostsPager = &resp
		m.newListVMHostsPager.add(req, newListVMHostsPager)
		server.PagerResponderInjectNextLinks(newListVMHostsPager, req, func(page *armlogz.MonitorClientListVMHostsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListVMHostsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListVMHostsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListVMHostsPager) {
		m.newListVMHostsPager.remove(req)
	}
	return resp, nil
}

func (m *MonitorServerTransport) dispatchVMHostPayload(req *http.Request) (*http.Response, error) {
	if m.srv.VMHostPayload == nil {
		return nil, &nonRetriableError{errors.New("fake for method VMHostPayload not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Logz/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/vmHostPayload`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.VMHostPayload(req.Context(), resourceGroupNameParam, monitorNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VMExtensionPayload, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
