//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/logic/armlogic"
	"net/http"
	"net/url"
	"regexp"
)

// IntegrationServiceEnvironmentManagedAPIOperationsServer is a fake server for instances of the armlogic.IntegrationServiceEnvironmentManagedAPIOperationsClient type.
type IntegrationServiceEnvironmentManagedAPIOperationsServer struct {
	// NewListPager is the fake for method IntegrationServiceEnvironmentManagedAPIOperationsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroup string, integrationServiceEnvironmentName string, apiName string, options *armlogic.IntegrationServiceEnvironmentManagedAPIOperationsClientListOptions) (resp azfake.PagerResponder[armlogic.IntegrationServiceEnvironmentManagedAPIOperationsClientListResponse])
}

// NewIntegrationServiceEnvironmentManagedAPIOperationsServerTransport creates a new instance of IntegrationServiceEnvironmentManagedAPIOperationsServerTransport with the provided implementation.
// The returned IntegrationServiceEnvironmentManagedAPIOperationsServerTransport instance is connected to an instance of armlogic.IntegrationServiceEnvironmentManagedAPIOperationsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewIntegrationServiceEnvironmentManagedAPIOperationsServerTransport(srv *IntegrationServiceEnvironmentManagedAPIOperationsServer) *IntegrationServiceEnvironmentManagedAPIOperationsServerTransport {
	return &IntegrationServiceEnvironmentManagedAPIOperationsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armlogic.IntegrationServiceEnvironmentManagedAPIOperationsClientListResponse]](),
	}
}

// IntegrationServiceEnvironmentManagedAPIOperationsServerTransport connects instances of armlogic.IntegrationServiceEnvironmentManagedAPIOperationsClient to instances of IntegrationServiceEnvironmentManagedAPIOperationsServer.
// Don't use this type directly, use NewIntegrationServiceEnvironmentManagedAPIOperationsServerTransport instead.
type IntegrationServiceEnvironmentManagedAPIOperationsServerTransport struct {
	srv          *IntegrationServiceEnvironmentManagedAPIOperationsServer
	newListPager *tracker[azfake.PagerResponder[armlogic.IntegrationServiceEnvironmentManagedAPIOperationsClientListResponse]]
}

// Do implements the policy.Transporter interface for IntegrationServiceEnvironmentManagedAPIOperationsServerTransport.
func (i *IntegrationServiceEnvironmentManagedAPIOperationsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "IntegrationServiceEnvironmentManagedAPIOperationsClient.NewListPager":
		resp, err = i.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (i *IntegrationServiceEnvironmentManagedAPIOperationsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if i.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := i.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroup>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Logic/integrationServiceEnvironments/(?P<integrationServiceEnvironmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/managedApis/(?P<apiName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/apiOperations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroup")])
		if err != nil {
			return nil, err
		}
		integrationServiceEnvironmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("integrationServiceEnvironmentName")])
		if err != nil {
			return nil, err
		}
		apiNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("apiName")])
		if err != nil {
			return nil, err
		}
		resp := i.srv.NewListPager(resourceGroupParam, integrationServiceEnvironmentNameParam, apiNameParam, nil)
		newListPager = &resp
		i.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armlogic.IntegrationServiceEnvironmentManagedAPIOperationsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		i.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		i.newListPager.remove(req)
	}
	return resp, nil
}
