//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/labservices/armlabservices"
	"net/http"
	"net/url"
	"regexp"
)

// ImagesServer is a fake server for instances of the armlabservices.ImagesClient type.
type ImagesServer struct {
	// CreateOrUpdate is the fake for method ImagesClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, labPlanName string, imageName string, body armlabservices.Image, options *armlabservices.ImagesClientCreateOrUpdateOptions) (resp azfake.Responder[armlabservices.ImagesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ImagesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, labPlanName string, imageName string, options *armlabservices.ImagesClientGetOptions) (resp azfake.Responder[armlabservices.ImagesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByLabPlanPager is the fake for method ImagesClient.NewListByLabPlanPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByLabPlanPager func(resourceGroupName string, labPlanName string, options *armlabservices.ImagesClientListByLabPlanOptions) (resp azfake.PagerResponder[armlabservices.ImagesClientListByLabPlanResponse])

	// Update is the fake for method ImagesClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, labPlanName string, imageName string, body armlabservices.ImageUpdate, options *armlabservices.ImagesClientUpdateOptions) (resp azfake.Responder[armlabservices.ImagesClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewImagesServerTransport creates a new instance of ImagesServerTransport with the provided implementation.
// The returned ImagesServerTransport instance is connected to an instance of armlabservices.ImagesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewImagesServerTransport(srv *ImagesServer) *ImagesServerTransport {
	return &ImagesServerTransport{
		srv:                   srv,
		newListByLabPlanPager: newTracker[azfake.PagerResponder[armlabservices.ImagesClientListByLabPlanResponse]](),
	}
}

// ImagesServerTransport connects instances of armlabservices.ImagesClient to instances of ImagesServer.
// Don't use this type directly, use NewImagesServerTransport instead.
type ImagesServerTransport struct {
	srv                   *ImagesServer
	newListByLabPlanPager *tracker[azfake.PagerResponder[armlabservices.ImagesClientListByLabPlanResponse]]
}

// Do implements the policy.Transporter interface for ImagesServerTransport.
func (i *ImagesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ImagesClient.CreateOrUpdate":
		resp, err = i.dispatchCreateOrUpdate(req)
	case "ImagesClient.Get":
		resp, err = i.dispatchGet(req)
	case "ImagesClient.NewListByLabPlanPager":
		resp, err = i.dispatchNewListByLabPlanPager(req)
	case "ImagesClient.Update":
		resp, err = i.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (i *ImagesServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if i.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.LabServices/labPlans/(?P<labPlanName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/images/(?P<imageName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armlabservices.Image](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	labPlanNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("labPlanName")])
	if err != nil {
		return nil, err
	}
	imageNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("imageName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, labPlanNameParam, imageNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Image, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *ImagesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if i.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.LabServices/labPlans/(?P<labPlanName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/images/(?P<imageName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	labPlanNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("labPlanName")])
	if err != nil {
		return nil, err
	}
	imageNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("imageName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.Get(req.Context(), resourceGroupNameParam, labPlanNameParam, imageNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Image, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *ImagesServerTransport) dispatchNewListByLabPlanPager(req *http.Request) (*http.Response, error) {
	if i.srv.NewListByLabPlanPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByLabPlanPager not implemented")}
	}
	newListByLabPlanPager := i.newListByLabPlanPager.get(req)
	if newListByLabPlanPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.LabServices/labPlans/(?P<labPlanName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/images`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		labPlanNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("labPlanName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armlabservices.ImagesClientListByLabPlanOptions
		if filterParam != nil {
			options = &armlabservices.ImagesClientListByLabPlanOptions{
				Filter: filterParam,
			}
		}
		resp := i.srv.NewListByLabPlanPager(resourceGroupNameParam, labPlanNameParam, options)
		newListByLabPlanPager = &resp
		i.newListByLabPlanPager.add(req, newListByLabPlanPager)
		server.PagerResponderInjectNextLinks(newListByLabPlanPager, req, func(page *armlabservices.ImagesClientListByLabPlanResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByLabPlanPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		i.newListByLabPlanPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByLabPlanPager) {
		i.newListByLabPlanPager.remove(req)
	}
	return resp, nil
}

func (i *ImagesServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if i.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.LabServices/labPlans/(?P<labPlanName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/images/(?P<imageName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armlabservices.ImageUpdate](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	labPlanNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("labPlanName")])
	if err != nil {
		return nil, err
	}
	imageNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("imageName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.Update(req.Context(), resourceGroupNameParam, labPlanNameParam, imageNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Image, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
