//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armkubernetesconfiguration.ClientFactory type.
type ServerFactory struct {
	ExtensionsServer                  ExtensionsServer
	FluxConfigOperationStatusServer   FluxConfigOperationStatusServer
	FluxConfigurationsServer          FluxConfigurationsServer
	OperationStatusServer             OperationStatusServer
	OperationsServer                  OperationsServer
	SourceControlConfigurationsServer SourceControlConfigurationsServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armkubernetesconfiguration.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armkubernetesconfiguration.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                                 *ServerFactory
	trMu                                sync.Mutex
	trExtensionsServer                  *ExtensionsServerTransport
	trFluxConfigOperationStatusServer   *FluxConfigOperationStatusServerTransport
	trFluxConfigurationsServer          *FluxConfigurationsServerTransport
	trOperationStatusServer             *OperationStatusServerTransport
	trOperationsServer                  *OperationsServerTransport
	trSourceControlConfigurationsServer *SourceControlConfigurationsServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "ExtensionsClient":
		initServer(s, &s.trExtensionsServer, func() *ExtensionsServerTransport { return NewExtensionsServerTransport(&s.srv.ExtensionsServer) })
		resp, err = s.trExtensionsServer.Do(req)
	case "FluxConfigOperationStatusClient":
		initServer(s, &s.trFluxConfigOperationStatusServer, func() *FluxConfigOperationStatusServerTransport {
			return NewFluxConfigOperationStatusServerTransport(&s.srv.FluxConfigOperationStatusServer)
		})
		resp, err = s.trFluxConfigOperationStatusServer.Do(req)
	case "FluxConfigurationsClient":
		initServer(s, &s.trFluxConfigurationsServer, func() *FluxConfigurationsServerTransport {
			return NewFluxConfigurationsServerTransport(&s.srv.FluxConfigurationsServer)
		})
		resp, err = s.trFluxConfigurationsServer.Do(req)
	case "OperationStatusClient":
		initServer(s, &s.trOperationStatusServer, func() *OperationStatusServerTransport {
			return NewOperationStatusServerTransport(&s.srv.OperationStatusServer)
		})
		resp, err = s.trOperationStatusServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "SourceControlConfigurationsClient":
		initServer(s, &s.trSourceControlConfigurationsServer, func() *SourceControlConfigurationsServerTransport {
			return NewSourceControlConfigurationsServerTransport(&s.srv.SourceControlConfigurationsServer)
		})
		resp, err = s.trSourceControlConfigurationsServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
