//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armkeyvault

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - Subscription credentials which uniquely identify Microsoft Azure subscription. The subscription ID forms
//     part of the URI for every service call.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewKeysClient creates a new instance of KeysClient.
func (c *ClientFactory) NewKeysClient() *KeysClient {
	subClient, _ := NewKeysClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewMHSMPrivateEndpointConnectionsClient creates a new instance of MHSMPrivateEndpointConnectionsClient.
func (c *ClientFactory) NewMHSMPrivateEndpointConnectionsClient() *MHSMPrivateEndpointConnectionsClient {
	subClient, _ := NewMHSMPrivateEndpointConnectionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewMHSMPrivateLinkResourcesClient creates a new instance of MHSMPrivateLinkResourcesClient.
func (c *ClientFactory) NewMHSMPrivateLinkResourcesClient() *MHSMPrivateLinkResourcesClient {
	subClient, _ := NewMHSMPrivateLinkResourcesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewMHSMRegionsClient creates a new instance of MHSMRegionsClient.
func (c *ClientFactory) NewMHSMRegionsClient() *MHSMRegionsClient {
	subClient, _ := NewMHSMRegionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedHsmKeysClient creates a new instance of ManagedHsmKeysClient.
func (c *ClientFactory) NewManagedHsmKeysClient() *ManagedHsmKeysClient {
	subClient, _ := NewManagedHsmKeysClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedHsmsClient creates a new instance of ManagedHsmsClient.
func (c *ClientFactory) NewManagedHsmsClient() *ManagedHsmsClient {
	subClient, _ := NewManagedHsmsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewPrivateEndpointConnectionsClient creates a new instance of PrivateEndpointConnectionsClient.
func (c *ClientFactory) NewPrivateEndpointConnectionsClient() *PrivateEndpointConnectionsClient {
	subClient, _ := NewPrivateEndpointConnectionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateLinkResourcesClient creates a new instance of PrivateLinkResourcesClient.
func (c *ClientFactory) NewPrivateLinkResourcesClient() *PrivateLinkResourcesClient {
	subClient, _ := NewPrivateLinkResourcesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSecretsClient creates a new instance of SecretsClient.
func (c *ClientFactory) NewSecretsClient() *SecretsClient {
	subClient, _ := NewSecretsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVaultsClient creates a new instance of VaultsClient.
func (c *ClientFactory) NewVaultsClient() *VaultsClient {
	subClient, _ := NewVaultsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
