//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armeducation

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// JoinRequestsClient contains the methods for the JoinRequests group.
// Don't use this type directly, use NewJoinRequestsClient() instead.
type JoinRequestsClient struct {
	internal *arm.Client
}

// NewJoinRequestsClient creates a new instance of JoinRequestsClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewJoinRequestsClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*JoinRequestsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &JoinRequestsClient{
		internal: cl,
	}
	return client, nil
}

// Approve - Approve student joining the redeemable lab
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-12-01-preview
//   - billingAccountName - Billing account name.
//   - billingProfileName - Billing profile name.
//   - invoiceSectionName - Invoice section name.
//   - joinRequestName - Join name
//   - options - JoinRequestsClientApproveOptions contains the optional parameters for the JoinRequestsClient.Approve method.
func (client *JoinRequestsClient) Approve(ctx context.Context, billingAccountName string, billingProfileName string, invoiceSectionName string, joinRequestName string, options *JoinRequestsClientApproveOptions) (JoinRequestsClientApproveResponse, error) {
	var err error
	const operationName = "JoinRequestsClient.Approve"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.approveCreateRequest(ctx, billingAccountName, billingProfileName, invoiceSectionName, joinRequestName, options)
	if err != nil {
		return JoinRequestsClientApproveResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return JoinRequestsClientApproveResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return JoinRequestsClientApproveResponse{}, err
	}
	return JoinRequestsClientApproveResponse{}, nil
}

// approveCreateRequest creates the Approve request.
func (client *JoinRequestsClient) approveCreateRequest(ctx context.Context, billingAccountName string, billingProfileName string, invoiceSectionName string, joinRequestName string, options *JoinRequestsClientApproveOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}/providers/Microsoft.Education/labs/default/joinRequests/{joinRequestName}/approve"
	if billingAccountName == "" {
		return nil, errors.New("parameter billingAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingAccountName}", url.PathEscape(billingAccountName))
	if billingProfileName == "" {
		return nil, errors.New("parameter billingProfileName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingProfileName}", url.PathEscape(billingProfileName))
	if invoiceSectionName == "" {
		return nil, errors.New("parameter invoiceSectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{invoiceSectionName}", url.PathEscape(invoiceSectionName))
	if joinRequestName == "" {
		return nil, errors.New("parameter joinRequestName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{joinRequestName}", url.PathEscape(joinRequestName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Deny - Deny student joining the redeemable lab
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-12-01-preview
//   - billingAccountName - Billing account name.
//   - billingProfileName - Billing profile name.
//   - invoiceSectionName - Invoice section name.
//   - joinRequestName - Join name
//   - options - JoinRequestsClientDenyOptions contains the optional parameters for the JoinRequestsClient.Deny method.
func (client *JoinRequestsClient) Deny(ctx context.Context, billingAccountName string, billingProfileName string, invoiceSectionName string, joinRequestName string, options *JoinRequestsClientDenyOptions) (JoinRequestsClientDenyResponse, error) {
	var err error
	const operationName = "JoinRequestsClient.Deny"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.denyCreateRequest(ctx, billingAccountName, billingProfileName, invoiceSectionName, joinRequestName, options)
	if err != nil {
		return JoinRequestsClientDenyResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return JoinRequestsClientDenyResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return JoinRequestsClientDenyResponse{}, err
	}
	return JoinRequestsClientDenyResponse{}, nil
}

// denyCreateRequest creates the Deny request.
func (client *JoinRequestsClient) denyCreateRequest(ctx context.Context, billingAccountName string, billingProfileName string, invoiceSectionName string, joinRequestName string, options *JoinRequestsClientDenyOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}/providers/Microsoft.Education/labs/default/joinRequests/{joinRequestName}/deny"
	if billingAccountName == "" {
		return nil, errors.New("parameter billingAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingAccountName}", url.PathEscape(billingAccountName))
	if billingProfileName == "" {
		return nil, errors.New("parameter billingProfileName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingProfileName}", url.PathEscape(billingProfileName))
	if invoiceSectionName == "" {
		return nil, errors.New("parameter invoiceSectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{invoiceSectionName}", url.PathEscape(invoiceSectionName))
	if joinRequestName == "" {
		return nil, errors.New("parameter joinRequestName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{joinRequestName}", url.PathEscape(joinRequestName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - get student join requests
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-12-01-preview
//   - billingAccountName - Billing account name.
//   - billingProfileName - Billing profile name.
//   - invoiceSectionName - Invoice section name.
//   - joinRequestName - Join name
//   - options - JoinRequestsClientGetOptions contains the optional parameters for the JoinRequestsClient.Get method.
func (client *JoinRequestsClient) Get(ctx context.Context, billingAccountName string, billingProfileName string, invoiceSectionName string, joinRequestName string, options *JoinRequestsClientGetOptions) (JoinRequestsClientGetResponse, error) {
	var err error
	const operationName = "JoinRequestsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, billingAccountName, billingProfileName, invoiceSectionName, joinRequestName, options)
	if err != nil {
		return JoinRequestsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return JoinRequestsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return JoinRequestsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *JoinRequestsClient) getCreateRequest(ctx context.Context, billingAccountName string, billingProfileName string, invoiceSectionName string, joinRequestName string, options *JoinRequestsClientGetOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}/providers/Microsoft.Education/labs/default/joinRequests/{joinRequestName}"
	if billingAccountName == "" {
		return nil, errors.New("parameter billingAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingAccountName}", url.PathEscape(billingAccountName))
	if billingProfileName == "" {
		return nil, errors.New("parameter billingProfileName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingProfileName}", url.PathEscape(billingProfileName))
	if invoiceSectionName == "" {
		return nil, errors.New("parameter invoiceSectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{invoiceSectionName}", url.PathEscape(invoiceSectionName))
	if joinRequestName == "" {
		return nil, errors.New("parameter joinRequestName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{joinRequestName}", url.PathEscape(joinRequestName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *JoinRequestsClient) getHandleResponse(resp *http.Response) (JoinRequestsClientGetResponse, error) {
	result := JoinRequestsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.JoinRequestDetails); err != nil {
		return JoinRequestsClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - get student join requests
//
// Generated from API version 2021-12-01-preview
//   - billingAccountName - Billing account name.
//   - billingProfileName - Billing profile name.
//   - invoiceSectionName - Invoice section name.
//   - options - JoinRequestsClientListOptions contains the optional parameters for the JoinRequestsClient.NewListPager method.
func (client *JoinRequestsClient) NewListPager(billingAccountName string, billingProfileName string, invoiceSectionName string, options *JoinRequestsClientListOptions) *runtime.Pager[JoinRequestsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[JoinRequestsClientListResponse]{
		More: func(page JoinRequestsClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *JoinRequestsClientListResponse) (JoinRequestsClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "JoinRequestsClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, billingAccountName, billingProfileName, invoiceSectionName, options)
			}, nil)
			if err != nil {
				return JoinRequestsClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *JoinRequestsClient) listCreateRequest(ctx context.Context, billingAccountName string, billingProfileName string, invoiceSectionName string, options *JoinRequestsClientListOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}/providers/Microsoft.Education/labs/default/joinRequests"
	if billingAccountName == "" {
		return nil, errors.New("parameter billingAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingAccountName}", url.PathEscape(billingAccountName))
	if billingProfileName == "" {
		return nil, errors.New("parameter billingProfileName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingProfileName}", url.PathEscape(billingProfileName))
	if invoiceSectionName == "" {
		return nil, errors.New("parameter invoiceSectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{invoiceSectionName}", url.PathEscape(invoiceSectionName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.IncludeDenied != nil {
		reqQP.Set("includeDenied", strconv.FormatBool(*options.IncludeDenied))
	}
	reqQP.Set("api-version", "2021-12-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *JoinRequestsClient) listHandleResponse(resp *http.Response) (JoinRequestsClientListResponse, error) {
	result := JoinRequestsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.JoinRequestList); err != nil {
		return JoinRequestsClientListResponse{}, err
	}
	return result, nil
}
