//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/datashare/armdatashare"
	"net/http"
	"net/url"
	"regexp"
)

// DataSetsServer is a fake server for instances of the armdatashare.DataSetsClient type.
type DataSetsServer struct {
	// Create is the fake for method DataSetsClient.Create
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	Create func(ctx context.Context, resourceGroupName string, accountName string, shareName string, dataSetName string, dataSet armdatashare.DataSetClassification, options *armdatashare.DataSetsClientCreateOptions) (resp azfake.Responder[armdatashare.DataSetsClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method DataSetsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, accountName string, shareName string, dataSetName string, options *armdatashare.DataSetsClientBeginDeleteOptions) (resp azfake.PollerResponder[armdatashare.DataSetsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method DataSetsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, accountName string, shareName string, dataSetName string, options *armdatashare.DataSetsClientGetOptions) (resp azfake.Responder[armdatashare.DataSetsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListBySharePager is the fake for method DataSetsClient.NewListBySharePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySharePager func(resourceGroupName string, accountName string, shareName string, options *armdatashare.DataSetsClientListByShareOptions) (resp azfake.PagerResponder[armdatashare.DataSetsClientListByShareResponse])
}

// NewDataSetsServerTransport creates a new instance of DataSetsServerTransport with the provided implementation.
// The returned DataSetsServerTransport instance is connected to an instance of armdatashare.DataSetsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDataSetsServerTransport(srv *DataSetsServer) *DataSetsServerTransport {
	return &DataSetsServerTransport{
		srv:                 srv,
		beginDelete:         newTracker[azfake.PollerResponder[armdatashare.DataSetsClientDeleteResponse]](),
		newListBySharePager: newTracker[azfake.PagerResponder[armdatashare.DataSetsClientListByShareResponse]](),
	}
}

// DataSetsServerTransport connects instances of armdatashare.DataSetsClient to instances of DataSetsServer.
// Don't use this type directly, use NewDataSetsServerTransport instead.
type DataSetsServerTransport struct {
	srv                 *DataSetsServer
	beginDelete         *tracker[azfake.PollerResponder[armdatashare.DataSetsClientDeleteResponse]]
	newListBySharePager *tracker[azfake.PagerResponder[armdatashare.DataSetsClientListByShareResponse]]
}

// Do implements the policy.Transporter interface for DataSetsServerTransport.
func (d *DataSetsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DataSetsClient.Create":
		resp, err = d.dispatchCreate(req)
	case "DataSetsClient.BeginDelete":
		resp, err = d.dispatchBeginDelete(req)
	case "DataSetsClient.Get":
		resp, err = d.dispatchGet(req)
	case "DataSetsClient.NewListBySharePager":
		resp, err = d.dispatchNewListBySharePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DataSetsServerTransport) dispatchCreate(req *http.Request) (*http.Response, error) {
	if d.srv.Create == nil {
		return nil, &nonRetriableError{errors.New("fake for method Create not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataShare/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/shares/(?P<shareName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataSets/(?P<dataSetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	raw, err := readRequestBody(req)
	if err != nil {
		return nil, err
	}
	body, err := unmarshalDataSetClassification(raw)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	shareNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("shareName")])
	if err != nil {
		return nil, err
	}
	dataSetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataSetName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Create(req.Context(), resourceGroupNameParam, accountNameParam, shareNameParam, dataSetNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DataSetClassification, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DataSetsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if d.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := d.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataShare/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/shares/(?P<shareName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataSets/(?P<dataSetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		shareNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("shareName")])
		if err != nil {
			return nil, err
		}
		dataSetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataSetName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginDelete(req.Context(), resourceGroupNameParam, accountNameParam, shareNameParam, dataSetNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		d.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		d.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		d.beginDelete.remove(req)
	}

	return resp, nil
}

func (d *DataSetsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if d.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataShare/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/shares/(?P<shareName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataSets/(?P<dataSetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	shareNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("shareName")])
	if err != nil {
		return nil, err
	}
	dataSetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataSetName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Get(req.Context(), resourceGroupNameParam, accountNameParam, shareNameParam, dataSetNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DataSetClassification, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DataSetsServerTransport) dispatchNewListBySharePager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListBySharePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySharePager not implemented")}
	}
	newListBySharePager := d.newListBySharePager.get(req)
	if newListBySharePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataShare/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/shares/(?P<shareName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataSets`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		shareNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("shareName")])
		if err != nil {
			return nil, err
		}
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skipToken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		orderbyUnescaped, err := url.QueryUnescape(qp.Get("$orderby"))
		if err != nil {
			return nil, err
		}
		orderbyParam := getOptional(orderbyUnescaped)
		var options *armdatashare.DataSetsClientListByShareOptions
		if skipTokenParam != nil || filterParam != nil || orderbyParam != nil {
			options = &armdatashare.DataSetsClientListByShareOptions{
				SkipToken: skipTokenParam,
				Filter:    filterParam,
				Orderby:   orderbyParam,
			}
		}
		resp := d.srv.NewListBySharePager(resourceGroupNameParam, accountNameParam, shareNameParam, options)
		newListBySharePager = &resp
		d.newListBySharePager.add(req, newListBySharePager)
		server.PagerResponderInjectNextLinks(newListBySharePager, req, func(page *armdatashare.DataSetsClientListByShareResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySharePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListBySharePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySharePager) {
		d.newListBySharePager.remove(req)
	}
	return resp, nil
}
