//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/dataprotection/armdataprotection/v3"
	"net/http"
	"net/url"
	"regexp"
)

// BackupInstancesServer is a fake server for instances of the armdataprotection.BackupInstancesClient type.
type BackupInstancesServer struct {
	// BeginAdhocBackup is the fake for method BackupInstancesClient.BeginAdhocBackup
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginAdhocBackup func(ctx context.Context, resourceGroupName string, vaultName string, backupInstanceName string, parameters armdataprotection.TriggerBackupRequest, options *armdataprotection.BackupInstancesClientBeginAdhocBackupOptions) (resp azfake.PollerResponder[armdataprotection.BackupInstancesClientAdhocBackupResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdate is the fake for method BackupInstancesClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated, http.StatusAccepted
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, vaultName string, backupInstanceName string, parameters armdataprotection.BackupInstanceResource, options *armdataprotection.BackupInstancesClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armdataprotection.BackupInstancesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method BackupInstancesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, vaultName string, backupInstanceName string, options *armdataprotection.BackupInstancesClientBeginDeleteOptions) (resp azfake.PollerResponder[armdataprotection.BackupInstancesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method BackupInstancesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, vaultName string, backupInstanceName string, options *armdataprotection.BackupInstancesClientGetOptions) (resp azfake.Responder[armdataprotection.BackupInstancesClientGetResponse], errResp azfake.ErrorResponder)

	// GetBackupInstanceOperationResult is the fake for method BackupInstancesClient.GetBackupInstanceOperationResult
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	GetBackupInstanceOperationResult func(ctx context.Context, resourceGroupName string, vaultName string, backupInstanceName string, operationID string, options *armdataprotection.BackupInstancesClientGetBackupInstanceOperationResultOptions) (resp azfake.Responder[armdataprotection.BackupInstancesClientGetBackupInstanceOperationResultResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method BackupInstancesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, vaultName string, options *armdataprotection.BackupInstancesClientListOptions) (resp azfake.PagerResponder[armdataprotection.BackupInstancesClientListResponse])

	// BeginResumeBackups is the fake for method BackupInstancesClient.BeginResumeBackups
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginResumeBackups func(ctx context.Context, resourceGroupName string, vaultName string, backupInstanceName string, options *armdataprotection.BackupInstancesClientBeginResumeBackupsOptions) (resp azfake.PollerResponder[armdataprotection.BackupInstancesClientResumeBackupsResponse], errResp azfake.ErrorResponder)

	// BeginResumeProtection is the fake for method BackupInstancesClient.BeginResumeProtection
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginResumeProtection func(ctx context.Context, resourceGroupName string, vaultName string, backupInstanceName string, options *armdataprotection.BackupInstancesClientBeginResumeProtectionOptions) (resp azfake.PollerResponder[armdataprotection.BackupInstancesClientResumeProtectionResponse], errResp azfake.ErrorResponder)

	// BeginStopProtection is the fake for method BackupInstancesClient.BeginStopProtection
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginStopProtection func(ctx context.Context, resourceGroupName string, vaultName string, backupInstanceName string, options *armdataprotection.BackupInstancesClientBeginStopProtectionOptions) (resp azfake.PollerResponder[armdataprotection.BackupInstancesClientStopProtectionResponse], errResp azfake.ErrorResponder)

	// BeginSuspendBackups is the fake for method BackupInstancesClient.BeginSuspendBackups
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginSuspendBackups func(ctx context.Context, resourceGroupName string, vaultName string, backupInstanceName string, options *armdataprotection.BackupInstancesClientBeginSuspendBackupsOptions) (resp azfake.PollerResponder[armdataprotection.BackupInstancesClientSuspendBackupsResponse], errResp azfake.ErrorResponder)

	// BeginSyncBackupInstance is the fake for method BackupInstancesClient.BeginSyncBackupInstance
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginSyncBackupInstance func(ctx context.Context, resourceGroupName string, vaultName string, backupInstanceName string, parameters armdataprotection.SyncBackupInstanceRequest, options *armdataprotection.BackupInstancesClientBeginSyncBackupInstanceOptions) (resp azfake.PollerResponder[armdataprotection.BackupInstancesClientSyncBackupInstanceResponse], errResp azfake.ErrorResponder)

	// BeginTriggerCrossRegionRestore is the fake for method BackupInstancesClient.BeginTriggerCrossRegionRestore
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginTriggerCrossRegionRestore func(ctx context.Context, resourceGroupName string, location string, parameters armdataprotection.CrossRegionRestoreRequestObject, options *armdataprotection.BackupInstancesClientBeginTriggerCrossRegionRestoreOptions) (resp azfake.PollerResponder[armdataprotection.BackupInstancesClientTriggerCrossRegionRestoreResponse], errResp azfake.ErrorResponder)

	// BeginTriggerRehydrate is the fake for method BackupInstancesClient.BeginTriggerRehydrate
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginTriggerRehydrate func(ctx context.Context, resourceGroupName string, vaultName string, backupInstanceName string, parameters armdataprotection.AzureBackupRehydrationRequest, options *armdataprotection.BackupInstancesClientBeginTriggerRehydrateOptions) (resp azfake.PollerResponder[armdataprotection.BackupInstancesClientTriggerRehydrateResponse], errResp azfake.ErrorResponder)

	// BeginTriggerRestore is the fake for method BackupInstancesClient.BeginTriggerRestore
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginTriggerRestore func(ctx context.Context, resourceGroupName string, vaultName string, backupInstanceName string, parameters armdataprotection.AzureBackupRestoreRequestClassification, options *armdataprotection.BackupInstancesClientBeginTriggerRestoreOptions) (resp azfake.PollerResponder[armdataprotection.BackupInstancesClientTriggerRestoreResponse], errResp azfake.ErrorResponder)

	// BeginValidateCrossRegionRestore is the fake for method BackupInstancesClient.BeginValidateCrossRegionRestore
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginValidateCrossRegionRestore func(ctx context.Context, resourceGroupName string, location string, parameters armdataprotection.ValidateCrossRegionRestoreRequestObject, options *armdataprotection.BackupInstancesClientBeginValidateCrossRegionRestoreOptions) (resp azfake.PollerResponder[armdataprotection.BackupInstancesClientValidateCrossRegionRestoreResponse], errResp azfake.ErrorResponder)

	// BeginValidateForBackup is the fake for method BackupInstancesClient.BeginValidateForBackup
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginValidateForBackup func(ctx context.Context, resourceGroupName string, vaultName string, parameters armdataprotection.ValidateForBackupRequest, options *armdataprotection.BackupInstancesClientBeginValidateForBackupOptions) (resp azfake.PollerResponder[armdataprotection.BackupInstancesClientValidateForBackupResponse], errResp azfake.ErrorResponder)

	// BeginValidateForRestore is the fake for method BackupInstancesClient.BeginValidateForRestore
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginValidateForRestore func(ctx context.Context, resourceGroupName string, vaultName string, backupInstanceName string, parameters armdataprotection.ValidateRestoreRequestObject, options *armdataprotection.BackupInstancesClientBeginValidateForRestoreOptions) (resp azfake.PollerResponder[armdataprotection.BackupInstancesClientValidateForRestoreResponse], errResp azfake.ErrorResponder)
}

// NewBackupInstancesServerTransport creates a new instance of BackupInstancesServerTransport with the provided implementation.
// The returned BackupInstancesServerTransport instance is connected to an instance of armdataprotection.BackupInstancesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewBackupInstancesServerTransport(srv *BackupInstancesServer) *BackupInstancesServerTransport {
	return &BackupInstancesServerTransport{
		srv:                             srv,
		beginAdhocBackup:                newTracker[azfake.PollerResponder[armdataprotection.BackupInstancesClientAdhocBackupResponse]](),
		beginCreateOrUpdate:             newTracker[azfake.PollerResponder[armdataprotection.BackupInstancesClientCreateOrUpdateResponse]](),
		beginDelete:                     newTracker[azfake.PollerResponder[armdataprotection.BackupInstancesClientDeleteResponse]](),
		newListPager:                    newTracker[azfake.PagerResponder[armdataprotection.BackupInstancesClientListResponse]](),
		beginResumeBackups:              newTracker[azfake.PollerResponder[armdataprotection.BackupInstancesClientResumeBackupsResponse]](),
		beginResumeProtection:           newTracker[azfake.PollerResponder[armdataprotection.BackupInstancesClientResumeProtectionResponse]](),
		beginStopProtection:             newTracker[azfake.PollerResponder[armdataprotection.BackupInstancesClientStopProtectionResponse]](),
		beginSuspendBackups:             newTracker[azfake.PollerResponder[armdataprotection.BackupInstancesClientSuspendBackupsResponse]](),
		beginSyncBackupInstance:         newTracker[azfake.PollerResponder[armdataprotection.BackupInstancesClientSyncBackupInstanceResponse]](),
		beginTriggerCrossRegionRestore:  newTracker[azfake.PollerResponder[armdataprotection.BackupInstancesClientTriggerCrossRegionRestoreResponse]](),
		beginTriggerRehydrate:           newTracker[azfake.PollerResponder[armdataprotection.BackupInstancesClientTriggerRehydrateResponse]](),
		beginTriggerRestore:             newTracker[azfake.PollerResponder[armdataprotection.BackupInstancesClientTriggerRestoreResponse]](),
		beginValidateCrossRegionRestore: newTracker[azfake.PollerResponder[armdataprotection.BackupInstancesClientValidateCrossRegionRestoreResponse]](),
		beginValidateForBackup:          newTracker[azfake.PollerResponder[armdataprotection.BackupInstancesClientValidateForBackupResponse]](),
		beginValidateForRestore:         newTracker[azfake.PollerResponder[armdataprotection.BackupInstancesClientValidateForRestoreResponse]](),
	}
}

// BackupInstancesServerTransport connects instances of armdataprotection.BackupInstancesClient to instances of BackupInstancesServer.
// Don't use this type directly, use NewBackupInstancesServerTransport instead.
type BackupInstancesServerTransport struct {
	srv                             *BackupInstancesServer
	beginAdhocBackup                *tracker[azfake.PollerResponder[armdataprotection.BackupInstancesClientAdhocBackupResponse]]
	beginCreateOrUpdate             *tracker[azfake.PollerResponder[armdataprotection.BackupInstancesClientCreateOrUpdateResponse]]
	beginDelete                     *tracker[azfake.PollerResponder[armdataprotection.BackupInstancesClientDeleteResponse]]
	newListPager                    *tracker[azfake.PagerResponder[armdataprotection.BackupInstancesClientListResponse]]
	beginResumeBackups              *tracker[azfake.PollerResponder[armdataprotection.BackupInstancesClientResumeBackupsResponse]]
	beginResumeProtection           *tracker[azfake.PollerResponder[armdataprotection.BackupInstancesClientResumeProtectionResponse]]
	beginStopProtection             *tracker[azfake.PollerResponder[armdataprotection.BackupInstancesClientStopProtectionResponse]]
	beginSuspendBackups             *tracker[azfake.PollerResponder[armdataprotection.BackupInstancesClientSuspendBackupsResponse]]
	beginSyncBackupInstance         *tracker[azfake.PollerResponder[armdataprotection.BackupInstancesClientSyncBackupInstanceResponse]]
	beginTriggerCrossRegionRestore  *tracker[azfake.PollerResponder[armdataprotection.BackupInstancesClientTriggerCrossRegionRestoreResponse]]
	beginTriggerRehydrate           *tracker[azfake.PollerResponder[armdataprotection.BackupInstancesClientTriggerRehydrateResponse]]
	beginTriggerRestore             *tracker[azfake.PollerResponder[armdataprotection.BackupInstancesClientTriggerRestoreResponse]]
	beginValidateCrossRegionRestore *tracker[azfake.PollerResponder[armdataprotection.BackupInstancesClientValidateCrossRegionRestoreResponse]]
	beginValidateForBackup          *tracker[azfake.PollerResponder[armdataprotection.BackupInstancesClientValidateForBackupResponse]]
	beginValidateForRestore         *tracker[azfake.PollerResponder[armdataprotection.BackupInstancesClientValidateForRestoreResponse]]
}

// Do implements the policy.Transporter interface for BackupInstancesServerTransport.
func (b *BackupInstancesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "BackupInstancesClient.BeginAdhocBackup":
		resp, err = b.dispatchBeginAdhocBackup(req)
	case "BackupInstancesClient.BeginCreateOrUpdate":
		resp, err = b.dispatchBeginCreateOrUpdate(req)
	case "BackupInstancesClient.BeginDelete":
		resp, err = b.dispatchBeginDelete(req)
	case "BackupInstancesClient.Get":
		resp, err = b.dispatchGet(req)
	case "BackupInstancesClient.GetBackupInstanceOperationResult":
		resp, err = b.dispatchGetBackupInstanceOperationResult(req)
	case "BackupInstancesClient.NewListPager":
		resp, err = b.dispatchNewListPager(req)
	case "BackupInstancesClient.BeginResumeBackups":
		resp, err = b.dispatchBeginResumeBackups(req)
	case "BackupInstancesClient.BeginResumeProtection":
		resp, err = b.dispatchBeginResumeProtection(req)
	case "BackupInstancesClient.BeginStopProtection":
		resp, err = b.dispatchBeginStopProtection(req)
	case "BackupInstancesClient.BeginSuspendBackups":
		resp, err = b.dispatchBeginSuspendBackups(req)
	case "BackupInstancesClient.BeginSyncBackupInstance":
		resp, err = b.dispatchBeginSyncBackupInstance(req)
	case "BackupInstancesClient.BeginTriggerCrossRegionRestore":
		resp, err = b.dispatchBeginTriggerCrossRegionRestore(req)
	case "BackupInstancesClient.BeginTriggerRehydrate":
		resp, err = b.dispatchBeginTriggerRehydrate(req)
	case "BackupInstancesClient.BeginTriggerRestore":
		resp, err = b.dispatchBeginTriggerRestore(req)
	case "BackupInstancesClient.BeginValidateCrossRegionRestore":
		resp, err = b.dispatchBeginValidateCrossRegionRestore(req)
	case "BackupInstancesClient.BeginValidateForBackup":
		resp, err = b.dispatchBeginValidateForBackup(req)
	case "BackupInstancesClient.BeginValidateForRestore":
		resp, err = b.dispatchBeginValidateForRestore(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (b *BackupInstancesServerTransport) dispatchBeginAdhocBackup(req *http.Request) (*http.Response, error) {
	if b.srv.BeginAdhocBackup == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginAdhocBackup not implemented")}
	}
	beginAdhocBackup := b.beginAdhocBackup.get(req)
	if beginAdhocBackup == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/backupVaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupInstances/(?P<backupInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backup`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdataprotection.TriggerBackupRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
		if err != nil {
			return nil, err
		}
		backupInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupInstanceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := b.srv.BeginAdhocBackup(req.Context(), resourceGroupNameParam, vaultNameParam, backupInstanceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginAdhocBackup = &respr
		b.beginAdhocBackup.add(req, beginAdhocBackup)
	}

	resp, err := server.PollerResponderNext(beginAdhocBackup, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		b.beginAdhocBackup.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginAdhocBackup) {
		b.beginAdhocBackup.remove(req)
	}

	return resp, nil
}

func (b *BackupInstancesServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if b.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := b.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/backupVaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupInstances/(?P<backupInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdataprotection.BackupInstanceResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
		if err != nil {
			return nil, err
		}
		backupInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupInstanceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := b.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, vaultNameParam, backupInstanceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		b.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated, http.StatusAccepted}, resp.StatusCode) {
		b.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		b.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (b *BackupInstancesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if b.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := b.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/backupVaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupInstances/(?P<backupInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
		if err != nil {
			return nil, err
		}
		backupInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupInstanceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := b.srv.BeginDelete(req.Context(), resourceGroupNameParam, vaultNameParam, backupInstanceNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		b.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		b.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		b.beginDelete.remove(req)
	}

	return resp, nil
}

func (b *BackupInstancesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if b.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/backupVaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupInstances/(?P<backupInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
	if err != nil {
		return nil, err
	}
	backupInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupInstanceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := b.srv.Get(req.Context(), resourceGroupNameParam, vaultNameParam, backupInstanceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).BackupInstanceResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (b *BackupInstancesServerTransport) dispatchGetBackupInstanceOperationResult(req *http.Request) (*http.Response, error) {
	if b.srv.GetBackupInstanceOperationResult == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetBackupInstanceOperationResult not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/backupVaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupInstances/(?P<backupInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/operationResults/(?P<operationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
	if err != nil {
		return nil, err
	}
	backupInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupInstanceName")])
	if err != nil {
		return nil, err
	}
	operationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("operationId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := b.srv.GetBackupInstanceOperationResult(req.Context(), resourceGroupNameParam, vaultNameParam, backupInstanceNameParam, operationIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusAccepted}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).BackupInstanceResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (b *BackupInstancesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if b.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := b.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/backupVaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupInstances`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
		if err != nil {
			return nil, err
		}
		resp := b.srv.NewListPager(resourceGroupNameParam, vaultNameParam, nil)
		newListPager = &resp
		b.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armdataprotection.BackupInstancesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		b.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		b.newListPager.remove(req)
	}
	return resp, nil
}

func (b *BackupInstancesServerTransport) dispatchBeginResumeBackups(req *http.Request) (*http.Response, error) {
	if b.srv.BeginResumeBackups == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginResumeBackups not implemented")}
	}
	beginResumeBackups := b.beginResumeBackups.get(req)
	if beginResumeBackups == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/backupVaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupInstances/(?P<backupInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resumeBackups`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
		if err != nil {
			return nil, err
		}
		backupInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupInstanceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := b.srv.BeginResumeBackups(req.Context(), resourceGroupNameParam, vaultNameParam, backupInstanceNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginResumeBackups = &respr
		b.beginResumeBackups.add(req, beginResumeBackups)
	}

	resp, err := server.PollerResponderNext(beginResumeBackups, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		b.beginResumeBackups.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginResumeBackups) {
		b.beginResumeBackups.remove(req)
	}

	return resp, nil
}

func (b *BackupInstancesServerTransport) dispatchBeginResumeProtection(req *http.Request) (*http.Response, error) {
	if b.srv.BeginResumeProtection == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginResumeProtection not implemented")}
	}
	beginResumeProtection := b.beginResumeProtection.get(req)
	if beginResumeProtection == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/backupVaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupInstances/(?P<backupInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resumeProtection`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
		if err != nil {
			return nil, err
		}
		backupInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupInstanceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := b.srv.BeginResumeProtection(req.Context(), resourceGroupNameParam, vaultNameParam, backupInstanceNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginResumeProtection = &respr
		b.beginResumeProtection.add(req, beginResumeProtection)
	}

	resp, err := server.PollerResponderNext(beginResumeProtection, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		b.beginResumeProtection.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginResumeProtection) {
		b.beginResumeProtection.remove(req)
	}

	return resp, nil
}

func (b *BackupInstancesServerTransport) dispatchBeginStopProtection(req *http.Request) (*http.Response, error) {
	if b.srv.BeginStopProtection == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStopProtection not implemented")}
	}
	beginStopProtection := b.beginStopProtection.get(req)
	if beginStopProtection == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/backupVaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupInstances/(?P<backupInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/stopProtection`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
		if err != nil {
			return nil, err
		}
		backupInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupInstanceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := b.srv.BeginStopProtection(req.Context(), resourceGroupNameParam, vaultNameParam, backupInstanceNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStopProtection = &respr
		b.beginStopProtection.add(req, beginStopProtection)
	}

	resp, err := server.PollerResponderNext(beginStopProtection, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		b.beginStopProtection.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStopProtection) {
		b.beginStopProtection.remove(req)
	}

	return resp, nil
}

func (b *BackupInstancesServerTransport) dispatchBeginSuspendBackups(req *http.Request) (*http.Response, error) {
	if b.srv.BeginSuspendBackups == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginSuspendBackups not implemented")}
	}
	beginSuspendBackups := b.beginSuspendBackups.get(req)
	if beginSuspendBackups == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/backupVaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupInstances/(?P<backupInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/suspendBackups`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
		if err != nil {
			return nil, err
		}
		backupInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupInstanceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := b.srv.BeginSuspendBackups(req.Context(), resourceGroupNameParam, vaultNameParam, backupInstanceNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginSuspendBackups = &respr
		b.beginSuspendBackups.add(req, beginSuspendBackups)
	}

	resp, err := server.PollerResponderNext(beginSuspendBackups, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		b.beginSuspendBackups.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginSuspendBackups) {
		b.beginSuspendBackups.remove(req)
	}

	return resp, nil
}

func (b *BackupInstancesServerTransport) dispatchBeginSyncBackupInstance(req *http.Request) (*http.Response, error) {
	if b.srv.BeginSyncBackupInstance == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginSyncBackupInstance not implemented")}
	}
	beginSyncBackupInstance := b.beginSyncBackupInstance.get(req)
	if beginSyncBackupInstance == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/backupVaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupInstances/(?P<backupInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sync`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdataprotection.SyncBackupInstanceRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
		if err != nil {
			return nil, err
		}
		backupInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupInstanceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := b.srv.BeginSyncBackupInstance(req.Context(), resourceGroupNameParam, vaultNameParam, backupInstanceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginSyncBackupInstance = &respr
		b.beginSyncBackupInstance.add(req, beginSyncBackupInstance)
	}

	resp, err := server.PollerResponderNext(beginSyncBackupInstance, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		b.beginSyncBackupInstance.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginSyncBackupInstance) {
		b.beginSyncBackupInstance.remove(req)
	}

	return resp, nil
}

func (b *BackupInstancesServerTransport) dispatchBeginTriggerCrossRegionRestore(req *http.Request) (*http.Response, error) {
	if b.srv.BeginTriggerCrossRegionRestore == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginTriggerCrossRegionRestore not implemented")}
	}
	beginTriggerCrossRegionRestore := b.beginTriggerCrossRegionRestore.get(req)
	if beginTriggerCrossRegionRestore == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/crossRegionRestore`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdataprotection.CrossRegionRestoreRequestObject](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := b.srv.BeginTriggerCrossRegionRestore(req.Context(), resourceGroupNameParam, locationParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginTriggerCrossRegionRestore = &respr
		b.beginTriggerCrossRegionRestore.add(req, beginTriggerCrossRegionRestore)
	}

	resp, err := server.PollerResponderNext(beginTriggerCrossRegionRestore, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		b.beginTriggerCrossRegionRestore.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginTriggerCrossRegionRestore) {
		b.beginTriggerCrossRegionRestore.remove(req)
	}

	return resp, nil
}

func (b *BackupInstancesServerTransport) dispatchBeginTriggerRehydrate(req *http.Request) (*http.Response, error) {
	if b.srv.BeginTriggerRehydrate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginTriggerRehydrate not implemented")}
	}
	beginTriggerRehydrate := b.beginTriggerRehydrate.get(req)
	if beginTriggerRehydrate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/backupVaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupInstances/(?P<backupInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/rehydrate`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdataprotection.AzureBackupRehydrationRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
		if err != nil {
			return nil, err
		}
		backupInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupInstanceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := b.srv.BeginTriggerRehydrate(req.Context(), resourceGroupNameParam, vaultNameParam, backupInstanceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginTriggerRehydrate = &respr
		b.beginTriggerRehydrate.add(req, beginTriggerRehydrate)
	}

	resp, err := server.PollerResponderNext(beginTriggerRehydrate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		b.beginTriggerRehydrate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginTriggerRehydrate) {
		b.beginTriggerRehydrate.remove(req)
	}

	return resp, nil
}

func (b *BackupInstancesServerTransport) dispatchBeginTriggerRestore(req *http.Request) (*http.Response, error) {
	if b.srv.BeginTriggerRestore == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginTriggerRestore not implemented")}
	}
	beginTriggerRestore := b.beginTriggerRestore.get(req)
	if beginTriggerRestore == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/backupVaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupInstances/(?P<backupInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/restore`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		raw, err := readRequestBody(req)
		if err != nil {
			return nil, err
		}
		body, err := unmarshalAzureBackupRestoreRequestClassification(raw)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
		if err != nil {
			return nil, err
		}
		backupInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupInstanceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := b.srv.BeginTriggerRestore(req.Context(), resourceGroupNameParam, vaultNameParam, backupInstanceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginTriggerRestore = &respr
		b.beginTriggerRestore.add(req, beginTriggerRestore)
	}

	resp, err := server.PollerResponderNext(beginTriggerRestore, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		b.beginTriggerRestore.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginTriggerRestore) {
		b.beginTriggerRestore.remove(req)
	}

	return resp, nil
}

func (b *BackupInstancesServerTransport) dispatchBeginValidateCrossRegionRestore(req *http.Request) (*http.Response, error) {
	if b.srv.BeginValidateCrossRegionRestore == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginValidateCrossRegionRestore not implemented")}
	}
	beginValidateCrossRegionRestore := b.beginValidateCrossRegionRestore.get(req)
	if beginValidateCrossRegionRestore == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/validateCrossRegionRestore`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdataprotection.ValidateCrossRegionRestoreRequestObject](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := b.srv.BeginValidateCrossRegionRestore(req.Context(), resourceGroupNameParam, locationParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginValidateCrossRegionRestore = &respr
		b.beginValidateCrossRegionRestore.add(req, beginValidateCrossRegionRestore)
	}

	resp, err := server.PollerResponderNext(beginValidateCrossRegionRestore, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		b.beginValidateCrossRegionRestore.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginValidateCrossRegionRestore) {
		b.beginValidateCrossRegionRestore.remove(req)
	}

	return resp, nil
}

func (b *BackupInstancesServerTransport) dispatchBeginValidateForBackup(req *http.Request) (*http.Response, error) {
	if b.srv.BeginValidateForBackup == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginValidateForBackup not implemented")}
	}
	beginValidateForBackup := b.beginValidateForBackup.get(req)
	if beginValidateForBackup == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/backupVaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/validateForBackup`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdataprotection.ValidateForBackupRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := b.srv.BeginValidateForBackup(req.Context(), resourceGroupNameParam, vaultNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginValidateForBackup = &respr
		b.beginValidateForBackup.add(req, beginValidateForBackup)
	}

	resp, err := server.PollerResponderNext(beginValidateForBackup, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		b.beginValidateForBackup.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginValidateForBackup) {
		b.beginValidateForBackup.remove(req)
	}

	return resp, nil
}

func (b *BackupInstancesServerTransport) dispatchBeginValidateForRestore(req *http.Request) (*http.Response, error) {
	if b.srv.BeginValidateForRestore == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginValidateForRestore not implemented")}
	}
	beginValidateForRestore := b.beginValidateForRestore.get(req)
	if beginValidateForRestore == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/backupVaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupInstances/(?P<backupInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/validateRestore`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdataprotection.ValidateRestoreRequestObject](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
		if err != nil {
			return nil, err
		}
		backupInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupInstanceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := b.srv.BeginValidateForRestore(req.Context(), resourceGroupNameParam, vaultNameParam, backupInstanceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginValidateForRestore = &respr
		b.beginValidateForRestore.add(req, beginValidateForRestore)
	}

	resp, err := server.PollerResponderNext(beginValidateForRestore, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		b.beginValidateForRestore.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginValidateForRestore) {
		b.beginValidateForRestore.remove(req)
	}

	return resp, nil
}
