//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdatamigration

import "encoding/json"

func unmarshalCommandPropertiesClassification(rawMsg json.RawMessage) (CommandPropertiesClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b CommandPropertiesClassification
	switch m["commandType"] {
	case "Migrate.SqlServer.AzureDbSqlMi.Complete":
		b = &MigrateMISyncCompleteCommandProperties{}
	case "Migrate.Sync.Complete.Database":
		b = &MigrateSyncCompleteCommandProperties{}
	case "cancel":
		b = &MongoDbCancelCommand{}
	case "finish":
		b = &MongoDbFinishCommand{}
	case "restart":
		b = &MongoDbRestartCommand{}
	default:
		b = &CommandProperties{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalCommandPropertiesClassificationArray(rawMsg json.RawMessage) ([]CommandPropertiesClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]CommandPropertiesClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalCommandPropertiesClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalConnectToSourceSQLServerTaskOutputClassification(rawMsg json.RawMessage) (ConnectToSourceSQLServerTaskOutputClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b ConnectToSourceSQLServerTaskOutputClassification
	switch m["resultType"] {
	case "AgentJobLevelOutput":
		b = &ConnectToSourceSQLServerTaskOutputAgentJobLevel{}
	case "DatabaseLevelOutput":
		b = &ConnectToSourceSQLServerTaskOutputDatabaseLevel{}
	case "LoginLevelOutput":
		b = &ConnectToSourceSQLServerTaskOutputLoginLevel{}
	case "TaskLevelOutput":
		b = &ConnectToSourceSQLServerTaskOutputTaskLevel{}
	default:
		b = &ConnectToSourceSQLServerTaskOutput{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalConnectToSourceSQLServerTaskOutputClassificationArray(rawMsg json.RawMessage) ([]ConnectToSourceSQLServerTaskOutputClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]ConnectToSourceSQLServerTaskOutputClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalConnectToSourceSQLServerTaskOutputClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalConnectionInfoClassification(rawMsg json.RawMessage) (ConnectionInfoClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b ConnectionInfoClassification
	switch m["type"] {
	case "MiSqlConnectionInfo":
		b = &MiSQLConnectionInfo{}
	case "MongoDbConnectionInfo":
		b = &MongoDbConnectionInfo{}
	case "MySqlConnectionInfo":
		b = &MySQLConnectionInfo{}
	case "OracleConnectionInfo":
		b = &OracleConnectionInfo{}
	case "PostgreSqlConnectionInfo":
		b = &PostgreSQLConnectionInfo{}
	case "SqlConnectionInfo":
		b = &SQLConnectionInfo{}
	default:
		b = &ConnectionInfo{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalMigrateMySQLAzureDbForMySQLOfflineTaskOutputClassification(rawMsg json.RawMessage) (MigrateMySQLAzureDbForMySQLOfflineTaskOutputClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b MigrateMySQLAzureDbForMySQLOfflineTaskOutputClassification
	switch m["resultType"] {
	case "DatabaseLevelOutput":
		b = &MigrateMySQLAzureDbForMySQLOfflineTaskOutputDatabaseLevel{}
	case "ErrorOutput":
		b = &MigrateMySQLAzureDbForMySQLOfflineTaskOutputError{}
	case "MigrationLevelOutput":
		b = &MigrateMySQLAzureDbForMySQLOfflineTaskOutputMigrationLevel{}
	case "TableLevelOutput":
		b = &MigrateMySQLAzureDbForMySQLOfflineTaskOutputTableLevel{}
	default:
		b = &MigrateMySQLAzureDbForMySQLOfflineTaskOutput{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalMigrateMySQLAzureDbForMySQLOfflineTaskOutputClassificationArray(rawMsg json.RawMessage) ([]MigrateMySQLAzureDbForMySQLOfflineTaskOutputClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]MigrateMySQLAzureDbForMySQLOfflineTaskOutputClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalMigrateMySQLAzureDbForMySQLOfflineTaskOutputClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalMigrateMySQLAzureDbForMySQLSyncTaskOutputClassification(rawMsg json.RawMessage) (MigrateMySQLAzureDbForMySQLSyncTaskOutputClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b MigrateMySQLAzureDbForMySQLSyncTaskOutputClassification
	switch m["resultType"] {
	case "DatabaseLevelErrorOutput":
		b = &MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError{}
	case "DatabaseLevelOutput":
		b = &MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel{}
	case "ErrorOutput":
		b = &MigrateMySQLAzureDbForMySQLSyncTaskOutputError{}
	case "MigrationLevelOutput":
		b = &MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel{}
	case "TableLevelOutput":
		b = &MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel{}
	default:
		b = &MigrateMySQLAzureDbForMySQLSyncTaskOutput{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalMigrateMySQLAzureDbForMySQLSyncTaskOutputClassificationArray(rawMsg json.RawMessage) ([]MigrateMySQLAzureDbForMySQLSyncTaskOutputClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]MigrateMySQLAzureDbForMySQLSyncTaskOutputClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalMigrateMySQLAzureDbForMySQLSyncTaskOutputClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalMigrateOracleAzureDbPostgreSQLSyncTaskOutputClassification(rawMsg json.RawMessage) (MigrateOracleAzureDbPostgreSQLSyncTaskOutputClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b MigrateOracleAzureDbPostgreSQLSyncTaskOutputClassification
	switch m["resultType"] {
	case "DatabaseLevelErrorOutput":
		b = &MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError{}
	case "DatabaseLevelOutput":
		b = &MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel{}
	case "ErrorOutput":
		b = &MigrateOracleAzureDbPostgreSQLSyncTaskOutputError{}
	case "MigrationLevelOutput":
		b = &MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel{}
	case "TableLevelOutput":
		b = &MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel{}
	default:
		b = &MigrateOracleAzureDbPostgreSQLSyncTaskOutput{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalMigrateOracleAzureDbPostgreSQLSyncTaskOutputClassificationArray(rawMsg json.RawMessage) ([]MigrateOracleAzureDbPostgreSQLSyncTaskOutputClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]MigrateOracleAzureDbPostgreSQLSyncTaskOutputClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalMigrateOracleAzureDbPostgreSQLSyncTaskOutputClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputClassification(rawMsg json.RawMessage) (MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputClassification
	switch m["resultType"] {
	case "DatabaseLevelErrorOutput":
		b = &MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError{}
	case "DatabaseLevelOutput":
		b = &MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel{}
	case "ErrorOutput":
		b = &MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError{}
	case "MigrationLevelOutput":
		b = &MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel{}
	case "TableLevelOutput":
		b = &MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel{}
	default:
		b = &MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputClassificationArray(rawMsg json.RawMessage) ([]MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalMigrateSQLServerSQLDbSyncTaskOutputClassification(rawMsg json.RawMessage) (MigrateSQLServerSQLDbSyncTaskOutputClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b MigrateSQLServerSQLDbSyncTaskOutputClassification
	switch m["resultType"] {
	case "DatabaseLevelErrorOutput":
		b = &MigrateSQLServerSQLDbSyncTaskOutputDatabaseError{}
	case "DatabaseLevelOutput":
		b = &MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel{}
	case "ErrorOutput":
		b = &MigrateSQLServerSQLDbSyncTaskOutputError{}
	case "MigrationLevelOutput":
		b = &MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel{}
	case "TableLevelOutput":
		b = &MigrateSQLServerSQLDbSyncTaskOutputTableLevel{}
	default:
		b = &MigrateSQLServerSQLDbSyncTaskOutput{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalMigrateSQLServerSQLDbSyncTaskOutputClassificationArray(rawMsg json.RawMessage) ([]MigrateSQLServerSQLDbSyncTaskOutputClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]MigrateSQLServerSQLDbSyncTaskOutputClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalMigrateSQLServerSQLDbSyncTaskOutputClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalMigrateSQLServerSQLDbTaskOutputClassification(rawMsg json.RawMessage) (MigrateSQLServerSQLDbTaskOutputClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b MigrateSQLServerSQLDbTaskOutputClassification
	switch m["resultType"] {
	case "DatabaseLevelOutput":
		b = &MigrateSQLServerSQLDbTaskOutputDatabaseLevel{}
	case "ErrorOutput":
		b = &MigrateSQLServerSQLDbTaskOutputError{}
	case "MigrationDatabaseLevelValidationOutput":
		b = &MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult{}
	case "MigrationLevelOutput":
		b = &MigrateSQLServerSQLDbTaskOutputMigrationLevel{}
	case "MigrationValidationOutput":
		b = &MigrateSQLServerSQLDbTaskOutputValidationResult{}
	case "TableLevelOutput":
		b = &MigrateSQLServerSQLDbTaskOutputTableLevel{}
	default:
		b = &MigrateSQLServerSQLDbTaskOutput{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalMigrateSQLServerSQLDbTaskOutputClassificationArray(rawMsg json.RawMessage) ([]MigrateSQLServerSQLDbTaskOutputClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]MigrateSQLServerSQLDbTaskOutputClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalMigrateSQLServerSQLDbTaskOutputClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalMigrateSQLServerSQLMISyncTaskOutputClassification(rawMsg json.RawMessage) (MigrateSQLServerSQLMISyncTaskOutputClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b MigrateSQLServerSQLMISyncTaskOutputClassification
	switch m["resultType"] {
	case "DatabaseLevelOutput":
		b = &MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel{}
	case "ErrorOutput":
		b = &MigrateSQLServerSQLMISyncTaskOutputError{}
	case "MigrationLevelOutput":
		b = &MigrateSQLServerSQLMISyncTaskOutputMigrationLevel{}
	default:
		b = &MigrateSQLServerSQLMISyncTaskOutput{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalMigrateSQLServerSQLMISyncTaskOutputClassificationArray(rawMsg json.RawMessage) ([]MigrateSQLServerSQLMISyncTaskOutputClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]MigrateSQLServerSQLMISyncTaskOutputClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalMigrateSQLServerSQLMISyncTaskOutputClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalMigrateSQLServerSQLMITaskOutputClassification(rawMsg json.RawMessage) (MigrateSQLServerSQLMITaskOutputClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b MigrateSQLServerSQLMITaskOutputClassification
	switch m["resultType"] {
	case "AgentJobLevelOutput":
		b = &MigrateSQLServerSQLMITaskOutputAgentJobLevel{}
	case "DatabaseLevelOutput":
		b = &MigrateSQLServerSQLMITaskOutputDatabaseLevel{}
	case "ErrorOutput":
		b = &MigrateSQLServerSQLMITaskOutputError{}
	case "LoginLevelOutput":
		b = &MigrateSQLServerSQLMITaskOutputLoginLevel{}
	case "MigrationLevelOutput":
		b = &MigrateSQLServerSQLMITaskOutputMigrationLevel{}
	default:
		b = &MigrateSQLServerSQLMITaskOutput{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalMigrateSQLServerSQLMITaskOutputClassificationArray(rawMsg json.RawMessage) ([]MigrateSQLServerSQLMITaskOutputClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]MigrateSQLServerSQLMITaskOutputClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalMigrateSQLServerSQLMITaskOutputClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalMigrateSchemaSQLServerSQLDbTaskOutputClassification(rawMsg json.RawMessage) (MigrateSchemaSQLServerSQLDbTaskOutputClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b MigrateSchemaSQLServerSQLDbTaskOutputClassification
	switch m["resultType"] {
	case "DatabaseLevelOutput":
		b = &MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel{}
	case "ErrorOutput":
		b = &MigrateSchemaSQLTaskOutputError{}
	case "MigrationLevelOutput":
		b = &MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel{}
	case "SchemaErrorOutput":
		b = &MigrateSchemaSQLServerSQLDbTaskOutputError{}
	default:
		b = &MigrateSchemaSQLServerSQLDbTaskOutput{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalMigrateSchemaSQLServerSQLDbTaskOutputClassificationArray(rawMsg json.RawMessage) ([]MigrateSchemaSQLServerSQLDbTaskOutputClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]MigrateSchemaSQLServerSQLDbTaskOutputClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalMigrateSchemaSQLServerSQLDbTaskOutputClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalMigrateSsisTaskOutputClassification(rawMsg json.RawMessage) (MigrateSsisTaskOutputClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b MigrateSsisTaskOutputClassification
	switch m["resultType"] {
	case "MigrationLevelOutput":
		b = &MigrateSsisTaskOutputMigrationLevel{}
	case "SsisProjectLevelOutput":
		b = &MigrateSsisTaskOutputProjectLevel{}
	default:
		b = &MigrateSsisTaskOutput{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalMigrateSsisTaskOutputClassificationArray(rawMsg json.RawMessage) ([]MigrateSsisTaskOutputClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]MigrateSsisTaskOutputClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalMigrateSsisTaskOutputClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalMongoDbProgressClassification(rawMsg json.RawMessage) (MongoDbProgressClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b MongoDbProgressClassification
	switch m["resultType"] {
	case string(MongoDbProgressResultTypeCollection):
		b = &MongoDbCollectionProgress{}
	case string(MongoDbProgressResultTypeDatabase):
		b = &MongoDbDatabaseProgress{}
	case string(MongoDbProgressResultTypeMigration):
		b = &MongoDbMigrationProgress{}
	default:
		b = &MongoDbProgress{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalMongoDbProgressClassificationArray(rawMsg json.RawMessage) ([]MongoDbProgressClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]MongoDbProgressClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalMongoDbProgressClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalProjectTaskPropertiesClassification(rawMsg json.RawMessage) (ProjectTaskPropertiesClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b ProjectTaskPropertiesClassification
	switch m["taskType"] {
	case "Connect.MongoDb":
		b = &ConnectToMongoDbTaskProperties{}
	case "ConnectToSource.MySql":
		b = &ConnectToSourceMySQLTaskProperties{}
	case "ConnectToSource.Oracle.Sync":
		b = &ConnectToSourceOracleSyncTaskProperties{}
	case "ConnectToSource.PostgreSql.Sync":
		b = &ConnectToSourcePostgreSQLSyncTaskProperties{}
	case "ConnectToSource.SqlServer":
		b = &ConnectToSourceSQLServerTaskProperties{}
	case "ConnectToSource.SqlServer.Sync":
		b = &ConnectToSourceSQLServerSyncTaskProperties{}
	case "ConnectToTarget.AzureDbForMySql":
		b = &ConnectToTargetAzureDbForMySQLTaskProperties{}
	case "ConnectToTarget.AzureDbForPostgreSql.Sync":
		b = &ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties{}
	case "ConnectToTarget.AzureSqlDbMI":
		b = &ConnectToTargetSQLMITaskProperties{}
	case "ConnectToTarget.AzureSqlDbMI.Sync.LRS":
		b = &ConnectToTargetSQLMISyncTaskProperties{}
	case "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync":
		b = &ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties{}
	case "ConnectToTarget.SqlDb":
		b = &ConnectToTargetSQLDbTaskProperties{}
	case "ConnectToTarget.SqlDb.Sync":
		b = &ConnectToTargetSQLDbSyncTaskProperties{}
	case "GetTDECertificates.Sql":
		b = &GetTdeCertificatesSQLTaskProperties{}
	case "GetUserTables.AzureSqlDb.Sync":
		b = &GetUserTablesSQLSyncTaskProperties{}
	case "GetUserTables.Sql":
		b = &GetUserTablesSQLTaskProperties{}
	case "GetUserTablesMySql":
		b = &GetUserTablesMySQLTaskProperties{}
	case "GetUserTablesOracle":
		b = &GetUserTablesOracleTaskProperties{}
	case "GetUserTablesPostgreSql":
		b = &GetUserTablesPostgreSQLTaskProperties{}
	case "Migrate.MongoDb":
		b = &MigrateMongoDbTaskProperties{}
	case "Migrate.MySql.AzureDbForMySql":
		b = &MigrateMySQLAzureDbForMySQLOfflineTaskProperties{}
	case "Migrate.MySql.AzureDbForMySql.Sync":
		b = &MigrateMySQLAzureDbForMySQLSyncTaskProperties{}
	case "Migrate.Oracle.AzureDbForPostgreSql.Sync":
		b = &MigrateOracleAzureDbForPostgreSQLSyncTaskProperties{}
	case "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2":
		b = &MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties{}
	case "Migrate.SqlServer.AzureSqlDb.Sync":
		b = &MigrateSQLServerSQLDbSyncTaskProperties{}
	case "Migrate.SqlServer.AzureSqlDbMI":
		b = &MigrateSQLServerSQLMITaskProperties{}
	case "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS":
		b = &MigrateSQLServerSQLMISyncTaskProperties{}
	case "Migrate.SqlServer.SqlDb":
		b = &MigrateSQLServerSQLDbTaskProperties{}
	case "Migrate.Ssis":
		b = &MigrateSsisTaskProperties{}
	case "MigrateSchemaSqlServerSqlDb":
		b = &MigrateSchemaSQLServerSQLDbTaskProperties{}
	case "Service.Check.OCI":
		b = &CheckOCIDriverTaskProperties{}
	case "Service.Install.OCI":
		b = &InstallOCIDriverTaskProperties{}
	case "Service.Upload.OCI":
		b = &UploadOCIDriverTaskProperties{}
	case "Validate.MongoDb":
		b = &ValidateMongoDbTaskProperties{}
	case "Validate.Oracle.AzureDbPostgreSql.Sync":
		b = &ValidateOracleAzureDbForPostgreSQLSyncTaskProperties{}
	case "ValidateMigrationInput.SqlServer.AzureSqlDbMI":
		b = &ValidateMigrationInputSQLServerSQLMITaskProperties{}
	case "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS":
		b = &ValidateMigrationInputSQLServerSQLMISyncTaskProperties{}
	case "ValidateMigrationInput.SqlServer.SqlDb.Sync":
		b = &ValidateMigrationInputSQLServerSQLDbSyncTaskProperties{}
	default:
		b = &ProjectTaskProperties{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}
