//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdatacatalog

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ADCCatalogsClient contains the methods for the ADCCatalogs group.
// Don't use this type directly, use NewADCCatalogsClient() instead.
type ADCCatalogsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewADCCatalogsClient creates a new instance of ADCCatalogsClient with the specified values.
//   - subscriptionID - Gets subscription credentials which uniquely identify the Microsoft Azure subscription. The subscription
//     ID forms part of the URI for every service call.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewADCCatalogsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ADCCatalogsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ADCCatalogsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// CreateOrUpdate - The Create Azure Data Catalog service operation creates a new data catalog service with the specified
// parameters. If the specific service already exists, then any patchable properties will be updated
// and any immutable properties will remain unchanged.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2016-03-30
//   - resourceGroupName - The name of the resource group within the user's subscription. The name is case insensitive.
//   - catalogName - The name of the data catalog in the specified subscription and resource group.
//   - properties - Properties supplied to the Create or Update a data catalog.
//   - options - ADCCatalogsClientCreateOrUpdateOptions contains the optional parameters for the ADCCatalogsClient.CreateOrUpdate
//     method.
func (client *ADCCatalogsClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, catalogName string, properties ADCCatalog, options *ADCCatalogsClientCreateOrUpdateOptions) (ADCCatalogsClientCreateOrUpdateResponse, error) {
	var err error
	const operationName = "ADCCatalogsClient.CreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, catalogName, properties, options)
	if err != nil {
		return ADCCatalogsClientCreateOrUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ADCCatalogsClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return ADCCatalogsClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.createOrUpdateHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *ADCCatalogsClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, catalogName string, properties ADCCatalog, options *ADCCatalogsClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataCatalog/catalogs/{catalogName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if catalogName == "" {
		return nil, errors.New("parameter catalogName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{catalogName}", url.PathEscape(catalogName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-03-30")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, properties); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *ADCCatalogsClient) createOrUpdateHandleResponse(resp *http.Response) (ADCCatalogsClientCreateOrUpdateResponse, error) {
	result := ADCCatalogsClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ADCCatalog); err != nil {
		return ADCCatalogsClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// BeginDelete - The Delete Azure Data Catalog Service operation deletes an existing data catalog.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2016-03-30
//   - resourceGroupName - The name of the resource group within the user's subscription. The name is case insensitive.
//   - catalogName - The name of the data catalog in the specified subscription and resource group.
//   - options - ADCCatalogsClientBeginDeleteOptions contains the optional parameters for the ADCCatalogsClient.BeginDelete method.
func (client *ADCCatalogsClient) BeginDelete(ctx context.Context, resourceGroupName string, catalogName string, options *ADCCatalogsClientBeginDeleteOptions) (*runtime.Poller[ADCCatalogsClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceGroupName, catalogName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ADCCatalogsClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ADCCatalogsClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Delete - The Delete Azure Data Catalog Service operation deletes an existing data catalog.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2016-03-30
func (client *ADCCatalogsClient) deleteOperation(ctx context.Context, resourceGroupName string, catalogName string, options *ADCCatalogsClientBeginDeleteOptions) (*http.Response, error) {
	var err error
	const operationName = "ADCCatalogsClient.BeginDelete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, catalogName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *ADCCatalogsClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, catalogName string, options *ADCCatalogsClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataCatalog/catalogs/{catalogName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if catalogName == "" {
		return nil, errors.New("parameter catalogName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{catalogName}", url.PathEscape(catalogName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-03-30")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}

// Get - The Get Azure Data Catalog Service operation retrieves a json representation of the data catalog.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2016-03-30
//   - resourceGroupName - The name of the resource group within the user's subscription. The name is case insensitive.
//   - catalogName - The name of the data catalog in the specified subscription and resource group.
//   - options - ADCCatalogsClientGetOptions contains the optional parameters for the ADCCatalogsClient.Get method.
func (client *ADCCatalogsClient) Get(ctx context.Context, resourceGroupName string, catalogName string, options *ADCCatalogsClientGetOptions) (ADCCatalogsClientGetResponse, error) {
	var err error
	const operationName = "ADCCatalogsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, catalogName, options)
	if err != nil {
		return ADCCatalogsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ADCCatalogsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ADCCatalogsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *ADCCatalogsClient) getCreateRequest(ctx context.Context, resourceGroupName string, catalogName string, options *ADCCatalogsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataCatalog/catalogs/{catalogName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if catalogName == "" {
		return nil, errors.New("parameter catalogName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{catalogName}", url.PathEscape(catalogName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-03-30")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ADCCatalogsClient) getHandleResponse(resp *http.Response) (ADCCatalogsClientGetResponse, error) {
	result := ADCCatalogsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ADCCatalog); err != nil {
		return ADCCatalogsClientGetResponse{}, err
	}
	return result, nil
}

// ListtByResourceGroup - The List catalogs in Resource Group operation lists all the Azure Data Catalogs available under
// the given resource group.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2016-03-30
//   - resourceGroupName - The name of the resource group within the user's subscription. The name is case insensitive.
//   - options - ADCCatalogsClientListtByResourceGroupOptions contains the optional parameters for the ADCCatalogsClient.ListtByResourceGroup
//     method.
func (client *ADCCatalogsClient) ListtByResourceGroup(ctx context.Context, resourceGroupName string, options *ADCCatalogsClientListtByResourceGroupOptions) (ADCCatalogsClientListtByResourceGroupResponse, error) {
	var err error
	const operationName = "ADCCatalogsClient.ListtByResourceGroup"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listtByResourceGroupCreateRequest(ctx, resourceGroupName, options)
	if err != nil {
		return ADCCatalogsClientListtByResourceGroupResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ADCCatalogsClientListtByResourceGroupResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ADCCatalogsClientListtByResourceGroupResponse{}, err
	}
	resp, err := client.listtByResourceGroupHandleResponse(httpResp)
	return resp, err
}

// listtByResourceGroupCreateRequest creates the ListtByResourceGroup request.
func (client *ADCCatalogsClient) listtByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *ADCCatalogsClientListtByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataCatalog/catalogs"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-03-30")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listtByResourceGroupHandleResponse handles the ListtByResourceGroup response.
func (client *ADCCatalogsClient) listtByResourceGroupHandleResponse(resp *http.Response) (ADCCatalogsClientListtByResourceGroupResponse, error) {
	result := ADCCatalogsClientListtByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ADCCatalogsListResult); err != nil {
		return ADCCatalogsClientListtByResourceGroupResponse{}, err
	}
	return result, nil
}

// Update - The Update Azure Data Catalog Service operation can be used to update the existing deployment. The update call
// only supports the properties listed in the PATCH body.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2016-03-30
//   - resourceGroupName - The name of the resource group within the user's subscription. The name is case insensitive.
//   - catalogName - The name of the data catalog in the specified subscription and resource group.
//   - properties - Properties supplied to the Update a data catalog.
//   - options - ADCCatalogsClientUpdateOptions contains the optional parameters for the ADCCatalogsClient.Update method.
func (client *ADCCatalogsClient) Update(ctx context.Context, resourceGroupName string, catalogName string, properties ADCCatalog, options *ADCCatalogsClientUpdateOptions) (ADCCatalogsClientUpdateResponse, error) {
	var err error
	const operationName = "ADCCatalogsClient.Update"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, resourceGroupName, catalogName, properties, options)
	if err != nil {
		return ADCCatalogsClientUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ADCCatalogsClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ADCCatalogsClientUpdateResponse{}, err
	}
	resp, err := client.updateHandleResponse(httpResp)
	return resp, err
}

// updateCreateRequest creates the Update request.
func (client *ADCCatalogsClient) updateCreateRequest(ctx context.Context, resourceGroupName string, catalogName string, properties ADCCatalog, options *ADCCatalogsClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataCatalog/catalogs/{catalogName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if catalogName == "" {
		return nil, errors.New("parameter catalogName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{catalogName}", url.PathEscape(catalogName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-03-30")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, properties); err != nil {
		return nil, err
	}
	return req, nil
}

// updateHandleResponse handles the Update response.
func (client *ADCCatalogsClient) updateHandleResponse(resp *http.Response) (ADCCatalogsClientUpdateResponse, error) {
	result := ADCCatalogsClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ADCCatalog); err != nil {
		return ADCCatalogsClientUpdateResponse{}, err
	}
	return result, nil
}
