//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armcostmanagement.ClientFactory type.
type ServerFactory struct {
	AlertsServer                                     AlertsServer
	BenefitRecommendationsServer                     BenefitRecommendationsServer
	BenefitUtilizationSummariesServer                BenefitUtilizationSummariesServer
	DimensionsServer                                 DimensionsServer
	ExportsServer                                    ExportsServer
	ForecastServer                                   ForecastServer
	GenerateCostDetailsReportServer                  GenerateCostDetailsReportServer
	GenerateDetailedCostReportServer                 GenerateDetailedCostReportServer
	GenerateDetailedCostReportOperationResultsServer GenerateDetailedCostReportOperationResultsServer
	GenerateDetailedCostReportOperationStatusServer  GenerateDetailedCostReportOperationStatusServer
	GenerateReservationDetailsReportServer           GenerateReservationDetailsReportServer
	OperationsServer                                 OperationsServer
	PriceSheetServer                                 PriceSheetServer
	QueryServer                                      QueryServer
	ScheduledActionsServer                           ScheduledActionsServer
	ViewsServer                                      ViewsServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armcostmanagement.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armcostmanagement.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                                                *ServerFactory
	trMu                                               sync.Mutex
	trAlertsServer                                     *AlertsServerTransport
	trBenefitRecommendationsServer                     *BenefitRecommendationsServerTransport
	trBenefitUtilizationSummariesServer                *BenefitUtilizationSummariesServerTransport
	trDimensionsServer                                 *DimensionsServerTransport
	trExportsServer                                    *ExportsServerTransport
	trForecastServer                                   *ForecastServerTransport
	trGenerateCostDetailsReportServer                  *GenerateCostDetailsReportServerTransport
	trGenerateDetailedCostReportServer                 *GenerateDetailedCostReportServerTransport
	trGenerateDetailedCostReportOperationResultsServer *GenerateDetailedCostReportOperationResultsServerTransport
	trGenerateDetailedCostReportOperationStatusServer  *GenerateDetailedCostReportOperationStatusServerTransport
	trGenerateReservationDetailsReportServer           *GenerateReservationDetailsReportServerTransport
	trOperationsServer                                 *OperationsServerTransport
	trPriceSheetServer                                 *PriceSheetServerTransport
	trQueryServer                                      *QueryServerTransport
	trScheduledActionsServer                           *ScheduledActionsServerTransport
	trViewsServer                                      *ViewsServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "AlertsClient":
		initServer(s, &s.trAlertsServer, func() *AlertsServerTransport { return NewAlertsServerTransport(&s.srv.AlertsServer) })
		resp, err = s.trAlertsServer.Do(req)
	case "BenefitRecommendationsClient":
		initServer(s, &s.trBenefitRecommendationsServer, func() *BenefitRecommendationsServerTransport {
			return NewBenefitRecommendationsServerTransport(&s.srv.BenefitRecommendationsServer)
		})
		resp, err = s.trBenefitRecommendationsServer.Do(req)
	case "BenefitUtilizationSummariesClient":
		initServer(s, &s.trBenefitUtilizationSummariesServer, func() *BenefitUtilizationSummariesServerTransport {
			return NewBenefitUtilizationSummariesServerTransport(&s.srv.BenefitUtilizationSummariesServer)
		})
		resp, err = s.trBenefitUtilizationSummariesServer.Do(req)
	case "DimensionsClient":
		initServer(s, &s.trDimensionsServer, func() *DimensionsServerTransport { return NewDimensionsServerTransport(&s.srv.DimensionsServer) })
		resp, err = s.trDimensionsServer.Do(req)
	case "ExportsClient":
		initServer(s, &s.trExportsServer, func() *ExportsServerTransport { return NewExportsServerTransport(&s.srv.ExportsServer) })
		resp, err = s.trExportsServer.Do(req)
	case "ForecastClient":
		initServer(s, &s.trForecastServer, func() *ForecastServerTransport { return NewForecastServerTransport(&s.srv.ForecastServer) })
		resp, err = s.trForecastServer.Do(req)
	case "GenerateCostDetailsReportClient":
		initServer(s, &s.trGenerateCostDetailsReportServer, func() *GenerateCostDetailsReportServerTransport {
			return NewGenerateCostDetailsReportServerTransport(&s.srv.GenerateCostDetailsReportServer)
		})
		resp, err = s.trGenerateCostDetailsReportServer.Do(req)
	case "GenerateDetailedCostReportClient":
		initServer(s, &s.trGenerateDetailedCostReportServer, func() *GenerateDetailedCostReportServerTransport {
			return NewGenerateDetailedCostReportServerTransport(&s.srv.GenerateDetailedCostReportServer)
		})
		resp, err = s.trGenerateDetailedCostReportServer.Do(req)
	case "GenerateDetailedCostReportOperationResultsClient":
		initServer(s, &s.trGenerateDetailedCostReportOperationResultsServer, func() *GenerateDetailedCostReportOperationResultsServerTransport {
			return NewGenerateDetailedCostReportOperationResultsServerTransport(&s.srv.GenerateDetailedCostReportOperationResultsServer)
		})
		resp, err = s.trGenerateDetailedCostReportOperationResultsServer.Do(req)
	case "GenerateDetailedCostReportOperationStatusClient":
		initServer(s, &s.trGenerateDetailedCostReportOperationStatusServer, func() *GenerateDetailedCostReportOperationStatusServerTransport {
			return NewGenerateDetailedCostReportOperationStatusServerTransport(&s.srv.GenerateDetailedCostReportOperationStatusServer)
		})
		resp, err = s.trGenerateDetailedCostReportOperationStatusServer.Do(req)
	case "GenerateReservationDetailsReportClient":
		initServer(s, &s.trGenerateReservationDetailsReportServer, func() *GenerateReservationDetailsReportServerTransport {
			return NewGenerateReservationDetailsReportServerTransport(&s.srv.GenerateReservationDetailsReportServer)
		})
		resp, err = s.trGenerateReservationDetailsReportServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "PriceSheetClient":
		initServer(s, &s.trPriceSheetServer, func() *PriceSheetServerTransport { return NewPriceSheetServerTransport(&s.srv.PriceSheetServer) })
		resp, err = s.trPriceSheetServer.Do(req)
	case "QueryClient":
		initServer(s, &s.trQueryServer, func() *QueryServerTransport { return NewQueryServerTransport(&s.srv.QueryServer) })
		resp, err = s.trQueryServer.Do(req)
	case "ScheduledActionsClient":
		initServer(s, &s.trScheduledActionsServer, func() *ScheduledActionsServerTransport {
			return NewScheduledActionsServerTransport(&s.srv.ScheduledActionsServer)
		})
		resp, err = s.trScheduledActionsServer.Do(req)
	case "ViewsClient":
		initServer(s, &s.trViewsServer, func() *ViewsServerTransport { return NewViewsServerTransport(&s.srv.ViewsServer) })
		resp, err = s.trViewsServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
