//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/containerregistry/armcontainerregistry"
	"net/http"
	"net/url"
	"regexp"
)

// WebhooksServer is a fake server for instances of the armcontainerregistry.WebhooksClient type.
type WebhooksServer struct {
	// BeginCreate is the fake for method WebhooksClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, resourceGroupName string, registryName string, webhookName string, webhookCreateParameters armcontainerregistry.WebhookCreateParameters, options *armcontainerregistry.WebhooksClientBeginCreateOptions) (resp azfake.PollerResponder[armcontainerregistry.WebhooksClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method WebhooksClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, registryName string, webhookName string, options *armcontainerregistry.WebhooksClientBeginDeleteOptions) (resp azfake.PollerResponder[armcontainerregistry.WebhooksClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method WebhooksClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, registryName string, webhookName string, options *armcontainerregistry.WebhooksClientGetOptions) (resp azfake.Responder[armcontainerregistry.WebhooksClientGetResponse], errResp azfake.ErrorResponder)

	// GetCallbackConfig is the fake for method WebhooksClient.GetCallbackConfig
	// HTTP status codes to indicate success: http.StatusOK
	GetCallbackConfig func(ctx context.Context, resourceGroupName string, registryName string, webhookName string, options *armcontainerregistry.WebhooksClientGetCallbackConfigOptions) (resp azfake.Responder[armcontainerregistry.WebhooksClientGetCallbackConfigResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method WebhooksClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, registryName string, options *armcontainerregistry.WebhooksClientListOptions) (resp azfake.PagerResponder[armcontainerregistry.WebhooksClientListResponse])

	// NewListEventsPager is the fake for method WebhooksClient.NewListEventsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListEventsPager func(resourceGroupName string, registryName string, webhookName string, options *armcontainerregistry.WebhooksClientListEventsOptions) (resp azfake.PagerResponder[armcontainerregistry.WebhooksClientListEventsResponse])

	// Ping is the fake for method WebhooksClient.Ping
	// HTTP status codes to indicate success: http.StatusOK
	Ping func(ctx context.Context, resourceGroupName string, registryName string, webhookName string, options *armcontainerregistry.WebhooksClientPingOptions) (resp azfake.Responder[armcontainerregistry.WebhooksClientPingResponse], errResp azfake.ErrorResponder)

	// BeginUpdate is the fake for method WebhooksClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginUpdate func(ctx context.Context, resourceGroupName string, registryName string, webhookName string, webhookUpdateParameters armcontainerregistry.WebhookUpdateParameters, options *armcontainerregistry.WebhooksClientBeginUpdateOptions) (resp azfake.PollerResponder[armcontainerregistry.WebhooksClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewWebhooksServerTransport creates a new instance of WebhooksServerTransport with the provided implementation.
// The returned WebhooksServerTransport instance is connected to an instance of armcontainerregistry.WebhooksClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewWebhooksServerTransport(srv *WebhooksServer) *WebhooksServerTransport {
	return &WebhooksServerTransport{
		srv:                srv,
		beginCreate:        newTracker[azfake.PollerResponder[armcontainerregistry.WebhooksClientCreateResponse]](),
		beginDelete:        newTracker[azfake.PollerResponder[armcontainerregistry.WebhooksClientDeleteResponse]](),
		newListPager:       newTracker[azfake.PagerResponder[armcontainerregistry.WebhooksClientListResponse]](),
		newListEventsPager: newTracker[azfake.PagerResponder[armcontainerregistry.WebhooksClientListEventsResponse]](),
		beginUpdate:        newTracker[azfake.PollerResponder[armcontainerregistry.WebhooksClientUpdateResponse]](),
	}
}

// WebhooksServerTransport connects instances of armcontainerregistry.WebhooksClient to instances of WebhooksServer.
// Don't use this type directly, use NewWebhooksServerTransport instead.
type WebhooksServerTransport struct {
	srv                *WebhooksServer
	beginCreate        *tracker[azfake.PollerResponder[armcontainerregistry.WebhooksClientCreateResponse]]
	beginDelete        *tracker[azfake.PollerResponder[armcontainerregistry.WebhooksClientDeleteResponse]]
	newListPager       *tracker[azfake.PagerResponder[armcontainerregistry.WebhooksClientListResponse]]
	newListEventsPager *tracker[azfake.PagerResponder[armcontainerregistry.WebhooksClientListEventsResponse]]
	beginUpdate        *tracker[azfake.PollerResponder[armcontainerregistry.WebhooksClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for WebhooksServerTransport.
func (w *WebhooksServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "WebhooksClient.BeginCreate":
		resp, err = w.dispatchBeginCreate(req)
	case "WebhooksClient.BeginDelete":
		resp, err = w.dispatchBeginDelete(req)
	case "WebhooksClient.Get":
		resp, err = w.dispatchGet(req)
	case "WebhooksClient.GetCallbackConfig":
		resp, err = w.dispatchGetCallbackConfig(req)
	case "WebhooksClient.NewListPager":
		resp, err = w.dispatchNewListPager(req)
	case "WebhooksClient.NewListEventsPager":
		resp, err = w.dispatchNewListEventsPager(req)
	case "WebhooksClient.Ping":
		resp, err = w.dispatchPing(req)
	case "WebhooksClient.BeginUpdate":
		resp, err = w.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (w *WebhooksServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if w.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := w.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerRegistry/registries/(?P<registryName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/webhooks/(?P<webhookName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcontainerregistry.WebhookCreateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		registryNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("registryName")])
		if err != nil {
			return nil, err
		}
		webhookNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("webhookName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginCreate(req.Context(), resourceGroupNameParam, registryNameParam, webhookNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		w.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		w.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		w.beginCreate.remove(req)
	}

	return resp, nil
}

func (w *WebhooksServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if w.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := w.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerRegistry/registries/(?P<registryName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/webhooks/(?P<webhookName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		registryNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("registryName")])
		if err != nil {
			return nil, err
		}
		webhookNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("webhookName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginDelete(req.Context(), resourceGroupNameParam, registryNameParam, webhookNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		w.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		w.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		w.beginDelete.remove(req)
	}

	return resp, nil
}

func (w *WebhooksServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if w.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerRegistry/registries/(?P<registryName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/webhooks/(?P<webhookName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	registryNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("registryName")])
	if err != nil {
		return nil, err
	}
	webhookNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("webhookName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.Get(req.Context(), resourceGroupNameParam, registryNameParam, webhookNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Webhook, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebhooksServerTransport) dispatchGetCallbackConfig(req *http.Request) (*http.Response, error) {
	if w.srv.GetCallbackConfig == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetCallbackConfig not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerRegistry/registries/(?P<registryName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/webhooks/(?P<webhookName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getCallbackConfig`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	registryNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("registryName")])
	if err != nil {
		return nil, err
	}
	webhookNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("webhookName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetCallbackConfig(req.Context(), resourceGroupNameParam, registryNameParam, webhookNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CallbackConfig, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebhooksServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := w.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerRegistry/registries/(?P<registryName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/webhooks`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		registryNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("registryName")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListPager(resourceGroupNameParam, registryNameParam, nil)
		newListPager = &resp
		w.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armcontainerregistry.WebhooksClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		w.newListPager.remove(req)
	}
	return resp, nil
}

func (w *WebhooksServerTransport) dispatchNewListEventsPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListEventsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListEventsPager not implemented")}
	}
	newListEventsPager := w.newListEventsPager.get(req)
	if newListEventsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerRegistry/registries/(?P<registryName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/webhooks/(?P<webhookName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listEvents`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		registryNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("registryName")])
		if err != nil {
			return nil, err
		}
		webhookNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("webhookName")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListEventsPager(resourceGroupNameParam, registryNameParam, webhookNameParam, nil)
		newListEventsPager = &resp
		w.newListEventsPager.add(req, newListEventsPager)
		server.PagerResponderInjectNextLinks(newListEventsPager, req, func(page *armcontainerregistry.WebhooksClientListEventsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListEventsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListEventsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListEventsPager) {
		w.newListEventsPager.remove(req)
	}
	return resp, nil
}

func (w *WebhooksServerTransport) dispatchPing(req *http.Request) (*http.Response, error) {
	if w.srv.Ping == nil {
		return nil, &nonRetriableError{errors.New("fake for method Ping not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerRegistry/registries/(?P<registryName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/webhooks/(?P<webhookName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/ping`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	registryNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("registryName")])
	if err != nil {
		return nil, err
	}
	webhookNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("webhookName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.Ping(req.Context(), resourceGroupNameParam, registryNameParam, webhookNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).EventInfo, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebhooksServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if w.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := w.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerRegistry/registries/(?P<registryName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/webhooks/(?P<webhookName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcontainerregistry.WebhookUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		registryNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("registryName")])
		if err != nil {
			return nil, err
		}
		webhookNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("webhookName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginUpdate(req.Context(), resourceGroupNameParam, registryNameParam, webhookNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		w.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		w.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		w.beginUpdate.remove(req)
	}

	return resp, nil
}
