//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/consumption/armconsumption"
	"net/http"
	"net/url"
	"regexp"
)

// CreditsServer is a fake server for instances of the armconsumption.CreditsClient type.
type CreditsServer struct {
	// Get is the fake for method CreditsClient.Get
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Get func(ctx context.Context, billingAccountID string, billingProfileID string, options *armconsumption.CreditsClientGetOptions) (resp azfake.Responder[armconsumption.CreditsClientGetResponse], errResp azfake.ErrorResponder)
}

// NewCreditsServerTransport creates a new instance of CreditsServerTransport with the provided implementation.
// The returned CreditsServerTransport instance is connected to an instance of armconsumption.CreditsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewCreditsServerTransport(srv *CreditsServer) *CreditsServerTransport {
	return &CreditsServerTransport{srv: srv}
}

// CreditsServerTransport connects instances of armconsumption.CreditsClient to instances of CreditsServer.
// Don't use this type directly, use NewCreditsServerTransport instead.
type CreditsServerTransport struct {
	srv *CreditsServer
}

// Do implements the policy.Transporter interface for CreditsServerTransport.
func (c *CreditsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "CreditsClient.Get":
		resp, err = c.dispatchGet(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *CreditsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if c.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingProfiles/(?P<billingProfileId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Consumption/credits/balanceSummary`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	billingAccountIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountId")])
	if err != nil {
		return nil, err
	}
	billingProfileIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingProfileId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Get(req.Context(), billingAccountIDParam, billingProfileIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CreditSummary, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
