//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/consumption/armconsumption"
	"net/http"
	"net/url"
	"regexp"
)

// AggregatedCostServer is a fake server for instances of the armconsumption.AggregatedCostClient type.
type AggregatedCostServer struct {
	// GetByManagementGroup is the fake for method AggregatedCostClient.GetByManagementGroup
	// HTTP status codes to indicate success: http.StatusOK
	GetByManagementGroup func(ctx context.Context, managementGroupID string, options *armconsumption.AggregatedCostClientGetByManagementGroupOptions) (resp azfake.Responder[armconsumption.AggregatedCostClientGetByManagementGroupResponse], errResp azfake.ErrorResponder)

	// GetForBillingPeriodByManagementGroup is the fake for method AggregatedCostClient.GetForBillingPeriodByManagementGroup
	// HTTP status codes to indicate success: http.StatusOK
	GetForBillingPeriodByManagementGroup func(ctx context.Context, managementGroupID string, billingPeriodName string, options *armconsumption.AggregatedCostClientGetForBillingPeriodByManagementGroupOptions) (resp azfake.Responder[armconsumption.AggregatedCostClientGetForBillingPeriodByManagementGroupResponse], errResp azfake.ErrorResponder)
}

// NewAggregatedCostServerTransport creates a new instance of AggregatedCostServerTransport with the provided implementation.
// The returned AggregatedCostServerTransport instance is connected to an instance of armconsumption.AggregatedCostClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAggregatedCostServerTransport(srv *AggregatedCostServer) *AggregatedCostServerTransport {
	return &AggregatedCostServerTransport{srv: srv}
}

// AggregatedCostServerTransport connects instances of armconsumption.AggregatedCostClient to instances of AggregatedCostServer.
// Don't use this type directly, use NewAggregatedCostServerTransport instead.
type AggregatedCostServerTransport struct {
	srv *AggregatedCostServer
}

// Do implements the policy.Transporter interface for AggregatedCostServerTransport.
func (a *AggregatedCostServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AggregatedCostClient.GetByManagementGroup":
		resp, err = a.dispatchGetByManagementGroup(req)
	case "AggregatedCostClient.GetForBillingPeriodByManagementGroup":
		resp, err = a.dispatchGetForBillingPeriodByManagementGroup(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AggregatedCostServerTransport) dispatchGetByManagementGroup(req *http.Request) (*http.Response, error) {
	if a.srv.GetByManagementGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetByManagementGroup not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<managementGroupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Consumption/aggregatedcost`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	managementGroupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("managementGroupId")])
	if err != nil {
		return nil, err
	}
	filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
	if err != nil {
		return nil, err
	}
	filterParam := getOptional(filterUnescaped)
	var options *armconsumption.AggregatedCostClientGetByManagementGroupOptions
	if filterParam != nil {
		options = &armconsumption.AggregatedCostClientGetByManagementGroupOptions{
			Filter: filterParam,
		}
	}
	respr, errRespr := a.srv.GetByManagementGroup(req.Context(), managementGroupIDParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ManagementGroupAggregatedCostResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AggregatedCostServerTransport) dispatchGetForBillingPeriodByManagementGroup(req *http.Request) (*http.Response, error) {
	if a.srv.GetForBillingPeriodByManagementGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetForBillingPeriodByManagementGroup not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<managementGroupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Billing/billingPeriods/(?P<billingPeriodName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Consumption/aggregatedCost`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	managementGroupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("managementGroupId")])
	if err != nil {
		return nil, err
	}
	billingPeriodNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingPeriodName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.GetForBillingPeriodByManagementGroup(req.Context(), managementGroupIDParam, billingPeriodNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ManagementGroupAggregatedCostResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
