//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// Code generated by Microsoft (R) AutoRest Code Generator.Changes may cause incorrect behavior and will be lost if the code
// is regenerated.
// Code generated by @autorest/go. DO NOT EDIT.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/connectedvmware/armconnectedvmware"
	"net/http"
	"net/url"
	"regexp"
)

// VMInstanceGuestAgentsServer is a fake server for instances of the armconnectedvmware.VMInstanceGuestAgentsClient type.
type VMInstanceGuestAgentsServer struct {
	// BeginCreate is the fake for method VMInstanceGuestAgentsClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, resourceURI string, body armconnectedvmware.GuestAgent, options *armconnectedvmware.VMInstanceGuestAgentsClientBeginCreateOptions) (resp azfake.PollerResponder[armconnectedvmware.VMInstanceGuestAgentsClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method VMInstanceGuestAgentsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceURI string, options *armconnectedvmware.VMInstanceGuestAgentsClientBeginDeleteOptions) (resp azfake.PollerResponder[armconnectedvmware.VMInstanceGuestAgentsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method VMInstanceGuestAgentsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceURI string, options *armconnectedvmware.VMInstanceGuestAgentsClientGetOptions) (resp azfake.Responder[armconnectedvmware.VMInstanceGuestAgentsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method VMInstanceGuestAgentsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceURI string, options *armconnectedvmware.VMInstanceGuestAgentsClientListOptions) (resp azfake.PagerResponder[armconnectedvmware.VMInstanceGuestAgentsClientListResponse])
}

// NewVMInstanceGuestAgentsServerTransport creates a new instance of VMInstanceGuestAgentsServerTransport with the provided implementation.
// The returned VMInstanceGuestAgentsServerTransport instance is connected to an instance of armconnectedvmware.VMInstanceGuestAgentsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewVMInstanceGuestAgentsServerTransport(srv *VMInstanceGuestAgentsServer) *VMInstanceGuestAgentsServerTransport {
	return &VMInstanceGuestAgentsServerTransport{
		srv:          srv,
		beginCreate:  newTracker[azfake.PollerResponder[armconnectedvmware.VMInstanceGuestAgentsClientCreateResponse]](),
		beginDelete:  newTracker[azfake.PollerResponder[armconnectedvmware.VMInstanceGuestAgentsClientDeleteResponse]](),
		newListPager: newTracker[azfake.PagerResponder[armconnectedvmware.VMInstanceGuestAgentsClientListResponse]](),
	}
}

// VMInstanceGuestAgentsServerTransport connects instances of armconnectedvmware.VMInstanceGuestAgentsClient to instances of VMInstanceGuestAgentsServer.
// Don't use this type directly, use NewVMInstanceGuestAgentsServerTransport instead.
type VMInstanceGuestAgentsServerTransport struct {
	srv          *VMInstanceGuestAgentsServer
	beginCreate  *tracker[azfake.PollerResponder[armconnectedvmware.VMInstanceGuestAgentsClientCreateResponse]]
	beginDelete  *tracker[azfake.PollerResponder[armconnectedvmware.VMInstanceGuestAgentsClientDeleteResponse]]
	newListPager *tracker[azfake.PagerResponder[armconnectedvmware.VMInstanceGuestAgentsClientListResponse]]
}

// Do implements the policy.Transporter interface for VMInstanceGuestAgentsServerTransport.
func (v *VMInstanceGuestAgentsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "VMInstanceGuestAgentsClient.BeginCreate":
		resp, err = v.dispatchBeginCreate(req)
	case "VMInstanceGuestAgentsClient.BeginDelete":
		resp, err = v.dispatchBeginDelete(req)
	case "VMInstanceGuestAgentsClient.Get":
		resp, err = v.dispatchGet(req)
	case "VMInstanceGuestAgentsClient.NewListPager":
		resp, err = v.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (v *VMInstanceGuestAgentsServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if v.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := v.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/(?P<resourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ConnectedVMwarevSphere/virtualMachineInstances/default/guestAgents/default`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armconnectedvmware.GuestAgent](req)
		if err != nil {
			return nil, err
		}
		resourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceUri")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginCreate(req.Context(), resourceURIParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		v.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		v.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		v.beginCreate.remove(req)
	}

	return resp, nil
}

func (v *VMInstanceGuestAgentsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if v.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := v.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/(?P<resourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ConnectedVMwarevSphere/virtualMachineInstances/default/guestAgents/default`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceUri")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginDelete(req.Context(), resourceURIParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		v.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		v.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		v.beginDelete.remove(req)
	}

	return resp, nil
}

func (v *VMInstanceGuestAgentsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if v.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/(?P<resourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ConnectedVMwarevSphere/virtualMachineInstances/default/guestAgents/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceUri")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.Get(req.Context(), resourceURIParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).GuestAgent, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *VMInstanceGuestAgentsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if v.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := v.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/(?P<resourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ConnectedVMwarevSphere/virtualMachineInstances/default/guestAgents`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceUri")])
		if err != nil {
			return nil, err
		}
		resp := v.srv.NewListPager(resourceURIParam, nil)
		newListPager = &resp
		v.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armconnectedvmware.VMInstanceGuestAgentsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		v.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		v.newListPager.remove(req)
	}
	return resp, nil
}
