//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armbotservice

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - Azure Subscription ID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewBotConnectionClient creates a new instance of BotConnectionClient.
func (c *ClientFactory) NewBotConnectionClient() *BotConnectionClient {
	subClient, _ := NewBotConnectionClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewBotsClient creates a new instance of BotsClient.
func (c *ClientFactory) NewBotsClient() *BotsClient {
	subClient, _ := NewBotsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewChannelsClient creates a new instance of ChannelsClient.
func (c *ClientFactory) NewChannelsClient() *ChannelsClient {
	subClient, _ := NewChannelsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDirectLineClient creates a new instance of DirectLineClient.
func (c *ClientFactory) NewDirectLineClient() *DirectLineClient {
	subClient, _ := NewDirectLineClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewEmailClient creates a new instance of EmailClient.
func (c *ClientFactory) NewEmailClient() *EmailClient {
	subClient, _ := NewEmailClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewHostSettingsClient creates a new instance of HostSettingsClient.
func (c *ClientFactory) NewHostSettingsClient() *HostSettingsClient {
	subClient, _ := NewHostSettingsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationResultsClient creates a new instance of OperationResultsClient.
func (c *ClientFactory) NewOperationResultsClient() *OperationResultsClient {
	subClient, _ := NewOperationResultsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewPrivateEndpointConnectionsClient creates a new instance of PrivateEndpointConnectionsClient.
func (c *ClientFactory) NewPrivateEndpointConnectionsClient() *PrivateEndpointConnectionsClient {
	subClient, _ := NewPrivateEndpointConnectionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateLinkResourcesClient creates a new instance of PrivateLinkResourcesClient.
func (c *ClientFactory) NewPrivateLinkResourcesClient() *PrivateLinkResourcesClient {
	subClient, _ := NewPrivateLinkResourcesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewQnAMakerEndpointKeysClient creates a new instance of QnAMakerEndpointKeysClient.
func (c *ClientFactory) NewQnAMakerEndpointKeysClient() *QnAMakerEndpointKeysClient {
	subClient, _ := NewQnAMakerEndpointKeysClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
