//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armblueprint

import "time"

// Artifact - Represents a blueprint artifact.
type Artifact struct {
	// REQUIRED; Specifies the kind of blueprint artifact.
	Kind *ArtifactKind

	// READ-ONLY; String Id used to locate any resource on Azure.
	ID *string

	// READ-ONLY; Name of this resource.
	Name *string

	// READ-ONLY; Type of this resource.
	Type *string
}

// GetArtifact implements the ArtifactClassification interface for type Artifact.
func (a *Artifact) GetArtifact() *Artifact { return a }

// ArtifactList - List of blueprint artifacts.
type ArtifactList struct {
	// List of blueprint artifacts.
	Value []ArtifactClassification

	// READ-ONLY; Link to the next page of results.
	NextLink *string
}

// Assignment - Represents a blueprint assignment.
type Assignment struct {
	// REQUIRED; Managed identity for this blueprint assignment.
	Identity *ManagedServiceIdentity

	// REQUIRED; The location of this blueprint assignment.
	Location *string

	// REQUIRED; Properties for blueprint assignment object.
	Properties *AssignmentProperties

	// READ-ONLY; String Id used to locate any resource on Azure.
	ID *string

	// READ-ONLY; Name of this resource.
	Name *string

	// READ-ONLY; Type of this resource.
	Type *string
}

// AssignmentDeploymentJob - Represents individual job in given blueprint assignment operation.
type AssignmentDeploymentJob struct {
	// Name of the action performed in this job.
	Action *string

	// Result of this deployment job for each retry.
	History []*AssignmentDeploymentJobResult

	// Id of this job.
	JobID *string

	// State of this job.
	JobState *string

	// Kind of job.
	Kind *string

	// Reference to deployment job resource id.
	RequestURI *string

	// Deployment job result.
	Result *AssignmentDeploymentJobResult
}

// AssignmentDeploymentJobResult - Result of each individual deployment in a blueprint assignment.
type AssignmentDeploymentJobResult struct {
	// Contains error details if deployment job failed.
	Error *AzureResourceManagerError

	// Resources created as result of the deployment job.
	Resources []*AssignmentJobCreatedResource
}

// AssignmentJobCreatedResource - Azure resource created from deployment job.
type AssignmentJobCreatedResource struct {
	// Additional properties in a dictionary.
	Properties map[string]*string

	// READ-ONLY; String Id used to locate any resource on Azure.
	ID *string

	// READ-ONLY; Name of this resource.
	Name *string

	// READ-ONLY; Type of this resource.
	Type *string
}

// AssignmentList - List of blueprint assignments
type AssignmentList struct {
	// List of blueprint assignments.
	Value []*Assignment

	// READ-ONLY; Link to the next page of results.
	NextLink *string
}

// AssignmentLockSettings - Defines how resources deployed by a blueprint assignment are locked.
type AssignmentLockSettings struct {
	// List of management operations that are excluded from blueprint locks. Up to 200 actions are permitted. If the lock mode
	// is set to 'AllResourcesReadOnly', then the following actions are automatically
	// appended to 'excludedActions': '*/read', 'Microsoft.Network/virtualNetworks/subnets/join/action' and 'Microsoft.Authorization/locks/delete'.
	// If the lock mode is set to 'AllResourcesDoNotDelete', then
	// the following actions are automatically appended to 'excludedActions': 'Microsoft.Authorization/locks/delete'. Duplicate
	// actions will get removed.
	ExcludedActions []*string

	// List of AAD principals excluded from blueprint locks. Up to 5 principals are permitted.
	ExcludedPrincipals []*string

	// Lock mode.
	Mode *AssignmentLockMode
}

// AssignmentOperation - Represents underlying deployment detail for each update to the blueprint assignment.
type AssignmentOperation struct {
	// Properties for AssignmentOperation.
	Properties *AssignmentOperationProperties

	// READ-ONLY; String Id used to locate any resource on Azure.
	ID *string

	// READ-ONLY; Name of this resource.
	Name *string

	// READ-ONLY; Type of this resource.
	Type *string
}

// AssignmentOperationList - List of AssignmentOperation.
type AssignmentOperationList struct {
	// List of AssignmentOperation.
	Value []*AssignmentOperation

	// READ-ONLY; Link to the next page of results.
	NextLink *string
}

// AssignmentOperationProperties - Properties of AssignmentOperation.
type AssignmentOperationProperties struct {
	// State of this blueprint assignment operation.
	AssignmentState *string

	// The published version of the blueprint definition used for the blueprint assignment operation.
	BlueprintVersion *string

	// List of jobs in this blueprint assignment operation.
	Deployments []*AssignmentDeploymentJob

	// Create time of this blueprint assignment operation.
	TimeCreated *string

	// Finish time of the overall underlying deployments.
	TimeFinished *string

	// Start time of the underlying deployment.
	TimeStarted *string
}

// AssignmentProperties - Detailed properties for a blueprint assignment.
type AssignmentProperties struct {
	// REQUIRED; Blueprint assignment parameter values.
	Parameters map[string]*ParameterValue

	// REQUIRED; Names and locations of resource group placeholders.
	ResourceGroups map[string]*ResourceGroupValue

	// ID of the published version of a blueprint definition.
	BlueprintID *string

	// Multi-line explain this resource.
	Description *string

	// One-liner string explain this resource.
	DisplayName *string

	// Defines how resources deployed by a blueprint assignment are locked.
	Locks *AssignmentLockSettings

	// The target subscription scope of the blueprint assignment (format: '/subscriptions/{subscriptionId}'). For management group
	// level assignments, the property is required.
	Scope *string

	// READ-ONLY; State of the blueprint assignment.
	ProvisioningState *AssignmentProvisioningState

	// READ-ONLY; Status of blueprint assignment. This field is readonly.
	Status *AssignmentStatus
}

// AssignmentStatus - The status of a blueprint assignment. This field is readonly.
type AssignmentStatus struct {
	// READ-ONLY; Last modified time of this blueprint definition.
	LastModified *time.Time

	// READ-ONLY; List of resources that were created by the blueprint assignment.
	ManagedResources []*string

	// READ-ONLY; Creation time of this blueprint definition.
	TimeCreated *time.Time
}

// AzureResourceBase - Common properties for all Azure resources.
type AzureResourceBase struct {
	// READ-ONLY; String Id used to locate any resource on Azure.
	ID *string

	// READ-ONLY; Name of this resource.
	Name *string

	// READ-ONLY; Type of this resource.
	Type *string
}

// AzureResourceManagerError - Error code and message
type AzureResourceManagerError struct {
	// Error code.
	Code *string

	// Error message.
	Message *string
}

// Blueprint - Represents a Blueprint definition.
type Blueprint struct {
	// REQUIRED; Detailed properties for blueprint definition.
	Properties *Properties

	// READ-ONLY; String Id used to locate any resource on Azure.
	ID *string

	// READ-ONLY; Name of this resource.
	Name *string

	// READ-ONLY; Type of this resource.
	Type *string
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.)
type ErrorResponse struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorResponse

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// KeyVaultReference - Specifies the link to a Key Vault.
type KeyVaultReference struct {
	// REQUIRED; Azure resource ID of the Key Vault.
	ID *string
}

// List of blueprint definitions.
type List struct {
	// List of blueprint definitions.
	Value []*Blueprint

	// READ-ONLY; Link to the next page of results.
	NextLink *string
}

// ManagedServiceIdentity - Managed identity generic object.
type ManagedServiceIdentity struct {
	// REQUIRED; Type of the managed identity.
	Type *ManagedServiceIdentityType

	// Azure Active Directory principal ID associated with this Identity.
	PrincipalID *string

	// ID of the Azure Active Directory.
	TenantID *string

	// The list of user-assigned managed identities associated with the resource. Key is the Azure resource Id of the managed
	// identity.
	UserAssignedIdentities map[string]*UserAssignedIdentity
}

// ParameterDefinition - Represent a parameter with constrains and metadata.
type ParameterDefinition struct {
	// REQUIRED; Allowed data types for Resource Manager template parameters.
	Type *TemplateParameterType

	// Array of allowed values for this parameter.
	AllowedValues []any

	// Default Value for this parameter.
	DefaultValue any

	// User-friendly properties for this parameter.
	Metadata *ParameterDefinitionMetadata
}

// ParameterDefinitionMetadata - User-friendly properties for this parameter.
type ParameterDefinitionMetadata struct {
	// Description of this parameter/resourceGroup.
	Description *string

	// DisplayName of this parameter/resourceGroup.
	DisplayName *string

	// StrongType for UI to render rich experience during blueprint assignment. Supported strong types are resourceType, principalId
	// and location.
	StrongType *string
}

// ParameterValue - Value for the specified parameter. Can be either 'value' or 'reference' but not both.
type ParameterValue struct {
	// Parameter value as reference type.
	Reference *SecretValueReference

	// Parameter value. Any valid JSON value is allowed including objects, arrays, strings, numbers and booleans.
	Value any
}

// PolicyAssignmentArtifact - Blueprint artifact that applies a Policy assignment.
type PolicyAssignmentArtifact struct {
	// REQUIRED; Specifies the kind of blueprint artifact.
	Kind *ArtifactKind

	// REQUIRED; properties for policyAssignment Artifact
	Properties *PolicyAssignmentArtifactProperties

	// READ-ONLY; String Id used to locate any resource on Azure.
	ID *string

	// READ-ONLY; Name of this resource.
	Name *string

	// READ-ONLY; Type of this resource.
	Type *string
}

// GetArtifact implements the ArtifactClassification interface for type PolicyAssignmentArtifact.
func (p *PolicyAssignmentArtifact) GetArtifact() *Artifact {
	return &Artifact{
		ID:   p.ID,
		Kind: p.Kind,
		Name: p.Name,
		Type: p.Type,
	}
}

// PolicyAssignmentArtifactProperties - Properties of a Policy assignment blueprint artifact.
type PolicyAssignmentArtifactProperties struct {
	// REQUIRED; Parameter values for the policy definition.
	Parameters map[string]*ParameterValue

	// REQUIRED; Azure resource ID of the policy definition.
	PolicyDefinitionID *string

	// Artifacts which need to be deployed before the specified artifact.
	DependsOn []*string

	// Multi-line explain this resource.
	Description *string

	// One-liner string explain this resource.
	DisplayName *string

	// Name of the resource group placeholder to which the policy will be assigned.
	ResourceGroup *string
}

// Properties - Schema for blueprint definition properties.
type Properties struct {
	// Multi-line explain this resource.
	Description *string

	// One-liner string explain this resource.
	DisplayName *string

	// Parameters required by this blueprint definition.
	Parameters map[string]*ParameterDefinition

	// Resource group placeholders defined by this blueprint definition.
	ResourceGroups map[string]*ResourceGroupDefinition

	// The scope where this blueprint definition can be assigned.
	TargetScope *BlueprintTargetScope

	// Published versions of this blueprint definition.
	Versions any

	// READ-ONLY; Layout view of the blueprint definition for UI reference.
	Layout any

	// READ-ONLY; Status of the blueprint. This field is readonly.
	Status *Status
}

// PublishedBlueprint - Represents a published blueprint.
type PublishedBlueprint struct {
	// REQUIRED; Detailed properties for published blueprint.
	Properties *PublishedBlueprintProperties

	// READ-ONLY; String Id used to locate any resource on Azure.
	ID *string

	// READ-ONLY; Name of this resource.
	Name *string

	// READ-ONLY; Type of this resource.
	Type *string
}

// PublishedBlueprintList - List of published blueprint definitions.
type PublishedBlueprintList struct {
	// List of published blueprint definitions.
	Value []*PublishedBlueprint

	// READ-ONLY; Link to the next page of results.
	NextLink *string
}

// PublishedBlueprintProperties - Schema for published blueprint definition properties.
type PublishedBlueprintProperties struct {
	// Name of the published blueprint definition.
	BlueprintName *string

	// Version-specific change notes.
	ChangeNotes *string

	// Multi-line explain this resource.
	Description *string

	// One-liner string explain this resource.
	DisplayName *string

	// Parameters required by this blueprint definition.
	Parameters map[string]*ParameterDefinition

	// Resource group placeholders defined by this blueprint definition.
	ResourceGroups map[string]*ResourceGroupDefinition

	// The scope where this blueprint definition can be assigned.
	TargetScope *BlueprintTargetScope

	// READ-ONLY; Status of the blueprint. This field is readonly.
	Status *Status
}

// ResourceGroupDefinition - Represents an Azure resource group in a blueprint definition.
type ResourceGroupDefinition struct {
	// Artifacts which need to be deployed before this resource group.
	DependsOn []*string

	// Location of this resourceGroup. Leave empty if the resource group location will be specified during the blueprint assignment.
	Location *string

	// User-friendly properties for this resource group.
	Metadata *ParameterDefinitionMetadata

	// Name of this resourceGroup. Leave empty if the resource group name will be specified during the blueprint assignment.
	Name *string

	// Tags to be assigned to this resource group.
	Tags map[string]*string
}

// ResourceGroupValue - Represents an Azure resource group.
type ResourceGroupValue struct {
	// Location of the resource group.
	Location *string

	// Name of the resource group.
	Name *string
}

// ResourceProviderOperation - Supported operations of this resource provider.
type ResourceProviderOperation struct {
	// Display metadata associated with the operation.
	Display *ResourceProviderOperationDisplay

	// Operation name, in format of {provider}/{resource}/{operation}
	Name *string
}

// ResourceProviderOperationDisplay - Display metadata associated with the operation.
type ResourceProviderOperationDisplay struct {
	// Description of this operation.
	Description *string

	// Type of operation: get, read, delete, etc.
	Operation *string

	// Resource provider: Microsoft Blueprint.
	Provider *string

	// Resource on which the operation is performed.
	Resource *string
}

// ResourceProviderOperationList - Results of the request to list operations.
type ResourceProviderOperationList struct {
	// List of operations supported by this resource provider.
	Value []*ResourceProviderOperation
}

// ResourceStatusBase - Shared status properties between all blueprint resources.
type ResourceStatusBase struct {
	// READ-ONLY; Last modified time of this blueprint definition.
	LastModified *time.Time

	// READ-ONLY; Creation time of this blueprint definition.
	TimeCreated *time.Time
}

// RoleAssignmentArtifact - Blueprint artifact that applies a Role assignment.
type RoleAssignmentArtifact struct {
	// REQUIRED; Specifies the kind of blueprint artifact.
	Kind *ArtifactKind

	// REQUIRED; Properties for a Role assignment blueprint artifact.
	Properties *RoleAssignmentArtifactProperties

	// READ-ONLY; String Id used to locate any resource on Azure.
	ID *string

	// READ-ONLY; Name of this resource.
	Name *string

	// READ-ONLY; Type of this resource.
	Type *string
}

// GetArtifact implements the ArtifactClassification interface for type RoleAssignmentArtifact.
func (r *RoleAssignmentArtifact) GetArtifact() *Artifact {
	return &Artifact{
		ID:   r.ID,
		Kind: r.Kind,
		Name: r.Name,
		Type: r.Type,
	}
}

// RoleAssignmentArtifactProperties - Properties of a Role assignment blueprint artifact.
type RoleAssignmentArtifactProperties struct {
	// REQUIRED; Array of user or group identities in Azure Active Directory. The roleDefinition will apply to each identity.
	PrincipalIDs any

	// REQUIRED; Azure resource ID of the RoleDefinition.
	RoleDefinitionID *string

	// Artifacts which need to be deployed before the specified artifact.
	DependsOn []*string

	// Multi-line explain this resource.
	Description *string

	// One-liner string explain this resource.
	DisplayName *string

	// RoleAssignment will be scope to this resourceGroup. If empty, it scopes to the subscription.
	ResourceGroup *string
}

// SecretValueReference - Reference to a Key Vault secret.
type SecretValueReference struct {
	// REQUIRED; Specifies the reference to a given Azure Key Vault.
	KeyVault *KeyVaultReference

	// REQUIRED; Name of the secret.
	SecretName *string

	// The version of the secret to use. If left blank, the latest version of the secret is used.
	SecretVersion *string
}

// Status - The status of the blueprint. This field is readonly.
type Status struct {
	// READ-ONLY; Last modified time of this blueprint definition.
	LastModified *time.Time

	// READ-ONLY; Creation time of this blueprint definition.
	TimeCreated *time.Time
}

// TemplateArtifact - Blueprint artifact that deploys a Resource Manager template.
type TemplateArtifact struct {
	// REQUIRED; Specifies the kind of blueprint artifact.
	Kind *ArtifactKind

	// REQUIRED; Properties for a Resource Manager template blueprint artifact.
	Properties *TemplateArtifactProperties

	// READ-ONLY; String Id used to locate any resource on Azure.
	ID *string

	// READ-ONLY; Name of this resource.
	Name *string

	// READ-ONLY; Type of this resource.
	Type *string
}

// GetArtifact implements the ArtifactClassification interface for type TemplateArtifact.
func (t *TemplateArtifact) GetArtifact() *Artifact {
	return &Artifact{
		ID:   t.ID,
		Kind: t.Kind,
		Name: t.Name,
		Type: t.Type,
	}
}

// TemplateArtifactProperties - Properties of a Resource Manager template blueprint artifact.
type TemplateArtifactProperties struct {
	// REQUIRED; Resource Manager template blueprint artifact parameter values.
	Parameters map[string]*ParameterValue

	// REQUIRED; The Resource Manager template blueprint artifact body.
	Template any

	// Artifacts which need to be deployed before the specified artifact.
	DependsOn []*string

	// Multi-line explain this resource.
	Description *string

	// One-liner string explain this resource.
	DisplayName *string

	// If applicable, the name of the resource group placeholder to which the Resource Manager template blueprint artifact will
	// be deployed.
	ResourceGroup *string
}

// TrackedResource - Common properties for all Azure tracked resources.
type TrackedResource struct {
	// REQUIRED; The location of this blueprint assignment.
	Location *string

	// READ-ONLY; String Id used to locate any resource on Azure.
	ID *string

	// READ-ONLY; Name of this resource.
	Name *string

	// READ-ONLY; Type of this resource.
	Type *string
}

// UserAssignedIdentity - User-assigned managed identity.
type UserAssignedIdentity struct {
	// Client App Id associated with this identity.
	ClientID *string

	// Azure Active Directory principal ID associated with this Identity.
	PrincipalID *string
}

// WhoIsBlueprintContract - Response schema for querying the Azure Blueprints service principal in the tenant.
type WhoIsBlueprintContract struct {
	// AAD object Id of the Azure Blueprints service principal in the tenant.
	ObjectID *string
}
