//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armbilling

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// SubscriptionsClient contains the methods for the BillingSubscriptions group.
// Don't use this type directly, use NewSubscriptionsClient() instead.
type SubscriptionsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewSubscriptionsClient creates a new instance of SubscriptionsClient with the specified values.
//   - subscriptionID - The ID that uniquely identifies an Azure subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewSubscriptionsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*SubscriptionsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &SubscriptionsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// Get - Gets a subscription by its ID. The operation is supported for billing accounts with agreement type Microsoft Customer
// Agreement and Microsoft Partner Agreement.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-05-01
//   - billingAccountName - The ID that uniquely identifies a billing account.
//   - options - SubscriptionsClientGetOptions contains the optional parameters for the SubscriptionsClient.Get method.
func (client *SubscriptionsClient) Get(ctx context.Context, billingAccountName string, options *SubscriptionsClientGetOptions) (SubscriptionsClientGetResponse, error) {
	var err error
	const operationName = "SubscriptionsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, billingAccountName, options)
	if err != nil {
		return SubscriptionsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SubscriptionsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SubscriptionsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *SubscriptionsClient) getCreateRequest(ctx context.Context, billingAccountName string, options *SubscriptionsClientGetOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingSubscriptions/{subscriptionId}"
	if billingAccountName == "" {
		return nil, errors.New("parameter billingAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingAccountName}", url.PathEscape(billingAccountName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *SubscriptionsClient) getHandleResponse(resp *http.Response) (SubscriptionsClientGetResponse, error) {
	result := SubscriptionsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Subscription); err != nil {
		return SubscriptionsClientGetResponse{}, err
	}
	return result, nil
}

// NewListByBillingAccountPager - Lists the subscriptions for a billing account. The operation is supported for billing accounts
// with agreement type Microsoft Customer Agreement or Microsoft Partner Agreement.
//
// Generated from API version 2020-05-01
//   - billingAccountName - The ID that uniquely identifies a billing account.
//   - options - SubscriptionsClientListByBillingAccountOptions contains the optional parameters for the SubscriptionsClient.NewListByBillingAccountPager
//     method.
func (client *SubscriptionsClient) NewListByBillingAccountPager(billingAccountName string, options *SubscriptionsClientListByBillingAccountOptions) *runtime.Pager[SubscriptionsClientListByBillingAccountResponse] {
	return runtime.NewPager(runtime.PagingHandler[SubscriptionsClientListByBillingAccountResponse]{
		More: func(page SubscriptionsClientListByBillingAccountResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SubscriptionsClientListByBillingAccountResponse) (SubscriptionsClientListByBillingAccountResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "SubscriptionsClient.NewListByBillingAccountPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByBillingAccountCreateRequest(ctx, billingAccountName, options)
			}, nil)
			if err != nil {
				return SubscriptionsClientListByBillingAccountResponse{}, err
			}
			return client.listByBillingAccountHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByBillingAccountCreateRequest creates the ListByBillingAccount request.
func (client *SubscriptionsClient) listByBillingAccountCreateRequest(ctx context.Context, billingAccountName string, options *SubscriptionsClientListByBillingAccountOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingSubscriptions"
	if billingAccountName == "" {
		return nil, errors.New("parameter billingAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingAccountName}", url.PathEscape(billingAccountName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByBillingAccountHandleResponse handles the ListByBillingAccount response.
func (client *SubscriptionsClient) listByBillingAccountHandleResponse(resp *http.Response) (SubscriptionsClientListByBillingAccountResponse, error) {
	result := SubscriptionsClientListByBillingAccountResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SubscriptionsListResult); err != nil {
		return SubscriptionsClientListByBillingAccountResponse{}, err
	}
	return result, nil
}

// NewListByBillingProfilePager - Lists the subscriptions that are billed to a billing profile. The operation is supported
// for billing accounts with agreement type Microsoft Customer Agreement or Microsoft Partner Agreement.
//
// Generated from API version 2020-05-01
//   - billingAccountName - The ID that uniquely identifies a billing account.
//   - billingProfileName - The ID that uniquely identifies a billing profile.
//   - options - SubscriptionsClientListByBillingProfileOptions contains the optional parameters for the SubscriptionsClient.NewListByBillingProfilePager
//     method.
func (client *SubscriptionsClient) NewListByBillingProfilePager(billingAccountName string, billingProfileName string, options *SubscriptionsClientListByBillingProfileOptions) *runtime.Pager[SubscriptionsClientListByBillingProfileResponse] {
	return runtime.NewPager(runtime.PagingHandler[SubscriptionsClientListByBillingProfileResponse]{
		More: func(page SubscriptionsClientListByBillingProfileResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SubscriptionsClientListByBillingProfileResponse) (SubscriptionsClientListByBillingProfileResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "SubscriptionsClient.NewListByBillingProfilePager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByBillingProfileCreateRequest(ctx, billingAccountName, billingProfileName, options)
			}, nil)
			if err != nil {
				return SubscriptionsClientListByBillingProfileResponse{}, err
			}
			return client.listByBillingProfileHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByBillingProfileCreateRequest creates the ListByBillingProfile request.
func (client *SubscriptionsClient) listByBillingProfileCreateRequest(ctx context.Context, billingAccountName string, billingProfileName string, options *SubscriptionsClientListByBillingProfileOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/billingSubscriptions"
	if billingAccountName == "" {
		return nil, errors.New("parameter billingAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingAccountName}", url.PathEscape(billingAccountName))
	if billingProfileName == "" {
		return nil, errors.New("parameter billingProfileName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingProfileName}", url.PathEscape(billingProfileName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByBillingProfileHandleResponse handles the ListByBillingProfile response.
func (client *SubscriptionsClient) listByBillingProfileHandleResponse(resp *http.Response) (SubscriptionsClientListByBillingProfileResponse, error) {
	result := SubscriptionsClientListByBillingProfileResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SubscriptionsListResult); err != nil {
		return SubscriptionsClientListByBillingProfileResponse{}, err
	}
	return result, nil
}

// NewListByCustomerPager - Lists the subscriptions for a customer. The operation is supported only for billing accounts with
// agreement type Microsoft Partner Agreement.
//
// Generated from API version 2020-05-01
//   - billingAccountName - The ID that uniquely identifies a billing account.
//   - customerName - The ID that uniquely identifies a customer.
//   - options - SubscriptionsClientListByCustomerOptions contains the optional parameters for the SubscriptionsClient.NewListByCustomerPager
//     method.
func (client *SubscriptionsClient) NewListByCustomerPager(billingAccountName string, customerName string, options *SubscriptionsClientListByCustomerOptions) *runtime.Pager[SubscriptionsClientListByCustomerResponse] {
	return runtime.NewPager(runtime.PagingHandler[SubscriptionsClientListByCustomerResponse]{
		More: func(page SubscriptionsClientListByCustomerResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SubscriptionsClientListByCustomerResponse) (SubscriptionsClientListByCustomerResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "SubscriptionsClient.NewListByCustomerPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByCustomerCreateRequest(ctx, billingAccountName, customerName, options)
			}, nil)
			if err != nil {
				return SubscriptionsClientListByCustomerResponse{}, err
			}
			return client.listByCustomerHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByCustomerCreateRequest creates the ListByCustomer request.
func (client *SubscriptionsClient) listByCustomerCreateRequest(ctx context.Context, billingAccountName string, customerName string, options *SubscriptionsClientListByCustomerOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/customers/{customerName}/billingSubscriptions"
	if billingAccountName == "" {
		return nil, errors.New("parameter billingAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingAccountName}", url.PathEscape(billingAccountName))
	if customerName == "" {
		return nil, errors.New("parameter customerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{customerName}", url.PathEscape(customerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByCustomerHandleResponse handles the ListByCustomer response.
func (client *SubscriptionsClient) listByCustomerHandleResponse(resp *http.Response) (SubscriptionsClientListByCustomerResponse, error) {
	result := SubscriptionsClientListByCustomerResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SubscriptionsListResult); err != nil {
		return SubscriptionsClientListByCustomerResponse{}, err
	}
	return result, nil
}

// NewListByInvoiceSectionPager - Lists the subscriptions that are billed to an invoice section. The operation is supported
// only for billing accounts with agreement type Microsoft Customer Agreement.
//
// Generated from API version 2020-05-01
//   - billingAccountName - The ID that uniquely identifies a billing account.
//   - billingProfileName - The ID that uniquely identifies a billing profile.
//   - invoiceSectionName - The ID that uniquely identifies an invoice section.
//   - options - SubscriptionsClientListByInvoiceSectionOptions contains the optional parameters for the SubscriptionsClient.NewListByInvoiceSectionPager
//     method.
func (client *SubscriptionsClient) NewListByInvoiceSectionPager(billingAccountName string, billingProfileName string, invoiceSectionName string, options *SubscriptionsClientListByInvoiceSectionOptions) *runtime.Pager[SubscriptionsClientListByInvoiceSectionResponse] {
	return runtime.NewPager(runtime.PagingHandler[SubscriptionsClientListByInvoiceSectionResponse]{
		More: func(page SubscriptionsClientListByInvoiceSectionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SubscriptionsClientListByInvoiceSectionResponse) (SubscriptionsClientListByInvoiceSectionResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "SubscriptionsClient.NewListByInvoiceSectionPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByInvoiceSectionCreateRequest(ctx, billingAccountName, billingProfileName, invoiceSectionName, options)
			}, nil)
			if err != nil {
				return SubscriptionsClientListByInvoiceSectionResponse{}, err
			}
			return client.listByInvoiceSectionHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByInvoiceSectionCreateRequest creates the ListByInvoiceSection request.
func (client *SubscriptionsClient) listByInvoiceSectionCreateRequest(ctx context.Context, billingAccountName string, billingProfileName string, invoiceSectionName string, options *SubscriptionsClientListByInvoiceSectionOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}/billingSubscriptions"
	if billingAccountName == "" {
		return nil, errors.New("parameter billingAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingAccountName}", url.PathEscape(billingAccountName))
	if billingProfileName == "" {
		return nil, errors.New("parameter billingProfileName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingProfileName}", url.PathEscape(billingProfileName))
	if invoiceSectionName == "" {
		return nil, errors.New("parameter invoiceSectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{invoiceSectionName}", url.PathEscape(invoiceSectionName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByInvoiceSectionHandleResponse handles the ListByInvoiceSection response.
func (client *SubscriptionsClient) listByInvoiceSectionHandleResponse(resp *http.Response) (SubscriptionsClientListByInvoiceSectionResponse, error) {
	result := SubscriptionsClientListByInvoiceSectionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SubscriptionsListResult); err != nil {
		return SubscriptionsClientListByInvoiceSectionResponse{}, err
	}
	return result, nil
}

// BeginMove - Moves a subscription's charges to a new invoice section. The new invoice section must belong to the same billing
// profile as the existing invoice section. This operation is supported for billing
// accounts with agreement type Microsoft Customer Agreement.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-05-01
//   - billingAccountName - The ID that uniquely identifies a billing account.
//   - parameters - Request parameters that are provided to the move subscription operation.
//   - options - SubscriptionsClientBeginMoveOptions contains the optional parameters for the SubscriptionsClient.BeginMove method.
func (client *SubscriptionsClient) BeginMove(ctx context.Context, billingAccountName string, parameters TransferBillingSubscriptionRequestProperties, options *SubscriptionsClientBeginMoveOptions) (*runtime.Poller[SubscriptionsClientMoveResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.move(ctx, billingAccountName, parameters, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[SubscriptionsClientMoveResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[SubscriptionsClientMoveResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Move - Moves a subscription's charges to a new invoice section. The new invoice section must belong to the same billing
// profile as the existing invoice section. This operation is supported for billing
// accounts with agreement type Microsoft Customer Agreement.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-05-01
func (client *SubscriptionsClient) move(ctx context.Context, billingAccountName string, parameters TransferBillingSubscriptionRequestProperties, options *SubscriptionsClientBeginMoveOptions) (*http.Response, error) {
	var err error
	const operationName = "SubscriptionsClient.BeginMove"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.moveCreateRequest(ctx, billingAccountName, parameters, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// moveCreateRequest creates the Move request.
func (client *SubscriptionsClient) moveCreateRequest(ctx context.Context, billingAccountName string, parameters TransferBillingSubscriptionRequestProperties, options *SubscriptionsClientBeginMoveOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingSubscriptions/{subscriptionId}/move"
	if billingAccountName == "" {
		return nil, errors.New("parameter billingAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingAccountName}", url.PathEscape(billingAccountName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// Update - Updates the properties of a billing subscription. Currently, cost center can be updated. The operation is supported
// only for billing accounts with agreement type Microsoft Customer Agreement.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-05-01
//   - billingAccountName - The ID that uniquely identifies a billing account.
//   - parameters - Request parameters that are provided to the update billing subscription operation.
//   - options - SubscriptionsClientUpdateOptions contains the optional parameters for the SubscriptionsClient.Update method.
func (client *SubscriptionsClient) Update(ctx context.Context, billingAccountName string, parameters Subscription, options *SubscriptionsClientUpdateOptions) (SubscriptionsClientUpdateResponse, error) {
	var err error
	const operationName = "SubscriptionsClient.Update"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, billingAccountName, parameters, options)
	if err != nil {
		return SubscriptionsClientUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SubscriptionsClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SubscriptionsClientUpdateResponse{}, err
	}
	resp, err := client.updateHandleResponse(httpResp)
	return resp, err
}

// updateCreateRequest creates the Update request.
func (client *SubscriptionsClient) updateCreateRequest(ctx context.Context, billingAccountName string, parameters Subscription, options *SubscriptionsClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingSubscriptions/{subscriptionId}"
	if billingAccountName == "" {
		return nil, errors.New("parameter billingAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingAccountName}", url.PathEscape(billingAccountName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// updateHandleResponse handles the Update response.
func (client *SubscriptionsClient) updateHandleResponse(resp *http.Response) (SubscriptionsClientUpdateResponse, error) {
	result := SubscriptionsClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Subscription); err != nil {
		return SubscriptionsClientUpdateResponse{}, err
	}
	return result, nil
}

// ValidateMove - Validates if a subscription's charges can be moved to a new invoice section. This operation is supported
// for billing accounts with agreement type Microsoft Customer Agreement.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-05-01
//   - billingAccountName - The ID that uniquely identifies a billing account.
//   - parameters - Request parameters that are provided to the validate move eligibility operation.
//   - options - SubscriptionsClientValidateMoveOptions contains the optional parameters for the SubscriptionsClient.ValidateMove
//     method.
func (client *SubscriptionsClient) ValidateMove(ctx context.Context, billingAccountName string, parameters TransferBillingSubscriptionRequestProperties, options *SubscriptionsClientValidateMoveOptions) (SubscriptionsClientValidateMoveResponse, error) {
	var err error
	const operationName = "SubscriptionsClient.ValidateMove"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.validateMoveCreateRequest(ctx, billingAccountName, parameters, options)
	if err != nil {
		return SubscriptionsClientValidateMoveResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SubscriptionsClientValidateMoveResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SubscriptionsClientValidateMoveResponse{}, err
	}
	resp, err := client.validateMoveHandleResponse(httpResp)
	return resp, err
}

// validateMoveCreateRequest creates the ValidateMove request.
func (client *SubscriptionsClient) validateMoveCreateRequest(ctx context.Context, billingAccountName string, parameters TransferBillingSubscriptionRequestProperties, options *SubscriptionsClientValidateMoveOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingSubscriptions/{subscriptionId}/validateMoveEligibility"
	if billingAccountName == "" {
		return nil, errors.New("parameter billingAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingAccountName}", url.PathEscape(billingAccountName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// validateMoveHandleResponse handles the ValidateMove response.
func (client *SubscriptionsClient) validateMoveHandleResponse(resp *http.Response) (SubscriptionsClientValidateMoveResponse, error) {
	result := SubscriptionsClientValidateMoveResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ValidateSubscriptionTransferEligibilityResult); err != nil {
		return SubscriptionsClientValidateMoveResponse{}, err
	}
	return result, nil
}
