//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/automanage/armautomanage"
	"net/http"
	"net/url"
	"regexp"
)

// ConfigurationProfilesVersionsServer is a fake server for instances of the armautomanage.ConfigurationProfilesVersionsClient type.
type ConfigurationProfilesVersionsServer struct {
	// CreateOrUpdate is the fake for method ConfigurationProfilesVersionsClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, configurationProfileName string, versionName string, resourceGroupName string, parameters armautomanage.ConfigurationProfile, options *armautomanage.ConfigurationProfilesVersionsClientCreateOrUpdateOptions) (resp azfake.Responder[armautomanage.ConfigurationProfilesVersionsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method ConfigurationProfilesVersionsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, configurationProfileName string, versionName string, options *armautomanage.ConfigurationProfilesVersionsClientDeleteOptions) (resp azfake.Responder[armautomanage.ConfigurationProfilesVersionsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ConfigurationProfilesVersionsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, configurationProfileName string, versionName string, resourceGroupName string, options *armautomanage.ConfigurationProfilesVersionsClientGetOptions) (resp azfake.Responder[armautomanage.ConfigurationProfilesVersionsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListChildResourcesPager is the fake for method ConfigurationProfilesVersionsClient.NewListChildResourcesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListChildResourcesPager func(configurationProfileName string, resourceGroupName string, options *armautomanage.ConfigurationProfilesVersionsClientListChildResourcesOptions) (resp azfake.PagerResponder[armautomanage.ConfigurationProfilesVersionsClientListChildResourcesResponse])
}

// NewConfigurationProfilesVersionsServerTransport creates a new instance of ConfigurationProfilesVersionsServerTransport with the provided implementation.
// The returned ConfigurationProfilesVersionsServerTransport instance is connected to an instance of armautomanage.ConfigurationProfilesVersionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewConfigurationProfilesVersionsServerTransport(srv *ConfigurationProfilesVersionsServer) *ConfigurationProfilesVersionsServerTransport {
	return &ConfigurationProfilesVersionsServerTransport{
		srv:                        srv,
		newListChildResourcesPager: newTracker[azfake.PagerResponder[armautomanage.ConfigurationProfilesVersionsClientListChildResourcesResponse]](),
	}
}

// ConfigurationProfilesVersionsServerTransport connects instances of armautomanage.ConfigurationProfilesVersionsClient to instances of ConfigurationProfilesVersionsServer.
// Don't use this type directly, use NewConfigurationProfilesVersionsServerTransport instead.
type ConfigurationProfilesVersionsServerTransport struct {
	srv                        *ConfigurationProfilesVersionsServer
	newListChildResourcesPager *tracker[azfake.PagerResponder[armautomanage.ConfigurationProfilesVersionsClientListChildResourcesResponse]]
}

// Do implements the policy.Transporter interface for ConfigurationProfilesVersionsServerTransport.
func (c *ConfigurationProfilesVersionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ConfigurationProfilesVersionsClient.CreateOrUpdate":
		resp, err = c.dispatchCreateOrUpdate(req)
	case "ConfigurationProfilesVersionsClient.Delete":
		resp, err = c.dispatchDelete(req)
	case "ConfigurationProfilesVersionsClient.Get":
		resp, err = c.dispatchGet(req)
	case "ConfigurationProfilesVersionsClient.NewListChildResourcesPager":
		resp, err = c.dispatchNewListChildResourcesPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *ConfigurationProfilesVersionsServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if c.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automanage/configurationProfiles/(?P<configurationProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/versions/(?P<versionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armautomanage.ConfigurationProfile](req)
	if err != nil {
		return nil, err
	}
	configurationProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("configurationProfileName")])
	if err != nil {
		return nil, err
	}
	versionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("versionName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.CreateOrUpdate(req.Context(), configurationProfileNameParam, versionNameParam, resourceGroupNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ConfigurationProfile, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ConfigurationProfilesVersionsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if c.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automanage/configurationProfiles/(?P<configurationProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/versions/(?P<versionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	configurationProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("configurationProfileName")])
	if err != nil {
		return nil, err
	}
	versionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("versionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Delete(req.Context(), resourceGroupNameParam, configurationProfileNameParam, versionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ConfigurationProfilesVersionsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if c.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automanage/configurationProfiles/(?P<configurationProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/versions/(?P<versionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	configurationProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("configurationProfileName")])
	if err != nil {
		return nil, err
	}
	versionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("versionName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Get(req.Context(), configurationProfileNameParam, versionNameParam, resourceGroupNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ConfigurationProfile, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ConfigurationProfilesVersionsServerTransport) dispatchNewListChildResourcesPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListChildResourcesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListChildResourcesPager not implemented")}
	}
	newListChildResourcesPager := c.newListChildResourcesPager.get(req)
	if newListChildResourcesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automanage/configurationProfiles/(?P<configurationProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/versions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		configurationProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("configurationProfileName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListChildResourcesPager(configurationProfileNameParam, resourceGroupNameParam, nil)
		newListChildResourcesPager = &resp
		c.newListChildResourcesPager.add(req, newListChildResourcesPager)
	}
	resp, err := server.PagerResponderNext(newListChildResourcesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListChildResourcesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListChildResourcesPager) {
		c.newListChildResourcesPager.remove(req)
	}
	return resp, nil
}
