//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/authorization/armauthorization/v3"
	"net/http"
	"net/url"
)

// AccessReviewScheduleDefinitionsAssignedForMyApprovalServer is a fake server for instances of the armauthorization.AccessReviewScheduleDefinitionsAssignedForMyApprovalClient type.
type AccessReviewScheduleDefinitionsAssignedForMyApprovalServer struct {
	// NewListPager is the fake for method AccessReviewScheduleDefinitionsAssignedForMyApprovalClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armauthorization.AccessReviewScheduleDefinitionsAssignedForMyApprovalClientListOptions) (resp azfake.PagerResponder[armauthorization.AccessReviewScheduleDefinitionsAssignedForMyApprovalClientListResponse])
}

// NewAccessReviewScheduleDefinitionsAssignedForMyApprovalServerTransport creates a new instance of AccessReviewScheduleDefinitionsAssignedForMyApprovalServerTransport with the provided implementation.
// The returned AccessReviewScheduleDefinitionsAssignedForMyApprovalServerTransport instance is connected to an instance of armauthorization.AccessReviewScheduleDefinitionsAssignedForMyApprovalClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAccessReviewScheduleDefinitionsAssignedForMyApprovalServerTransport(srv *AccessReviewScheduleDefinitionsAssignedForMyApprovalServer) *AccessReviewScheduleDefinitionsAssignedForMyApprovalServerTransport {
	return &AccessReviewScheduleDefinitionsAssignedForMyApprovalServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armauthorization.AccessReviewScheduleDefinitionsAssignedForMyApprovalClientListResponse]](),
	}
}

// AccessReviewScheduleDefinitionsAssignedForMyApprovalServerTransport connects instances of armauthorization.AccessReviewScheduleDefinitionsAssignedForMyApprovalClient to instances of AccessReviewScheduleDefinitionsAssignedForMyApprovalServer.
// Don't use this type directly, use NewAccessReviewScheduleDefinitionsAssignedForMyApprovalServerTransport instead.
type AccessReviewScheduleDefinitionsAssignedForMyApprovalServerTransport struct {
	srv          *AccessReviewScheduleDefinitionsAssignedForMyApprovalServer
	newListPager *tracker[azfake.PagerResponder[armauthorization.AccessReviewScheduleDefinitionsAssignedForMyApprovalClientListResponse]]
}

// Do implements the policy.Transporter interface for AccessReviewScheduleDefinitionsAssignedForMyApprovalServerTransport.
func (a *AccessReviewScheduleDefinitionsAssignedForMyApprovalServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AccessReviewScheduleDefinitionsAssignedForMyApprovalClient.NewListPager":
		resp, err = a.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AccessReviewScheduleDefinitionsAssignedForMyApprovalServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := a.newListPager.get(req)
	if newListPager == nil {
		qp := req.URL.Query()
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armauthorization.AccessReviewScheduleDefinitionsAssignedForMyApprovalClientListOptions
		if filterParam != nil {
			options = &armauthorization.AccessReviewScheduleDefinitionsAssignedForMyApprovalClientListOptions{
				Filter: filterParam,
			}
		}
		resp := a.srv.NewListPager(options)
		newListPager = &resp
		a.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armauthorization.AccessReviewScheduleDefinitionsAssignedForMyApprovalClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		a.newListPager.remove(req)
	}
	return resp, nil
}
