//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appservice/armappservice/v2"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// DomainsServer is a fake server for instances of the armappservice.DomainsClient type.
type DomainsServer struct {
	// CheckAvailability is the fake for method DomainsClient.CheckAvailability
	// HTTP status codes to indicate success: http.StatusOK
	CheckAvailability func(ctx context.Context, identifier armappservice.NameIdentifier, options *armappservice.DomainsClientCheckAvailabilityOptions) (resp azfake.Responder[armappservice.DomainsClientCheckAvailabilityResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdate is the fake for method DomainsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, domainName string, domain armappservice.Domain, options *armappservice.DomainsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armappservice.DomainsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateOwnershipIdentifier is the fake for method DomainsClient.CreateOrUpdateOwnershipIdentifier
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdateOwnershipIdentifier func(ctx context.Context, resourceGroupName string, domainName string, name string, domainOwnershipIdentifier armappservice.DomainOwnershipIdentifier, options *armappservice.DomainsClientCreateOrUpdateOwnershipIdentifierOptions) (resp azfake.Responder[armappservice.DomainsClientCreateOrUpdateOwnershipIdentifierResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method DomainsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, domainName string, options *armappservice.DomainsClientDeleteOptions) (resp azfake.Responder[armappservice.DomainsClientDeleteResponse], errResp azfake.ErrorResponder)

	// DeleteOwnershipIdentifier is the fake for method DomainsClient.DeleteOwnershipIdentifier
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteOwnershipIdentifier func(ctx context.Context, resourceGroupName string, domainName string, name string, options *armappservice.DomainsClientDeleteOwnershipIdentifierOptions) (resp azfake.Responder[armappservice.DomainsClientDeleteOwnershipIdentifierResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method DomainsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, domainName string, options *armappservice.DomainsClientGetOptions) (resp azfake.Responder[armappservice.DomainsClientGetResponse], errResp azfake.ErrorResponder)

	// GetControlCenterSsoRequest is the fake for method DomainsClient.GetControlCenterSsoRequest
	// HTTP status codes to indicate success: http.StatusOK
	GetControlCenterSsoRequest func(ctx context.Context, options *armappservice.DomainsClientGetControlCenterSsoRequestOptions) (resp azfake.Responder[armappservice.DomainsClientGetControlCenterSsoRequestResponse], errResp azfake.ErrorResponder)

	// GetOwnershipIdentifier is the fake for method DomainsClient.GetOwnershipIdentifier
	// HTTP status codes to indicate success: http.StatusOK
	GetOwnershipIdentifier func(ctx context.Context, resourceGroupName string, domainName string, name string, options *armappservice.DomainsClientGetOwnershipIdentifierOptions) (resp azfake.Responder[armappservice.DomainsClientGetOwnershipIdentifierResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method DomainsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armappservice.DomainsClientListOptions) (resp azfake.PagerResponder[armappservice.DomainsClientListResponse])

	// NewListByResourceGroupPager is the fake for method DomainsClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armappservice.DomainsClientListByResourceGroupOptions) (resp azfake.PagerResponder[armappservice.DomainsClientListByResourceGroupResponse])

	// NewListOwnershipIdentifiersPager is the fake for method DomainsClient.NewListOwnershipIdentifiersPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListOwnershipIdentifiersPager func(resourceGroupName string, domainName string, options *armappservice.DomainsClientListOwnershipIdentifiersOptions) (resp azfake.PagerResponder[armappservice.DomainsClientListOwnershipIdentifiersResponse])

	// NewListRecommendationsPager is the fake for method DomainsClient.NewListRecommendationsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListRecommendationsPager func(parameters armappservice.DomainRecommendationSearchParameters, options *armappservice.DomainsClientListRecommendationsOptions) (resp azfake.PagerResponder[armappservice.DomainsClientListRecommendationsResponse])

	// Renew is the fake for method DomainsClient.Renew
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	Renew func(ctx context.Context, resourceGroupName string, domainName string, options *armappservice.DomainsClientRenewOptions) (resp azfake.Responder[armappservice.DomainsClientRenewResponse], errResp azfake.ErrorResponder)

	// TransferOut is the fake for method DomainsClient.TransferOut
	// HTTP status codes to indicate success: http.StatusOK
	TransferOut func(ctx context.Context, resourceGroupName string, domainName string, options *armappservice.DomainsClientTransferOutOptions) (resp azfake.Responder[armappservice.DomainsClientTransferOutResponse], errResp azfake.ErrorResponder)

	// Update is the fake for method DomainsClient.Update
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	Update func(ctx context.Context, resourceGroupName string, domainName string, domain armappservice.DomainPatchResource, options *armappservice.DomainsClientUpdateOptions) (resp azfake.Responder[armappservice.DomainsClientUpdateResponse], errResp azfake.ErrorResponder)

	// UpdateOwnershipIdentifier is the fake for method DomainsClient.UpdateOwnershipIdentifier
	// HTTP status codes to indicate success: http.StatusOK
	UpdateOwnershipIdentifier func(ctx context.Context, resourceGroupName string, domainName string, name string, domainOwnershipIdentifier armappservice.DomainOwnershipIdentifier, options *armappservice.DomainsClientUpdateOwnershipIdentifierOptions) (resp azfake.Responder[armappservice.DomainsClientUpdateOwnershipIdentifierResponse], errResp azfake.ErrorResponder)
}

// NewDomainsServerTransport creates a new instance of DomainsServerTransport with the provided implementation.
// The returned DomainsServerTransport instance is connected to an instance of armappservice.DomainsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDomainsServerTransport(srv *DomainsServer) *DomainsServerTransport {
	return &DomainsServerTransport{
		srv:                              srv,
		beginCreateOrUpdate:              newTracker[azfake.PollerResponder[armappservice.DomainsClientCreateOrUpdateResponse]](),
		newListPager:                     newTracker[azfake.PagerResponder[armappservice.DomainsClientListResponse]](),
		newListByResourceGroupPager:      newTracker[azfake.PagerResponder[armappservice.DomainsClientListByResourceGroupResponse]](),
		newListOwnershipIdentifiersPager: newTracker[azfake.PagerResponder[armappservice.DomainsClientListOwnershipIdentifiersResponse]](),
		newListRecommendationsPager:      newTracker[azfake.PagerResponder[armappservice.DomainsClientListRecommendationsResponse]](),
	}
}

// DomainsServerTransport connects instances of armappservice.DomainsClient to instances of DomainsServer.
// Don't use this type directly, use NewDomainsServerTransport instead.
type DomainsServerTransport struct {
	srv                              *DomainsServer
	beginCreateOrUpdate              *tracker[azfake.PollerResponder[armappservice.DomainsClientCreateOrUpdateResponse]]
	newListPager                     *tracker[azfake.PagerResponder[armappservice.DomainsClientListResponse]]
	newListByResourceGroupPager      *tracker[azfake.PagerResponder[armappservice.DomainsClientListByResourceGroupResponse]]
	newListOwnershipIdentifiersPager *tracker[azfake.PagerResponder[armappservice.DomainsClientListOwnershipIdentifiersResponse]]
	newListRecommendationsPager      *tracker[azfake.PagerResponder[armappservice.DomainsClientListRecommendationsResponse]]
}

// Do implements the policy.Transporter interface for DomainsServerTransport.
func (d *DomainsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DomainsClient.CheckAvailability":
		resp, err = d.dispatchCheckAvailability(req)
	case "DomainsClient.BeginCreateOrUpdate":
		resp, err = d.dispatchBeginCreateOrUpdate(req)
	case "DomainsClient.CreateOrUpdateOwnershipIdentifier":
		resp, err = d.dispatchCreateOrUpdateOwnershipIdentifier(req)
	case "DomainsClient.Delete":
		resp, err = d.dispatchDelete(req)
	case "DomainsClient.DeleteOwnershipIdentifier":
		resp, err = d.dispatchDeleteOwnershipIdentifier(req)
	case "DomainsClient.Get":
		resp, err = d.dispatchGet(req)
	case "DomainsClient.GetControlCenterSsoRequest":
		resp, err = d.dispatchGetControlCenterSsoRequest(req)
	case "DomainsClient.GetOwnershipIdentifier":
		resp, err = d.dispatchGetOwnershipIdentifier(req)
	case "DomainsClient.NewListPager":
		resp, err = d.dispatchNewListPager(req)
	case "DomainsClient.NewListByResourceGroupPager":
		resp, err = d.dispatchNewListByResourceGroupPager(req)
	case "DomainsClient.NewListOwnershipIdentifiersPager":
		resp, err = d.dispatchNewListOwnershipIdentifiersPager(req)
	case "DomainsClient.NewListRecommendationsPager":
		resp, err = d.dispatchNewListRecommendationsPager(req)
	case "DomainsClient.Renew":
		resp, err = d.dispatchRenew(req)
	case "DomainsClient.TransferOut":
		resp, err = d.dispatchTransferOut(req)
	case "DomainsClient.Update":
		resp, err = d.dispatchUpdate(req)
	case "DomainsClient.UpdateOwnershipIdentifier":
		resp, err = d.dispatchUpdateOwnershipIdentifier(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DomainsServerTransport) dispatchCheckAvailability(req *http.Request) (*http.Response, error) {
	if d.srv.CheckAvailability == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckAvailability not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DomainRegistration/checkDomainAvailability`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.NameIdentifier](req)
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.CheckAvailability(req.Context(), body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DomainAvailabilityCheckResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DomainsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if d.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := d.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DomainRegistration/domains/(?P<domainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.Domain](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		domainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("domainName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, domainNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		d.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		d.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (d *DomainsServerTransport) dispatchCreateOrUpdateOwnershipIdentifier(req *http.Request) (*http.Response, error) {
	if d.srv.CreateOrUpdateOwnershipIdentifier == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateOwnershipIdentifier not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DomainRegistration/domains/(?P<domainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/domainOwnershipIdentifiers/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.DomainOwnershipIdentifier](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	domainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("domainName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.CreateOrUpdateOwnershipIdentifier(req.Context(), resourceGroupNameParam, domainNameParam, nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DomainOwnershipIdentifier, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DomainsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if d.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DomainRegistration/domains/(?P<domainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	domainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("domainName")])
	if err != nil {
		return nil, err
	}
	forceHardDeleteDomainUnescaped, err := url.QueryUnescape(qp.Get("forceHardDeleteDomain"))
	if err != nil {
		return nil, err
	}
	forceHardDeleteDomainParam, err := parseOptional(forceHardDeleteDomainUnescaped, strconv.ParseBool)
	if err != nil {
		return nil, err
	}
	var options *armappservice.DomainsClientDeleteOptions
	if forceHardDeleteDomainParam != nil {
		options = &armappservice.DomainsClientDeleteOptions{
			ForceHardDeleteDomain: forceHardDeleteDomainParam,
		}
	}
	respr, errRespr := d.srv.Delete(req.Context(), resourceGroupNameParam, domainNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DomainsServerTransport) dispatchDeleteOwnershipIdentifier(req *http.Request) (*http.Response, error) {
	if d.srv.DeleteOwnershipIdentifier == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteOwnershipIdentifier not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DomainRegistration/domains/(?P<domainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/domainOwnershipIdentifiers/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	domainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("domainName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.DeleteOwnershipIdentifier(req.Context(), resourceGroupNameParam, domainNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DomainsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if d.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DomainRegistration/domains/(?P<domainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	domainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("domainName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Get(req.Context(), resourceGroupNameParam, domainNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Domain, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DomainsServerTransport) dispatchGetControlCenterSsoRequest(req *http.Request) (*http.Response, error) {
	if d.srv.GetControlCenterSsoRequest == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetControlCenterSsoRequest not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DomainRegistration/generateSsoRequest`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	respr, errRespr := d.srv.GetControlCenterSsoRequest(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DomainControlCenterSsoRequest, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DomainsServerTransport) dispatchGetOwnershipIdentifier(req *http.Request) (*http.Response, error) {
	if d.srv.GetOwnershipIdentifier == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetOwnershipIdentifier not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DomainRegistration/domains/(?P<domainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/domainOwnershipIdentifiers/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	domainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("domainName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.GetOwnershipIdentifier(req.Context(), resourceGroupNameParam, domainNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DomainOwnershipIdentifier, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DomainsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := d.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DomainRegistration/domains`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := d.srv.NewListPager(nil)
		newListPager = &resp
		d.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armappservice.DomainsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		d.newListPager.remove(req)
	}
	return resp, nil
}

func (d *DomainsServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := d.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DomainRegistration/domains`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		d.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armappservice.DomainsClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		d.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (d *DomainsServerTransport) dispatchNewListOwnershipIdentifiersPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListOwnershipIdentifiersPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListOwnershipIdentifiersPager not implemented")}
	}
	newListOwnershipIdentifiersPager := d.newListOwnershipIdentifiersPager.get(req)
	if newListOwnershipIdentifiersPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DomainRegistration/domains/(?P<domainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/domainOwnershipIdentifiers`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		domainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("domainName")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListOwnershipIdentifiersPager(resourceGroupNameParam, domainNameParam, nil)
		newListOwnershipIdentifiersPager = &resp
		d.newListOwnershipIdentifiersPager.add(req, newListOwnershipIdentifiersPager)
		server.PagerResponderInjectNextLinks(newListOwnershipIdentifiersPager, req, func(page *armappservice.DomainsClientListOwnershipIdentifiersResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListOwnershipIdentifiersPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListOwnershipIdentifiersPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListOwnershipIdentifiersPager) {
		d.newListOwnershipIdentifiersPager.remove(req)
	}
	return resp, nil
}

func (d *DomainsServerTransport) dispatchNewListRecommendationsPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListRecommendationsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListRecommendationsPager not implemented")}
	}
	newListRecommendationsPager := d.newListRecommendationsPager.get(req)
	if newListRecommendationsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DomainRegistration/listDomainRecommendations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.DomainRecommendationSearchParameters](req)
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListRecommendationsPager(body, nil)
		newListRecommendationsPager = &resp
		d.newListRecommendationsPager.add(req, newListRecommendationsPager)
		server.PagerResponderInjectNextLinks(newListRecommendationsPager, req, func(page *armappservice.DomainsClientListRecommendationsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListRecommendationsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListRecommendationsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListRecommendationsPager) {
		d.newListRecommendationsPager.remove(req)
	}
	return resp, nil
}

func (d *DomainsServerTransport) dispatchRenew(req *http.Request) (*http.Response, error) {
	if d.srv.Renew == nil {
		return nil, &nonRetriableError{errors.New("fake for method Renew not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DomainRegistration/domains/(?P<domainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/renew`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	domainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("domainName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Renew(req.Context(), resourceGroupNameParam, domainNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DomainsServerTransport) dispatchTransferOut(req *http.Request) (*http.Response, error) {
	if d.srv.TransferOut == nil {
		return nil, &nonRetriableError{errors.New("fake for method TransferOut not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DomainRegistration/domains/(?P<domainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/transferOut`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	domainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("domainName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.TransferOut(req.Context(), resourceGroupNameParam, domainNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Domain, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DomainsServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if d.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DomainRegistration/domains/(?P<domainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.DomainPatchResource](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	domainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("domainName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Update(req.Context(), resourceGroupNameParam, domainNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusAccepted}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Domain, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DomainsServerTransport) dispatchUpdateOwnershipIdentifier(req *http.Request) (*http.Response, error) {
	if d.srv.UpdateOwnershipIdentifier == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateOwnershipIdentifier not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DomainRegistration/domains/(?P<domainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/domainOwnershipIdentifiers/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.DomainOwnershipIdentifier](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	domainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("domainName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.UpdateOwnershipIdentifier(req.Context(), resourceGroupNameParam, domainNameParam, nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DomainOwnershipIdentifier, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
