//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package azsystemevents

import "encoding/json"

func unmarshalMediaJobOutputClassification(rawMsg json.RawMessage) (MediaJobOutputClassification, error) {
	if rawMsg == nil || string(rawMsg) == "null" {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b MediaJobOutputClassification
	switch m["@odata.type"] {
	case "#Microsoft.Media.JobOutputAsset":
		b = &MediaJobOutputAsset{}
	default:
		b = &MediaJobOutput{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalMediaJobOutputClassificationArray(rawMsg json.RawMessage) ([]MediaJobOutputClassification, error) {
	if rawMsg == nil || string(rawMsg) == "null" {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]MediaJobOutputClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalMediaJobOutputClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}
