//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package azcontainerregistry

// ArtifactArchitecture - The artifact platform's architecture.
type ArtifactArchitecture string

const (
	// ArtifactArchitectureAmd64 - AMD64
	ArtifactArchitectureAmd64 ArtifactArchitecture = "amd64"
	// ArtifactArchitectureArm - ARM
	ArtifactArchitectureArm ArtifactArchitecture = "arm"
	// ArtifactArchitectureArm64 - ARM64
	ArtifactArchitectureArm64 ArtifactArchitecture = "arm64"
	// ArtifactArchitectureI386 - i386
	ArtifactArchitectureI386 ArtifactArchitecture = "386"
	// ArtifactArchitectureMips - MIPS
	ArtifactArchitectureMips ArtifactArchitecture = "mips"
	// ArtifactArchitectureMips64 - MIPS64
	ArtifactArchitectureMips64 ArtifactArchitecture = "mips64"
	// ArtifactArchitectureMips64Le - MIPS64LE
	ArtifactArchitectureMips64Le ArtifactArchitecture = "mips64le"
	// ArtifactArchitectureMipsLe - MIPSLE
	ArtifactArchitectureMipsLe ArtifactArchitecture = "mipsle"
	// ArtifactArchitecturePpc64 - PPC64
	ArtifactArchitecturePpc64 ArtifactArchitecture = "ppc64"
	// ArtifactArchitecturePpc64Le - PPC64LE
	ArtifactArchitecturePpc64Le ArtifactArchitecture = "ppc64le"
	// ArtifactArchitectureRiscV64 - RISCv64
	ArtifactArchitectureRiscV64 ArtifactArchitecture = "riscv64"
	// ArtifactArchitectureS390X - s390x
	ArtifactArchitectureS390X ArtifactArchitecture = "s390x"
	// ArtifactArchitectureWasm - Wasm
	ArtifactArchitectureWasm ArtifactArchitecture = "wasm"
)

// PossibleArtifactArchitectureValues returns the possible values for the ArtifactArchitecture const type.
func PossibleArtifactArchitectureValues() []ArtifactArchitecture {
	return []ArtifactArchitecture{
		ArtifactArchitectureAmd64,
		ArtifactArchitectureArm,
		ArtifactArchitectureArm64,
		ArtifactArchitectureI386,
		ArtifactArchitectureMips,
		ArtifactArchitectureMips64,
		ArtifactArchitectureMips64Le,
		ArtifactArchitectureMipsLe,
		ArtifactArchitecturePpc64,
		ArtifactArchitecturePpc64Le,
		ArtifactArchitectureRiscV64,
		ArtifactArchitectureS390X,
		ArtifactArchitectureWasm,
	}
}

// ArtifactManifestOrderBy - Sort options for ordering manifests in a collection.
type ArtifactManifestOrderBy string

const (
	// ArtifactManifestOrderByLastUpdatedOnAscending - Order manifest by LastUpdatedOn field, from least recently updated to most
	// recently updated.
	ArtifactManifestOrderByLastUpdatedOnAscending ArtifactManifestOrderBy = "timeasc"
	// ArtifactManifestOrderByLastUpdatedOnDescending - Order manifests by LastUpdatedOn field, from most recently updated to
	// least recently updated.
	ArtifactManifestOrderByLastUpdatedOnDescending ArtifactManifestOrderBy = "timedesc"
	// ArtifactManifestOrderByNone - Do not provide an orderby value in the request.
	ArtifactManifestOrderByNone ArtifactManifestOrderBy = "none"
)

// PossibleArtifactManifestOrderByValues returns the possible values for the ArtifactManifestOrderBy const type.
func PossibleArtifactManifestOrderByValues() []ArtifactManifestOrderBy {
	return []ArtifactManifestOrderBy{
		ArtifactManifestOrderByLastUpdatedOnAscending,
		ArtifactManifestOrderByLastUpdatedOnDescending,
		ArtifactManifestOrderByNone,
	}
}

// ArtifactOperatingSystem - The artifact platform's operating system.
type ArtifactOperatingSystem string

const (
	ArtifactOperatingSystemAix       ArtifactOperatingSystem = "aix"
	ArtifactOperatingSystemAndroid   ArtifactOperatingSystem = "android"
	ArtifactOperatingSystemDarwin    ArtifactOperatingSystem = "darwin"
	ArtifactOperatingSystemDragonfly ArtifactOperatingSystem = "dragonfly"
	ArtifactOperatingSystemFreeBsd   ArtifactOperatingSystem = "freebsd"
	ArtifactOperatingSystemIOS       ArtifactOperatingSystem = "ios"
	ArtifactOperatingSystemIllumos   ArtifactOperatingSystem = "illumos"
	ArtifactOperatingSystemJS        ArtifactOperatingSystem = "js"
	ArtifactOperatingSystemLinux     ArtifactOperatingSystem = "linux"
	ArtifactOperatingSystemNetBsd    ArtifactOperatingSystem = "netbsd"
	ArtifactOperatingSystemOpenBsd   ArtifactOperatingSystem = "openbsd"
	ArtifactOperatingSystemPlan9     ArtifactOperatingSystem = "plan9"
	ArtifactOperatingSystemSolaris   ArtifactOperatingSystem = "solaris"
	ArtifactOperatingSystemWindows   ArtifactOperatingSystem = "windows"
)

// PossibleArtifactOperatingSystemValues returns the possible values for the ArtifactOperatingSystem const type.
func PossibleArtifactOperatingSystemValues() []ArtifactOperatingSystem {
	return []ArtifactOperatingSystem{
		ArtifactOperatingSystemAix,
		ArtifactOperatingSystemAndroid,
		ArtifactOperatingSystemDarwin,
		ArtifactOperatingSystemDragonfly,
		ArtifactOperatingSystemFreeBsd,
		ArtifactOperatingSystemIOS,
		ArtifactOperatingSystemIllumos,
		ArtifactOperatingSystemJS,
		ArtifactOperatingSystemLinux,
		ArtifactOperatingSystemNetBsd,
		ArtifactOperatingSystemOpenBsd,
		ArtifactOperatingSystemPlan9,
		ArtifactOperatingSystemSolaris,
		ArtifactOperatingSystemWindows,
	}
}

// ArtifactTagOrderBy - Sort options for ordering tags in a collection.
type ArtifactTagOrderBy string

const (
	// ArtifactTagOrderByLastUpdatedOnAscending - Order tags by LastUpdatedOn field, from least recently updated to most recently
	// updated.
	ArtifactTagOrderByLastUpdatedOnAscending ArtifactTagOrderBy = "timeasc"
	// ArtifactTagOrderByLastUpdatedOnDescending - Order tags by LastUpdatedOn field, from most recently updated to least recently
	// updated.
	ArtifactTagOrderByLastUpdatedOnDescending ArtifactTagOrderBy = "timedesc"
	// ArtifactTagOrderByNone - Do not provide an orderby value in the request.
	ArtifactTagOrderByNone ArtifactTagOrderBy = "none"
)

// PossibleArtifactTagOrderByValues returns the possible values for the ArtifactTagOrderBy const type.
func PossibleArtifactTagOrderByValues() []ArtifactTagOrderBy {
	return []ArtifactTagOrderBy{
		ArtifactTagOrderByLastUpdatedOnAscending,
		ArtifactTagOrderByLastUpdatedOnDescending,
		ArtifactTagOrderByNone,
	}
}

// ContentType - Content type for upload
type ContentType string

const (
	// ContentTypeApplicationVndDockerDistributionManifestV2JSON - Content Type 'application/vnd.docker.distribution.manifest.v2+json'
	ContentTypeApplicationVndDockerDistributionManifestV2JSON ContentType = "application/vnd.docker.distribution.manifest.v2+json"
	// ContentTypeApplicationVndOciImageManifestV1JSON - Content Type 'application/vnd.oci.image.manifest.v1+json'
	ContentTypeApplicationVndOciImageManifestV1JSON ContentType = "application/vnd.oci.image.manifest.v1+json"
)

// PossibleContentTypeValues returns the possible values for the ContentType const type.
func PossibleContentTypeValues() []ContentType {
	return []ContentType{
		ContentTypeApplicationVndDockerDistributionManifestV2JSON,
		ContentTypeApplicationVndOciImageManifestV1JSON,
	}
}

// postContentSchemaGrantType - Can take a value of accesstokenrefreshtoken, or accesstoken, or refresh_token
type postContentSchemaGrantType string

const (
	postContentSchemaGrantTypeAccessToken             postContentSchemaGrantType = "access_token"
	postContentSchemaGrantTypeAccessTokenRefreshToken postContentSchemaGrantType = "access_token_refresh_token"
	postContentSchemaGrantTypeRefreshToken            postContentSchemaGrantType = "refresh_token"
)

// possiblePostContentSchemaGrantTypeValues returns the possible values for the postContentSchemaGrantType const type.
func possiblePostContentSchemaGrantTypeValues() []postContentSchemaGrantType {
	return []postContentSchemaGrantType{
		postContentSchemaGrantTypeAccessToken,
		postContentSchemaGrantTypeAccessTokenRefreshToken,
		postContentSchemaGrantTypeRefreshToken,
	}
}

// tokenGrantType - Grant type is expected to be refresh_token
type tokenGrantType string

const (
	tokenGrantTypePassword     tokenGrantType = "password"
	tokenGrantTypeRefreshToken tokenGrantType = "refresh_token"
)

// possibleTokenGrantTypeValues returns the possible values for the tokenGrantType const type.
func possibleTokenGrantTypeValues() []tokenGrantType {
	return []tokenGrantType{
		tokenGrantTypePassword,
		tokenGrantTypeRefreshToken,
	}
}
