!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubecompute_one2one_act
  use cubetools_parameters
  use cubecompute_messaging

  public :: one2one_act_comm_t,one2one_act_prog_t
  private
  !
  type one2one_act_comm_t
    procedure(cubecompute_one2one_act_ima2ima), pointer, nopass, public :: ima2ima => null()
    procedure(cubecompute_one2one_act_vis2ima), pointer, nopass, public :: vis2ima => null()
    procedure(cubecompute_one2one_act_vis2vis), pointer, nopass, public :: vis2vis => null()
    procedure(cubecompute_one2one_act_spe2spe), pointer, nopass, public :: spe2spe => null()
  contains
    procedure, public :: register_ima2ima => cubecompute_one2one_act_register_ima2ima
    procedure, public :: register_vis2ima => cubecompute_one2one_act_register_vis2ima
    procedure, public :: register_vis2vis => cubecompute_one2one_act_register_vis2vis
    procedure, public :: register_spe2spe => cubecompute_one2one_act_register_spe2spe
  end type one2one_act_comm_t
  !
  type one2one_act_prog_t
    procedure(cubecompute_one2one_act_ima2ima), pointer, nopass, public :: ima2ima => null()
    procedure(cubecompute_one2one_act_vis2ima), pointer, nopass, public :: vis2ima => null()
    procedure(cubecompute_one2one_act_vis2vis), pointer, nopass, public :: vis2vis => null()
    procedure(cubecompute_one2one_act_spe2spe), pointer, nopass, public :: spe2spe => null()
  end type one2one_act_prog_t
  !
contains
  !
  subroutine cubecompute_one2one_act_ima2ima(ie,incube,oucube,error)
    use cubeadm_image_types
    !----------------------------------------------------------------------
    ! Provides the interface for the operation
    !  R*4 image_t = R*4 image_t
    !----------------------------------------------------------------------
    integer(kind=entr_k), intent(in)    :: ie
    type(image_t),        intent(inout) :: incube
    type(image_t),        intent(inout) :: oucube
    logical,              intent(inout) :: error
  end subroutine cubecompute_one2one_act_ima2ima
  !
  subroutine cubecompute_one2one_act_vis2ima(ie,incube,oucube,error)
    use cubeadm_image_types
    use cubeadm_visi_types
    !----------------------------------------------------------------------
    ! Provides the interface for the operation
    !  C*4 visi_t = R*4 image_t
    !----------------------------------------------------------------------
    integer(kind=entr_k), intent(in)    :: ie
    type(visi_t),         intent(inout) :: incube
    type(image_t),        intent(inout) :: oucube
    logical,              intent(inout) :: error
  end subroutine cubecompute_one2one_act_vis2ima
  !
  subroutine cubecompute_one2one_act_vis2vis(ie,incube,oucube,error)
    use cubeadm_visi_types
    !----------------------------------------------------------------------
    ! Provides the interface for the operation
    !  C*4 visi_t = C*4 visi_t
    !----------------------------------------------------------------------
    integer(kind=entr_k), intent(in)    :: ie
    type(visi_t),         intent(inout) :: incube
    type(visi_t),         intent(inout) :: oucube
    logical,              intent(inout) :: error
  end subroutine cubecompute_one2one_act_vis2vis
  !
  subroutine cubecompute_one2one_act_spe2spe(ie,incube,oucube,error)
    use cubeadm_spectrum_types
    !----------------------------------------------------------------------
    ! Provides the interface for the operation
    !  R*4 spectrum_t = R*4 spectrum_t
    !----------------------------------------------------------------------
    integer(kind=entr_k), intent(in)    :: ie
    type(spectrum_t),     intent(inout) :: incube
    type(spectrum_t),     intent(inout) :: oucube
    logical,              intent(inout) :: error
  end subroutine cubecompute_one2one_act_spe2spe
  !
  !---------------------------------------------------------------------
  !
  subroutine cubecompute_one2one_act_register_ima2ima(comm,act,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(one2one_act_comm_t),                 intent(inout) :: comm
    procedure(cubecompute_one2one_act_ima2ima)               :: act
    logical,                                   intent(inout) :: error
    !
    character(len=*), parameter :: rname='ONE2ONE>ACT>REGISTER>IMA2IMA'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    comm%ima2ima => act
  end subroutine cubecompute_one2one_act_register_ima2ima
  !
  subroutine cubecompute_one2one_act_register_vis2ima(comm,act,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(one2one_act_comm_t),                 intent(inout) :: comm
    procedure(cubecompute_one2one_act_vis2ima)               :: act
    logical,                                   intent(inout) :: error
    !
    character(len=*), parameter :: rname='ONE2ONE>ACT>REGISTER>VIS2IMA'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    comm%vis2ima => act
  end subroutine cubecompute_one2one_act_register_vis2ima
  !
  subroutine cubecompute_one2one_act_register_vis2vis(comm,act,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(one2one_act_comm_t),                 intent(inout) :: comm
    procedure(cubecompute_one2one_act_vis2vis)               :: act
    logical,                                   intent(inout) :: error
    !
    character(len=*), parameter :: rname='ONE2ONE>ACT>REGISTER>VIS2VIS'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    comm%vis2vis => act
  end subroutine cubecompute_one2one_act_register_vis2vis
  !
  subroutine cubecompute_one2one_act_register_spe2spe(comm,act,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(one2one_act_comm_t),                 intent(inout) :: comm
    procedure(cubecompute_one2one_act_spe2spe)               :: act
    logical,                                   intent(inout) :: error
    !
    character(len=*), parameter :: rname='ONE2ONE>ACT>REGISTER>SPE2SPE'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    comm%spe2spe => act
  end subroutine cubecompute_one2one_act_register_spe2spe

end module cubecompute_one2one_act
!
module cubecompute_two2one_act
  use cubetools_parameters
  use cubecompute_messaging

  public :: two2one_act_comm_t,two2one_act_prog_t
  private
  !
  type two2one_act_comm_t
    procedure(cubecompute_two2one_act_imaima2ima), pointer, nopass, public :: imaima2ima => null()
    procedure(cubecompute_two2one_act_imaima2vis), pointer, nopass, public :: imaima2vis => null()
    procedure(cubecompute_two2one_act_imavis2vis), pointer, nopass, public :: imavis2vis => null()
    procedure(cubecompute_two2one_act_visima2vis), pointer, nopass, public :: visima2vis => null()
    procedure(cubecompute_two2one_act_visvis2vis), pointer, nopass, public :: visvis2vis => null()
  contains
    procedure, public :: register_imaima2ima => cubecompute_two2one_act_register_imaima2ima
    procedure, public :: register_imaima2vis => cubecompute_two2one_act_register_imaima2vis
    procedure, public :: register_imavis2vis => cubecompute_two2one_act_register_imavis2vis
    procedure, public :: register_visima2vis => cubecompute_two2one_act_register_visima2vis
    procedure, public :: register_visvis2vis => cubecompute_two2one_act_register_visvis2vis
  end type two2one_act_comm_t
  !
  type two2one_act_prog_t
    procedure(cubecompute_two2one_act_imaima2ima), pointer, nopass, public :: imaima2ima => null()
    procedure(cubecompute_two2one_act_imaima2vis), pointer, nopass, public :: imaima2vis => null()
    procedure(cubecompute_two2one_act_imavis2vis), pointer, nopass, public :: imavis2vis => null()
    procedure(cubecompute_two2one_act_visima2vis), pointer, nopass, public :: visima2vis => null()
    procedure(cubecompute_two2one_act_visvis2vis), pointer, nopass, public :: visvis2vis => null()
  end type two2one_act_prog_t
  !
contains
  !
  subroutine cubecompute_two2one_act_imaima2ima(ie,incube1,incube2,oucube,error)
    use cubeadm_image_types
    !----------------------------------------------------------------------
    ! Provides the interface for the operation
    !  R*4 image_t + R*4 image_t = R*4 image_t
    !----------------------------------------------------------------------
    integer(kind=entr_k), intent(in)    :: ie
    type(image_t),        intent(inout) :: incube1
    type(image_t),        intent(inout) :: incube2
    type(image_t),        intent(inout) :: oucube
    logical,              intent(inout) :: error
  end subroutine cubecompute_two2one_act_imaima2ima
  !
  subroutine cubecompute_two2one_act_imaima2vis(ie,incube1,incube2,oucube,error)
    use cubeadm_image_types
    use cubeadm_visi_types
    !----------------------------------------------------------------------
    ! Provides the interface for the operation
    !  R*4 image_t + R*4 image_t = C*4 visi_t
    !----------------------------------------------------------------------
    integer(kind=entr_k), intent(in)    :: ie
    type(image_t),        intent(inout) :: incube1
    type(image_t),        intent(inout) :: incube2
    type(visi_t),         intent(inout) :: oucube
    logical,              intent(inout) :: error
  end subroutine cubecompute_two2one_act_imaima2vis
  !
  subroutine cubecompute_two2one_act_imavis2vis(ie,incube1,incube2,oucube,error)
    use cubeadm_image_types
    use cubeadm_visi_types
    !----------------------------------------------------------------------
    ! Provides the interface for the operation
    !  R*4 image_t + C*4 visi_t = C*4 visi_t
    !----------------------------------------------------------------------
    integer(kind=entr_k), intent(in)    :: ie
    type(image_t),        intent(inout) :: incube1
    type(visi_t),         intent(inout) :: incube2
    type(visi_t),         intent(inout) :: oucube
    logical,              intent(inout) :: error
  end subroutine cubecompute_two2one_act_imavis2vis
  !
  subroutine cubecompute_two2one_act_visima2vis(ie,incube1,incube2,oucube,error)
    use cubeadm_image_types
    use cubeadm_visi_types
    !----------------------------------------------------------------------
    ! Provides the interface for the operation
    !  C*4 visi_t + R*4 image_t = C*4 visi_t
    !----------------------------------------------------------------------
    integer(kind=entr_k), intent(in)    :: ie
    type(visi_t),         intent(inout) :: incube1
    type(image_t),        intent(inout) :: incube2
    type(visi_t),         intent(inout) :: oucube
    logical,              intent(inout) :: error
  end subroutine cubecompute_two2one_act_visima2vis
  !
  subroutine cubecompute_two2one_act_visvis2vis(ie,incube1,incube2,oucube,error)
    use cubeadm_visi_types
    !----------------------------------------------------------------------
    ! Provides the interface for the operation
    !  C*4 visi_t + C*4 visi_t = C*4 visi_t
    !----------------------------------------------------------------------
    integer(kind=entr_k), intent(in)    :: ie
    type(visi_t),         intent(inout) :: incube1
    type(visi_t),         intent(inout) :: incube2
    type(visi_t),         intent(inout) :: oucube
    logical,              intent(inout) :: error
  end subroutine cubecompute_two2one_act_visvis2vis
  !
  subroutine cubecompute_two2one_act_register_imaima2ima(comm,act,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(two2one_act_comm_t),                    intent(inout) :: comm
    procedure(cubecompute_two2one_act_imaima2ima)               :: act
    logical,                                      intent(inout) :: error
    !
    character(len=*), parameter :: rname='TWO2ONE>ACT>REGISTER>IMAIMA2IMA'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    comm%imaima2ima => act
  end subroutine cubecompute_two2one_act_register_imaima2ima
  !
  subroutine cubecompute_two2one_act_register_imaima2vis(comm,act,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(two2one_act_comm_t),                    intent(inout) :: comm
    procedure(cubecompute_two2one_act_imaima2vis)               :: act
    logical,                                      intent(inout) :: error
    !
    character(len=*), parameter :: rname='TWO2ONE>ACT>REGISTER>IMAIMA2VIS'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    comm%imaima2vis => act
  end subroutine cubecompute_two2one_act_register_imaima2vis
  !
  subroutine cubecompute_two2one_act_register_imavis2vis(comm,act,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(two2one_act_comm_t),                    intent(inout) :: comm
    procedure(cubecompute_two2one_act_imavis2vis)               :: act
    logical,                                      intent(inout) :: error
    !
    character(len=*), parameter :: rname='TWO2ONE>ACT>REGISTER>IMAVIS2VIS'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    comm%imavis2vis => act
  end subroutine cubecompute_two2one_act_register_imavis2vis
  !
  subroutine cubecompute_two2one_act_register_visima2vis(comm,act,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(two2one_act_comm_t),                    intent(inout) :: comm
    procedure(cubecompute_two2one_act_visima2vis)               :: act
    logical,                                      intent(inout) :: error
    !
    character(len=*), parameter :: rname='TWO2ONE>ACT>REGISTER>VISIMA2VIS'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    comm%visima2vis => act
  end subroutine cubecompute_two2one_act_register_visima2vis
  !
  subroutine cubecompute_two2one_act_register_visvis2vis(comm,act,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(two2one_act_comm_t),                    intent(inout) :: comm
    procedure(cubecompute_two2one_act_visvis2vis)               :: act
    logical,                                      intent(inout) :: error
    !
    character(len=*), parameter :: rname='TWO2ONE>ACT>REGISTER>VISVIS2VIS'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    comm%visvis2vis => act
  end subroutine cubecompute_two2one_act_register_visvis2vis

end module cubecompute_two2one_act
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
