!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubecompute_weight
  use cubecompute_one2one_template
  use cubecompute_messaging
  !
  public :: cubecompute_weight_register
  private
  !
  type(one2one_comm_t) :: weight
  !
contains
  !
  subroutine cubecompute_weight_register(error)
    use cubedag_allflags
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    logical, intent(inout) :: error
    !
    character(len=*), parameter :: rname='WEIGHT>REGISTER'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    call weight%register_syntax(&
         'WEIGHT','noise',&
         code_access_imaset,[flag_weight],cubecompute_weight_command,error)
    if (error) return
    call weight%act%register_ima2ima(cubecompute_weight_prog_act,error)
    if (error) return
  end subroutine cubecompute_weight_register
  !
  subroutine cubecompute_weight_command(line,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(one2one_user_t) :: user
    character(len=*), parameter :: rname='WEIGHT>COMMAND'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    call weight%parse(line,user,error)
    if (error) return
    call weight%main(user,error)
    if (error) continue
  end subroutine cubecompute_weight_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubecompute_weight_prog_act(ie,input,weight,error)
    use cubetools_parameters
    use cubetools_nan
    use cubeadm_image_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    integer(kind=entr_k), intent(in)    :: ie
    type(image_t),        intent(inout) :: input
    type(image_t),        intent(inout) :: weight
    logical,              intent(inout) :: error
    !
    integer(kind=pixe_k) :: ix,iy
    character(len=*), parameter :: rname='WEIGHT>PROG>ACT'
    !
    call input%get(ie,error)
    if (error) return
    do iy=1,weight%ny
       do ix=1,weight%nx
          if (input%val(ix,iy).ne.0) then
             weight%val(ix,iy) = 1.0/input%val(ix,iy)**2
          else
             weight%val(ix,iy) = gr4nan
          endif
       enddo ! ix
    enddo ! iy
    call weight%put(ie,error)
    if (error) return
  end subroutine cubecompute_weight_prog_act
end module cubecompute_weight
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
