import { jsx as _jsx } from "react/jsx-runtime";
/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { renderWithProviders } from '../../test-utils/render.js';
import { describe, it, expect, vi } from 'vitest';
import { ShellConfirmationDialog } from './ShellConfirmationDialog.js';
describe('ShellConfirmationDialog', () => {
    const onConfirm = vi.fn();
    const request = {
        commands: ['ls -la', 'echo "hello"'],
        onConfirm,
    };
    it('renders correctly', () => {
        const { lastFrame } = renderWithProviders(_jsx(ShellConfirmationDialog, { request: request }), { width: 101 });
        expect(lastFrame()).toMatchSnapshot();
    });
    it('calls onConfirm with ProceedOnce when "Allow once" is selected', () => {
        const { lastFrame } = renderWithProviders(_jsx(ShellConfirmationDialog, { request: request }));
        const select = lastFrame().toString();
        // Simulate selecting the first option
        // This is a simplified way to test the selection
        expect(select).toContain('Allow once');
    });
    it('calls onConfirm with ProceedAlways when "Allow for this session" is selected', () => {
        const { lastFrame } = renderWithProviders(_jsx(ShellConfirmationDialog, { request: request }));
        const select = lastFrame().toString();
        // Simulate selecting the second option
        expect(select).toContain('Allow for this session');
    });
    it('calls onConfirm with Cancel when "No (esc)" is selected', () => {
        const { lastFrame } = renderWithProviders(_jsx(ShellConfirmationDialog, { request: request }), { width: 100 });
        const select = lastFrame().toString();
        // Simulate selecting the third option
        expect(select).toContain('No (esc)');
    });
});
//# sourceMappingURL=ShellConfirmationDialog.test.js.map