/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.internal.Errors;
import com.google.inject.internal.ErrorsException;

public abstract class FailableCache<K, V> {
    private final LoadingCache<K, Object> delegate = CacheBuilder.newBuilder().build(new CacheLoader<K, Object>(){

        public Object load(K key2) {
            Errors errors2 = new Errors();
            Object result = null;
            try {
                result = FailableCache.this.create(key2, errors2);
            }
            catch (ErrorsException e2) {
                errors2.merge(e2.getErrors());
            }
            return errors2.hasErrors() ? errors2 : result;
        }
    });

    protected abstract V create(K var1, Errors var2) throws ErrorsException;

    public V get(K key2, Errors errors2) throws ErrorsException {
        Object resultOrError = this.delegate.getUnchecked(key2);
        if (resultOrError instanceof Errors) {
            errors2.merge((Errors)resultOrError);
            throw errors2.toException();
        }
        Object result = resultOrError;
        return (V)result;
    }

    boolean remove(K key2) {
        return this.delegate.asMap().remove(key2) != null;
    }
}

