# t20047 - Test case for 'call' comment directive
## Config
```yaml
add_compile_flags:
  - -fparse-all-comments
diagrams:
  t20047_sequence:
    type: sequence
    glob:
      - t20047.cc
    include:
      namespaces:
        - clanguml::t20047
    using_namespace: clanguml::t20047
    from:
      - function: "clanguml::t20047::tmain()"
```
## Source code
File `tests/t20047/t20047.cc`
```cpp
#include <future>

namespace clanguml {
namespace t20047 {

int a1(int x) { return x + 1; }

int a2(int x) { return x + 2; }

int a3(int x) { return x + 3; }

int a4(int x) { return x + 4; }

int a5(int x) { return x + 5; }

int a6(int x) { return x + 6; }

int run(int (*f)(int), int arg) { return f(arg); }

int tmain()
{
    auto res =
        // \uml{call clanguml::t20047::a1(int)}
        run(a1, 0);

    res = a3(
        // \uml{call clanguml::t20047::a2(int)}
        run(a2, 0));

    // \uml{call clanguml::t20047::a4(int)}
    res = [](auto &&x) { return a4(x); }(0);

    // \uml{call clanguml::t20047::a5(int)}
    res = std::async(a5, 10).get();

    // \uml{call clanguml::t20047::a6(int)}
    res = [](auto &&x) { return std::async(run, a6, x).get(); }(1);

    return res;
}
}
}
```
## Generated PlantUML diagrams
![t20047_sequence](./t20047_sequence.svg "Test case for 'call' comment directive")
## Generated Mermaid diagrams
![t20047_sequence](./t20047_sequence_mermaid.svg "Test case for 'call' comment directive")
## Generated JSON models
```json
{
  "diagram_type": "sequence",
  "name": "t20047_sequence",
  "participants": [
    {
      "display_name": "tmain()",
      "full_name": "clanguml::t20047::tmain()",
      "id": "3162686479555008053",
      "name": "tmain",
      "namespace": "clanguml::t20047",
      "source_location": {
        "column": 5,
        "file": "t20047.cc",
        "line": 20,
        "translation_unit": "t20047.cc"
      },
      "type": "function"
    },
    {
      "display_name": "a1(int)",
      "full_name": "clanguml::t20047::a1(int)",
      "id": "9147410523066341435",
      "name": "a1",
      "namespace": "clanguml::t20047",
      "source_location": {
        "column": 5,
        "file": "t20047.cc",
        "line": 6,
        "translation_unit": "t20047.cc"
      },
      "type": "function"
    },
    {
      "display_name": "a2(int)",
      "full_name": "clanguml::t20047::a2(int)",
      "id": "5139366757406208800",
      "name": "a2",
      "namespace": "clanguml::t20047",
      "source_location": {
        "column": 5,
        "file": "t20047.cc",
        "line": 8,
        "translation_unit": "t20047.cc"
      },
      "type": "function"
    },
    {
      "display_name": "a3(int)",
      "full_name": "clanguml::t20047::a3(int)",
      "id": "2163698648498387098",
      "name": "a3",
      "namespace": "clanguml::t20047",
      "source_location": {
        "column": 5,
        "file": "t20047.cc",
        "line": 10,
        "translation_unit": "t20047.cc"
      },
      "type": "function"
    },
    {
      "display_name": "a4(int)",
      "full_name": "clanguml::t20047::a4(int)",
      "id": "1030278663203036825",
      "name": "a4",
      "namespace": "clanguml::t20047",
      "source_location": {
        "column": 5,
        "file": "t20047.cc",
        "line": 12,
        "translation_unit": "t20047.cc"
      },
      "type": "function"
    },
    {
      "display_name": "a5(int)",
      "full_name": "clanguml::t20047::a5(int)",
      "id": "17461287046043558961",
      "name": "a5",
      "namespace": "clanguml::t20047",
      "source_location": {
        "column": 5,
        "file": "t20047.cc",
        "line": 14,
        "translation_unit": "t20047.cc"
      },
      "type": "function"
    },
    {
      "display_name": "a6(int)",
      "full_name": "clanguml::t20047::a6(int)",
      "id": "10178804914206248997",
      "name": "a6",
      "namespace": "clanguml::t20047",
      "source_location": {
        "column": 5,
        "file": "t20047.cc",
        "line": 16,
        "translation_unit": "t20047.cc"
      },
      "type": "function"
    }
  ],
  "sequences": [
    {
      "from": {
        "id": "3162686479555008053",
        "location": "clanguml::t20047::tmain()"
      },
      "messages": [
        {
          "from": {
            "activity_id": "3162686479555008053",
            "participant_id": "3162686479555008053"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 9,
            "file": "t20047.cc",
            "line": 24,
            "translation_unit": "t20047.cc"
          },
          "to": {
            "activity_id": "9147410523066341435",
            "participant_id": "9147410523066341435"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "9147410523066341435",
            "participant_id": "9147410523066341435"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20047.cc",
            "line": 6,
            "translation_unit": "t20047.cc"
          },
          "to": {
            "activity_id": "3162686479555008053",
            "participant_id": "3162686479555008053"
          },
          "type": "return"
        },
        {
          "from": {
            "activity_id": "3162686479555008053",
            "participant_id": "3162686479555008053"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 9,
            "file": "t20047.cc",
            "line": 28,
            "translation_unit": "t20047.cc"
          },
          "to": {
            "activity_id": "5139366757406208800",
            "participant_id": "5139366757406208800"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "5139366757406208800",
            "participant_id": "5139366757406208800"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20047.cc",
            "line": 8,
            "translation_unit": "t20047.cc"
          },
          "to": {
            "activity_id": "3162686479555008053",
            "participant_id": "3162686479555008053"
          },
          "type": "return"
        },
        {
          "from": {
            "activity_id": "3162686479555008053",
            "participant_id": "3162686479555008053"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 11,
            "file": "t20047.cc",
            "line": 26,
            "translation_unit": "t20047.cc"
          },
          "to": {
            "activity_id": "2163698648498387098",
            "participant_id": "2163698648498387098"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "2163698648498387098",
            "participant_id": "2163698648498387098"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20047.cc",
            "line": 10,
            "translation_unit": "t20047.cc"
          },
          "to": {
            "activity_id": "3162686479555008053",
            "participant_id": "3162686479555008053"
          },
          "type": "return"
        },
        {
          "from": {
            "activity_id": "3162686479555008053",
            "participant_id": "3162686479555008053"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 11,
            "file": "t20047.cc",
            "line": 31,
            "translation_unit": "t20047.cc"
          },
          "to": {
            "activity_id": "1030278663203036825",
            "participant_id": "1030278663203036825"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "1030278663203036825",
            "participant_id": "1030278663203036825"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20047.cc",
            "line": 12,
            "translation_unit": "t20047.cc"
          },
          "to": {
            "activity_id": "3162686479555008053",
            "participant_id": "3162686479555008053"
          },
          "type": "return"
        },
        {
          "from": {
            "activity_id": "3162686479555008053",
            "participant_id": "3162686479555008053"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 11,
            "file": "t20047.cc",
            "line": 34,
            "translation_unit": "t20047.cc"
          },
          "to": {
            "activity_id": "17461287046043558961",
            "participant_id": "17461287046043558961"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "17461287046043558961",
            "participant_id": "17461287046043558961"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20047.cc",
            "line": 14,
            "translation_unit": "t20047.cc"
          },
          "to": {
            "activity_id": "3162686479555008053",
            "participant_id": "3162686479555008053"
          },
          "type": "return"
        },
        {
          "from": {
            "activity_id": "3162686479555008053",
            "participant_id": "3162686479555008053"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 11,
            "file": "t20047.cc",
            "line": 37,
            "translation_unit": "t20047.cc"
          },
          "to": {
            "activity_id": "10178804914206248997",
            "participant_id": "10178804914206248997"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "10178804914206248997",
            "participant_id": "10178804914206248997"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20047.cc",
            "line": 16,
            "translation_unit": "t20047.cc"
          },
          "to": {
            "activity_id": "3162686479555008053",
            "participant_id": "3162686479555008053"
          },
          "type": "return"
        }
      ]
    }
  ],
  "using_namespace": "clanguml::t20047"
}
```
## Generated GraphML models
