# t20020 - If statement sequence diagram test case
## Config
```yaml
diagrams:
  t20020_sequence:
    type: sequence
    glob:
      - t20020.cc
    include:
      namespaces:
        - clanguml::t20020
    using_namespace: clanguml::t20020
    from:
      - function: "clanguml::t20020::tmain()"
```
## Source code
File `tests/t20020/t20020.cc`
```cpp
#include <cmath>
#include <cstdint>

namespace clanguml {
namespace t20020 {
struct A {
    int a1() { return 0; }
    int a2() { return 1; }
    int a3() { return 2; }
    int a4() { return 3; }
    int a5() { return 4; }
};

struct B {
    void log() { }

    int b1() { return 3; }
    int b2() { return 4; }
};

struct C {
    void log() const { }

    void c1() const
    {
        if (c2())
            log();
    }

    bool c2() const { return true; }

    int c3(int x) { return x * 2; }
};

template <typename T> struct D {

    T d1(T x, T y) { return x + y; }
};

int tmain()
{
    A a;
    B b;
    C c;
    D<int> d;

    int result{0};

    if (reinterpret_cast<uint64_t>(&a) % 100 == 0ULL) {
        result = a.a1();
    }
    else if (reinterpret_cast<uint64_t>(&a) % 100 == 42ULL) {
        result = a.a5();
    }
    else if (reinterpret_cast<uint64_t>(&a) % 64 == 0ULL) {
        if (c.c3(a.a2()) > 2)
            result = b.b1();
        else if (a.a3() % 2)
            result = b.b2();
        else
            result = 0;
    }
    else {
        result = a.a4();
    }

    b.log();

    if (true)
        c.c1();

    if (true)
        d.d1(1, 1);

    // This if/else should not be included in the diagram at all
    // as the calls to std will be excluded by the diagram filters
    if (result != 2) {
        result = std::exp(result);
    }
    else if (result == 3) {
        result = 4;
    }
    else {
        result = std::exp(result + 1);
    }

    return result;
}
}
}
```
## Generated PlantUML diagrams
![t20020_sequence](./t20020_sequence.svg "If statement sequence diagram test case")
## Generated Mermaid diagrams
![t20020_sequence](./t20020_sequence_mermaid.svg "If statement sequence diagram test case")
## Generated JSON models
```json
{
  "diagram_type": "sequence",
  "name": "t20020_sequence",
  "participants": [
    {
      "display_name": "tmain()",
      "full_name": "clanguml::t20020::tmain()",
      "id": "3456995108499205319",
      "name": "tmain",
      "namespace": "clanguml::t20020",
      "source_location": {
        "column": 5,
        "file": "t20020.cc",
        "line": 40,
        "translation_unit": "t20020.cc"
      },
      "type": "function"
    },
    {
      "activities": [
        {
          "display_name": "a1()",
          "full_name": "clanguml::t20020::A::a1()",
          "id": "351429406124277608",
          "name": "a1",
          "namespace": "clanguml::t20020",
          "source_location": {
            "column": 9,
            "file": "t20020.cc",
            "line": 7,
            "translation_unit": "t20020.cc"
          },
          "type": "method"
        },
        {
          "display_name": "a5()",
          "full_name": "clanguml::t20020::A::a5()",
          "id": "12907657969785462610",
          "name": "a5",
          "namespace": "clanguml::t20020",
          "source_location": {
            "column": 9,
            "file": "t20020.cc",
            "line": 11,
            "translation_unit": "t20020.cc"
          },
          "type": "method"
        },
        {
          "display_name": "a2()",
          "full_name": "clanguml::t20020::A::a2()",
          "id": "10317962018325505121",
          "name": "a2",
          "namespace": "clanguml::t20020",
          "source_location": {
            "column": 9,
            "file": "t20020.cc",
            "line": 8,
            "translation_unit": "t20020.cc"
          },
          "type": "method"
        },
        {
          "display_name": "a3()",
          "full_name": "clanguml::t20020::A::a3()",
          "id": "15869285436437359185",
          "name": "a3",
          "namespace": "clanguml::t20020",
          "source_location": {
            "column": 9,
            "file": "t20020.cc",
            "line": 9,
            "translation_unit": "t20020.cc"
          },
          "type": "method"
        },
        {
          "display_name": "a4()",
          "full_name": "clanguml::t20020::A::a4()",
          "id": "164585591999830934",
          "name": "a4",
          "namespace": "clanguml::t20020",
          "source_location": {
            "column": 9,
            "file": "t20020.cc",
            "line": 10,
            "translation_unit": "t20020.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "A",
      "full_name": "clanguml::t20020::A",
      "id": "1671534773191452877",
      "name": "A",
      "namespace": "clanguml::t20020",
      "source_location": {
        "column": 8,
        "file": "t20020.cc",
        "line": 6,
        "translation_unit": "t20020.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "c3(int)",
          "full_name": "clanguml::t20020::C::c3(int)",
          "id": "10427510278737569612",
          "name": "c3",
          "namespace": "clanguml::t20020",
          "source_location": {
            "column": 9,
            "file": "t20020.cc",
            "line": 32,
            "translation_unit": "t20020.cc"
          },
          "type": "method"
        },
        {
          "display_name": "c1() const",
          "full_name": "clanguml::t20020::C::c1() const",
          "id": "11788172907238269228",
          "name": "c1",
          "namespace": "clanguml::t20020",
          "source_location": {
            "column": 10,
            "file": "t20020.cc",
            "line": 24,
            "translation_unit": "t20020.cc"
          },
          "type": "method"
        },
        {
          "display_name": "c2() const",
          "full_name": "clanguml::t20020::C::c2() const",
          "id": "14312931061803887318",
          "name": "c2",
          "namespace": "clanguml::t20020",
          "source_location": {
            "column": 10,
            "file": "t20020.cc",
            "line": 30,
            "translation_unit": "t20020.cc"
          },
          "type": "method"
        },
        {
          "display_name": "log() const",
          "full_name": "clanguml::t20020::C::log() const",
          "id": "5086244200172581365",
          "name": "log",
          "namespace": "clanguml::t20020",
          "source_location": {
            "column": 10,
            "file": "t20020.cc",
            "line": 22,
            "translation_unit": "t20020.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "C",
      "full_name": "clanguml::t20020::C",
      "id": "12499698455275243071",
      "name": "C",
      "namespace": "clanguml::t20020",
      "source_location": {
        "column": 8,
        "file": "t20020.cc",
        "line": 21,
        "translation_unit": "t20020.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "b1()",
          "full_name": "clanguml::t20020::B::b1()",
          "id": "4337572658684858744",
          "name": "b1",
          "namespace": "clanguml::t20020",
          "source_location": {
            "column": 9,
            "file": "t20020.cc",
            "line": 17,
            "translation_unit": "t20020.cc"
          },
          "type": "method"
        },
        {
          "display_name": "b2()",
          "full_name": "clanguml::t20020::B::b2()",
          "id": "4046081895713433497",
          "name": "b2",
          "namespace": "clanguml::t20020",
          "source_location": {
            "column": 9,
            "file": "t20020.cc",
            "line": 18,
            "translation_unit": "t20020.cc"
          },
          "type": "method"
        },
        {
          "display_name": "log()",
          "full_name": "clanguml::t20020::B::log()",
          "id": "11490006309633640210",
          "name": "log",
          "namespace": "clanguml::t20020",
          "source_location": {
            "column": 10,
            "file": "t20020.cc",
            "line": 15,
            "translation_unit": "t20020.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "B",
      "full_name": "clanguml::t20020::B",
      "id": "10740507868897363302",
      "name": "B",
      "namespace": "clanguml::t20020",
      "source_location": {
        "column": 8,
        "file": "t20020.cc",
        "line": 14,
        "translation_unit": "t20020.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "d1(int,int)",
          "full_name": "clanguml::t20020::D<int>::d1(int,int)",
          "id": "14240016080422742133",
          "name": "d1",
          "namespace": "clanguml::t20020",
          "source_location": {
            "column": 7,
            "file": "t20020.cc",
            "line": 37,
            "translation_unit": "t20020.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "D<int>",
      "full_name": "clanguml::t20020::D<int>",
      "id": "12847314485974494933",
      "name": "D",
      "namespace": "clanguml::t20020",
      "source_location": {
        "column": 30,
        "file": "t20020.cc",
        "line": 35,
        "translation_unit": "t20020.cc"
      },
      "type": "class"
    }
  ],
  "sequences": [
    {
      "from": {
        "id": "3456995108499205319",
        "location": "clanguml::t20020::tmain()"
      },
      "messages": [
        {
          "activity_id": "3456995108499205319",
          "branches": [
            {
              "messages": [
                {
                  "from": {
                    "activity_id": "3456995108499205319",
                    "participant_id": "3456995108499205319"
                  },
                  "name": "a1()",
                  "return_type": "int",
                  "scope": "normal",
                  "source_location": {
                    "column": 18,
                    "file": "t20020.cc",
                    "line": 50,
                    "translation_unit": "t20020.cc"
                  },
                  "to": {
                    "activity_id": "351429406124277608",
                    "participant_id": "1671534773191452877"
                  },
                  "type": "message"
                },
                {
                  "from": {
                    "activity_id": "351429406124277608",
                    "participant_id": "1671534773191452877"
                  },
                  "name": "",
                  "return_type": "int",
                  "scope": "normal",
                  "source_location": {
                    "column": 16,
                    "file": "t20020.cc",
                    "line": 7,
                    "translation_unit": "t20020.cc"
                  },
                  "to": {
                    "activity_id": "3456995108499205319",
                    "participant_id": "3456995108499205319"
                  },
                  "type": "return"
                }
              ],
              "type": "consequent"
            },
            {
              "messages": [
                {
                  "from": {
                    "activity_id": "3456995108499205319",
                    "participant_id": "3456995108499205319"
                  },
                  "name": "a5()",
                  "return_type": "int",
                  "scope": "normal",
                  "source_location": {
                    "column": 18,
                    "file": "t20020.cc",
                    "line": 53,
                    "translation_unit": "t20020.cc"
                  },
                  "to": {
                    "activity_id": "12907657969785462610",
                    "participant_id": "1671534773191452877"
                  },
                  "type": "message"
                },
                {
                  "from": {
                    "activity_id": "12907657969785462610",
                    "participant_id": "1671534773191452877"
                  },
                  "name": "",
                  "return_type": "int",
                  "scope": "normal",
                  "source_location": {
                    "column": 16,
                    "file": "t20020.cc",
                    "line": 11,
                    "translation_unit": "t20020.cc"
                  },
                  "to": {
                    "activity_id": "3456995108499205319",
                    "participant_id": "3456995108499205319"
                  },
                  "type": "return"
                }
              ],
              "type": "alternative"
            },
            {
              "messages": [
                {
                  "activity_id": "3456995108499205319",
                  "branches": [
                    {
                      "messages": [
                        {
                          "from": {
                            "activity_id": "3456995108499205319",
                            "participant_id": "3456995108499205319"
                          },
                          "name": "a2()",
                          "return_type": "int",
                          "scope": "condition",
                          "source_location": {
                            "column": 18,
                            "file": "t20020.cc",
                            "line": 56,
                            "translation_unit": "t20020.cc"
                          },
                          "to": {
                            "activity_id": "10317962018325505121",
                            "participant_id": "1671534773191452877"
                          },
                          "type": "message"
                        },
                        {
                          "from": {
                            "activity_id": "10317962018325505121",
                            "participant_id": "1671534773191452877"
                          },
                          "name": "",
                          "return_type": "int",
                          "scope": "normal",
                          "source_location": {
                            "column": 16,
                            "file": "t20020.cc",
                            "line": 8,
                            "translation_unit": "t20020.cc"
                          },
                          "to": {
                            "activity_id": "3456995108499205319",
                            "participant_id": "3456995108499205319"
                          },
                          "type": "return"
                        },
                        {
                          "from": {
                            "activity_id": "3456995108499205319",
                            "participant_id": "3456995108499205319"
                          },
                          "name": "c3(int)",
                          "return_type": "int",
                          "scope": "condition",
                          "source_location": {
                            "column": 13,
                            "file": "t20020.cc",
                            "line": 56,
                            "translation_unit": "t20020.cc"
                          },
                          "to": {
                            "activity_id": "10427510278737569612",
                            "participant_id": "12499698455275243071"
                          },
                          "type": "message"
                        },
                        {
                          "from": {
                            "activity_id": "10427510278737569612",
                            "participant_id": "12499698455275243071"
                          },
                          "name": "",
                          "return_type": "int",
                          "scope": "normal",
                          "source_location": {
                            "column": 21,
                            "file": "t20020.cc",
                            "line": 32,
                            "translation_unit": "t20020.cc"
                          },
                          "to": {
                            "activity_id": "3456995108499205319",
                            "participant_id": "3456995108499205319"
                          },
                          "type": "return"
                        },
                        {
                          "from": {
                            "activity_id": "3456995108499205319",
                            "participant_id": "3456995108499205319"
                          },
                          "name": "b1()",
                          "return_type": "int",
                          "scope": "normal",
                          "source_location": {
                            "column": 22,
                            "file": "t20020.cc",
                            "line": 57,
                            "translation_unit": "t20020.cc"
                          },
                          "to": {
                            "activity_id": "4337572658684858744",
                            "participant_id": "10740507868897363302"
                          },
                          "type": "message"
                        },
                        {
                          "from": {
                            "activity_id": "4337572658684858744",
                            "participant_id": "10740507868897363302"
                          },
                          "name": "",
                          "return_type": "int",
                          "scope": "normal",
                          "source_location": {
                            "column": 16,
                            "file": "t20020.cc",
                            "line": 17,
                            "translation_unit": "t20020.cc"
                          },
                          "to": {
                            "activity_id": "3456995108499205319",
                            "participant_id": "3456995108499205319"
                          },
                          "type": "return"
                        }
                      ],
                      "type": "consequent"
                    },
                    {
                      "messages": [
                        {
                          "from": {
                            "activity_id": "3456995108499205319",
                            "participant_id": "3456995108499205319"
                          },
                          "name": "a3()",
                          "return_type": "int",
                          "scope": "condition",
                          "source_location": {
                            "column": 18,
                            "file": "t20020.cc",
                            "line": 58,
                            "translation_unit": "t20020.cc"
                          },
                          "to": {
                            "activity_id": "15869285436437359185",
                            "participant_id": "1671534773191452877"
                          },
                          "type": "message"
                        },
                        {
                          "from": {
                            "activity_id": "15869285436437359185",
                            "participant_id": "1671534773191452877"
                          },
                          "name": "",
                          "return_type": "int",
                          "scope": "normal",
                          "source_location": {
                            "column": 16,
                            "file": "t20020.cc",
                            "line": 9,
                            "translation_unit": "t20020.cc"
                          },
                          "to": {
                            "activity_id": "3456995108499205319",
                            "participant_id": "3456995108499205319"
                          },
                          "type": "return"
                        },
                        {
                          "from": {
                            "activity_id": "3456995108499205319",
                            "participant_id": "3456995108499205319"
                          },
                          "name": "b2()",
                          "return_type": "int",
                          "scope": "normal",
                          "source_location": {
                            "column": 22,
                            "file": "t20020.cc",
                            "line": 59,
                            "translation_unit": "t20020.cc"
                          },
                          "to": {
                            "activity_id": "4046081895713433497",
                            "participant_id": "10740507868897363302"
                          },
                          "type": "message"
                        },
                        {
                          "from": {
                            "activity_id": "4046081895713433497",
                            "participant_id": "10740507868897363302"
                          },
                          "name": "",
                          "return_type": "int",
                          "scope": "normal",
                          "source_location": {
                            "column": 16,
                            "file": "t20020.cc",
                            "line": 18,
                            "translation_unit": "t20020.cc"
                          },
                          "to": {
                            "activity_id": "3456995108499205319",
                            "participant_id": "3456995108499205319"
                          },
                          "type": "return"
                        }
                      ],
                      "type": "alternative"
                    }
                  ],
                  "name": "if",
                  "type": "alt"
                }
              ],
              "type": "alternative"
            },
            {
              "messages": [
                {
                  "from": {
                    "activity_id": "3456995108499205319",
                    "participant_id": "3456995108499205319"
                  },
                  "name": "a4()",
                  "return_type": "int",
                  "scope": "normal",
                  "source_location": {
                    "column": 18,
                    "file": "t20020.cc",
                    "line": 64,
                    "translation_unit": "t20020.cc"
                  },
                  "to": {
                    "activity_id": "164585591999830934",
                    "participant_id": "1671534773191452877"
                  },
                  "type": "message"
                },
                {
                  "from": {
                    "activity_id": "164585591999830934",
                    "participant_id": "1671534773191452877"
                  },
                  "name": "",
                  "return_type": "int",
                  "scope": "normal",
                  "source_location": {
                    "column": 16,
                    "file": "t20020.cc",
                    "line": 10,
                    "translation_unit": "t20020.cc"
                  },
                  "to": {
                    "activity_id": "3456995108499205319",
                    "participant_id": "3456995108499205319"
                  },
                  "type": "return"
                }
              ],
              "type": "alternative"
            }
          ],
          "name": "if",
          "type": "alt"
        },
        {
          "from": {
            "activity_id": "3456995108499205319",
            "participant_id": "3456995108499205319"
          },
          "name": "log()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20020.cc",
            "line": 67,
            "translation_unit": "t20020.cc"
          },
          "to": {
            "activity_id": "11490006309633640210",
            "participant_id": "10740507868897363302"
          },
          "type": "message"
        },
        {
          "activity_id": "3456995108499205319",
          "branches": [
            {
              "messages": [
                {
                  "from": {
                    "activity_id": "3456995108499205319",
                    "participant_id": "3456995108499205319"
                  },
                  "name": "c1() const",
                  "return_type": "void",
                  "scope": "normal",
                  "source_location": {
                    "column": 9,
                    "file": "t20020.cc",
                    "line": 70,
                    "translation_unit": "t20020.cc"
                  },
                  "to": {
                    "activity_id": "11788172907238269228",
                    "participant_id": "12499698455275243071"
                  },
                  "type": "message"
                },
                {
                  "activity_id": "11788172907238269228",
                  "branches": [
                    {
                      "messages": [
                        {
                          "from": {
                            "activity_id": "11788172907238269228",
                            "participant_id": "12499698455275243071"
                          },
                          "name": "c2() const",
                          "return_type": "bool",
                          "scope": "condition",
                          "source_location": {
                            "column": 13,
                            "file": "t20020.cc",
                            "line": 26,
                            "translation_unit": "t20020.cc"
                          },
                          "to": {
                            "activity_id": "14312931061803887318",
                            "participant_id": "12499698455275243071"
                          },
                          "type": "message"
                        },
                        {
                          "from": {
                            "activity_id": "14312931061803887318",
                            "participant_id": "12499698455275243071"
                          },
                          "name": "",
                          "return_type": "_Bool",
                          "scope": "normal",
                          "source_location": {
                            "column": 23,
                            "file": "t20020.cc",
                            "line": 30,
                            "translation_unit": "t20020.cc"
                          },
                          "to": {
                            "activity_id": "11788172907238269228",
                            "participant_id": "12499698455275243071"
                          },
                          "type": "return"
                        },
                        {
                          "from": {
                            "activity_id": "11788172907238269228",
                            "participant_id": "12499698455275243071"
                          },
                          "name": "log() const",
                          "return_type": "void",
                          "scope": "normal",
                          "source_location": {
                            "column": 13,
                            "file": "t20020.cc",
                            "line": 27,
                            "translation_unit": "t20020.cc"
                          },
                          "to": {
                            "activity_id": "5086244200172581365",
                            "participant_id": "12499698455275243071"
                          },
                          "type": "message"
                        }
                      ],
                      "type": "consequent"
                    }
                  ],
                  "name": "if",
                  "type": "alt"
                }
              ],
              "type": "consequent"
            }
          ],
          "name": "if",
          "type": "alt"
        },
        {
          "activity_id": "3456995108499205319",
          "branches": [
            {
              "messages": [
                {
                  "from": {
                    "activity_id": "3456995108499205319",
                    "participant_id": "3456995108499205319"
                  },
                  "name": "d1(int,int)",
                  "return_type": "int",
                  "scope": "normal",
                  "source_location": {
                    "column": 9,
                    "file": "t20020.cc",
                    "line": 73,
                    "translation_unit": "t20020.cc"
                  },
                  "to": {
                    "activity_id": "14240016080422742133",
                    "participant_id": "12847314485974494933"
                  },
                  "type": "message"
                },
                {
                  "from": {
                    "activity_id": "14240016080422742133",
                    "participant_id": "12847314485974494933"
                  },
                  "name": "",
                  "return_type": "int",
                  "scope": "normal",
                  "source_location": {
                    "column": 22,
                    "file": "t20020.cc",
                    "line": 37,
                    "translation_unit": "t20020.cc"
                  },
                  "to": {
                    "activity_id": "3456995108499205319",
                    "participant_id": "3456995108499205319"
                  },
                  "type": "return"
                }
              ],
              "type": "consequent"
            }
          ],
          "name": "if",
          "type": "alt"
        }
      ]
    }
  ],
  "using_namespace": "clanguml::t20020"
}
```
## Generated GraphML models
