# t00031 - PlantUML style decorator test case
## Config
```yaml
diagrams:
  t00031_class:
    type: class
    glob:
      - t00031.cc
    skip_redundant_dependencies: false
    using_namespace: clanguml::t00031
    include:
      namespaces:
        - clanguml::t00031

```
## Source code
File `tests/t00031/t00031.cc`
```cpp
#include <memory>
#include <vector>

namespace clanguml {
namespace t00031 {

/// @uml{style[#back:lightgreen|yellow;header:blue/red]}
class A { };

/// @uml{style[#line.dotted:blue]}
enum B { one, two, three };

/// @uml{style[#pink;line:red;line.bold;text:red]}
template <typename T> class C {
    T ttt;
};

class D { };

struct R {
    /// @uml{style[#red,dashed,thickness=2]}
    A *aaa;

    /// @uml{composition}
    /// @uml{style[#green,dashed,thickness=4]}
    std::vector<B> bbb;

    void add_b(B b) { bbb.push_back(b); }

    /// @uml{style[#blue,dotted,thickness=8]}
    C<int> ccc;

    /// @uml{style[#blue,plain,thickness=16]}
    D *ddd;
};

} // namespace t00031
} // namespace clanguml

```
## Generated PlantUML diagrams
![t00031_class](./t00031_class.svg "PlantUML style decorator test case")
## Generated Mermaid diagrams
![t00031_class](./t00031_class_mermaid.svg "PlantUML style decorator test case")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "comment": {
        "formatted": "@uml{style[#back:lightgreen|yellow;header:blue/red]}",
        "raw": "/// @uml{style[#back:lightgreen|yellow;header:blue/red]}"
      },
      "display_name": "A",
      "id": "6782204316023257980",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00031",
      "source_location": {
        "column": 7,
        "file": "t00031.cc",
        "line": 8,
        "translation_unit": "t00031.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "comment": {
        "formatted": "@uml{style[#line.dotted:blue]}",
        "raw": "/// @uml{style[#line.dotted:blue]}"
      },
      "constants": [
        "one",
        "two",
        "three"
      ],
      "display_name": "B",
      "id": "11534370866611057435",
      "is_nested": false,
      "name": "B",
      "namespace": "clanguml::t00031",
      "source_location": {
        "column": 6,
        "file": "t00031.cc",
        "line": 11,
        "translation_unit": "t00031.cc"
      },
      "type": "enum"
    },
    {
      "bases": [],
      "comment": {
        "formatted": "@uml{style[#pink;line:red;line.bold;text:red]}",
        "raw": "/// @uml{style[#pink;line:red;line.bold;text:red]}"
      },
      "display_name": "C<T>",
      "id": "929673157866263642",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "private",
          "is_static": false,
          "name": "ttt",
          "source_location": {
            "column": 7,
            "file": "t00031.cc",
            "line": 15,
            "translation_unit": "t00031.cc"
          },
          "type": "T"
        }
      ],
      "methods": [],
      "name": "C",
      "namespace": "clanguml::t00031",
      "source_location": {
        "column": 29,
        "file": "t00031.cc",
        "line": 14,
        "translation_unit": "t00031.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "D",
      "id": "18132274755804041259",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "D",
      "namespace": "clanguml::t00031",
      "source_location": {
        "column": 7,
        "file": "t00031.cc",
        "line": 18,
        "translation_unit": "t00031.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "C<int>",
      "id": "1669604233406885166",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "C",
      "namespace": "clanguml::t00031",
      "source_location": {
        "column": 12,
        "file": "t00031.cc",
        "line": 31,
        "translation_unit": "t00031.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "int"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "R",
      "id": "3877696738918944260",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "comment": {
            "formatted": "@uml{style[#red,dashed,thickness=2]}",
            "raw": "/// @uml{style[#red,dashed,thickness=2]}"
          },
          "is_static": false,
          "name": "aaa",
          "source_location": {
            "column": 8,
            "file": "t00031.cc",
            "line": 22,
            "translation_unit": "t00031.cc"
          },
          "type": "A *"
        },
        {
          "access": "public",
          "comment": {
            "formatted": "@uml{composition}\n@uml{style[#green,dashed,thickness=4]}",
            "raw": "/// @uml{composition}\n    /// @uml{style[#green,dashed,thickness=4]}"
          },
          "is_static": false,
          "name": "bbb",
          "source_location": {
            "column": 20,
            "file": "t00031.cc",
            "line": 26,
            "translation_unit": "t00031.cc"
          },
          "type": "std::vector<B>"
        },
        {
          "access": "public",
          "comment": {
            "formatted": "@uml{style[#blue,dotted,thickness=8]}",
            "raw": "/// @uml{style[#blue,dotted,thickness=8]}"
          },
          "is_static": false,
          "name": "ccc",
          "source_location": {
            "column": 12,
            "file": "t00031.cc",
            "line": 31,
            "translation_unit": "t00031.cc"
          },
          "type": "C<int>"
        },
        {
          "access": "public",
          "comment": {
            "formatted": "@uml{style[#blue,plain,thickness=16]}",
            "raw": "/// @uml{style[#blue,plain,thickness=16]}"
          },
          "is_static": false,
          "name": "ddd",
          "source_location": {
            "column": 8,
            "file": "t00031.cc",
            "line": 34,
            "translation_unit": "t00031.cc"
          },
          "type": "D *"
        }
      ],
      "methods": [
        {
          "access": "public",
          "display_name": "add_b",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "add_b",
          "parameters": [
            {
              "name": "b",
              "type": "B"
            }
          ],
          "source_location": {
            "column": 10,
            "file": "t00031.cc",
            "line": 28,
            "translation_unit": "t00031.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "R",
      "namespace": "clanguml::t00031",
      "source_location": {
        "column": 8,
        "file": "t00031.cc",
        "line": 20,
        "translation_unit": "t00031.cc"
      },
      "template_parameters": [],
      "type": "class"
    }
  ],
  "name": "t00031_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "public",
      "destination": "929673157866263642",
      "source": "1669604233406885166",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "11534370866611057435",
      "source": "3877696738918944260",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "6782204316023257980",
      "label": "aaa",
      "source": "3877696738918944260",
      "type": "association"
    },
    {
      "access": "public",
      "destination": "11534370866611057435",
      "label": "bbb",
      "source": "3877696738918944260",
      "type": "composition"
    },
    {
      "access": "public",
      "destination": "1669604233406885166",
      "label": "ccc",
      "source": "3877696738918944260",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "18132274755804041259",
      "label": "ddd",
      "source": "3877696738918944260",
      "type": "association"
    }
  ],
  "using_namespace": "clanguml::t00031"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00031</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n1">
   <data key="nd1">enum</data>
   <data key="nd2"><![CDATA[B]]></data>
  </node>
  <node id="n2">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[C<T>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n3">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[D]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n4">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[C<int>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n5">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[R]]></data>
   <data key="nd6">false</data>
  </node>
  <edge id="e0" source="n4" target="n2">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e1" source="n5" target="n1">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e2" source="n5" target="n0">
   <data key="ed0">association</data>
   <data key="ed2">aaa</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e3" source="n5" target="n1">
   <data key="ed0">composition</data>
   <data key="ed2">bbb</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e4" source="n5" target="n4">
   <data key="ed0">aggregation</data>
   <data key="ed2">ccc</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e5" source="n5" target="n3">
   <data key="ed0">association</data>
   <data key="ed2">ddd</data>
   <data key="ed1">public</data>
  </edge>
 </graph>
</graphml>

```
