/* vim: set expandtab ts=4 sw=4: */
/*
 * You may redistribute this program and/or modify it under the terms of
 * the GNU General Public License as published by the Free Software Foundation,
 * either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
#include "benc/Dict.h"
#include "benc/String.h"
#include "exception/Err.h"
#include "util/log/Log.h"
#include "util/Security.h"
#include "memory/Allocator.h"
#include "util/events/EventBase.h"
#include "util/events/Timeout.h"

#include <unistd.h>

Dict* Security_getUser(char* userName, struct Allocator* retAlloc)
{
    Dict* ret = Dict_new(retAlloc);
    Dict_putString(ret, String_new("error", retAlloc),
                        String_new("Not supported on windows", retAlloc),
                        retAlloc);
    return ret;
}

Err_DEFUN Security_setUser(int uid,
                      int gid,
                      bool keepNetAdmin,
                      struct Log* logger,
                      struct Allocator* alloc)
{
    return NULL;
}

Err_DEFUN Security_nofiles(struct Allocator* errAlloc)
{
    return NULL;
}

Err_DEFUN Security_noforks(struct Allocator* errAlloc)
{
    return NULL;
}

Err_DEFUN Security_chroot(char* root, struct Allocator* errAlloc)
{
    return NULL;
}

struct Security_pvt
{
    struct Security pub;
    struct Allocator* setupAlloc;
    struct Log* log;
    Identity
};

void Security_setupComplete(struct Security* security)
{
    struct Security_pvt* sec = Identity_check((struct Security_pvt*) security);
    sec->pub.setupComplete = 1;
    Allocator_free(sec->setupAlloc);
}

static void fail(void* vSec)
{
    struct Security_pvt* sec = Identity_check((struct Security_pvt*) vSec);
    Log_critical(sec->log, "Security_setupComplete() not called in time, exiting");
    _exit(232);
}

struct Security* Security_new(struct Allocator* alloc, struct Log* log, EventBase_t* base)
{
    struct Security_pvt* sec = Allocator_calloc(alloc, sizeof(struct Security_pvt), 1);
    Identity_set(sec);
    sec->setupAlloc = Allocator_child(alloc);
    Timeout_setInterval(fail, sec, 20000, base, sec->setupAlloc);
    sec->log = log;
    return &sec->pub;
}

Err_DEFUN Security_checkPermissions(struct Security_Permissions** outP, struct Allocator* alloc)
{
    struct Security_Permissions* out =
        Allocator_calloc(alloc, sizeof(struct Security_Permissions), 1);
    *outP = out;
    return NULL;
}
