//  ██████╗  █████╗ ███████╗███████╗██╗███╗   ██╗ ██████╗
//  ██╔══██╗██╔══██╗██╔════╝██╔════╝██║████╗  ██║██╔════╝
//  ██████╔╝███████║███████╗███████╗██║██╔██╗ ██║██║  ███╗
//  ██╔═══╝ ██╔══██║╚════██║╚════██║██║██║╚██╗██║██║   ██║
//  ██║     ██║  ██║███████║███████║██║██║ ╚████║╚██████╔╝
//  ╚═╝     ╚═╝  ╚═╝╚══════╝╚══════╝╚═╝╚═╝  ╚═══╝ ╚═════╝

#[cfg(test)]
mod passing {
    use monolith::html::is_favicon;

    #[test]
    fn icon() {
        assert!(is_favicon("icon"));
    }

    #[test]
    fn shortcut_icon_capitalized() {
        assert!(is_favicon("Shortcut Icon"));
    }

    #[test]
    fn icon_uppercase() {
        assert!(is_favicon("ICON"));
    }
}

//  ███████╗ █████╗ ██╗██╗     ██╗███╗   ██╗ ██████╗
//  ██╔════╝██╔══██╗██║██║     ██║████╗  ██║██╔════╝
//  █████╗  ███████║██║██║     ██║██╔██╗ ██║██║  ███╗
//  ██╔══╝  ██╔══██║██║██║     ██║██║╚██╗██║██║   ██║
//  ██║     ██║  ██║██║███████╗██║██║ ╚████║╚██████╔╝
//  ╚═╝     ╚═╝  ╚═╝╚═╝╚══════╝╚═╝╚═╝  ╚═══╝ ╚═════╝

#[cfg(test)]
mod failing {
    use monolith::html::is_favicon;

    #[test]
    fn apple_touch_icon() {
        assert!(!is_favicon("apple-touch-icon"));
    }

    #[test]
    fn mask_icon() {
        assert!(!is_favicon("mask-icon"));
    }

    #[test]
    fn fluid_icon() {
        assert!(!is_favicon("fluid-icon"));
    }

    #[test]
    fn stylesheet() {
        assert!(!is_favicon("stylesheet"));
    }

    #[test]
    fn empty_string() {
        assert!(!is_favicon(""));
    }
}
