<!-- @generated by usage-cli from usage spec -->
# `mise tasks validate`

- **Usage**: `mise tasks validate [--errors-only] [--json] [TASKS]…`
- **Source code**: [`src/cli/tasks/validate.rs`](https://github.com/jdx/mise/blob/main/src/cli/tasks/validate.rs)

Validate tasks for common errors and issues

## Arguments

### `[TASKS]…`

Tasks to validate
If not specified, validates all tasks

## Flags

### `--errors-only`

Only show errors (skip warnings)

### `--json`

Output validation results in JSON format

Examples:

```
# Validate all tasks
$ mise tasks validate

# Validate specific tasks
$ mise tasks validate build test

# Output results as JSON
$ mise tasks validate --json

# Only show errors (skip warnings)
$ mise tasks validate --errors-only
```

Validation Checks:

The validate command performs the following checks:

  • Circular Dependencies: Detects dependency cycles
  • Missing References: Finds references to non-existent tasks
  • Usage Spec Parsing: Validates #USAGE directives and specs
  • Timeout Format: Checks timeout values are valid durations
  • Alias Conflicts: Detects duplicate aliases across tasks
  • File Existence: Verifies file-based tasks exist
  • Directory Templates: Validates directory paths and templates
  • Shell Commands: Checks shell executables exist
  • Glob Patterns: Validates source and output patterns
  • Run Entries: Ensures tasks reference valid dependencies
