/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core.xqsequence;

import javax.xml.xquery.XQConnection;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItem;
import javax.xml.xquery.XQResultSequence;
import net.xqj.core.GenericXQConnection;
import net.xqj.core.XQToolkit;
import net.xqj.core.exception.XQExceptionImpl;
import net.xqj.core.xqitem.XQItemBase;
import net.xqj.core.xqitem.XQItemFactory;
import net.xqj.core.xqitem.XQResultItemProxy;
import net.xqj.core.xqsequence.XQSequenceBase;
import net.xqj.core.xqsequence.XQSequenceProxy;

public class XQResultSequenceProxy
extends XQSequenceProxy
implements XQResultSequence,
Cloneable {
    protected boolean isObsolete = false;
    protected XQConnection parentConnection = null;

    protected XQResultSequenceProxy() {
    }

    protected XQResultSequenceProxy(XQSequenceBase sequence) {
        super(sequence);
    }

    static XQResultSequenceProxy newInstance(XQSequenceBase sequence) {
        return new XQResultSequenceProxy(sequence);
    }

    static XQResultSequenceProxy newInstance() {
        return new XQResultSequenceProxy();
    }

    @Override
    public XQItem getItem() throws XQException {
        this.isClosedCheck();
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(48, this));
        }
        XQItemBase itemBase = (XQItemBase)this.sequence.getItem();
        XQResultItemProxy itemProxy = XQItemFactory.newXQResultItemProxy(itemBase);
        itemProxy.setSequence(this);
        itemProxy.setConnection((GenericXQConnection)this.parentConnection);
        return itemProxy;
    }

    public XQConnection getConnection() throws XQException {
        this.isClosedCheck();
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(82, this));
        }
        return this.parentConnection;
    }

    public void makeObsolete() throws XQException {
        this.isObsolete = true;
        super.close();
    }

    @Override
    public boolean isClosed() {
        return super.isClosed() || this.parentConnection != null && this.parentConnection.isClosed();
    }

    public void setConnection(GenericXQConnection connection) throws XQException {
        this.parentConnection = connection;
        this.logger = connection.getDataSource().getLogger();
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(83, this, connection));
        }
    }

    @Override
    public void reset(XQSequenceBase sequence, boolean isClosed) {
        throw new UnsupportedOperationException("must invoke reset(XQSequenceBase, boolean, XQConnection) instead.");
    }

    public void reset(XQSequenceBase sequence, boolean isClosed, XQConnection parentConnection) {
        super.reset(sequence, isClosed);
        this.isObsolete = false;
        this.parentConnection = parentConnection;
    }

    @Override
    public void isClosedCheck() throws XQException {
        if (this.isObsolete) {
            throw new XQExceptionImpl("Obsolete XQResultSequence object.\nAccording to the XQJ 1.0 Specification, executing expressions via XQPreparedExpression or XQExpression implicitly closes the previously created XQResultSequence object which was tied to the parent XQConnection object.\nTo keep a XQResultSequence alive and accessible, you could either create an immutable XQSequence by using XQConnection.createSequence(XQResultSequence) or modify the XQStaticContext's Scrollability property to ensure that future XQResultSequence objects will be \"SCROLLABLE\" (cached) and not \"FORWARD_ONLY\" (streamed).\nPlease read the XQJ.NET documentation for further details.", "XQJRS001");
        }
        super.isClosedCheck();
    }

    @Override
    public String toString() {
        return "XQResultSequenceProxy-" + this.instanceId + "-(" + this.sequence + ")";
    }

    @Override
    public Object clone() {
        return super.clone();
    }
}

