/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.var;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.ann.Annotation;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ExprInfo;
import org.basex.query.util.hash.QNmMap;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.Value;
import org.basex.query.value.item.QNm;
import org.basex.query.var.StaticVar;
import org.basex.query.var.StaticVarRef;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenObjectMap;
import org.basex.util.hash.TokenSet;

public final class Variables
extends ExprInfo
implements Iterable<StaticVar> {
    private final ArrayList<UnresolvedRef> unresolvedRefs = new ArrayList();
    private final TokenObjectMap<QNmMap<StaticVar>> varsByModule = new TokenObjectMap();

    public StaticVar declare(Var var, TokenSet imports, Expr expr, AnnList anns, boolean external, VarScope vs, String doc) throws QueryException {
        QNmMap vars;
        byte[] varUri;
        byte[] modUri = QNm.uri(var.info.sc().module);
        if (!Token.eq(modUri, varUri = var.name.uri())) {
            StaticVar sv;
            if (modUri != Token.EMPTY && !anns.contains(Annotation.PRIVATE)) {
                throw QueryError.MODULENS_X.get(var.info, var);
            }
            if (imports.contains(varUri) && (sv = this.get(var.name, varUri)) != null && !sv.anns.contains(Annotation.PRIVATE)) {
                throw QueryError.VARDUPL_X.get(var.info, new Object[]{var.name.string()});
            }
        }
        if ((vars = this.varsByModule.computeIfAbsent(modUri, QNmMap::new)).contains(var.name)) {
            throw QueryError.VARDUPL_X.get(var.info, new Object[]{var.name.string()});
        }
        StaticVar sv = new StaticVar(var, expr, anns, external, vs, doc);
        vars.put(var.name, sv);
        return sv;
    }

    public void checkUp() throws QueryException {
        for (StaticVar var : this) {
            var.checkUp();
        }
    }

    public void resolve() throws QueryException {
        for (UnresolvedRef ur : this.unresolvedRefs) {
            StaticVarRef ref = ur.ref;
            byte[] modUri = QNm.uri(ref.sc().module);
            StaticVar var = this.get(ref.name, modUri);
            if (var == null) {
                byte[] refUri = ref.name.uri();
                var = this.get(ref.name, refUri);
                if (var == null) {
                    throw QueryError.VARUNDEF_X.get(ref.info(), ref);
                }
                if (!Token.eq(modUri, refUri) && !ur.hasImport) {
                    throw QueryError.INVISIBLEVAR_X.get(ref.info(), ref.name);
                }
            }
            if (var.anns.contains(Annotation.PRIVATE) && !Token.eq(modUri, QNm.uri(var.sc.module))) {
                throw QueryError.VARPRIVATE_X.get(ref.info(), ref);
            }
            ref.init(var);
        }
        this.unresolvedRefs.clear();
    }

    public void compileAll(CompileContext cc) throws QueryException {
        for (StaticVar var : this) {
            var.compile(cc);
        }
    }

    public StaticVarRef newRef(QNm name, InputInfo info, TokenSet imports) {
        if (info == null) {
            throw Util.notExpected();
        }
        StaticVarRef ref = new StaticVarRef(info, name);
        this.unresolvedRefs.add(new UnresolvedRef(ref, imports.contains(name.uri())));
        return ref;
    }

    private StaticVar get(QNm name, byte[] module) {
        QNmMap<StaticVar> vars = this.varsByModule.get(module);
        return vars == null ? null : vars.get(name);
    }

    public void bindExternal(QueryContext qc, QNmMap<Value> bindings, boolean cast) throws QueryException {
        for (QNm qnm : bindings) {
            if (qnm == QNm.EMPTY) continue;
            Value val = bindings.get(qnm);
            for (QNmMap<StaticVar> vars : this.varsByModule.values()) {
                StaticVar var = vars.get(qnm);
                if (var == null) continue;
                var.bind(val, qc, cast);
            }
        }
    }

    @Override
    public Iterator<StaticVar> iterator() {
        return new Iterator<StaticVar>(){
            private final Iterator<QNmMap<StaticVar>> modules;
            private Iterator<StaticVar> vars;
            {
                this.modules = Variables.this.varsByModule.values().iterator();
                this.vars = Collections.emptyIterator();
            }

            @Override
            public boolean hasNext() {
                while (!this.vars.hasNext()) {
                    if (!this.modules.hasNext()) {
                        return false;
                    }
                    this.vars = this.modules.next().values().iterator();
                }
                return true;
            }

            @Override
            public StaticVar next() {
                if (!this.vars.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.vars.next();
            }
        };
    }

    @Override
    public void toXml(QueryPlan plan) {
        if (this.varsByModule.isEmpty()) {
            return;
        }
        ArrayList<StaticVar> list = new ArrayList<StaticVar>();
        for (StaticVar var : this) {
            list.add(var);
        }
        plan.add(plan.create(this, new Object[0]), list.toArray());
    }

    @Override
    public void toString(QueryString qs) {
        for (StaticVar var : this) {
            qs.token(var);
        }
    }

    private record UnresolvedRef(StaticVarRef ref, boolean hasImport) {
    }
}

