/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.map;

import org.basex.core.jobs.Job;
import org.basex.query.QueryBiConsumer;
import org.basex.query.QueryBiPredicate;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.AStr;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.type.Type;
import org.basex.query.value.type.Types;
import org.basex.util.Util;

abstract class XQHashMap
extends XQMap {
    private XQMap trie;

    XQHashMap(Type type) {
        super(type);
    }

    @Override
    public abstract long structSize();

    @Override
    public abstract Value getOrNull(Item var1) throws QueryException;

    @Override
    public XQMap put(Item key, Value value) throws QueryException {
        return this.trie().put(key, value);
    }

    @Override
    public XQMap putAt(int index, Value value) throws QueryException {
        return this.trie().putAt(index, value);
    }

    void valueAt(int index, Value value) {
        throw Util.notExpected();
    }

    @Override
    public final XQMap remove(Item key) throws QueryException {
        return this.getOrNull(key) == null ? this : this.trie().remove(key);
    }

    @Override
    public final void forEach(QueryBiConsumer<Item, Value> func) throws QueryException {
        long is = this.structSize();
        int i = 0;
        while ((long)i < is) {
            func.accept(this.keyAt(i), this.valueAt(i));
            ++i;
        }
    }

    @Override
    public final boolean test(QueryBiPredicate<Item, Value> func) throws QueryException {
        long is = this.structSize();
        int i = 0;
        while ((long)i < is) {
            if (!func.test(this.keyAt(i), this.valueAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    abstract XQHashMap build(Item var1, Value var2) throws QueryException;

    final XQHashMap build(XQHashMap old) throws QueryException {
        old.forEach(this::build);
        return this;
    }

    final void shrinkValues(Job job) throws QueryException {
        long is = this.structSize();
        int i = 0;
        while ((long)i < is) {
            this.valueAt(i, this.valueAt(i).shrink(job));
            ++i;
        }
    }

    private XQMap trie() throws QueryException {
        if (this.trie == null) {
            XQMap mp = XQHashMap.empty();
            long is = this.structSize();
            int i = 0;
            while ((long)i < is) {
                mp = mp.put(this.keyAt(i), this.valueAt(i));
                ++i;
            }
            this.trie = mp;
        }
        return this.trie;
    }

    static byte[] toStr(Value value) throws QueryException {
        if (value.seqType().eq(Types.STRING_O)) {
            return ((AStr)value).string(null);
        }
        return null;
    }

    static byte[] toAtm(Value value) {
        if (value.seqType().eq(Types.UNTYPED_ATOMIC_O)) {
            return ((Atm)value).string(null);
        }
        return null;
    }

    static int toInt(Value value) {
        int n;
        if (value instanceof Itr) {
            Itr itr = (Itr)value;
            n = itr.toInt();
        } else {
            n = Integer.MIN_VALUE;
        }
        return n;
    }
}

